/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import com.gn4me.ArrayList;
import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.CollideCircle;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;

public class CircleContact
extends Contact
implements ContactCreateFcn {
    Manifold m_manifold = new Manifold();

    public Contact create(Shape shape1, Shape shape2) {
        return new CircleContact(shape1, shape2);
    }

    public static void Destroy(Contact contact) {
        ((CircleContact)contact).destructor();
    }

    public Contact clone() {
        return this;
    }

    public CircleContact() {
        this.m_manifoldCount = 0;
    }

    public CircleContact(Shape shape1, Shape shape2) {
        super(shape1, shape2);
        this.m_manifold.pointCount = 0;
        this.m_manifold.points[0].normalImpulse = 0.0f;
        this.m_manifold.points[0].tangentImpulse = 0.0f;
        this.m_manifold.points[0].localPoint1 = new Vec2();
        this.m_manifold.points[0].localPoint2 = new Vec2();
    }

    public void destructor() {
    }

    public void evaluate(ContactListener listener) {
        Body b1 = this.m_shape1.getBody();
        Body b2 = this.m_shape2.getBody();
        Manifold m0 = new Manifold(this.m_manifold);
        for (int k = 0; k < this.m_manifold.pointCount; ++k) {
            m0.points[k] = new ManifoldPoint(this.m_manifold.points[k]);
            m0.points[k].normalImpulse = this.m_manifold.points[k].normalImpulse;
            m0.points[k].tangentImpulse = this.m_manifold.points[k].tangentImpulse;
            m0.points[k].separation = this.m_manifold.points[k].separation;
            m0.points[k].id.features.set(this.m_manifold.points[k].id.features);
        }
        m0.pointCount = this.m_manifold.pointCount;
        CollideCircle.collideCircles(this.m_manifold, (CircleShape)this.m_shape1, b1.m_xf, (CircleShape)this.m_shape2, b2.m_xf);
        ContactPoint cp = new ContactPoint();
        cp.shape1 = this.m_shape1;
        cp.shape2 = this.m_shape2;
        cp.friction = this.m_friction;
        cp.restitution = this.m_restitution;
        if (this.m_manifold.pointCount > 0) {
            this.m_manifoldCount = 1;
            ManifoldPoint mp = this.m_manifold.points[0];
            if (m0.pointCount == 0) {
                mp.normalImpulse = 0.0f;
                mp.tangentImpulse = 0.0f;
                if (listener != null) {
                    cp.position = b1.getWorldPoint(mp.localPoint1);
                    Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp.localPoint1);
                    Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp.localPoint2);
                    cp.velocity = v2.sub(v1);
                    cp.normal = this.m_manifold.normal.clone();
                    cp.separation = mp.separation;
                    cp.id = new ContactID(mp.id);
                    listener.add(cp);
                }
            } else {
                ManifoldPoint mp0 = m0.points[0];
                mp.normalImpulse = mp0.normalImpulse;
                mp.tangentImpulse = mp0.tangentImpulse;
                if (listener != null) {
                    cp.position = b1.getWorldPoint(mp.localPoint1);
                    Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp.localPoint1);
                    Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp.localPoint2);
                    cp.velocity = v2.sub(v1);
                    cp.normal = this.m_manifold.normal.clone();
                    cp.separation = mp.separation;
                    cp.id = new ContactID(mp.id);
                    listener.persist(cp);
                }
            }
        } else {
            this.m_manifoldCount = 0;
            if (m0.pointCount > 0 && listener != null) {
                ManifoldPoint mp0 = m0.points[0];
                cp.position = b1.getWorldPoint(mp0.localPoint1);
                Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp0.localPoint1);
                Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp0.localPoint2);
                cp.velocity = v2.sub(v1);
                cp.normal = m0.normal.clone();
                cp.separation = mp0.separation;
                cp.id = new ContactID(mp0.id);
                listener.remove(cp);
            }
        }
    }

    public ArrayList getManifolds() {
        ArrayList ret = new ArrayList(1);
        if (this.m_manifold != null) {
            ret.add(this.m_manifold);
        }
        return ret;
    }
}

