/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import com.gn4me.ArrayList;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.CircleContact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.contacts.ContactRegister;
import org.jbox2d.dynamics.contacts.PolyAndCircleContact;
import org.jbox2d.dynamics.contacts.PolyContact;

public abstract class Contact {
    public static final int e_nonSolidFlag = 1;
    public static final int e_slowFlag = 2;
    public static final int e_islandFlag = 4;
    public static final int e_toiFlag = 8;
    static ArrayList s_registers;
    static boolean s_initialized;
    public World m_world;
    public Contact m_prev;
    public Contact m_next;
    public ContactEdge m_node1 = new ContactEdge();
    public ContactEdge m_node2 = new ContactEdge();
    public Shape m_shape1;
    public Shape m_shape2;
    public float m_friction;
    public float m_restitution;
    public int m_flags;
    public int m_manifoldCount;
    public float m_toi;

    public abstract void evaluate(ContactListener var1);

    public abstract ArrayList getManifolds();

    public int getManifoldCount() {
        return this.m_manifoldCount;
    }

    public boolean isSolid() {
        return (this.m_flags & 1) == 0;
    }

    public Contact() {
    }

    public Contact(Shape s1, Shape s2) {
        this();
        this.m_flags = 0;
        if (s1.isSensor() || s2.isSensor()) {
            this.m_flags |= 1;
        }
        this.m_shape1 = s1;
        this.m_shape2 = s2;
        this.m_manifoldCount = 0;
        this.getManifolds().clear();
        this.m_friction = (float)Math.sqrt(this.m_shape1.m_friction * this.m_shape2.m_friction);
        this.m_restitution = MathUtils.max(this.m_shape1.m_restitution, this.m_shape2.m_restitution);
        this.m_prev = null;
        this.m_next = null;
        this.m_node1.contact = null;
        this.m_node1.prev = null;
        this.m_node1.next = null;
        this.m_node1.other = null;
        this.m_node2.contact = null;
        this.m_node2.prev = null;
        this.m_node2.next = null;
        this.m_node2.other = null;
    }

    public Contact getNext() {
        return this.m_next;
    }

    public Shape getShape1() {
        return this.m_shape1;
    }

    public Shape getShape2() {
        return this.m_shape2;
    }

    static void initializeRegisters() {
        s_registers = new ArrayList();
        Contact.addType(new CircleContact(), 1, 1);
        Contact.addType(new PolyAndCircleContact(), 2, 1);
        Contact.addType(new PolyContact(), 2, 2);
    }

    static void addType(ContactCreateFcn createFcn, int type1, int type2) {
        ContactRegister cr = new ContactRegister();
        cr.s1 = type1;
        cr.s2 = type2;
        cr.createFcn = createFcn;
        cr.primary = true;
        s_registers.add(cr);
        if (type1 != type2) {
            ContactRegister cr2 = new ContactRegister();
            cr2.s2 = type1;
            cr2.s1 = type2;
            cr2.createFcn = createFcn;
            cr2.primary = false;
            s_registers.add(cr2);
        }
    }

    public static Contact createContact(Shape shape1, Shape shape2) {
        int type2;
        int type1;
        ContactRegister register;
        if (!s_initialized) {
            Contact.initializeRegisters();
            s_initialized = true;
        }
        if ((register = Contact.getContactRegister(type1 = shape1.m_type, type2 = shape2.m_type)) != null) {
            if (register.primary) {
                return register.createFcn.create(shape1, shape2);
            }
            Contact c = register.createFcn.create(shape2, shape1);
            for (int i = 0; i < c.getManifoldCount(); ++i) {
                Manifold m = (Manifold)c.getManifolds().get(i);
                m.normal.negateLocal();
            }
            return c;
        }
        return null;
    }

    private static ContactRegister getContactRegister(int type1, int type2) {
        for (int j = 0; j < s_registers.size(); ++j) {
            ContactRegister cr = (ContactRegister)s_registers.get(j);
            if (cr.s1 != type1 || cr.s2 != type2) continue;
            return cr;
        }
        return null;
    }

    public static void destroy(Contact contact) {
        if (contact.getManifoldCount() > 0) {
            contact.getShape1().getBody().wakeUp();
            contact.getShape2().getBody().wakeUp();
        }
    }

    public void update(ContactListener listener) {
        int oldCount = this.getManifoldCount();
        this.evaluate(listener);
        int newCount = this.getManifoldCount();
        Body body1 = this.m_shape1.getBody();
        Body body2 = this.m_shape2.getBody();
        if (newCount == 0 && oldCount > 0) {
            body1.wakeUp();
            body2.wakeUp();
        }
        this.m_flags = body1.isStatic() || body1.isBullet() || body2.isStatic() || body2.isBullet() ? (this.m_flags &= 0xFFFFFFFD) : (this.m_flags |= 2);
    }

    public abstract Contact clone();
}

