/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import com.gn4me.ArrayList;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;

public class ContactSolver {
    public TimeStep m_step;
    public ContactConstraint[] m_constraints;
    public int m_constraintCount;

    public ContactSolver(TimeStep step, Contact[] contacts, int contactCount) {
        int i;
        this.m_step = step;
        this.m_constraintCount = 0;
        for (i = 0; i < contactCount; ++i) {
            this.m_constraintCount += contacts[i].getManifoldCount();
        }
        this.m_constraints = new ContactConstraint[this.m_constraintCount];
        for (i = 0; i < this.m_constraintCount; ++i) {
            this.m_constraints[i] = new ContactConstraint();
        }
        int count = 0;
        for (int i2 = 0; i2 < contactCount; ++i2) {
            Contact contact = contacts[i2];
            Body b1 = contact.m_shape1.getBody();
            Body b2 = contact.m_shape2.getBody();
            int manifoldCount = contact.getManifoldCount();
            ArrayList manifolds = contact.getManifolds();
            float friction = contact.m_friction;
            float restitution = contact.m_restitution;
            Vec2 v1 = b1.m_linearVelocity.clone();
            Vec2 v2 = b2.m_linearVelocity.clone();
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            for (int j = 0; j < manifoldCount; ++j) {
                Manifold manifold = (Manifold)manifolds.get(j);
                Vec2 normal = manifold.normal.clone();
                ContactConstraint c = this.m_constraints[count];
                c.body1 = b1;
                c.body2 = b2;
                c.manifold = manifold;
                c.normal = normal.clone();
                c.pointCount = manifold.pointCount;
                c.friction = friction;
                c.restitution = restitution;
                for (int k = 0; k < c.pointCount; ++k) {
                    Vec2 buffer;
                    float vRel;
                    ManifoldPoint cp = manifold.points[k];
                    ContactConstraintPoint ccp = c.points[k];
                    ccp.normalImpulse = cp.normalImpulse;
                    ccp.tangentImpulse = cp.tangentImpulse;
                    ccp.separation = cp.separation;
                    ccp.positionImpulse = 0.0f;
                    ccp.localAnchor1.set(cp.localPoint1);
                    ccp.localAnchor2.set(cp.localPoint2);
                    ccp.r1 = Mat22.mul(b1.getXForm().R, cp.localPoint1.sub(b1.getLocalCenter()));
                    ccp.r2 = Mat22.mul(b2.getXForm().R, cp.localPoint2.sub(b2.getLocalCenter()));
                    float rn1 = Vec2.cross(ccp.r1, normal);
                    float rn2 = Vec2.cross(ccp.r2, normal);
                    rn1 *= rn1;
                    rn2 *= rn2;
                    float kNormal = b1.m_invMass + b2.m_invMass + b1.m_invI * rn1 + b2.m_invI * rn2;
                    ccp.normalMass = 1.0f / kNormal;
                    float kEqualized = b1.m_mass * b1.m_invMass + b2.m_mass * b2.m_invMass;
                    ccp.equalizedMass = 1.0f / (kEqualized += b1.m_mass * b1.m_invI * rn1 + b2.m_mass * b2.m_invI * rn2);
                    Vec2 tangent = Vec2.cross(normal, 1.0f);
                    float rt1 = Vec2.cross(ccp.r1, tangent);
                    float rt2 = Vec2.cross(ccp.r2, tangent);
                    rt1 *= rt1;
                    rt2 *= rt2;
                    float kTangent = b1.m_invMass + b2.m_invMass + b1.m_invI * rt1 + b2.m_invI * rt2;
                    ccp.tangentMass = 1.0f / kTangent;
                    ccp.velocityBias = 0.0f;
                    if (ccp.separation > 0.0f) {
                        ccp.velocityBias = -60.0f * ccp.separation;
                    }
                    if (!((vRel = Vec2.dot(c.normal, buffer = Vec2.cross(w2, ccp.r2).subLocal(Vec2.cross(w1, ccp.r1)).addLocal(v2).subLocal(v1))) < -1.0f)) continue;
                    ccp.velocityBias += -c.restitution * vRel;
                }
                ++count;
            }
        }
    }

    public void initVelocityConstraints(TimeStep step) {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraintPoint ccp;
            int j;
            float normaly;
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            float normalx = c.normal.x;
            float tangentx = normaly = c.normal.y;
            float tangenty = -normalx;
            if (step.warmStarting) {
                for (j = 0; j < c.pointCount; ++j) {
                    ccp = c.points[j];
                    ccp.normalImpulse *= step.dtRatio;
                    ccp.tangentImpulse *= step.dtRatio;
                    float px = ccp.normalImpulse * normalx + ccp.tangentImpulse * tangentx;
                    float py = ccp.normalImpulse * normaly + ccp.tangentImpulse * tangenty;
                    b1.m_angularVelocity -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                    b1.m_linearVelocity.x -= px * invMass1;
                    b1.m_linearVelocity.y -= py * invMass1;
                    b2.m_angularVelocity += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                    b2.m_linearVelocity.x += px * invMass2;
                    b2.m_linearVelocity.y += py * invMass2;
                }
                continue;
            }
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                ccp.normalImpulse = 0.0f;
                ccp.tangentImpulse = 0.0f;
            }
        }
    }

    public void solveVelocityConstraints() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            float lambda;
            float dvy;
            float dvx;
            ContactConstraintPoint ccp;
            int j;
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            Vec2 v1 = b1.m_linearVelocity.clone();
            Vec2 v2 = b2.m_linearVelocity.clone();
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            Vec2 normal = c.normal;
            Vec2 tangent = Vec2.cross(normal, 1.0f);
            float friction = c.friction;
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                dvx = v2.x - w2 * ccp.r2.y - v1.x + w1 * ccp.r1.y;
                dvy = v2.y + w2 * ccp.r2.x - v1.y - w1 * ccp.r1.x;
                float vn = dvx * normal.x + dvy * normal.y;
                lambda = -ccp.normalMass * (vn - ccp.velocityBias);
                float newImpulse = MathUtils.max(ccp.normalImpulse + lambda, 0.0f);
                lambda = newImpulse - ccp.normalImpulse;
                float Px = lambda * normal.x;
                float Py = lambda * normal.y;
                v1.x -= invMass1 * Px;
                v1.y -= invMass1 * Py;
                w1 -= invI1 * (ccp.r1.x * Py - ccp.r1.y * Px);
                v2.x += invMass2 * Px;
                v2.y += invMass2 * Py;
                w2 += invI2 * (ccp.r2.x * Py - ccp.r2.y * Px);
                ccp.normalImpulse = newImpulse;
            }
            for (j = 0; j < c.pointCount; ++j) {
                ccp = c.points[j];
                dvx = v2.x - w2 * ccp.r2.y - v1.x + w1 * ccp.r1.y;
                dvy = v2.y + w2 * ccp.r2.x - v1.y - w1 * ccp.r1.x;
                float vt = dvx * tangent.x + dvy * tangent.y;
                lambda = ccp.tangentMass * -vt;
                float maxFriction = friction * ccp.normalImpulse;
                float newImpulse = MathUtils.max(-maxFriction, MathUtils.min(ccp.tangentImpulse + lambda, maxFriction));
                lambda = newImpulse - ccp.tangentImpulse;
                float px = lambda * tangent.x;
                float py = lambda * tangent.y;
                v1.x -= px * invMass1;
                v1.y -= py * invMass1;
                w1 -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                v2.x += px * invMass2;
                v2.y += py * invMass2;
                w2 += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                ccp.tangentImpulse = newImpulse;
            }
            b1.m_linearVelocity.set(v1);
            b1.m_angularVelocity = w1;
            b2.m_linearVelocity.set(v2);
            b2.m_angularVelocity = w2;
        }
    }

    public void finalizeVelocityConstraints() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint c = this.m_constraints[i];
            Manifold m = c.manifold;
            for (int j = 0; j < c.pointCount; ++j) {
                m.points[j].normalImpulse = c.points[j].normalImpulse;
                m.points[j].tangentImpulse = c.points[j].tangentImpulse;
            }
        }
    }

    public boolean solvePositionConstraints(float baumgarte) {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint c = this.m_constraints[i];
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_mass * b1.m_invMass;
            float invI1 = b1.m_mass * b1.m_invI;
            float invMass2 = b2.m_mass * b2.m_invMass;
            float invI2 = b2.m_mass * b2.m_invI;
            Vec2 normal = c.normal;
            for (int j = 0; j < c.pointCount; ++j) {
                ContactConstraintPoint ccp = c.points[j];
                Vec2 r1 = Mat22.mul(b1.getXForm().R, ccp.localAnchor1.sub(b1.getLocalCenter()));
                Vec2 r2 = Mat22.mul(b2.getXForm().R, ccp.localAnchor2.sub(b2.getLocalCenter()));
                float dpx = b2.m_sweep.c.x + r2.x - b1.m_sweep.c.x - r1.x;
                float dpy = b2.m_sweep.c.y + r2.y - b1.m_sweep.c.y - r1.y;
                float separation = dpx * normal.x + dpy * normal.y + ccp.separation;
                minSeparation = MathUtils.min(minSeparation, separation);
                float C = baumgarte * MathUtils.clamp(separation + 0.005f, -0.2f, 0.0f);
                float dImpulse = -ccp.equalizedMass * C;
                float impulse0 = ccp.positionImpulse;
                ccp.positionImpulse = MathUtils.max(impulse0 + dImpulse, 0.0f);
                dImpulse = ccp.positionImpulse - impulse0;
                float impulsex = dImpulse * normal.x;
                float impulsey = dImpulse * normal.y;
                b1.m_sweep.c.x -= invMass1 * impulsex;
                b1.m_sweep.c.y -= invMass1 * impulsey;
                b1.m_sweep.a -= invI1 * (r1.x * impulsey - r1.y * impulsex);
                b1.synchronizeTransform();
                b2.m_sweep.c.x += invMass2 * impulsex;
                b2.m_sweep.c.y += invMass2 * impulsey;
                b2.m_sweep.a += invI2 * (r2.x * impulsey - r2.y * impulsex);
                b2.synchronizeTransform();
            }
        }
        return minSeparation >= -0.0075f;
    }
}

