/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka;

import com.gn4me.waka.Main;
import com.gn4me.waka.Setting;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundsPlayer
implements Runnable {
    private static SoundsPlayer spacePlayer;
    private Player player;
    private int mainSoundLevel1;
    private Setting setting = Setting.getInstance();
    private boolean paused;
    private boolean running;

    private SoundsPlayer() {
        this.create();
    }

    public static SoundsPlayer getInstance() {
        if (spacePlayer == null) {
            spacePlayer = new SoundsPlayer();
        }
        return spacePlayer;
    }

    private void create() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/main.mid");
            this.player = Manager.createPlayer((InputStream)in, (String)"audio/midi");
            this.player.prefetch();
            VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
            this.mainSoundLevel1 = vc.getLevel();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSoundLevel(int level) {
        level *= 4;
        level = this.mainSoundLevel1 * level / 100;
        try {
            VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
            vc.setLevel(level);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setSoundLevel(this.setting.getSound());
        while (this.running) {
            boolean isForgeground;
            if (this.paused) {
                try {
                    SoundsPlayer soundsPlayer = this;
                    synchronized (soundsPlayer) {
                        this.wait();
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (isForgeground = Main.isForeground()) {
                try {
                    if (this.player.getState() != 400) {
                        this.player.start();
                    }
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
            if (!isForgeground) {
                try {
                    this.player.stop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
    }
}

