/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.menu;

import com.gn4me.waka.Drawable;
import com.gn4me.waka.Game;
import com.gn4me.waka.Main;
import com.gn4me.waka.Resources;
import com.gn4me.waka.Tasks;
import com.gn4me.waka.menu.Element;
import com.gn4me.waka.menu.Options;
import com.gn4me.waka.select.LevelSelection;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MenuGame
implements Drawable {
    protected Vector vecElements = new Vector();
    protected int numberOfElements = -1;
    protected int spacer = 20;
    private int selectedIndex;
    private int menuX;
    private int menuY;
    private int height;
    private int width;
    private Game game = Main.currentGame;

    public MenuGame() {
        this.creatElements();
        this.calculate();
    }

    protected void calculate() {
        Element element = null;
        this.numberOfElements = this.vecElements.size();
        this.height = this.numberOfElements * (40 + this.spacer) - this.spacer;
        this.width = 215;
        this.menuX = 180 - this.width / 2;
        this.menuY = 320 - this.height / 2;
        for (int j = 0; j < this.vecElements.size(); ++j) {
            element = (Element)this.vecElements.elementAt(j);
            element.setX(this.menuX);
            element.setY(this.menuY + j * (40 + this.spacer));
        }
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        for (int j = 0; j < this.vecElements.size(); ++j) {
            ((Element)this.vecElements.elementAt(j)).draw(g);
        }
    }

    public void creatElements() {
        Element element = null;
        element = new Element(5, Resources.MENU_RESUME, null);
        element.setSelected(true);
        this.vecElements.addElement(element);
        element = new Element(6, Resources.MENU_RESTART, null);
        this.vecElements.addElement(element);
        element = new Element(7, Resources.MENU_SELECT_LEVEL, null);
        this.vecElements.addElement(element);
        element = new Element(8, Resources.MENU_OPTIONS, null);
        this.vecElements.addElement(element);
        element = new Element(9, Resources.MENU_MAIN_MENU, null);
        this.vecElements.addElement(element);
    }

    private void execute(Element element) {
        Main.menuVibrate();
        switch (element.getType()) {
            case 7: {
                this.game.setDrawable(new LevelSelection(this.game, null));
                System.gc();
                break;
            }
            case 9: {
                this.game.setEndTask(Tasks.viewMEnu());
                this.game.stop();
                break;
            }
            case 8: {
                this.game.setDrawable(new Options(null, this.game));
                System.gc();
                break;
            }
            case 6: {
                this.game.setEndTask(Tasks.startLevel(this.game.getLevelNumber()));
                this.game.stop();
                break;
            }
            case 5: {
                this.game.resume();
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        if (x < this.menuX || x > this.menuX + 215 || y < this.menuY || y > this.menuY + this.height) {
            return;
        }
        this.selectedIndex = (y -= this.menuY) / (40 + this.spacer);
        this.execute((Element)this.vecElements.elementAt(this.selectedIndex));
    }

    public void pointerReleased(int x, int y) {
    }
}

