/*
 * Decompiled with CFR 0.152.
 */
package com.gn4me.waka.menu;

import com.gn4me.waka.Main;
import com.gn4me.waka.Resources;
import com.gn4me.waka.SoundsPlayer;
import com.gn4me.waka.menu.Element;
import com.goodnews.games.loading.LoaderListener;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuMain
extends Canvas
implements LoaderListener {
    protected Vector vecElements;
    protected int numberOfElements = -1;
    protected int spacer = 20;
    private int selectedIndex;
    private int menuX;
    private int menuY;
    private int height;
    private int width;

    public MenuMain() {
        this.setFullScreenMode(true);
        this.vecElements = new Vector();
    }

    public MenuMain(boolean noLoader) {
        this.setFullScreenMode(true);
        this.vecElements = new Vector();
        this.creatElements();
        this.calculate();
    }

    protected void calculate() {
        Element element = null;
        this.numberOfElements = this.vecElements.size();
        this.height = this.numberOfElements * (40 + this.spacer) - this.spacer;
        this.width = 215;
        this.menuX = 180 - this.width / 2;
        this.menuY = 320 - this.height / 2 + 20;
        for (int j = 0; j < this.vecElements.size(); ++j) {
            element = (Element)this.vecElements.elementAt(j);
            element.setX(this.menuX);
            element.setY(this.menuY + j * (40 + this.spacer));
        }
    }

    protected void paint(Graphics gg) {
        Image i = null;
        i = this.getWidth() < this.getHeight() ? Image.createImage((int)this.getWidth(), (int)this.getHeight()) : Image.createImage((int)this.getHeight(), (int)this.getWidth());
        Graphics g = i.getGraphics();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(Resources.MENU_BACKGROUND, i.getWidth() / 2, i.getHeight() / 2, 3);
        for (int j = 0; j < this.vecElements.size(); ++j) {
            ((Element)this.vecElements.elementAt(j)).draw(g);
        }
        if (this.getWidth() < this.getHeight()) {
            gg.drawImage(i, 0, 0, 20);
        } else {
            gg.drawRegion(i, 0, 0, i.getWidth(), i.getHeight(), 6, 0, 0, 20);
        }
    }

    protected void keyPressed(int keyCode) {
        int key = this.getGameAction(keyCode);
        if (key == 8) {
            this.execute();
        } else if (key == 1 || key == 5) {
            --this.selectedIndex;
            this.changeSelected();
        } else if (key == 6 || key == 2) {
            ++this.selectedIndex;
            this.changeSelected();
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.getWidth() > this.getHeight()) {
            int xOld = x;
            int yOld = y;
            y = xOld;
            x = this.getHeight() - yOld;
        }
        if (x < this.menuX || x > this.menuX + 215 || y < this.menuY || y > this.menuY + this.height) {
            return;
        }
        this.selectedIndex = (y -= this.menuY) / (40 + this.spacer);
        if (this.selectedIndex < this.vecElements.size()) {
            this.setSelectedIndex();
            ((Element)this.vecElements.elementAt(this.selectedIndex)).execute();
        }
    }

    private void setSelectedIndex() {
        Element element = null;
        for (int j = 0; j < this.vecElements.size(); ++j) {
            element = (Element)this.vecElements.elementAt(j);
            if (j == this.selectedIndex) {
                element.setSelected(true);
                continue;
            }
            element.setSelected(false);
        }
    }

    private void changeSelected() {
        if (this.selectedIndex < 0) {
            this.selectedIndex += this.vecElements.size();
        }
        this.selectedIndex %= this.vecElements.size();
        Element element = null;
        for (int j = 0; j < this.vecElements.size(); ++j) {
            element = (Element)this.vecElements.elementAt(j);
            if (j == this.selectedIndex) {
                element.setSelected(true);
                continue;
            }
            element.setSelected(false);
        }
        this.repaint();
    }

    private void execute() {
        Element element = null;
        for (int j = 0; j < this.vecElements.size(); ++j) {
            element = (Element)this.vecElements.elementAt(j);
            if (!element.isSelected()) continue;
            element.execute();
            return;
        }
    }

    public void creatElements() {
        Element element = null;
        element = new Element(0, Resources.MENU_PLAY, this);
        element.setSelected(true);
        this.vecElements.addElement(element);
        element = new Element(1, Resources.MENU_OPTIONS, this);
        this.vecElements.addElement(element);
        element = new Element(2, Resources.MENU_HELP, this);
        this.vecElements.addElement(element);
        element = new Element(3, Resources.MENU_ABOUT, this);
        this.vecElements.addElement(element);
        element = new Element(4, Resources.MENU_QUIT, this);
        this.vecElements.addElement(element);
    }

    public void loaderFinished() {
        this.creatElements();
        this.calculate();
        SoundsPlayer.getInstance().start();
        Main.setCurrent((Displayable)this);
    }

    public void loaderStarted() {
    }

    public void loaderStepped(int finishedSteps) {
    }
}

