/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.collision.MassData;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.joints.JointEdge;

public class Body {
    public static final int e_frozenFlag = 2;
    public static final int e_islandFlag = 4;
    public static final int e_sleepFlag = 8;
    public static final int e_allowSleepFlag = 16;
    public static final int e_bulletFlag = 32;
    public static final int e_fixedRotationFlag = 64;
    public int m_flags = 0;
    public static final int e_staticType = 0;
    public static final int e_dynamicType = 1;
    public static final int e_maxTypes = 2;
    public int m_type;
    public XForm m_xf;
    public Sweep m_sweep;
    public Vec2 m_linearVelocity;
    public float m_angularVelocity;
    public Vec2 m_force;
    public float m_torque;
    public World m_world;
    public Body m_prev;
    public Body m_next;
    public Shape m_shapeList;
    public int m_shapeCount;
    public JointEdge m_jointList;
    public ContactEdge m_contactList;
    public float m_mass;
    public float m_invMass;
    public float m_I;
    public float m_invI;
    public float m_linearDamping;
    public float m_angularDamping;
    public float m_sleepTime;
    public Object m_userData;

    public Body(BodyDef bd, World world) {
        if (bd.isBullet) {
            this.m_flags |= 0x20;
        }
        if (bd.fixedRotation) {
            this.m_flags |= 0x40;
        }
        if (bd.allowSleep) {
            this.m_flags |= 0x10;
        }
        if (bd.isSleeping) {
            this.m_flags |= 8;
        }
        this.m_world = world;
        this.m_xf = new XForm();
        this.m_xf.position.set(bd.position);
        this.m_xf.R.set(bd.angle);
        this.m_sweep = new Sweep();
        this.m_sweep.localCenter.set(bd.massData.center);
        this.m_sweep.t0 = 1.0f;
        this.m_sweep.a0 = this.m_sweep.a = bd.angle;
        this.m_sweep.c.set(XForm.mul(this.m_xf, this.m_sweep.localCenter));
        this.m_sweep.c0.set(this.m_sweep.c);
        this.m_jointList = null;
        this.m_contactList = null;
        this.m_prev = null;
        this.m_next = null;
        this.m_linearDamping = bd.linearDamping;
        this.m_angularDamping = bd.angularDamping;
        this.m_force = new Vec2(0.0f, 0.0f);
        this.m_torque = 0.0f;
        this.m_linearVelocity = new Vec2(0.0f, 0.0f);
        this.m_angularVelocity = 0.0f;
        this.m_sleepTime = 0.0f;
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_mass = bd.massData.mass;
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
        }
        if ((this.m_flags & 0x40) == 0) {
            this.m_I = bd.massData.I;
        }
        if (this.m_I > 0.0f) {
            this.m_invI = 1.0f / this.m_I;
        }
        this.m_type = this.m_invMass == 0.0f && this.m_invI == 0.0f ? 0 : 1;
        this.m_userData = bd.userData;
        this.m_shapeList = null;
        this.m_shapeCount = 0;
    }

    public Shape createShape(ShapeDef def) {
        if (this.m_world.m_lock) {
            return null;
        }
        Shape s = Shape.create(def);
        s.m_next = this.m_shapeList;
        this.m_shapeList = s;
        ++this.m_shapeCount;
        s.m_body = this;
        s.createProxy(this.m_world.m_broadPhase, this.m_xf);
        s.updateSweepRadius(this.m_sweep.localCenter);
        return s;
    }

    public void destroyShape(Shape s) {
        if (this.m_world.m_lock) {
            return;
        }
        s.destroyProxy(this.m_world.m_broadPhase);
        Shape node = this.m_shapeList;
        Shape prevNode = null;
        boolean found = false;
        while (node != null) {
            if (node == s) {
                if (prevNode == null) {
                    this.m_shapeList = s.m_next;
                    found = true;
                    break;
                }
                prevNode.m_next = s.m_next;
                found = true;
                break;
            }
            prevNode = node;
            node = node.m_next;
        }
        s.m_body = null;
        s.m_next = null;
        --this.m_shapeCount;
        Shape.destroy(s);
    }

    public void setMass(MassData massData) {
        if (this.m_world.m_lock) {
            return;
        }
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_mass = massData.mass;
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
        }
        if ((this.m_flags & 0x40) == 0) {
            this.m_I = massData.I;
        }
        if (this.m_I > 0.0f) {
            this.m_invI = 1.0f / this.m_I;
        }
        this.m_sweep.localCenter.set(massData.center);
        this.m_sweep.c.set(XForm.mul(this.m_xf, this.m_sweep.localCenter));
        this.m_sweep.c0.set(this.m_sweep.c);
        Shape s = this.m_shapeList;
        while (s != null) {
            s.updateSweepRadius(this.m_sweep.localCenter);
            s = s.m_next;
        }
        int oldType = this.m_type;
        this.m_type = this.m_invMass == 0.0f && this.m_invI == 0.0f ? 0 : 1;
        if (oldType != this.m_type) {
            Shape s2 = this.m_shapeList;
            while (s2 != null) {
                s2.refilterProxy(this.m_world.m_broadPhase, this.m_xf);
                s2 = s2.m_next;
            }
        }
    }

    public void setMassFromShapes() {
        if (this.m_world.m_lock) {
            return;
        }
        this.m_mass = 0.0f;
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        Vec2 center = new Vec2(0.0f, 0.0f);
        Shape s = this.m_shapeList;
        while (s != null) {
            MassData massData = new MassData();
            s.computeMass(massData);
            this.m_mass += massData.mass;
            center.x += massData.mass * massData.center.x;
            center.y += massData.mass * massData.center.y;
            this.m_I += massData.I;
            s = s.m_next;
        }
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
            center.x *= this.m_invMass;
            center.y *= this.m_invMass;
        }
        if (this.m_I > 0.0f && (this.m_flags & 0x40) == 0) {
            this.m_I -= this.m_mass * Vec2.dot(center, center);
            this.m_invI = 1.0f / this.m_I;
        } else {
            this.m_I = 0.0f;
            this.m_invI = 0.0f;
        }
        this.m_sweep.localCenter.set(center);
        this.m_sweep.c.set(XForm.mul(this.m_xf, this.m_sweep.localCenter));
        this.m_sweep.c0.set(this.m_sweep.c);
        s = this.m_shapeList;
        while (s != null) {
            s.updateSweepRadius(this.m_sweep.localCenter);
            s = s.m_next;
        }
        int oldType = this.m_type;
        this.m_type = this.m_invMass == 0.0f && this.m_invI == 0.0f ? 0 : 1;
        if (oldType != this.m_type) {
            Shape s2 = this.m_shapeList;
            while (s2 != null) {
                s2.refilterProxy(this.m_world.m_broadPhase, this.m_xf);
                s2 = s2.m_next;
            }
        }
    }

    public boolean setXForm(Vec2 position, float angle) {
        if (this.m_world.m_lock) {
            return true;
        }
        if (this.isFrozen()) {
            return false;
        }
        this.m_xf.R.set(angle);
        this.m_xf.position.set(position);
        this.m_sweep.c.set(XForm.mul(this.m_xf, this.m_sweep.localCenter));
        this.m_sweep.c0.set(this.m_sweep.c);
        this.m_sweep.a0 = this.m_sweep.a = angle;
        boolean freeze = false;
        Shape s = this.m_shapeList;
        while (s != null) {
            boolean inRange = s.synchronize(this.m_world.m_broadPhase, this.m_xf, this.m_xf);
            if (!inRange) {
                freeze = true;
                break;
            }
            s = s.m_next;
        }
        if (freeze) {
            this.m_flags |= 2;
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            s = this.m_shapeList;
            while (s != null) {
                s.destroyProxy(this.m_world.m_broadPhase);
                s = s.m_next;
            }
            return false;
        }
        this.m_world.m_broadPhase.commit();
        return true;
    }

    public XForm getXForm() {
        XForm xf = new XForm();
        xf.set(this.m_xf);
        return xf;
    }

    public Vec2 getPosition() {
        return this.m_xf.position.clone();
    }

    public float getAngle() {
        return this.m_sweep.a;
    }

    public Vec2 getWorldCenter() {
        return this.m_sweep.c.clone();
    }

    public Vec2 getLocalCenter() {
        return this.m_sweep.localCenter.clone();
    }

    public void setLinearVelocity(Vec2 v) {
        this.m_linearVelocity.set(v);
    }

    public Vec2 getLinearVelocity() {
        return this.m_linearVelocity.clone();
    }

    public void setAngularVelocity(float omega) {
        this.m_angularVelocity = omega;
    }

    public float getAngularVelocity() {
        return this.m_angularVelocity;
    }

    public void applyForce(Vec2 force, Vec2 point) {
        if (this.isSleeping()) {
            this.wakeUp();
        }
        this.m_force.addLocal(force);
        this.m_torque += Vec2.cross(point.sub(this.m_sweep.c), force);
    }

    public void applyTorque(float torque) {
        if (this.isSleeping()) {
            this.wakeUp();
        }
        this.m_torque += torque;
    }

    public void applyImpulse(Vec2 impulse, Vec2 point) {
        if (this.isSleeping()) {
            this.wakeUp();
        }
        this.m_linearVelocity.x += this.m_invMass * impulse.x;
        this.m_linearVelocity.y += this.m_invMass * impulse.y;
        this.m_angularVelocity += this.m_invI * Vec2.cross(point.sub(this.m_sweep.c), impulse);
    }

    public float getMass() {
        return this.m_mass;
    }

    public float getInertia() {
        return this.m_I;
    }

    public Vec2 getWorldPoint(Vec2 localPoint) {
        return XForm.mul(this.m_xf, localPoint);
    }

    public Vec2 getWorldVector(Vec2 localVector) {
        return Mat22.mul(this.m_xf.R, localVector);
    }

    public Vec2 getLocalPoint(Vec2 worldPoint) {
        return XForm.mulT(this.m_xf, worldPoint);
    }

    public Vec2 getLocalVector(Vec2 worldVector) {
        return Mat22.mulT(this.m_xf.R, worldVector);
    }

    public boolean isBullet() {
        return (this.m_flags & 0x20) == 32;
    }

    public void setBullet(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 0x20) : (this.m_flags &= 0xFFFFFFDF);
    }

    public boolean isStatic() {
        return this.m_type == 0;
    }

    public boolean isDynamic() {
        return this.m_type == 1;
    }

    public boolean isFrozen() {
        return (this.m_flags & 2) == 2;
    }

    public boolean isSleeping() {
        return (this.m_flags & 8) == 8;
    }

    public void allowSleeping(boolean flag) {
        if (flag) {
            this.m_flags |= 0x10;
        } else {
            this.m_flags &= 0xFFFFFFEF;
            this.wakeUp();
        }
    }

    public void wakeUp() {
        this.m_flags &= 0xFFFFFFF7;
        this.m_sleepTime = 0.0f;
    }

    public Shape getShapeList() {
        return this.m_shapeList;
    }

    public JointEdge getJointList() {
        return this.m_jointList;
    }

    public Body getNext() {
        return this.m_next;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void computeMass() {
    }

    public boolean synchronizeShapes() {
        XForm xf1 = new XForm();
        xf1.R.set(this.m_sweep.a0);
        xf1.position.set(this.m_sweep.c0.sub(Mat22.mul(xf1.R, this.m_sweep.localCenter)));
        boolean inRange = true;
        Shape s = this.m_shapeList;
        while (s != null && (inRange = s.synchronize(this.m_world.m_broadPhase, xf1, this.m_xf))) {
            s = s.m_next;
        }
        if (!inRange) {
            this.m_flags |= 2;
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            s = this.m_shapeList;
            while (s != null) {
                s.destroyProxy(this.m_world.m_broadPhase);
                s = s.m_next;
            }
            return false;
        }
        return true;
    }

    public void synchronizeTransform() {
        this.m_xf.R.set(this.m_sweep.a);
        Vec2 v1 = this.m_sweep.localCenter;
        this.m_xf.position.x = this.m_sweep.c.x - (this.m_xf.R.col1.x * v1.x + this.m_xf.R.col2.x * v1.y);
        this.m_xf.position.y = this.m_sweep.c.y - (this.m_xf.R.col1.y * v1.x + this.m_xf.R.col2.y * v1.y);
    }

    public boolean isConnected(Body other) {
        JointEdge jn = this.m_jointList;
        while (jn != null) {
            if (jn.other == other) {
                return !jn.joint.m_collideConnected;
            }
            jn = jn.next;
        }
        return false;
    }

    public void advance(float t) {
        this.m_sweep.advance(t);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_sweep.a = this.m_sweep.a0;
        this.synchronizeTransform();
    }

    public Vec2 getLinearVelocityFromWorldPoint(Vec2 worldPoint) {
        return this.m_linearVelocity.add(Vec2.cross(this.m_angularVelocity, worldPoint.sub(this.m_sweep.c)));
    }

    public Vec2 getLinearVelocityFromLocalPoint(Vec2 localPoint) {
        return this.getLinearVelocityFromWorldPoint(this.getWorldPoint(localPoint));
    }

    public void putToSleep() {
        this.m_flags |= 8;
        this.m_sleepTime = 0.0f;
        this.m_linearVelocity.setZero();
        this.m_angularVelocity = 0.0f;
        this.m_force.setZero();
        this.m_torque = 0.0f;
    }

    public void setUserData(Object data) {
        this.m_userData = data;
    }

    public World getWorld() {
        return this.m_world;
    }
}

