/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import com.gn4me.ArrayList;
import org.jbox2d.collision.CollidePoly;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.collision.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;

public class PolyContact
extends Contact
implements ContactCreateFcn {
    Manifold m_manifold = new Manifold();

    public PolyContact(Shape s1, Shape s2) {
        super(s1, s2);
        this.m_manifoldCount = 0;
    }

    public PolyContact() {
        this.m_manifoldCount = 0;
    }

    public Contact clone() {
        PolyContact newC = new PolyContact(this.m_shape1, this.m_shape2);
        if (this.m_manifold != null) {
            newC.m_manifold = new Manifold(this.m_manifold);
        }
        newC.m_manifoldCount = this.m_manifoldCount;
        newC.m_world = this.m_world;
        newC.m_toi = this.m_toi;
        newC.m_prev = this.m_prev;
        newC.m_next = this.m_next;
        newC.m_node1 = this.m_node1;
        newC.m_node2 = this.m_node2;
        newC.m_friction = this.m_friction;
        newC.m_restitution = this.m_restitution;
        newC.m_flags = this.m_flags;
        return newC;
    }

    public ArrayList getManifolds() {
        ArrayList ret = new ArrayList();
        if (this.m_manifold != null) {
            ret.add(this.m_manifold);
        }
        return ret;
    }

    public Contact create(Shape shape1, Shape shape2) {
        return new PolyContact(shape1, shape2);
    }

    public void dumpManifoldPoints() {
        for (int i = 0; i < this.m_manifold.pointCount; ++i) {
            ManifoldPoint mp = this.m_manifold.points[i];
            System.out.println("Manifold point dump: " + mp.normalImpulse + " " + mp.tangentImpulse);
        }
    }

    public void evaluate(ContactListener listener) {
        int i;
        Body b1 = this.m_shape1.getBody();
        Body b2 = this.m_shape2.getBody();
        Manifold m0 = new Manifold(this.m_manifold);
        for (int k = 0; k < this.m_manifold.pointCount; ++k) {
            m0.points[k] = new ManifoldPoint(this.m_manifold.points[k]);
            m0.points[k].normalImpulse = this.m_manifold.points[k].normalImpulse;
            m0.points[k].tangentImpulse = this.m_manifold.points[k].tangentImpulse;
            m0.points[k].separation = this.m_manifold.points[k].separation;
            m0.points[k].id.features.set(this.m_manifold.points[k].id.features);
        }
        m0.pointCount = this.m_manifold.pointCount;
        CollidePoly.collidePolygons(this.m_manifold, (PolygonShape)this.m_shape1, b1.getXForm(), (PolygonShape)this.m_shape2, b2.getXForm());
        boolean[] persisted = new boolean[]{false, false};
        ContactPoint cp = new ContactPoint();
        cp.shape1 = this.m_shape1;
        cp.shape2 = this.m_shape2;
        cp.friction = this.m_friction;
        cp.restitution = this.m_restitution;
        if (this.m_manifold.pointCount > 0) {
            for (i = 0; i < this.m_manifold.pointCount; ++i) {
                ManifoldPoint mp = this.m_manifold.points[i];
                mp.normalImpulse = 0.0f;
                mp.tangentImpulse = 0.0f;
                boolean found = false;
                ContactID id = new ContactID(mp.id);
                for (int j = 0; j < m0.pointCount; ++j) {
                    if (persisted[j]) continue;
                    ManifoldPoint mp0 = m0.points[j];
                    if (!mp0.id.isEqual(id)) continue;
                    persisted[j] = true;
                    mp.normalImpulse = mp0.normalImpulse;
                    mp.tangentImpulse = mp0.tangentImpulse;
                    found = true;
                    if (listener == null) break;
                    cp.position = b1.getWorldPoint(mp.localPoint1);
                    Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp.localPoint1);
                    Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp.localPoint2);
                    cp.velocity = v2.sub(v1);
                    cp.normal = this.m_manifold.normal.clone();
                    cp.separation = mp.separation;
                    cp.id = new ContactID(id);
                    listener.persist(cp);
                    break;
                }
                if (found || listener == null) continue;
                cp.position = b1.getWorldPoint(mp.localPoint1);
                Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp.localPoint1);
                Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp.localPoint2);
                cp.velocity = v2.sub(v1);
                cp.normal = this.m_manifold.normal.clone();
                cp.separation = mp.separation;
                cp.id = new ContactID(id);
                listener.add(cp);
            }
            this.m_manifoldCount = 1;
        } else {
            this.m_manifoldCount = 0;
        }
        if (listener == null) {
            return;
        }
        for (i = 0; i < m0.pointCount; ++i) {
            if (persisted[i]) continue;
            ManifoldPoint mp0 = m0.points[i];
            cp.position = b1.getWorldPoint(mp0.localPoint1);
            Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp0.localPoint1);
            Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp0.localPoint2);
            cp.velocity = v2.sub(v1);
            cp.normal = m0.normal.clone();
            cp.separation = mp0.separation;
            cp.id = new ContactID(mp0.id);
            listener.remove(cp);
        }
    }
}

