/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.blob;

import com.gn4me.ArrayList;
import org.jbox2d.util.blob.BlobPoint;

public class BlobStructure {
    ArrayList points = new ArrayList();
    ArrayList connections = new ArrayList();
    ArrayList connectionsR = new ArrayList();
    ArrayList connectionsDR = new ArrayList();
    ArrayList connectionsD = new ArrayList();
    ArrayList connectionsUR = new ArrayList();
    float currentFrequency = 10.0f;
    float currentDamping = 0.9f;

    private void updateSprings() {
        IntIntFloatFloat iiff;
        int j;
        for (j = 0; j < this.connections.size(); ++j) {
            iiff = (IntIntFloatFloat)this.connections.get(j);
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (j = 0; j < this.connectionsR.size(); ++j) {
            iiff = (IntIntFloatFloat)this.connectionsR.get(j);
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (j = 0; j < this.connectionsDR.size(); ++j) {
            iiff = (IntIntFloatFloat)this.connectionsDR.get(j);
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (j = 0; j < this.connectionsD.size(); ++j) {
            iiff = (IntIntFloatFloat)this.connectionsD.get(j);
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
        for (j = 0; j < this.connectionsUR.size(); ++j) {
            iiff = (IntIntFloatFloat)this.connectionsUR.get(j);
            iiff.c = this.currentFrequency;
            iiff.d = this.currentDamping;
        }
    }

    public void setSpringFrequency(float freq) {
        this.currentFrequency = freq;
        this.updateSprings();
    }

    public float getSpringFrequency() {
        return this.currentFrequency;
    }

    public void setSpringDamping(float damp) {
        this.currentDamping = damp;
        this.updateSprings();
    }

    public float getSpringDamping() {
        return this.currentDamping;
    }

    public int addPoint(BlobPoint p) {
        if (p.position.x < 0.0f || p.position.x > 1.0f || p.position.y < 0.0f || p.position.y > 1.0f) {
            throw new RuntimeException("Points must be within (0,0)->(1,1) in a BlobStructure.");
        }
        this.points.add(p);
        return this.points.indexOf(p);
    }

    public void addConnection(int a2, int b) {
        this.connections.add(new IntIntFloatFloat(a2, b, this.currentFrequency, this.currentDamping));
    }

    public void addConnection(int a2, int b, int r) {
        switch (r) {
            case 4: {
                this.addConnection(a2, b);
                break;
            }
            case 1: {
                this.connectionsR.add(new IntIntFloatFloat(a2, b, this.currentFrequency, this.currentDamping));
                break;
            }
            case 2: {
                this.connectionsDR.add(new IntIntFloatFloat(a2, b, this.currentFrequency, this.currentDamping));
                break;
            }
            case 0: {
                this.connectionsD.add(new IntIntFloatFloat(a2, b, this.currentFrequency, this.currentDamping));
                break;
            }
            case 3: {
                this.connectionsUR.add(new IntIntFloatFloat(a2, b, this.currentFrequency, this.currentDamping));
            }
        }
    }

    static interface Region {
        public static final int DOWN = 0;
        public static final int RIGHT = 1;
        public static final int DOWN_RIGHT = 2;
        public static final int UP_RIGHT = 3;
        public static final int CENTER = 4;
    }

    class IntIntFloatFloat {
        public int a;
        public int b;
        public float c;
        public float d;

        public IntIntFloatFloat(int _a, int _b, float _c, float _d) {
            this.a = _a;
            this.b = _b;
            this.c = _c;
            this.d = _d;
        }
    }
}

