/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.util.blob;

import org.jbox2d.collision.AABB;
import org.jbox2d.common.Vec2;
import org.jbox2d.util.blob.BlobContainer;

public class CircularBlobContainer
implements BlobContainer {
    private float centerX;
    private float centerY;
    private float radius;
    private float radiusSqr;

    public CircularBlobContainer(Vec2 _center, float _radius) {
        this.centerX = _center.x;
        this.centerY = _center.y;
        this.radius = _radius;
        this.radiusSqr = _radius * _radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float r) {
        this.radius = r;
        this.radiusSqr = r * r;
    }

    public Vec2 getCenter() {
        return new Vec2(this.centerX, this.centerY);
    }

    public void setCenter(Vec2 c) {
        this.centerX = c.x;
        this.centerY = c.y;
    }

    public boolean containsPoint(Vec2 p) {
        float distSqr = (p.x - this.centerX) * (p.x - this.centerX) + (p.y - this.centerY) * (p.y - this.centerY);
        return !(distSqr > this.radiusSqr);
    }

    public AABB getAABB() {
        Vec2 min = new Vec2(this.centerX - this.radius * 1.2f, this.centerY - this.radius * 1.2f);
        Vec2 max = new Vec2(this.centerX + this.radius * 1.2f, this.centerY + this.radius * 1.2f);
        return new AABB(min, max);
    }
}

