/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AJGraphicFont {
    private byte[] fontWidths;
    private short[] fontPos;
    private char[] fontChars = new char[2000];
    private Image fontImage = null;
    private byte imageRows = 1;
    public int charSpacer = 0;
    public int baseLine = 10;
    public int backColor = 0;
    public boolean transparent = true;
    private static final int IANCHOR = 20;

    public static AJGraphicFont loadFontFromPack(String string, String string2) throws IOException {
        Image image = new AJPackInputStream(string.getClass().getResourceAsStream(string)).getImage(string2);
        try {
            AJPackInputStream aJPackInputStream = new AJPackInputStream(string.getClass().getResourceAsStream(string));
            int n = aJPackInputStream.seekEntry("dat" + string2);
            byte[] byArray = new byte[n];
            aJPackInputStream.read(byArray);
            return new AJGraphicFont(new ByteArrayInputStream(byArray), image);
        }
        catch (Exception exception) {
            throw new IOException("Unable to load font from " + string + " " + string2);
        }
    }

    public AJGraphicFont(InputStream inputStream, Image image) throws IOException {
        this.fontImage = image;
        this.loadFontData(inputStream);
    }

    private void loadFontData(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        int n = dataInputStream.readByte();
        this.imageRows = dataInputStream.readByte();
        this.baseLine = by > 1 ? (int)dataInputStream.readShort() : this.getHeight();
        this.fontWidths = new byte[n];
        this.fontPos = new short[n];
        for (int i = 0; i < n; ++i) {
            char c = dataInputStream.readChar();
            this.fontChars[c] = (char)i;
            this.fontWidths[i] = dataInputStream.readByte();
            int n2 = 0;
            for (int j = 0; j < i; ++j) {
                n2 += this.fontWidths[j];
            }
            this.fontPos[i] = (short)n2;
        }
    }

    public int stringWidth(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        try {
            for (n3 = 0; n3 < n2; ++n3) {
                n += this.fontWidths[this.fontChars[string.charAt(n3)]] + this.charSpacer;
            }
        }
        catch (Exception exception) {
            System.err.println("Invalid charcter: " + string.charAt(n3) + " in: " + string);
        }
        return n;
    }

    public int getHeight() {
        return this.fontImage.getHeight() / this.imageRows;
    }

    public int getBaseLine() {
        return this.baseLine;
    }

    public void render(Graphics graphics, String string, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = string.length();
        int n7 = this.getHeight();
        int n8 = (n3 & 8) == 8 ? n - this.stringWidth(string) : (n5 = (n3 & 1) == 1 ? n - (this.stringWidth(string) >> 1) : n);
        int n9 = (n3 & 0x20) == 32 ? n2 - n7 : (n4 = (n3 & 2) == 2 ? n2 - (n7 >> 1) : n2);
        if (!this.transparent) {
            graphics.setColor(this.backColor);
            graphics.fillRect(n5 - 1, n4 - 1, this.stringWidth(string) + 2, n7 + 2);
        }
        for (int i = 0; i < n6; ++i) {
            char c = this.fontChars[string.charAt(i)];
            byte by = this.fontWidths[c];
            graphics.drawRegion(this.fontImage, (int)this.fontPos[c], 0, (int)by, n7, 0, n5, n4, 20);
            n5 += by + this.charSpacer;
        }
    }
}

