/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AJList
extends AJPanel {
    private Vector listItems = new Vector();
    private int selected;
    private boolean showSelectedItem = true;
    private int scrollFrom = 0;
    private int visibleItems = 0;
    private int startOffset = 0;
    public AJGraphicFont itemFont;
    public int foreColor = 0;
    public int backColor = 0xAA5500;
    public int selectedForeColor = 0xFFFFFF;
    public int selectedBackColor = 0xAA0000;
    public boolean loopedList = false;
    public boolean showLabels = false;
    public int itemSpacing = 0;
    public int itemAlign = 4;
    public int separatorColor = 0xFFAA00;
    public boolean separator = false;
    public boolean fillItemBack = false;
    private int flashIndex = -1;
    private int flashTick = 0;
    private boolean animate = false;
    private int animTick = 0;
    private AJCommandListener temp = null;

    public void add(String string, Image image, int n) {
        this.add(new AJListItem(this, string, image, n));
    }

    public void add(AJListItem aJListItem) {
        this.listItems.addElement(aJListItem);
        this.selected = 0;
        aJListItem.width = this.width - 2;
        this.visibleItems = this.height / (aJListItem.height + this.itemSpacing + (this.showLabels ? this.itemFont.getHeight() + 3 : 0));
        if (this.height % aJListItem.height >= this.itemFont.getHeight()) {
            ++this.visibleItems;
        }
    }

    public AJListItem getItem(int n) {
        try {
            return (AJListItem)this.listItems.elementAt(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void remove(int n) {
        this.listItems.removeElementAt(n);
    }

    public void clear() {
        this.listItems.removeAllElements();
        this.selected = -1;
        this.flashIndex = -1;
    }

    public String getText(int n) {
        try {
            return ((AJListItem)this.listItems.elementAt((int)n)).text;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setTextImage(int n, String string, Image image, int n2) {
        try {
            AJListItem aJListItem = (AJListItem)this.listItems.elementAt(n);
            if (aJListItem != null) {
                aJListItem.text = string;
                aJListItem.itemImg = image;
                aJListItem.subImages = n2;
            }
        }
        catch (Exception exception) {
            System.out.println("setText " + exception);
        }
    }

    public Image getImage(int n) {
        return ((AJListItem)this.listItems.elementAt((int)n)).itemImg;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void setSelectedIndex(int n) {
        if (n >= 0 && n < this.listItems.size()) {
            this.selected = n;
        }
        this.showSelectedItem = n > -1;
    }

    public void setMenuMode(boolean bl, int n) {
        int n2;
        if (n > 0 && n < this.visibleItems) {
            this.visibleItems = n;
        }
        int n3 = n2 = this.listItems.size() > this.visibleItems ? this.visibleItems + 1 : this.listItems.size();
        this.startOffset = n2 > 0 ? (bl ? (this.height >> 1) - (n2 * ((AJListItem)this.listItems.firstElement()).height + (n2 - 1) * (this.itemSpacing + (this.showLabels ? this.itemFont.getHeight() + 3 : 0)) >> 1) : 0) : 0;
        this.loopedList = bl;
        this.animTick = bl ? -1 : 0;
    }

    protected void render(Graphics graphics) {
        int n = this.listItems.size();
        if (this.forceRepaint) {
            if (this.selected >= this.visibleItems - 1 + this.scrollFrom) {
                this.scrollFrom = this.selected - this.visibleItems + 1;
            } else if (this.selected < this.scrollFrom) {
                this.scrollFrom = this.selected;
            }
            this.screen.repaintBorder = true;
            AJScreen.showArrows = this.selected == 0 ? 2 : (this.selected < n - 1 ? 1 | 2 : 1);
            for (int i = this.scrollFrom; i < n && i < this.visibleItems + this.scrollFrom + 1; ++i) {
                boolean bl;
                AJListItem aJListItem = (AJListItem)this.listItems.elementAt(i);
                boolean bl2 = bl = i == this.selected && this.showSelectedItem;
                if (i == this.flashIndex) {
                    boolean bl3 = bl = this.flashTick <= 0;
                }
                if (this.animate && (!this.animate || this.animTick <= i)) continue;
                int n2 = (i - this.scrollFrom) * (aJListItem.height + (this.showLabels ? this.itemFont.getHeight() + 3 : 0) + (i == this.scrollFrom ? 0 : this.itemSpacing)) + this.startOffset;
                aJListItem.render(graphics, 1, n2, bl);
            }
            this.forceRepaint = false;
        }
    }

    public void keyEvent(int n, boolean bl) {
        int n2 = this.screen.getGameActionKey(n);
        if (bl && !this.animate) {
            switch (n2) {
                case 1: {
                    --this.selected;
                    if (this.selected >= 0) break;
                    this.selected = this.loopedList ? this.listItems.size() - 1 : 0;
                    break;
                }
                case 6: {
                    ++this.selected;
                    if (this.selected != this.listItems.size()) break;
                    this.selected = this.loopedList ? 0 : this.listItems.size() - 1;
                }
            }
        }
        this.forceRepaint = true;
    }

    public int getSize() {
        return this.listItems.size();
    }

    public int getHeight() {
        int n = this.listItems.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += ((AJListItem)this.listItems.elementAt((int)i)).height + this.itemSpacing;
        }
        return n2;
    }

    public void flashItem(int n) {
        if (n > -1 && n < this.listItems.size()) {
            this.flashIndex = n;
            this.flashTick = 0;
        }
    }

    public void stopFlash() {
        this.flashIndex = -1;
    }

    public void tick() {
        if (this.flashIndex > -1) {
            if (this.flashTick-- == -1) {
                this.flashTick = 2;
            }
            this.forceRepaint = true;
        }
        if (this.animate) {
            ++this.animTick;
            if (this.animTick == this.visibleItems) {
                this.cmdListener = this.temp;
                this.animate = false;
                this.animTick = -1;
            }
            this.forceRepaint = true;
        }
    }

    protected void activate() {
        if (this.cmdListener != null) {
            this.temp = this.cmdListener;
        }
        if (this.animTick == -1) {
            this.animate = true;
            this.cmdListener = null;
        }
    }
}

