/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DeviceControl;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScreen
extends AJPanel {
    public static final int UI_QUIZRESULT_TIMEOUT = 500;
    public static final int UI_CONQUERE_SELECTED_TIMEOUT = 3000;
    public static final int UI_MESSAGE_TIMEOUT = 3000;
    public static final int UI_SCOREFX_TIMEOUT = 5000;
    public static final int RANK_DISPLAY_PAUSE = 1500;
    private GameSession session;
    private SysTimer timer = new SysTimer();
    static final int STATE_LOADING = 0;
    static final int STATE_SESSION = 1;
    static final int STATE_LOADMENU = 6;
    public static final int GUI_IDLE = 100;
    public static boolean gamePaused = false;
    int state = 0;
    private int sessionState;
    private int statePhase;
    private int loadingPhase;
    private ModelControl parent;
    private static String[] textMessage;
    private Image messageImage;
    private static short[] messageImageCoords;
    private boolean messageBoxVisible = false;
    private static final int MESSAGE_BOX_BGCOLOR = 798289;
    private static final int MESSAGE_BOX_FGCOLOR = 0xFFFFFF;
    private int backgroundHeight;
    public static Image header;
    public static Image footer;
    public static Image footerPlayerBox;
    public static Image gameMenu;
    public static Image[] gameSportIcons;
    public static Image gameMapCell;
    public static Image gameMapCellSel;
    public static Image quizField;
    public static Image quizButton;
    public static Image headerTimeField;
    public static Image scoreNums;
    private int scoreNumWidth;
    public static Image roundGauge;
    public static Image resultField;
    public static Image resultFieldClock;
    public static Image resultFieldHover;
    public static Image flags;
    public static int flagWidth;
    public static Image medals;
    public static int medalWidth;
    public static Image scoreFx;
    private static final int SCOREFX_FRAMES = 9;
    private static int scoreFxWidth;
    private int scoreFxAnim = -1;
    private static Resources quizRes;
    private static int quizLoadingState;
    private static String barTitle;
    private static int barTitleAlign;
    private static short barTitleLen;
    private static int barTitleScrollOffset;
    private static int gameMapPosX;
    private static int gameMapPosY;
    private static int gameMapBorderWidth;
    private static boolean showMap;
    private static final byte FOCUSDIR_LEFT = -1;
    private static final byte FOCUSDIR_RIGHT = 1;
    private byte focusDirection = 0;
    private static String[] quizQuestion;
    private boolean userSelection = false;
    private static final byte HOURGLASS_STATES = 4;
    private static final byte TIMELEFTBAR_STATES = 5;
    private static final int TIMELEFTBAR_FLASH_FROM = 10000;
    private int barState = 0;
    private static final byte SCROLL_DOWN = 1;
    private static final byte SCROLL_UP = -1;
    public static final int MAX_SCROLL_WAIT_CYCLES = 10;
    private static int scrollPosY;
    private static byte scrollDirection;
    private static int scrollWait;
    private static final byte SELECTABLE_SPORTSELECT = 0;
    private static final byte SELECTABLE_ATTACK = 1;
    private static AJList attackConfirmList;
    private static int attackConfirmHeight;
    private static AJList possQuizAnswers;
    private static int possQuizAnswersHeight;
    private static final byte TIPQUIZ_INPUTMAX = 9;
    private StringBuffer tipQuizInput = new StringBuffer();
    private int gameMenuTicker = 0;
    private static final byte CURSOR_FLASHING_INTERVAL = 6;
    private int cursorFlashing = 0;
    private int sendButtonFlash = 0;
    private static String sendButtonText;
    private static int displayPlayerID;
    private static PlayerListItem[] playerListItems;
    private int playerListTop = 0;
    private int selectedCountyIndex = 0;
    private Sport selectedSport = null;
    private boolean countySelectionChanged = false;
    private static Player[] statusPlayerOrder;
    private static int attackFxClippingHeight;
    public boolean inSession = false;

    public GameScreen(ModelControl modelControl) {
        int n;
        this.parent = modelControl;
        this.session = new GameSession(this);
        attackConfirmList = new AJList();
        GameScreen.attackConfirmList.fillItemBack = false;
        GameScreen.attackConfirmList.itemAlign = 1;
        GameScreen.attackConfirmList.itemFont = ModelControl.font;
        GameScreen.attackConfirmList.itemSpacing = 4;
        attackConfirmList.add(Language.langTexts[Language.TEXT_CMD_YES], ModelControl.menuButton, 2);
        attackConfirmList.add(Language.langTexts[Language.TEXT_CMD_NO], ModelControl.menuButton, 2);
        possQuizAnswers = new AJList();
        GameScreen.possQuizAnswers.backColor = 16635532;
        GameScreen.possQuizAnswers.fillItemBack = false;
        GameScreen.possQuizAnswers.itemAlign = 1;
        GameScreen.possQuizAnswers.itemFont = ModelControl.font;
        GameScreen.possQuizAnswers.itemSpacing = 4;
        flagWidth = flags.getWidth() / ModelControl.countries.length;
        medalWidth = medals.getWidth() / 3;
        scoreFxWidth = scoreFx.getWidth() / 9;
        for (n = 0; n < 4; ++n) {
            possQuizAnswers.add(new PQListItem(possQuizAnswers));
        }
        playerListItems = new PlayerListItem[3];
        for (n = 0; n < 3; ++n) {
            GameScreen.playerListItems[n] = new PlayerListItem(this);
        }
    }

    private void setState(int n) {
        switch (n) {
            case 0: {
                quizLoadingState = 0;
            }
            case 6: {
                this.loadingPhase = 0;
                break;
            }
            case 1: {
                this.inSession = true;
                gameMapPosY = header.getHeight() + (this.screen.height - header.getHeight() - footer.getHeight() >> 1) - (ModelControl.GAMEMAP_HEIGHT >> 1);
                gameMapBorderWidth = this.screen.width >> 5;
            }
        }
        this.state = n;
    }

    private void setTitle(String string) {
        barTitle = string;
        barTitleLen = (short)ModelControl.font.stringWidth(string);
    }

    private void setMessageImage(Image image, int n, int n2, int n3, int n4) {
        this.messageImage = image;
    }

    private void setMessageText(String string) {
        textMessage = AJText.wrapText(string, this.screen.width - (this.screen.width >> 4), ModelControl.font);
    }

    private void setQuizText(String string) {
        quizQuestion = AJText.wrapText(string, this.screen.width, ModelControl.font);
    }

    private String getCurrentPlayerTitle(String string) {
        if (Language.direction >= 0) {
            return this.session.currentPlayer.name + string;
        }
        return string + this.session.currentPlayer.name;
    }

    private void setSessionState(int n) {
        this.statePhase = 0;
        scrollPosY = 0;
        showMap = true;
        switch (n) {
            case 1: {
                gameMapPosX = 0;
                displayPlayerID = 0;
                int n2 = 1;
                GameScreen.statusPlayerOrder[0] = GameSession.clientPlayer;
                int n3 = 0;
                while (true) {
                    if (n3 >= GameSession.players.length) break;
                    if (GameSession.players[n3] != GameSession.clientPlayer) {
                        int n4 = n2++;
                        GameScreen.statusPlayerOrder[n4] = GameSession.players[n3];
                    }
                    ++n3;
                }
                barTitleAlign = 1;
                this.setTitle("");
                break;
            }
            case 100: {
                showMap = false;
                displayPlayerID = -1;
                this.initPlayerListItems(this.session.displayPList, (byte)1);
                textMessage = null;
                if (GameSession.clientPlayer.matchesWon == -1) {
                    this.setMessageText(Language.langTexts[Language.TEXT_FINISH_LOOSE]);
                    this.statePhase = 2;
                } else if (this.session.displayPList.get(0) == GameSession.clientPlayer) {
                    this.setMessageText(Language.langTexts[Language.TEXT_FINISH_WIN]);
                }
                barTitleAlign = 1;
                this.setTitle(Language.langTexts[Language.TITLE_FINALRESULT]);
                this.timer.reset();
                this.inSession = false;
                break;
            }
            case 33: {
                this.setMessageText(Language.langTexts[Language.TEXT_FINALMSG]);
                this.setTitle(Language.langTexts[Language.TITLE_FINALQUIZ]);
                this.messageBoxVisible = true;
                this.timer.reset();
            }
            case 17: {
                this.tipQuizInput.setLength(0);
                if (n == 17) {
                    barTitleAlign = 4;
                    this.setTitle(Language.langTexts[Language.TITLE_TIPQUIZ]);
                }
                this.setQuizText(this.session.currentQuiz.question);
                showMap = false;
                break;
            }
            case 26: {
                gameMapPosX = -gameMapBorderWidth;
                showMap = false;
                this.session.currentPlayer.selectable.get((int)0).posX = (this.screen.width >> 1) - (this.screen.width >> 5) - (Sport.mapCellWidth >> 1);
                this.session.currentPlayer.selectable.get((int)0).posY = ModelControl.GAMEMAP_HEIGHT >> 1;
                this.session.currentPlayer.selectable.get((int)1).posX = (this.screen.width >> 1) + (this.screen.width >> 5) + (Sport.mapCellWidth >> 1);
                this.session.currentPlayer.selectable.get((int)1).posY = this.session.currentPlayer.selectable.get((int)0).posY;
                this.statePhase = 1;
            }
            case 10: 
            case 14: {
                this.selectedCountyIndex = 0;
                this.selectedSport = this.session.currentPlayer.selectable.get(this.selectedCountyIndex);
                barTitleAlign = 4;
                switch (n) {
                    case 14: {
                        this.setTitle(this.session.isClientPlayerTurn() ? Language.langTexts[Language.TITLE_SPORTSELECT] : this.getCurrentPlayerTitle(Language.langTexts[Language.TITLE_SPORTSELECT_ROBOT]));
                        String string = Language.replace(Language.langTexts[Language.TEXT_MSGROUND], "%point%", Integer.toString(GameSession.currentRound * 100));
                        string = Language.replace(string, "%round%", Integer.toString(GameSession.currentRound));
                        string = Language.replace(string, "%question%", Integer.toString(this.session.getCurrentPlayerIndex()));
                        this.setMessageText(string);
                        break;
                    }
                    case 10: {
                        this.setTitle(this.getCurrentPlayerTitle(Language.langTexts[Language.TITLE_SPORTSELECT_ROBOT]));
                        if (this.session.isClientPlayerTurn()) {
                            this.setMessageText(Language.langTexts[Language.TEXT_MSGPLAYER_FAV]);
                            break;
                        }
                        this.setMessageText(this.getCurrentPlayerTitle(Language.langTexts[Language.TEXT_MSGROBOT_FAV]));
                        break;
                    }
                    case 26: {
                        this.setTitle(this.session.isClientPlayerTurn() ? Language.langTexts[Language.TITLE_ATTACK] : this.getCurrentPlayerTitle(Language.langTexts[Language.TITLE_ATTACK_ROBOT]));
                        if (this.session.isClientPlayerTurn()) {
                            this.setMessageText(Language.langTexts[Language.TEXT_MSGPLAYER_ATTACK]);
                            break;
                        }
                        this.setMessageText(this.getCurrentPlayerTitle(Language.langTexts[Language.TITLE_ATTACK_ROBOT]));
                    }
                }
                break;
            }
            case 24: {
                showMap = !this.session.isClientPlayerTurn();
                this.userSelection = false;
                this.setTitle(Language.langTexts[Language.TITLE_ATTACKCONFIRM]);
                this.setQuizText(Language.langTexts[Language.TEXT_MSGCONFIRM_ATTACK]);
                attackConfirmList.setSelectedIndex(0);
                this.timer.reset();
                break;
            }
            case 25: {
                showMap = false;
                this.timer.reset();
                if (this.session.isPlayerAttackConfirmed()) break;
                this.setMessageText(this.getCurrentPlayerTitle(Language.langTexts[Language.TEXT_MSGATTACK_SKIP]));
                break;
            }
            case 29: {
                showMap = false;
                barTitleAlign = 4;
                this.setTitle(this.session.currentPlayer.name + Language.langTexts[Language.TITLE_ATTACK_DELIMITER] + this.session.currentPlayer.inAttackWith.name);
                if (!this.session.isClientPlayerPlaysInQuiz()) {
                    possQuizAnswers.setSelectedIndex(-1);
                } else {
                    possQuizAnswers.setSelectedIndex(0);
                }
                this.setQuizText(this.session.currentQuiz.question);
                for (int i = 0; i < 4; ++i) {
                    PQListItem pQListItem = (PQListItem)possQuizAnswers.getItem(i);
                    pQListItem.setText(((PossibilityQuiz)this.session.currentQuiz).answers[i]);
                }
                break;
            }
            case 28: {
                showMap = false;
                this.statePhase = 1;
                this.timer.reset();
            }
            case 12: 
            case 16: {
                this.messageBoxVisible = false;
                this.selectedSport = this.session.currentPlayer.selectedSport;
                if (n != 12) break;
                this.selectedSport.favSport = false;
                break;
            }
            case 11: 
            case 15: 
            case 27: {
                showMap = false;
                this.userSelection = false;
                this.barState = 0;
                this.cursorFlashing = 0;
                this.timer.reset();
                break;
            }
            case 19: 
            case 35: {
                barTitleAlign = 1;
                this.setTitle(Language.langTexts[Language.TITLE_QUIZRESULT]);
                displayPlayerID = -1;
                this.initPlayerListItems(this.session.displayPList, (byte)0);
            }
            case 18: 
            case 34: {
                sendButtonText = Language.langTexts[Language.BUTTONTS_TIPSEND];
            }
            case 31: {
                if (n == 31) {
                    barTitleAlign = 1;
                    this.setTitle(Language.langTexts[Language.TITLE_QUIZRESULT]);
                }
                PQListItem.setAttackWinner(this.session.getAttackWinner());
                attackFxClippingHeight = 0;
            }
            case 30: {
                showMap = false;
                this.userSelection = false;
                this.barState = 0;
                this.cursorFlashing = 0;
                this.timer.reset();
                break;
            }
            case 20: 
            case 36: {
                showMap = false;
            }
            case 32: {
                this.scoreFxAnim = 0;
                this.timer.reset();
            }
        }
        this.sessionState = n;
    }

    private boolean moveMapFocus(Sport sport) {
        if (this.focusDirection <= 0 && sport.posX + gameMapPosX > (this.screen.width >> 1) - gameMapBorderWidth && gameMapPosX > this.screen.width - ModelControl.GAMEMAP_WIDTH - (gameMapBorderWidth << 1)) {
            gameMapPosX -= this.screen.width >> 5;
            this.focusDirection = (byte)-1;
            return true;
        }
        if (this.focusDirection >= 0 && sport.posX + gameMapPosX < (this.screen.width >> 1) - gameMapBorderWidth && gameMapPosX < gameMapBorderWidth) {
            gameMapPosX += this.screen.width >> 5;
            this.focusDirection = 1;
            return true;
        }
        this.focusDirection = 0;
        return false;
    }

    private void tickResultList(long l, long l2) {
        switch (this.statePhase) {
            case 0: {
                displayPlayerID = (int)(l / 1500L);
                if (displayPlayerID < this.session.displayPList.size) break;
                this.timer.reset();
                ++this.statePhase;
                break;
            }
            case 1: {
                if (l < l2 && !this.userSelection) break;
                this.userSelection = false;
                ++this.statePhase;
            }
        }
    }

    private void updateCursorFlash() {
        if (this.cursorFlashing++ > 6) {
            this.cursorFlashing = 0;
        }
    }

    private void updateTimer(long l) {
        this.barState = (int)(l / 3000L);
    }

    private void sendQuizAnswer(int n, long l) {
        this.setTitle(Language.langTexts[Language.TITLE_WAIT]);
        GameSession.clientPlayer.setSelectedQuizAnswer(n, l);
        this.session.quizAnswered(GameSession.clientPlayer);
        this.barState = 0;
        this.userSelection = false;
    }

    private synchronized void tickSessionState() {
        switch (this.sessionState) {
            case 1: {
                this.session.resume();
                break;
            }
            case 100: {
                long l = this.timer.tick();
                switch (this.statePhase) {
                    case 0: 
                    case 1: {
                        this.tickResultList(l, 2000L);
                        if (this.statePhase != 2) break;
                        this.messageBoxVisible = true;
                        break;
                    }
                    case 2: {
                        if (!this.userSelection && textMessage != null) break;
                        this.userSelection = false;
                        this.messageBoxVisible = false;
                        this.setState(6);
                    }
                }
                break;
            }
            case 26: {
                this.session.resume();
                break;
            }
            case 10: 
            case 14: {
                switch (this.statePhase) {
                    case 0: {
                        if (this.moveMapFocus(this.selectedSport)) break;
                        this.timer.reset();
                        ++this.statePhase;
                        break;
                    }
                    case 1: {
                        long l = this.timer.tick();
                        if (l < 3000L) break;
                        ++this.statePhase;
                        break;
                    }
                    case 2: {
                        this.session.resume();
                    }
                }
                break;
            }
            case 11: 
            case 15: 
            case 27: {
                if (this.session.isClientPlayerTurn()) {
                    switch (this.statePhase) {
                        case 0: {
                            if (this.countySelectionChanged) {
                                this.countySelectionChanged = false;
                                this.selectedSport = this.session.currentPlayer.selectable.get(this.selectedCountyIndex);
                                this.setTitle(Language.langTexts[Language.TEXT_FIRSTSPORT + this.selectedSport.id]);
                                if (this.sessionState != 27) {
                                    this.statePhase = 1;
                                }
                            }
                            if (!this.userSelection) break;
                            GameSession.clientPlayer.setSelectedSportIndex(this.selectedCountyIndex);
                            this.session.sportSelected();
                            this.barState = 0;
                            this.statePhase = 2;
                            break;
                        }
                        case 1: {
                            if (this.moveMapFocus(this.selectedSport)) break;
                            this.statePhase = 0;
                            break;
                        }
                    }
                }
                this.updateCursorFlash();
                break;
            }
            case 12: 
            case 16: 
            case 28: {
                switch (this.statePhase) {
                    case 0: {
                        if (!this.session.isClientPlayerTurn()) {
                            if (this.moveMapFocus(this.selectedSport)) break;
                            this.timer.reset();
                            ++this.statePhase;
                            break;
                        }
                        this.timer.reset();
                        ++this.statePhase;
                        break;
                    }
                    case 1: {
                        long l = this.timer.tick();
                        if (l < 1500L) {
                            this.updateCursorFlash();
                            break;
                        }
                        if (l > 3000L) {
                            this.session.resume();
                            break;
                        }
                        if (this.sessionState == 12) {
                            this.selectedSport.favSport = true;
                            break;
                        }
                        this.cursorFlashing = 3;
                    }
                }
                break;
            }
            case 24: {
                if (!this.session.isClientPlayerTurn()) break;
                attackConfirmList.refresh();
                long l = this.timer.tick();
                if (!this.userSelection) {
                    if (l < GameSession.USER_RESPONSE_TIME) break;
                }
                this.session.confirmSelected(attackConfirmList.getSelectedIndex() == 0);
                break;
            }
            case 25: {
                if (this.session.isPlayerAttackConfirmed()) {
                    this.session.resume();
                    break;
                }
                long l = this.timer.tick();
                if (this.session.isClientPlayerTurn()) {
                    attackConfirmList.setSelectedIndex(this.cursorFlashing % 2 == 0 ? 1 : -1);
                    attackConfirmList.refresh();
                    this.updateCursorFlash();
                    if (l < 3000L) break;
                    this.session.resume();
                    break;
                }
                if (l < 6000L) break;
                this.session.resume();
                break;
            }
            case 17: 
            case 29: 
            case 33: {
                if (this.sessionState == 33) {
                    long l = this.timer.tick();
                    if (l <= 6000L) break;
                    this.messageBoxVisible = false;
                    this.session.resume();
                    break;
                }
                this.session.resume();
                break;
            }
            case 30: {
                possQuizAnswers.refresh();
                this.scrollQuizField();
                switch (this.statePhase) {
                    case 0: {
                        if (this.session.isClientPlayerPlaysInQuiz()) {
                            long l = this.timer.tick();
                            this.updateTimer(l);
                            if (!this.userSelection) {
                                if (l < GameSession.USER_RESPONSE_TIME) break;
                            }
                            if (l > GameSession.USER_RESPONSE_TIME) {
                                l = GameSession.USER_RESPONSE_TIME;
                            }
                            if (this.userSelection) {
                                this.sendQuizAnswer(possQuizAnswers.getSelectedIndex(), l);
                            } else {
                                this.sendQuizAnswer(-2, GameSession.USER_RESPONSE_TIME);
                            }
                            possQuizAnswers.setSelectedIndex(-1);
                            this.statePhase = 1;
                            break;
                        }
                        ++this.statePhase;
                        break;
                    }
                }
                this.updateCursorFlash();
                break;
            }
            case 31: {
                long l = this.timer.tick();
                switch (this.statePhase) {
                    case 0: {
                        showMap = false;
                        possQuizAnswers.refresh();
                        if (l >= 2500L) {
                            possQuizAnswers.setSelectedIndex(this.cursorFlashing > 3 ? this.session.currentQuiz.correctAnswer : -1);
                        }
                        if (l >= 5000L) {
                            this.statePhase = 1;
                        }
                        if (this.statePhase != 1) break;
                        showMap = true;
                        this.messageBoxVisible = true;
                        this.timer.reset();
                        if (this.session.lastAttackResult == 0) {
                            this.setMessageText(Language.langTexts[Language.TEXT_ATTACK_DRAWN_LOOSE]);
                            break;
                        }
                        if (this.session.getAttackWinner() != null && this.session.getAttackWinner() == this.session.currentPlayer) {
                            String string;
                            if (this.session.getAttackWinner() == GameSession.clientPlayer) {
                                string = Language.replace(Language.langTexts[Language.TEXT_ATTACK_SUCCESS_USER], "%attacked%", this.session.currentPlayer.inAttackWith.name);
                            } else if (this.session.getAttackWinner().inAttackWith != GameSession.clientPlayer) {
                                string = Language.replace(Language.langTexts[Language.TEXT_ATTACK_SUCCESS_ROBOT], "%attacker%", this.session.currentPlayer.name);
                                string = Language.replace(string, "%attacked%", this.session.currentPlayer.inAttackWith.name);
                            } else {
                                string = Language.replace(Language.langTexts[Language.TEXT_ATTACK_SUCCESS_ROBOT_USER], "%attacker%", this.session.currentPlayer.name);
                            }
                            this.setMessageText(string);
                            break;
                        }
                        this.setMessageText(Language.langTexts[Language.TEXT_ATTACK_DRAWN_LOOSE]);
                        break;
                    }
                    case 1: {
                        if (l < 500L) break;
                        this.session.resume();
                    }
                }
                this.updateCursorFlash();
                break;
            }
            case 18: 
            case 34: {
                this.scrollQuizField();
                if (this.session.isClientPlayerPlaysInQuiz()) {
                    switch (this.statePhase) {
                        case 0: {
                            long l = this.timer.tick();
                            this.updateTimer(l);
                            int n = this.sendButtonFlash = this.tipQuizInput.length() > 0 && this.cursorFlashing > 3 ? ModelControl.menuButton.getHeight() >> 1 : 0;
                            if (!this.userSelection) {
                                if (l < GameSession.USER_RESPONSE_TIME) break;
                            }
                            if (l > GameSession.USER_RESPONSE_TIME) {
                                l = GameSession.USER_RESPONSE_TIME;
                            }
                            sendButtonText = Language.langTexts[Language.BUTTONTS_TIPSENT];
                            int n2 = this.tipQuizInput.length() > 0 ? Integer.parseInt(this.tipQuizInput.toString()) : -2000;
                            this.sendQuizAnswer(n2, l);
                            this.statePhase = 1;
                            break;
                        }
                        case 1: {
                            this.sendButtonFlash = ModelControl.menuButton.getHeight() >> 1;
                        }
                    }
                }
                this.updateCursorFlash();
                break;
            }
            case 20: 
            case 32: 
            case 36: {
                long l = this.timer.tick();
                if (l >= 5000L) {
                    int n = 0;
                    while (true) {
                        if (n >= 3) break;
                        GameSession.players[n].scoreChanged = false;
                        ++n;
                    }
                    if (this.sessionState == 32) {
                        this.messageBoxVisible = false;
                    }
                    this.scoreFxAnim = -1;
                    this.session.resume();
                    break;
                }
                if (this.scoreFxAnim++ == 8) {
                    this.scoreFxAnim = 0;
                }
                if (l < 3000L) break;
                this.scoreFxAnim = -1;
                break;
            }
            case 19: 
            case 35: {
                long l = this.timer.tick();
                this.tickResultList(l, 500L);
                if (this.statePhase == 2) {
                    this.session.resume();
                }
                this.updateCursorFlash();
            }
        }
    }

    private void resetGame() {
        this.statePhase = 0;
        this.sessionState = 0;
        showMap = false;
        this.userSelection = false;
        this.session.reset();
    }

    protected void tick() {
        if (gamePaused) {
            GameScreen.possQuizAnswers.forceRepaint = true;
            return;
        }
        switch (this.state) {
            case 0: {
                try {
                    switch (this.loadingPhase) {
                        case 0: {
                            if (header == null) {
                                header = ModelControl.FILE_IMGS.getNextImage();
                                footer = ModelControl.FILE_IMGS.getNextImage();
                                AJScreen.background = ModelControl.FILE_IMGS.getNextImage();
                                this.backgroundHeight = AJScreen.background.getHeight();
                                ModelControl.FILE_IMGS.close();
                            }
                            this.screen.showBackgroundImage = true;
                            this.scoreNumWidth = scoreNums.getWidth() / 10;
                            this.screen.setBackgroundPos(0, header.getHeight());
                            if (this.inSession) {
                                this.loadingPhase = 3;
                                break;
                            }
                            this.resetGame();
                            possQuizAnswersHeight = possQuizAnswers.getHeight();
                            attackConfirmHeight = attackConfirmList.getHeight();
                            this.session.loadSports();
                            this.session.loadQuiz((byte)0, quizRes);
                            ++this.loadingPhase;
                            break;
                        }
                        case 1: {
                            quizRes.loadCategory();
                            if (++quizLoadingState != 22) break;
                            this.session.loadQuiz((byte)1, quizRes);
                            ++this.loadingPhase;
                            break;
                        }
                        case 2: {
                            quizRes.loadCategory();
                            if (++quizLoadingState != 43) break;
                            ++this.loadingPhase;
                            break;
                        }
                        case 3: {
                            System.gc();
                            this.setState(1);
                        }
                    }
                }
                catch (IOException iOException) {
                    this.setState(-1);
                }
                break;
            }
            case 1: {
                if (this.gameMenuTicker++ == 5) {
                    this.gameMenuTicker = 0;
                }
                this.session.tick();
                this.tickSessionState();
                break;
            }
            case 6: {
                if (this.loadingPhase == 1) {
                    this.showMenu();
                    break;
                }
                this.loadingPhase = 1;
            }
        }
        try {
            DeviceControl.setLights((int)0, (int)100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showMenu() {
        this.screen.setBackgroundPos(0, 0);
        this.screen.showBackgroundImage = false;
        this.screen.setFullScreen(false);
        this.screen.setCurrent(ModelControl.mainMenu);
    }

    private void handleTipQuizInput(int n) {
        if (n >= 48 && n <= 57) {
            if (this.tipQuizInput.length() < 9) {
                this.tipQuizInput.append(n - 48);
            }
        } else if (this.tipQuizInput.length() > 0) {
            int n2 = this.screen.getGameActionKey(n);
            if (n == -8) {
                n2 = 2;
            }
            switch (n2) {
                case 2: {
                    this.tipQuizInput.deleteCharAt(this.tipQuizInput.length() - 1);
                    break;
                }
                case 8: {
                    this.userSelection = true;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getNearestCounty(int n) {
        int n2 = this.session.currentPlayer.selectable.size();
        SportList sportList = this.session.currentPlayer.selectable;
        Sport sport = sportList.get(this.selectedCountyIndex);
        int n3 = 9999999;
        int n4 = -1;
        int n5 = 0;
        while (true) {
            block9: {
                if (n5 >= n2) {
                    return n4;
                }
                Sport sport2 = this.session.currentPlayer.selectable.get(n5);
                switch (n) {
                    case 5: {
                        if (sport.posX < sport2.posX && Math.abs(sport.posY - sport2.posY) <= Math.abs(sport.posX - sport2.posX) * 2) break;
                        break block9;
                    }
                    case 2: {
                        if (sport.posX > sport2.posX && Math.abs(sport.posY - sport2.posY) <= Math.abs(sport.posX - sport2.posX) * 2) break;
                        break block9;
                    }
                    case 1: {
                        if (sport.posY > sport2.posY && Math.abs(sport.posX - sport2.posX) <= Math.abs(sport.posY - sport2.posY) * 2) break;
                        break block9;
                    }
                    case 6: {
                        if (sport.posY >= sport2.posY || Math.abs(sport.posX - sport2.posX) > Math.abs(sport.posY - sport2.posY) * 2) break block9;
                    }
                }
                int n6 = sport.posY - sport2.posY;
                int n7 = sport.posX - sport2.posX;
                int n8 = n7 * n7 + n6 * n6;
                if (n3 > n8) {
                    n3 = n8;
                    n4 = n5;
                }
            }
            ++n5;
        }
    }

    private void handleCursorInput(int n) {
        int n2;
        int n3 = this.screen.getGameActionKey(n);
        if (n3 == 8) {
            this.userSelection = true;
        } else if (n3 != 0 && (n2 = this.getNearestCounty(n3)) > -1) {
            this.selectedCountyIndex = n2;
            this.countySelectionChanged = true;
        }
    }

    private void handleListEvent(AJList aJList, int n, boolean bl) {
        aJList.keyEvent(n, bl);
        if (this.screen.getGameActionKey(n) == 8) {
            this.userSelection = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void keyEvent(int n, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.state == 1 && (n == 35 || gamePaused)) {
            gamePaused = !gamePaused;
            return;
        }
        switch (this.state) {
            case 1: {
                switch (this.sessionState) {
                    case 18: 
                    case 34: {
                        if (!this.session.isClientPlayerPlaysInQuiz() || this.statePhase != 0) break;
                        this.handleTipQuizInput(n);
                        break;
                    }
                    case 19: 
                    case 35: {
                        if (this.statePhase != 1) break;
                        this.userSelection = true;
                        break;
                    }
                    case 11: 
                    case 15: 
                    case 27: {
                        if (this.statePhase != 0 || !this.session.isClientPlayerTurn()) break;
                        this.handleCursorInput(n);
                        break;
                    }
                    case 30: {
                        if (!this.session.isClientPlayerPlaysInQuiz()) break;
                        this.handleListEvent(possQuizAnswers, n, bl);
                        break;
                    }
                    case 24: {
                        if (!this.session.isClientPlayerTurn()) break;
                        this.handleListEvent(attackConfirmList, n, bl);
                        break;
                    }
                    case 100: {
                        if (this.statePhase < 1) break;
                        this.userSelection = true;
                    }
                }
                break;
            }
        }
        if (!bl) return;
        if (!this.screen.leftSoftkeyPressed(n)) {
            if (n != 42) return;
        }
        switch (this.sessionState) {
            case 0: 
            case 6: 
            case 18: 
            case 30: 
            case 34: 
            case 100: {
                return;
            }
        }
        this.setState(6);
    }

    private int getQuizVerticalCenter() {
        return header.getHeight() + quizField.getHeight() + (this.backgroundHeight - quizField.getHeight() >> 1);
    }

    private void displayWrappedText(Graphics graphics, String[] stringArray, int n, int n2, int n3, boolean bl, AJGraphicFont aJGraphicFont) {
        if (bl) {
            n2 -= stringArray.length * ModelControl.font.getHeight() >> 1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            aJGraphicFont.render(graphics, stringArray[i], n, n2, n3 | 0x10);
            n2 += ModelControl.font.getHeight();
        }
    }

    public void displayScoreNumbers(Graphics graphics, String string, int n, int n2) {
        int n3 = string.length();
        n -= n3 * this.scoreNumWidth >> 1;
        n2 -= scoreNums.getHeight() >> 1;
        for (int i = 0; i < n3; ++i) {
            graphics.drawRegion(scoreNums, (string.charAt(i) - 48) * this.scoreNumWidth, 0, this.scoreNumWidth, scoreNums.getHeight(), 0, n + i * this.scoreNumWidth, n2, 20);
        }
    }

    private int drawMessageBox(Graphics graphics, int n) {
        int n2 = textMessage.length * ModelControl.font.getHeight() + n + (ModelControl.font.getHeight() + (ModelControl.font.getHeight() >> 2));
        int n3 = (this.screen.height >> 1) - (n2 >> 1);
        graphics.setColor(798289);
        graphics.fillRect(this.screen.width >> 6, n3, this.screen.width - (this.screen.width >> 5), n2);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(this.screen.width >> 6, n3, this.screen.width - (this.screen.width >> 5), n2);
        this.displayWrappedText(graphics, textMessage, this.screen.width >> 1, (this.screen.height >> 1) + (n >> 1) + (n >> 3), 1, true, ModelControl.font);
        return n3;
    }

    private void drawRoundMessage(Graphics graphics) {
        int n = this.drawMessageBox(graphics, flags.getHeight());
        GameScreen.drawFlag(graphics, this.session.currentPlayer.countryId, (this.screen.width >> 1) - (flagWidth >> 1), n + (ModelControl.font.getHeight() >> 1));
    }

    private void drawAttackFlags(Graphics graphics) {
        int n = header.getHeight() + (this.backgroundHeight >> 2) - (flags.getHeight() >> 1);
        int n2 = ModelControl.font.stringWidth(Language.langTexts[Language.TITLE_ATTACK_DELIMITER]);
        GameScreen.drawFlag(graphics, this.session.currentPlayer.countryId, (this.screen.width >> 1) - (n2 >> 1) - 1 - flagWidth, n);
        GameScreen.drawFlag(graphics, this.session.currentPlayer.inAttackWith.countryId, (this.screen.width >> 1) + (n2 >> 1) + 1, n);
        ModelControl.font.render(graphics, Language.langTexts[Language.TITLE_ATTACK_DELIMITER], this.screen.width >> 1, n + (flags.getHeight() >> 1), 3);
    }

    private void scrollQuizField() {
        int n = quizQuestion.length * ModelControl.font.getHeight();
        if (53 < n) {
            if (scrollWait == 0) {
                if ((scrollPosY += scrollDirection * 2) >= n - 53) {
                    scrollDirection = (byte)-1;
                    scrollWait = 5;
                } else if (scrollPosY <= 0) {
                    scrollDirection = 1;
                    scrollWait = 10;
                } else {
                    scrollWait = 1;
                }
            } else {
                --scrollWait;
            }
        }
    }

    private void drawQuizField(Graphics graphics, boolean bl) {
        graphics.drawImage(quizField, 0, header.getHeight(), 20);
        if (bl) {
            int n = graphics.getClipWidth();
            int n2 = graphics.getClipHeight();
            graphics.setClip(0, header.getHeight() + 10, this.screen.width, 53);
            this.displayWrappedText(graphics, quizQuestion, this.screen.width >> 1, header.getHeight() + 10 - scrollPosY, 1, false, ModelControl.font);
            graphics.setClip(0, 0, n, n2);
        }
    }

    private void drawHeaderBars(Graphics graphics, boolean bl) {
        if (bl) {
            graphics.drawImage(headerTimeField, this.screen.width - headerTimeField.getWidth(), 0, 20);
            if (this.timer.currentSecs < 10000L || this.cursorFlashing > 3) {
                this.displayScoreNumbers(graphics, this.timer.toString(GameSession.USER_RESPONSE_TIME), this.screen.width - (headerTimeField.getWidth() >> 1), headerTimeField.getHeight() >> 1);
            }
        }
    }

    public void drawRounds(Graphics graphics) {
        int n = roundGauge.getWidth() >> 1;
        int n2 = this.screen.width - GameSession.MAX_ROUNDS * n - (n >> 2);
        int n3 = 0;
        while (true) {
            if (n3 >= GameSession.MAX_ROUNDS) break;
            graphics.drawRegion(roundGauge, n * (n3 > GameSession.currentRound - 1 ? 0 : 1), 0, n, roundGauge.getHeight(), 0, n2, this.screen.height - (footer.getHeight() >> 1) - (footer.getHeight() >> 2) - (roundGauge.getHeight() >> 1), 20);
            n2 += n;
            ++n3;
        }
    }

    private void initPlayerListItems(PlayerList playerList, byte by) {
        for (int i = 0; i < playerList.size; ++i) {
            playerListItems[i].set(playerList.get(i), by, i);
        }
    }

    private String getCorrectAnswer() {
        return Language.direction == 1 ? Language.langTexts[Language.TEXT_TIPQUIZ_CORRECTA] + Integer.toString(this.session.currentQuiz.correctAnswer) : Integer.toString(this.session.currentQuiz.correctAnswer) + Language.langTexts[Language.TEXT_TIPQUIZ_CORRECTA];
    }

    private void drawTipQuizResult(Graphics graphics, int n) {
        this.drawPlayerList(graphics, n, ModelControl.font.getHeight() >> 2);
        if (this.cursorFlashing > 3) {
            ModelControl.font.render(graphics, this.getCorrectAnswer(), this.screen.width >> 1, this.playerListTop - (ModelControl.font.getHeight() >> 3), 33);
        }
    }

    private void drawPlayerList(Graphics graphics, int n, int n2) {
        int n3 = this.playerListTop = header.getHeight() + n2 + (this.backgroundHeight >> 1) - (resultField.getHeight() * this.session.displayPList.size >> 1);
        for (int i = 0; i < n; ++i) {
            graphics.drawImage(resultField, (this.screen.width >> 1) - (resultField.getWidth() >> 1), n3, 20);
            graphics.drawImage(resultFieldHover, (this.screen.width >> 1) - (resultFieldHover.getWidth() >> 1), n3, 20);
            playerListItems[i].paint(graphics, n3);
            n3 += resultField.getHeight() + 3;
        }
    }

    private void drawPossibilityQuiz(Graphics graphics, boolean bl) {
        if (bl) {
            this.drawHeaderBars(graphics, this.statePhase != 1);
        }
        int n = this.getQuizVerticalCenter();
        this.drawQuizField(graphics, true);
        possQuizAnswers.renderAt(graphics, 0, n - (possQuizAnswersHeight >> 1));
    }

    public static void drawFlag(Graphics graphics, int n, int n2, int n3) {
        graphics.drawRegion(flags, n * flagWidth, 0, flagWidth, flags.getHeight(), 0, n2, n3, 20);
    }

    public static void drawMedal(Graphics graphics, int n, int n2, int n3) {
        graphics.drawRegion(medals, n * medalWidth, 0, medalWidth, medals.getHeight(), 0, n2, n3, 20);
    }

    private void drawScoreFx(Graphics graphics, Player player, int n, int n2) {
        int n3 = Integer.toString(player.score).length();
        for (int i = 0; i < n3; ++i) {
            graphics.drawRegion(scoreFx, Math.abs(this.scoreFxAnim - i * 3) % 9 * scoreFxWidth, 0, scoreFxWidth, scoreFx.getHeight(), 0, n - (i + 1) * scoreFxWidth, n2 - (scoreFx.getHeight() >> 1), 20);
        }
    }

    private void drawPlayerStatus(Graphics graphics) {
        int n = 0;
        int n2 = footerPlayerBox.getWidth();
        int n3 = statusPlayerOrder.length;
        int n4 = footerPlayerBox.getHeight();
        for (int i = 0; i < n3; ++i) {
            Player player = statusPlayerOrder[i];
            graphics.drawImage(footerPlayerBox, n, this.screen.height - n4, 0);
            GameScreen.drawFlag(graphics, player.countryId, n + (n2 >> 4), this.screen.height - (n4 >> 1) - (flags.getHeight() >> 1));
            if (this.scoreFxAnim > -1 && player.scoreChanged) {
                this.drawScoreFx(graphics, player, n + n2 - 4, this.screen.height - (n4 >> 1));
            } else {
                ModelControl.font.render(graphics, Integer.toString(player.score), n + n2 - 4, this.screen.height - (n4 >> 1), 10);
            }
            n += n2;
        }
    }

    private void drawSelectableCounties(Graphics graphics, byte by) {
        Object object;
        int n;
        for (n = 0; n < this.session.currentPlayer.selectable.size; ++n) {
            object = this.session.currentPlayer.selectable.data[n];
            ((Sport)object).paintState(graphics, gameMapBorderWidth + gameMapPosX, gameMapPosY);
            if (by != 1) continue;
            GameScreen.drawFlag(graphics, ((Sport)object).selectedBy.countryId, ((Sport)object).posX - (flagWidth >> 1), gameMapPosY + ((Sport)object).posY + (gameMapCell.getHeight() >> 1) + 2);
        }
        if (by == 0) {
            n = 0;
            while (true) {
                if (n >= 3) break;
                object = GameSession.players[n];
                if (((Player)object).favSport != null) {
                    ((Player)object).favSport.paintState(graphics, gameMapBorderWidth + gameMapPosX, gameMapPosY);
                }
                ++n;
            }
        }
    }

    private void drawMap(Graphics graphics) {
        int n = GameSession.map.length;
        for (int i = 0; i < n; ++i) {
            Sport sport = GameSession.map[i];
            if (sport.selectedBy != null && !sport.favSport && sport != this.selectedSport) continue;
            sport.paintState(graphics, gameMapBorderWidth + gameMapPosX, gameMapPosY);
        }
    }

    private void showAttackCountyConqueredFx(Graphics graphics, Sport sport) {
        int n = graphics.getClipWidth();
        int n2 = graphics.getClipHeight();
        if (this.cursorFlashing >= 3) {
            ModelControl.font.render(graphics, this.session.currentPlayer.name, gameMapBorderWidth + gameMapPosX + sport.posX, gameMapPosY + sport.posY, 3);
        }
    }

    private void displayLoadingText(Graphics graphics, String string) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.screen.width, this.screen.height);
        ModelControl.titleFont.render(graphics, string, this.screen.width >> 1, this.screen.height >> 1, 1);
    }

    private void displayBarTitle(Graphics graphics) {
        int n = this.screen.width - 4;
        switch (this.sessionState) {
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                n -= headerTimeField.getWidth();
            }
        }
        if (barTitleLen > n) {
            int n2 = Math.min(barTitleLen - n, barTitleScrollOffset >> 1);
            ModelControl.font.render(graphics, barTitle, 3 - n2, header.getHeight() >> 1, 6);
            if (barTitleScrollOffset++ > (barTitleLen - n) * 3) {
                barTitleScrollOffset = 0;
            }
        } else {
            ModelControl.font.render(graphics, barTitle, barTitleAlign == 4 ? 3 : this.screen.width >> 1, header.getHeight() >> 1, barTitleAlign | 2);
        }
    }

    protected void render(Graphics graphics) {
        int n = 2;
        switch (this.state) {
            case 0: 
            case 6: {
                this.displayLoadingText(graphics, Language.langTexts[Language.TEXT_LOADING]);
                if (this.state != 0 || this.loadingPhase <= 0 || this.loadingPhase >= 3) break;
                this.parent.showLoadingBar(graphics, quizLoadingState / 4, 10);
                break;
            }
            case 1: {
                if (showMap) {
                    this.drawMap(graphics);
                }
                graphics.drawImage(header, 0, 0, 0x10 | 4);
                if (barTitle != null) {
                    this.displayBarTitle(graphics);
                }
                block4 : switch (this.sessionState) {
                    case 0: {
                        this.displayLoadingText(graphics, Language.langTexts[Language.TEXT_LOADING]);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 100: {
                        switch (this.statePhase) {
                            case 0: 
                            case 1: {
                                this.drawPlayerList(graphics, displayPlayerID, 0);
                                break block4;
                            }
                        }
                        break;
                    }
                    case 33: {
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 34: {
                        this.drawQuizField(graphics, true);
                        if (this.session.isClientPlayerPlaysInQuiz()) {
                            int n2 = this.getQuizVerticalCenter();
                            graphics.drawImage(resultField, (this.screen.width >> 1) - (resultField.getWidth() >> 1), n2 - resultField.getHeight(), 20);
                            graphics.drawRegion(ModelControl.menuButton, 0, this.sendButtonFlash, ModelControl.menuButton.getWidth(), ModelControl.menuButton.getHeight() >> 1, 0, (this.screen.width >> 1) - (ModelControl.menuButton.getWidth() >> 1), n2 + 2, 20);
                            ModelControl.font.render(graphics, sendButtonText, this.screen.width >> 1, n2 + 2 + (ModelControl.menuButton.getHeight() >> 2), 3);
                            this.displayScoreNumbers(graphics, this.tipQuizInput.toString(), this.screen.width >> 1, n2 - (resultField.getHeight() >> 1));
                            switch (this.statePhase) {
                                case 0: {
                                    if (this.cursorFlashing <= 3) {
                                        graphics.setColor(0xFFFFFF);
                                        graphics.fillRect((this.screen.width >> 1) + (this.tipQuizInput.length() * this.scoreNumWidth >> 1) + (this.tipQuizInput.length() > 0 ? this.scoreNumWidth >> 2 : 0), n2 - (resultField.getHeight() >> 1) - (scoreNums.getHeight() >> 1), scoreNums.getHeight() >> 2, scoreNums.getHeight());
                                    }
                                    this.drawHeaderBars(graphics, true);
                                    break;
                                }
                                case 1: {
                                    this.drawHeaderBars(graphics, false);
                                }
                            }
                            break;
                        }
                        this.drawHeaderBars(graphics, false);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 35: 
                    case 36: {
                        this.drawTipQuizResult(graphics, displayPlayerID);
                        break;
                    }
                    case 10: 
                    case 14: {
                        this.drawRoundMessage(graphics);
                        break;
                    }
                    case 11: 
                    case 15: 
                    case 27: {
                        boolean bl = this.session.isClientPlayerTurn();
                        this.drawSelectableCounties(graphics, this.sessionState == 27 ? (byte)1 : 0);
                        if (bl && this.statePhase == 0) {
                            this.selectedSport.paintSelection(graphics, gameMapBorderWidth + gameMapPosX, gameMapPosY);
                        }
                        if (this.sessionState == 27) {
                            this.displayWrappedText(graphics, textMessage, this.screen.width >> 1, header.getHeight() + (this.screen.height - header.getHeight() - footer.getHeight() >> 2), 1, true, ModelControl.font);
                            break;
                        }
                        if (bl) break;
                        this.drawRoundMessage(graphics);
                        break;
                    }
                    case 28: {
                        this.drawSelectableCounties(graphics, (byte)1);
                        this.drawAttackFlags(graphics);
                    }
                    case 12: 
                    case 16: {
                        switch (this.statePhase) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                if (this.cursorFlashing % 3 != 0) break;
                                this.selectedSport.paintSelection(graphics, gameMapBorderWidth + gameMapPosX, gameMapPosY);
                                break;
                            }
                            case 2: {
                                if (this.sessionState != 28) break;
                                this.selectedSport.paintState(graphics, gameMapBorderWidth + gameMapPosX, gameMapPosY);
                                break;
                            }
                        }
                        break;
                    }
                    case 25: {
                        if (this.session.isPlayerAttackConfirmed()) break;
                        if (!this.session.isClientPlayerTurn()) {
                            this.drawRoundMessage(graphics);
                            break;
                        }
                        this.drawQuizField(graphics, true);
                        attackConfirmList.renderAt(graphics, 0, this.getQuizVerticalCenter() - (attackConfirmHeight >> 1));
                        break;
                    }
                    case 24: {
                        if (!this.session.isClientPlayerTurn()) break;
                        this.drawQuizField(graphics, true);
                        attackConfirmList.renderAt(graphics, 0, this.getQuizVerticalCenter() - (attackConfirmHeight >> 1));
                        break;
                    }
                    case 29: 
                    case 30: {
                        this.drawPossibilityQuiz(graphics, true);
                        break;
                    }
                    case 31: {
                        if (this.statePhase != 0) break;
                        this.drawPossibilityQuiz(graphics, false);
                    }
                }
                if (this.messageBoxVisible && textMessage != null) {
                    this.drawMessageBox(graphics, 0);
                }
                if (this.sessionState == 0) break;
                graphics.drawImage(footer, 0, this.screen.height, 0x20 | 4);
                if (GameSession.clientPlayer != null) {
                    ModelControl.font.render(graphics, GameSession.clientPlayer.name, this.screen.width / 6, this.screen.height - (footer.getHeight() >> 1) - 2, 33);
                }
                this.drawPlayerStatus(graphics);
                if (this.sessionState <= 12 || this.sessionState >= 33) break;
                this.drawRounds(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStateUpdated(int n) {
        GameScreen gameScreen = this;
        synchronized (gameScreen) {
            this.setSessionState(n);
        }
    }

    public void possibilityQuizAnswered(Player player) {
        if (player.quizAnswer >= 0) {
            ((PQListItem)possQuizAnswers.getItem(player.quizAnswer)).addPlayer(player);
        }
    }

    protected void appActive(boolean bl) {
        gamePaused = !bl;
    }

    protected void activate() {
        this.loadingPhase = 0;
        this.setState(0);
    }

    static {
        header = null;
        footer = null;
        footerPlayerBox = null;
        flagWidth = 0;
        medalWidth = 0;
        quizRes = new Resources();
        quizLoadingState = 0;
        barTitleAlign = 4;
        barTitleScrollOffset = 0;
        gameMapPosX = 0;
        gameMapPosY = 0;
        gameMapBorderWidth = 0;
        showMap = false;
        scrollPosY = 0;
        scrollDirection = 1;
        scrollWait = 0;
        displayPlayerID = -1;
        statusPlayerOrder = new Player[3];
        attackFxClippingHeight = 0;
    }
}

