/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;

public class ModelControl
implements AJCommandListener,
CommandListener {
    private static final String VERSION = "1.3";
    private static ModelControl instance = null;
    private BChallenge parent;
    static AJScreen screen;
    private AJSplash splash;
    public static final String MENUBG_FILE = "/mbg.png";
    public static final String MENUHDR_FILE = "/hdr.png";
    public static final String MENUFTR_FILE = "/ftr.png";
    public static Image menuButton;
    private static final String FILE_FONT = "/font";
    public static AJGraphicFont font;
    public static AJGraphicFont titleFont;
    public static GameScreen mscreen;
    public static AJList mainMenu;
    public static AJList options;
    public static AJList continueMenu;
    public static AJList countryList;
    public static AJText infoText;
    public static Command SELECT;
    public static Command OKCMD;
    public static Command OKCMD_INPUT;
    public static Command BACK;
    public static Command YES;
    public static Command NO;
    public static Command UPDATE;
    boolean firstTimeGamePlay = true;
    private static final int BACKGROUND_COLOR = 1185829;
    private static final int BORDER_COLOR = 2122380;
    private static final int BORDERLINE_COLOR = 4547718;
    public static final int LOADINGBAR_LIGHTCOLOR = 2122380;
    public static final int LOADINGBAR_DARKCOLOR = 863051;
    static int GAMEMAP_WIDTH;
    static int GAMEMAP_HEIGHT;
    static final int SCREEN_WIDTH = 240;
    static final int SCREEN_HEIGHT = 320;
    static final int SOFTKEY_HCENTER_POS = 47;
    static final int MENUITEM_SPACING = 10;
    static final int MAX_VISIBLE_MENUITEMS = 5;
    static final int INFOIMAGE_BORDER = 15;
    static final int SPLASH_BOTTOM_OFFSET = 5;
    static final int SCROLL_SPEED = 2;
    static final int ATTACK_SEQUENCE_SLICEWIDTH = 10;
    static final int QUIZFIELD_TOP = 10;
    static final int QUIZFIELD_HEIGHT = 53;
    static final int PQUIZANSWERS_ITEMSPACING = 4;
    public static String[] countries;
    public static String playerName;
    public static int selectedCountry;
    static TextBox userNameInput;
    public static AJPackInputStream FILE_IMGS;
    private static AJPackInputStream FILE_UI;
    public static final int MAX_LOADING_STATES = 5;

    public static ModelControl getInstance(BChallenge bChallenge) {
        if (instance == null) {
            instance = new ModelControl(bChallenge);
        }
        return instance;
    }

    private ModelControl(BChallenge bChallenge) {
        this.parent = bChallenge;
        Resources.loadRMS();
        playerName = Language.langTexts[Language.DEFAULT_PLAYERNAME];
        SELECT = new Command(Language.langTexts[Language.TEXT_CMD_SELECT], 4, 1);
        OKCMD = new Command(Language.langTexts[Language.TEXT_CMD_OK], 4, 1);
        OKCMD_INPUT = new Command(ModelControl.reverseText(Language.langTexts[Language.TEXT_CMD_OK]), 4, 1);
        BACK = new Command(Language.langTexts[Language.TEXT_CMD_BACK], 2, 1);
        YES = new Command(Language.langTexts[Language.TEXT_CMD_YES], 4, 1);
        NO = new Command(Language.langTexts[Language.TEXT_CMD_NO], 2, 1);
        UPDATE = new Command(Language.langTexts[Language.TEXT_CMD_UPDATE], 4, 1);
        userNameInput.addCommand(OKCMD_INPUT);
        userNameInput.setCommandListener((CommandListener)this);
        userNameInput.setString(playerName == null ? Language.langTexts[Language.DEFAULT_PLAYERNAME] : playerName);
    }

    private static String reverseText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Language.direction < 0) {
            for (int i = 0; i < string.length(); ++i) {
                stringBuffer.insert(0, string.charAt(i));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void init(int n) throws IOException {
        String string = Language.langTexts[Language.TEXT_LOADING];
        if (this.splash == null) {
            font = AJGraphicFont.loadFontFromPack(FILE_FONT, "small");
            titleFont = AJGraphicFont.loadFontFromPack(FILE_FONT, "title");
            FILE_IMGS = new AJPackInputStream(this.getClass().getResourceAsStream("/imgs"));
            FILE_UI = new AJPackInputStream(this.getClass().getResourceAsStream("/ui"));
            screen = AJScreen.getScreen(240, 320, titleFont, this.parent);
            screen.setFullScreen(true);
            this.splash = new AJSplash(this);
            AJSplash.loadingFont = font;
            AJSplash.loadingText = null;
            screen.setCurrent(this.splash);
        }
        switch (n) {
            case 0: {
                screen.clearBackImage();
                this.splash.setImage(AJScreen.loadImage("/sp.png"));
                screen.setLogoBackground(true, 0);
                break;
            }
            case 1: {
                AJPackInputStream aJPackInputStream = new AJPackInputStream(this.getClass().getResourceAsStream("/sportmap"));
                GameScreen.gameSportIcons = aJPackInputStream.getAllImages();
                aJPackInputStream.close();
                AJScreen.verticalArrows = FILE_IMGS.getNextImage();
                break;
            }
            case 2: {
                GameScreen.gameMapCell = FILE_IMGS.getNextImage();
                GameScreen.gameMapCellSel = FILE_IMGS.getNextImage();
                GameScreen.footerPlayerBox = FILE_IMGS.getNextImage();
                GameScreen.quizField = FILE_IMGS.getNextImage();
                GameScreen.headerTimeField = FILE_IMGS.getNextImage();
                break;
            }
            case 3: {
                GameScreen.scoreFx = FILE_UI.getNextImage();
                GameScreen.resultField = FILE_UI.getNextImage();
                GameScreen.resultFieldHover = FILE_UI.getNextImage();
                GameScreen.resultFieldClock = FILE_UI.getNextImage();
                GameScreen.roundGauge = FILE_UI.getNextImage();
                break;
            }
            case 4: {
                GameScreen.quizButton = FILE_UI.getNextImage();
                GameScreen.scoreNums = FILE_UI.getNextImage();
                GameScreen.gameMenu = FILE_UI.getNextImage();
                break;
            }
            case 5: {
                GameScreen.flags = AJScreen.loadImage("/flag.png");
                GameScreen.medals = FILE_UI.getNextImage();
                menuButton = FILE_UI.getNextImage();
                FILE_UI.close();
                this.loadCountries();
                System.gc();
            }
        }
    }

    private void setup() {
        int n;
        screen.setFullScreen(false);
        screen.clearBackImage();
        screen.setLogoBackground(false, 0);
        AJScreen.softkeyHOffsetCenter = 47;
        AJScreen.softkeyVOffset = ModelControl.screen.bottomHeight >> 1;
        AJScreen.titleHAlign = 1;
        AJScreen.titleVAlign = 2;
        AJScreen.titleHPosition = ModelControl.screen.width >> 1;
        AJScreen.titleVPosition = ModelControl.screen.top >> 1;
        AJScreen.backgroundFill = 1185829;
        AJScreen.borderColor = 2122380;
        AJScreen.borderLineColor = 4547718;
        mainMenu = new AJList();
        ModelControl.mainMenu.itemFont = font;
        ModelControl.mainMenu.itemSpacing = 10;
        ModelControl.mainMenu.itemAlign = 1;
        for (n = 0; n < 4; ++n) {
            mainMenu.add(Language.langTexts[Language.TEXT_MENU_FIRSTITEM + n], menuButton, 2);
        }
        mainMenu.setMenuMode(true, 5);
        ModelControl.mainMenu.title = Language.langTexts[Language.TEXT_MENUTITLE];
        mainMenu.addCommand(SELECT);
        mainMenu.setSelectCommand(SELECT);
        mainMenu.setCommandListener(this);
        infoText = new AJText();
        ModelControl.infoText.borderWidth = 15;
        ModelControl.infoText.textHAlign = Language.direction == 1 ? 4 : 8;
        ModelControl.infoText.textFont = font;
        infoText.setCommandListener(this);
        continueMenu = new AJList();
        ModelControl.continueMenu.itemFont = font;
        ModelControl.continueMenu.itemSpacing = 10;
        ModelControl.continueMenu.itemAlign = 1;
        continueMenu.add(Language.langTexts[Language.CONTMENU_CONTINUE], menuButton, 2);
        continueMenu.add(Language.langTexts[Language.CONTMENU_NEWGAME], menuButton, 2);
        continueMenu.setMenuMode(true, 5);
        ModelControl.continueMenu.title = Language.langTexts[Language.TITLE_CONTINUE];
        continueMenu.addCommand(SELECT);
        continueMenu.addCommand(BACK);
        continueMenu.setSelectCommand(SELECT);
        continueMenu.setCommandListener(this);
        countryList = new AJList();
        ModelControl.countryList.itemFont = font;
        ModelControl.countryList.itemSpacing = 10;
        ModelControl.countryList.itemAlign = 1;
        ModelControl.countryList.title = Language.langTexts[Language.TITLE_SELECTCOUNTRY];
        for (n = 0; n < countries.length; ++n) {
            countryList.add(countries[n], menuButton, 2);
        }
        countryList.setSelectedIndex(0);
        countryList.setMenuMode(true, 4);
        countryList.setSelectCommand(SELECT);
        countryList.addCommand(BACK);
        countryList.setCommandListener(this);
        options = new AJList();
        ModelControl.options.itemFont = font;
        ModelControl.options.itemSpacing = 2;
        ModelControl.options.itemAlign = 1;
        ModelControl.options.title = Language.langTexts[Language.TITLE_OPTIONS];
        ModelControl.options.showLabels = true;
        options.addCommand(BACK);
        options.setSelectCommand(SELECT);
        options.setCommandListener(this);
        options.add("VAL", menuButton, 2);
        ModelControl.options.getItem((int)0).label = Language.langTexts[Language.OPTMENU_GAMELEVEL];
        options.add("VAL", menuButton, 2);
        ModelControl.options.getItem((int)1).label = Language.langTexts[Language.OPTMENU_PLAYERNAME];
        options.add(countries[selectedCountry], menuButton, 2);
        ModelControl.options.getItem((int)2).label = Language.langTexts[Language.OPTMENU_COUNTRY];
        options.setMenuMode(true, 0);
        mscreen = new GameScreen(this);
        screen.setCurrent(mainMenu);
    }

    public void firstStart() {
        this.setup();
        this.splash = null;
        System.gc();
    }

    public void show() {
        if (this.parent.display.getCurrent() != screen) {
            this.parent.display.setCurrent((Displayable)screen);
        }
    }

    private void showNameInput() {
        this.parent.display.setCurrent((Displayable)userNameInput);
    }

    private void startGame() {
        screen.setFullScreen(true);
        screen.setCurrent(mscreen);
    }

    public void exit() {
        Resources.saveRMS();
        screen.close();
        instance = null;
        this.parent.notifyDestroyed();
    }

    private void loadCountries() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/countries.dat"));
        countries = new String[dataInputStream.readByte()];
        for (int i = 0; i < countries.length; ++i) {
            ModelControl.countries[i] = dataInputStream.readUTF();
        }
        dataInputStream.close();
    }

    private void gotoWap() {
        String string = this.parent.getAppProperty("wapupdate");
        try {
            if (string != null) {
                boolean bl = this.parent.platformRequest(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.exit();
    }

    public void showLoadingBar(Graphics graphics, int n, int n2) {
        int n3 = ModelControl.screen.width >> 5;
        int n4 = (ModelControl.screen.width >> 1) - ((n3 + 2) * n2 >> 1);
        graphics.setColor(2122380);
        graphics.drawRect(n4 - 2, ModelControl.screen.height - 5 - n3 - 4, (n3 + 2) * n2 + 1, n3 + 3);
        for (int i = 0; i < n2; ++i) {
            if (n >= i) {
                graphics.setColor(2122380);
            } else {
                graphics.setColor(863051);
            }
            graphics.fillRect(n4 + (n3 + 2) * i, ModelControl.screen.height - 5 - n3 - 2, n3, n3);
        }
    }

    private void prepareInfoText(String string, String string2, Command command) {
        infoText.removeAllCommands();
        infoText.addCommand(BACK);
        if (command != null) {
            infoText.addCommand(command);
        }
        ModelControl.infoText.title = string;
        infoText.setText(string2);
        screen.setCurrent(infoText);
    }

    private void handleOptionsSelect() {
        switch (options.getSelectedIndex()) {
            case 0: {
                if (++GameSession.gameLevel > 2) {
                    GameSession.gameLevel = 0;
                }
                ModelControl.options.getItem((int)0).text = Language.langTexts[Language.GAMELEVEL_EASY + GameSession.gameLevel];
                break;
            }
            case 1: {
                this.showNameInput();
                break;
            }
            case 2: {
                screen.setCurrent(countryList);
            }
        }
    }

    public void commandAction(AJPanel aJPanel, Command command) {
        if (aJPanel == mainMenu) {
            if (command == SELECT) {
                switch (mainMenu.getSelectedIndex()) {
                    case 0: {
                        if (ModelControl.mscreen.inSession) {
                            screen.setCurrent(continueMenu);
                            break;
                        }
                        if (playerName == null) {
                            this.showNameInput();
                            break;
                        }
                        this.startGame();
                        break;
                    }
                    case 1: {
                        ModelControl.options.getItem((int)0).text = Language.langTexts[Language.GAMELEVEL_EASY + GameSession.gameLevel];
                        ModelControl.options.getItem((int)1).text = playerName;
                        ModelControl.options.getItem((int)2).text = countries[selectedCountry];
                        screen.setCurrent(options);
                        break;
                    }
                    case 2: {
                        this.prepareInfoText(Language.langTexts[Language.TITLE_HELP], Language.langTexts[Language.TEXT_HELP], null);
                        break;
                    }
                    case 3: {
                        this.parent.destroyApp(true);
                    }
                }
            }
        } else if (aJPanel == infoText) {
            mainMenu.setSelectedIndex(0);
            screen.setCurrent(mainMenu);
        } else if (aJPanel == countryList) {
            if (command == SELECT) {
                selectedCountry = countryList.getSelectedIndex();
                ModelControl.options.getItem((int)2).text = countries[selectedCountry];
            }
            screen.setCurrent(options);
        } else if (aJPanel == continueMenu) {
            if (command == SELECT) {
                if (continueMenu.getSelectedIndex() == 1) {
                    ModelControl.mscreen.inSession = false;
                }
                this.startGame();
            } else if (command == BACK) {
                mainMenu.setSelectedIndex(0);
                screen.setCurrent(mainMenu);
            }
        } else if (aJPanel == options) {
            if (command == SELECT) {
                this.handleOptionsSelect();
            } else {
                mainMenu.setSelectedIndex(0);
                screen.setCurrent(mainMenu);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == OKCMD_INPUT && displayable == userNameInput) {
            if (userNameInput.getString() != null && userNameInput.getString().length() > 0) {
                playerName = ModelControl.reverseText(userNameInput.getString());
            }
            if (playerName == null) {
                playerName = Language.langTexts[Language.DEFAULT_PLAYERNAME];
            }
            ModelControl.options.getItem((int)1).text = playerName;
            if (screen.getCurrent() == mainMenu) {
                this.startGame();
            }
            this.show();
        }
    }

    static {
        GAMEMAP_WIDTH = 0;
        GAMEMAP_HEIGHT = 0;
        countries = null;
        playerName = null;
        selectedCountry = 0;
        userNameInput = new TextBox(ModelControl.reverseText(Language.langTexts[Language.TITLE_PLAYERNAME]), "", 10, 0);
    }
}

