/*
 * Decompiled with CFR 0.152.
 */
public class PlayerList
extends Sortable {
    protected Player[] order;
    private int orderIndex;
    protected int size;

    public PlayerList() {
        this.order = new Player[3];
        this.reset();
    }

    public PlayerList(PlayerList playerList) {
        this.setArray(playerList.order, playerList.size);
    }

    public PlayerList(Player[] playerArray) {
        this.setArray(playerArray, playerArray.length);
    }

    public void reset() {
        this.orderIndex = 0;
        this.size = 0;
    }

    public void resizeArray(int n) {
        this.order = null;
        System.gc();
        this.order = new Player[n];
        this.reset();
    }

    public void setArray(Player[] playerArray, int n) {
        if (this.order == null || playerArray.length > this.order.length) {
            this.resizeArray(playerArray.length);
        }
        System.arraycopy(playerArray, 0, this.order, 0, n);
        this.orderIndex = 0;
        this.size = n;
    }

    public void add(Player player) {
        if (this.size < this.order.length) {
            this.order[this.size++] = player;
        }
    }

    public Player get(int n) {
        return this.order[n];
    }

    public void set(int n, Player player) {
        this.order[n] = player;
    }

    public int getIndex() {
        return this.orderIndex;
    }

    public int size() {
        return this.size;
    }

    public boolean hasNext() {
        return this.orderIndex < this.size;
    }

    public Player next() {
        if (this.orderIndex == this.size) {
            return null;
        }
        return this.order[this.orderIndex++];
    }

    public boolean hasPlayer(Player player) {
        for (int i = 0; i < this.size; ++i) {
            if (this.order[i] != player) continue;
            return true;
        }
        return false;
    }

    public Player[] getArray() {
        return this.order;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.order[i]).append(' ');
        }
        return stringBuffer.toString();
    }

    public void sortByScore(int n) {
        Sortable.sortArray(this.order, n, this.order.length, this);
    }

    public boolean compare(Object object, Object object2) {
        Player player = (Player)object;
        Player player2 = (Player)object2;
        if (player.score < player2.score) {
            return true;
        }
        if (player.score == player2.score) {
            return player.matchesWon < player2.matchesWon;
        }
        return false;
    }
}

