/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Resources
extends Sortable {
    private DataInputStream din;
    private Vector quizVector;
    private int quizType;
    private static final String RSNAME = "bchallenge";

    private boolean addNumber(short[] sArray, int n, short s) {
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != s) continue;
            return false;
        }
        sArray[n] = s;
        return true;
    }

    private void createRandomList(short[] sArray, int n, int n2) {
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Math.abs(GameSession.rand.nextInt() % n) + 1;
            if (!this.addNumber(sArray, n3, (short)n4)) continue;
            ++n3;
        }
        this.sortList(sArray, n2);
    }

    private void sortList(short[] sArray, int n) {
        boolean bl = true;
        while (bl) {
            --n;
            bl = false;
            for (int i = 0; i < n; ++i) {
                if (sArray[i] <= sArray[i + 1]) continue;
                int n2 = i + 1;
                sArray[n2] = (short)(sArray[n2] ^ sArray[i]);
                int n3 = i;
                sArray[n3] = (short)(sArray[n3] ^ sArray[i + 1]);
                int n4 = i + 1;
                sArray[n4] = (short)(sArray[n4] ^ sArray[i]);
                bl = true;
            }
        }
    }

    public boolean compare(Object object, Object object2) {
        return ((Player)object).score > ((Player)object2).score;
    }

    private void skipTipQuiz(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readByte();
        dataInputStream.readUTF();
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
    }

    private void skipPossQuiz(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readByte();
        dataInputStream.readUTF();
        for (int i = 0; i < 4; ++i) {
            dataInputStream.readUTF();
        }
        dataInputStream.readByte();
    }

    private TipQuiz loadTipQuiz(DataInputStream dataInputStream) throws IOException {
        TipQuiz tipQuiz = new TipQuiz();
        tipQuiz.category = dataInputStream.readByte();
        tipQuiz.question = dataInputStream.readUTF();
        tipQuiz.correctAnswer = dataInputStream.readInt();
        tipQuiz.lowerBound = Math.abs(tipQuiz.correctAnswer - dataInputStream.readInt());
        tipQuiz.upperBound = dataInputStream.readInt() - tipQuiz.correctAnswer;
        return tipQuiz;
    }

    private PossibilityQuiz loadPossQuiz(DataInputStream dataInputStream) throws IOException {
        PossibilityQuiz possibilityQuiz = new PossibilityQuiz();
        possibilityQuiz.category = dataInputStream.readByte();
        possibilityQuiz.question = dataInputStream.readUTF();
        for (int i = 0; i < 4; ++i) {
            possibilityQuiz.addAnswer(dataInputStream.readUTF());
        }
        possibilityQuiz.difficulity = dataInputStream.readByte();
        return possibilityQuiz;
    }

    public void loadCategory() throws IOException {
        short[] sArray = new short[6];
        int n = 0;
        Quiz quiz = null;
        short s = this.din.readShort();
        this.createRandomList(sArray, s, 5);
        sArray[5] = (short)(s + 1);
        for (int i = 0; i <= 5; ++i) {
            int n2 = sArray[i];
            block9: for (int j = n; j < n2 - 1; ++j) {
                switch (this.quizType) {
                    case 0: {
                        this.skipTipQuiz(this.din);
                        continue block9;
                    }
                    case 1: {
                        this.skipPossQuiz(this.din);
                    }
                }
            }
            if (i < 5) {
                switch (this.quizType) {
                    case 0: {
                        quiz = this.loadTipQuiz(this.din);
                        break;
                    }
                    case 1: {
                        quiz = this.loadPossQuiz(this.din);
                    }
                }
                this.quizVector.addElement(quiz);
            }
            n = n2;
        }
        sArray = null;
        System.gc();
    }

    public void openQuizData(String string, int n, Vector vector) throws IOException {
        try {
            this.quizVector = vector;
            this.quizType = n;
            this.din = new DataInputStream(((Object)((Object)BChallenge.instance)).getClass().getResourceAsStream(string));
        }
        catch (Exception exception) {
            throw new IOException("Error opening quizfile: " + string + " Error: " + exception.getMessage());
        }
    }

    public void closeQuizStream() {
        try {
            this.din.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Sport[] loadSports(String string) throws IOException {
        FilterInputStream filterInputStream = null;
        int n = 10000;
        int n2 = 0;
        int n3 = 10000;
        int n4 = 0;
        try {
            Sport[] sportArray;
            int n5;
            filterInputStream = new DataInputStream(GameSession.players.getClass().getResourceAsStream(string));
            int n6 = ((DataInputStream)filterInputStream).readByte();
            Sport[] sportArray2 = new Sport[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                sportArray2[n5] = new Sport();
            }
            for (n5 = 0; n5 < n6; ++n5) {
                sportArray = sportArray2[n5];
                sportArray.id = ((DataInputStream)filterInputStream).readShort();
                sportArray.posX = ((DataInputStream)filterInputStream).readShort();
                sportArray.posY = ((DataInputStream)filterInputStream).readShort();
                if (n > sportArray.posX) {
                    n = sportArray.posX;
                } else if (n2 < sportArray.posX) {
                    n2 = sportArray.posX;
                }
                if (n3 > sportArray.posY) {
                    n3 = sportArray.posY;
                    continue;
                }
                if (n4 >= sportArray.posY) continue;
                n4 = sportArray.posY;
            }
            sportArray = sportArray2;
            return sportArray;
        }
        catch (Exception exception) {
            throw new IOException("Failed to load county data: " + exception.getMessage());
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
            ModelControl.GAMEMAP_WIDTH = n2 - n + Sport.mapCellWidth;
            ModelControl.GAMEMAP_HEIGHT = n4 - n3 + GameScreen.gameMapCell.getHeight();
        }
    }

    public static final void randomizeArray(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            int n = Math.abs(GameSession.rand.nextInt()) % objectArray.length;
            Object object = objectArray[i];
            objectArray[i] = objectArray[n];
            objectArray[n] = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRMS() {
        RecordStore recordStore = null;
        try {
            try {
                RecordStore.deleteRecordStore((String)RSNAME);
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            recordStore = RecordStore.openRecordStore((String)RSNAME, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (ModelControl.playerName == null) {
                ModelControl.playerName = Language.langTexts[Language.DEFAULT_PLAYERNAME];
            }
            dataOutputStream.writeUTF(ModelControl.playerName);
            dataOutputStream.writeShort(GameSession.gameLevel);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRMS() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RSNAME, (boolean)false);
            if (recordStore.getNumRecords() > 0) {
                byte[] byArray = recordStore.getRecord(1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                ModelControl.playerName = dataInputStream.readUTF();
                GameSession.gameLevel = dataInputStream.readShort();
                dataInputStream.close();
                byteArrayInputStream.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }
}

