/*
 * Decompiled with CFR 0.152.
 */
package game;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CustomGraphics {
    Image img_font = null;
    int height;
    int width;
    Graphics g;
    int characterX;
    int[] characterW = new int[]{10, 4, 10, 10, 12, 10, 4, 10, 10, 10, 10, 4, 10, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 4, 4, 10, 10, 10, 12, 10, 10, 10, 10, 10, 9, 12, 11, 7, 7, 10, 10, 12, 11, 13, 11, 11, 11, 11, 10, 10, 10, 12, 10, 10, 10, 7, 6, 7, 10, 10, 4, 9, 8, 8, 9, 10, 6, 9, 7, 6, 5, 9, 5, 12, 8, 9, 8, 9, 8, 8, 6, 8, 8, 12, 8, 7, 8, 8, 7, 7, 7, 7, 7};

    void getGraphics(Graphics g) {
        this.g = g;
    }

    void setColor(int RGB) {
        this.g.setColor(RGB);
    }

    void setColor(int red, int green, int blue) {
        this.g.setColor(red, green, blue);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public void setFont(Image img) {
        this.img_font = img;
        this.height = img.getHeight() / 3;
        this.width = img.getWidth() / 32;
    }

    void drawImage(Image img, int x, int y, int anchor) {
        if (img != null) {
            this.g.drawImage(img, x, y, anchor);
        } else {
            System.out.println("error:img is null");
        }
    }

    public void drawString(String str, int x, int y, int anchor) {
        if (this.img_font == null) {
            this.g.drawString(str, x, y, anchor);
        } else {
            this.drawCustomString(str, x, y, anchor);
        }
    }

    void drawCustomString(String str, int x, int y, int anchor) {
        switch (anchor) {
            case 20: {
                this.characterX = x;
                break;
            }
            case 24: {
                this.characterX = x - str.length() * 8 - 8;
                break;
            }
            case 17: {
                this.characterX = x - str.length() * 8 / 2 - 4;
            }
        }
        int i = 0;
        while (i < str.length()) {
            this.drawCharacter(str.charAt(i), this.characterX, y);
            ++i;
        }
        this.g.setClip(0, 0, 240, 320);
    }

    public void drawArrText(String[] str, int x, int y, int rowspacing) {
        int i = 0;
        while (i < str.length) {
            if (str[i] != null) {
                this.drawString(str[i], x / 2, y + i * rowspacing, 17);
            }
            ++i;
        }
    }

    void drawCharacter(int ascii, int x, int y) {
        if (ascii == 32) {
            this.characterX += 7;
        } else if (ascii < 127 && ascii > 32) {
            this.g.setClip(x, y, this.width, this.height);
            this.g.drawImage(this.img_font, x - (ascii -= 33) % 32 * this.width, y - ascii / 32 * this.height, 20);
            this.characterX += this.characterW[ascii];
        } else {
            System.out.println("error:no Character on the font image:" + (ascii + 32));
        }
    }

    void drawArrowUp(int x, int y) {
        this.g.setClip(x, y, this.width, this.height);
        this.g.drawImage(this.img_font, x - 31 * this.width, y - 2 * this.height, 20);
        this.g.setClip(0, 0, 240, 320);
    }

    void drawArrowDown(int x, int y) {
        this.g.setClip(x, y, this.width, this.height);
        this.g.drawImage(this.img_font, x - 30 * this.width, y - 2 * this.height, 20);
        this.g.setClip(0, 0, 240, 320);
    }
}

