/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class GameCanvas
extends Canvas
implements Runnable {
    Image bufi = Image.createImage((int)240, (int)400);
    public static final byte INTRO_MODE = 0;
    public static final byte GAME_MODE = 1;
    public static final byte MENU_MODE = 2;
    public static final byte HIGHSCORE_MODE = 3;
    public static final byte ABOUT_MODE = 4;
    public static final byte HELP_MODE = 5;
    public static final byte MOREGAMES_MODE = 10;
    public static final byte SPLASH_MODE = 6;
    public static final byte TOURNAMENT_MODE = 7;
    public static final byte GAME_2PLAYER_MODE = 8;
    public static final byte LAN_MODE = 11;
    public static final byte LANCHGE_MODE = 12;
    public static final int KEY_SOFTKEY1 = -6;
    public static final int KEY_SOFTKEY2 = -7;
    public static final int KEY_SOFTKEY3 = 42;
    public static final int KEY_SOFTKEY4 = 35;
    public byte PREQ_INTROSPLASH = 0;
    public byte PREQ_CANVAS_PLAYERLOCATION = 1;
    public byte PREQ_CANVAS_SCORE = (byte)2;
    public byte PREQ_CANVAS_AITHNIKING = (byte)3;
    public byte PREQ_CANVAS_SPLASH = (byte)4;
    public byte PREQ_BOARD_ET = (byte)5;
    public byte PREQ_BOARD_ETBEAM = (byte)6;
    public byte PREQ_BOARD_BACKGROUND = (byte)7;
    public byte PREQ_BOARD_GAMEBOARD = (byte)8;
    public byte PREQ_TOURNAMENT_DRAW_MSGBOX = (byte)9;
    public byte PREQ_HIGHSCORE_PAINT = (byte)10;
    public byte PREQ_MENU_PAINT = (byte)11;
    public byte PREQ_MSGBOX_PAINT = (byte)12;
    public byte PREQ_MSGBOX_TEXT_PAINT = (byte)13;
    public byte PREQ_MAX = (byte)15;
    public boolean[] paintRequested;
    private byte mode = (byte)2;
    public byte previous_mode = (byte)2;
    public Splash introSplash;
    protected int screenXOrigin = 0;
    protected int screenYOrigin = 0;
    protected MessageBox messageBox = null;
    public byte msgboxX = 0;
    public byte msgboxY = (byte)10;
    public int msgboxWidth = 240;
    public int msgboxHeight = 220;
    protected int menuX;
    protected int menuY;
    protected int menuWidth = 114;
    protected int menuHeight = 12;
    protected Menu menu = null;
    protected static final byte SPLASH_NONE = 0;
    protected static final byte SPLASH_GAME_OVER = 1;
    protected String sSplashMessage;
    protected byte splash = 0;
    protected int splashX = 5;
    protected int splashY = 60;
    protected int splashWidth = 240;
    protected int splashHeight = 60;
    protected HighScore highScore;
    protected Displayable next;
    protected Game midlet;
    protected byte fieldWidth = (byte)33;
    protected byte fieldHeight = (byte)33;
    protected int boardX = 0;
    protected int boardY = 0;
    protected int boardWidth = 240;
    protected int boardHeight = 400;
    protected int drawScoreX;
    protected int drawScoreY;
    protected int drawScoreWidth = 105;
    protected int drawScoreHeight = 17;
    protected int drawComputerAvatarX;
    protected int drawComputerAvatarY;
    protected int drawComputerAvatarWidth = 40;
    protected int drawComputerAvatarHeight = 50;
    protected int playerLocationX = 0;
    protected int playerFieldLocationX = 0;
    protected int playerLocationY = 0;
    protected int playerFieldLocationY = 0;
    protected int oldplayerFieldLocationX = 0;
    protected int oldplayerFieldLocationY = 0;
    boolean bRun = false;
    boolean loadDone = false;
    boolean nowPainting = false;
    boolean nowUpdating = false;
    boolean paintPlayerLocation = true;
    public static boolean langbk = false;
    protected boolean bAiIsThinking = false;
    protected Ai ai;
    public static int mgm = 0;
    public static boolean gmgconnect = false;
    protected Board board;
    protected int playerScore = 0;
    protected int playerMatch = 0;
    protected int computerScore = 0;
    protected int computerMatch = 0;
    protected int currentFaceIdx = -1;
    protected static final int SHADES_COLOR = 0x9C9C9C;
    private boolean isMove = true;
    protected Alphabet abc = null;
    protected int mpmLength = 0;
    protected int mpmIndex = 0;
    protected int mpmDrawnChars = 0;
    protected Tournament tournament = null;
    protected boolean bGameInProgress = false;
    public static int canvasWidth = 0;
    public static int canvasHeight = 0;
    public Image[] langImage = new Image[4];
    public Image[] linkImage1 = new Image[6];
    public Image pauseImg;
    Graphics _g = this.bufi.getGraphics();
    public static String languageString = null;
    public static RecordStore rs;
    public static int ii;
    public static int lsImg;
    public static int lsX;
    public static int lsY;
    public static int exY;
    static long currentTime;
    long prevTime = System.currentTimeMillis();

    public int getWidth() {
        return 240;
    }

    public int getHeight() {
        return 400;
    }

    public void showNotify() {
        if (this.loadDone) {
            this.menu.setMusic(Resources.isMusicOn);
        }
        for (int i = 0; i < this.PREQ_MAX; ++i) {
            this.paintRequested[i] = true;
        }
    }

    public void hideNotify() {
        block8: {
            block7: {
                if (this.loadDone) {
                    Resources.stopAllSounds();
                }
                if (this.getMode() == 1 || this.getMode() == 8) break block7;
                if (this.getMode() != 7) break block8;
                if (this.tournament.tournamentState != 6) break block8;
            }
            if (this.getMode() != 7) {
                this.setMode((byte)2);
                this.menu.setMenu(this.menu.inGameMenu, true);
            } else if (this.tournament.tournamentState == 6) {
                this.tournament.setState((byte)12);
                this.menu.setMenu(this.menu.inGameMenu, true);
            }
        }
    }

    public GameCanvas(Game _midlet) {
        this.paintRequested = new boolean[this.PREQ_MAX];
        for (int i = 0; i < this.PREQ_MAX; ++i) {
            this.paintRequested[i] = true;
        }
        this.loadDone = false;
        this.midlet = _midlet;
        this.setFullScreenMode(true);
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
        if (Game.dtr.equalsIgnoreCase("/lang_en.dat")) {
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 3000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.menu.setMenu(this.menu.mainMenu, true);
        } else if (Game.dtr.equalsIgnoreCase("/lang_fr.dat")) {
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 3000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.menu.setMenu(this.menu.mainMenu, true);
        } else if (Game.dtr.equalsIgnoreCase("/lang_de.dat")) {
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 3000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.menu.setMenu(this.menu.mainMenu, true);
        } else if (Game.dtr.equalsIgnoreCase("/lang_it.dat")) {
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 3000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.menu.setMenu(this.menu.mainMenu, true);
        } else if (Game.dtr.equalsIgnoreCase("/lang_sl.dat")) {
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 3000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.menu.setMenu(this.menu.mainMenu, true);
        } else if (Game.dtr.equalsIgnoreCase("/lang_rm.dat")) {
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 3000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.menu.setMenu(this.menu.mainMenu, true);
        }
        try {
            this.langImage[0] = Image.createImage((String)"/flag_united_kingdom.png");
            this.langImage[1] = Image.createImage((String)"/flag_france.png");
            this.langImage[2] = Image.createImage((String)"/flag_germany.png");
            this.langImage[3] = Image.createImage((String)"/flag_italy.png");
            this.pauseImg = Image.createImage((String)"/pauseImg.png");
            this.linkImage1[0] = Image.createImage((String)"/anno_en.png");
            this.linkImage1[1] = Image.createImage((String)"/iq_booster_en.png");
            this.linkImage1[2] = Image.createImage((String)"/office_dares_en.png");
            this.linkImage1[3] = Image.createImage((String)"/generic_operator.png");
            this.linkImage1[4] = Image.createImage((String)"/arrow_left.png");
            this.linkImage1[5] = Image.createImage((String)"/arrow_right.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initGameCanvas() {
        this.board = new Board(this, 1, 0);
        this.ai = new Ai();
        this.ai.setAi((byte)1);
        this.playerFieldLocationX = 3;
        this.playerFieldLocationY = 3;
        this.abc = new Alphabet();
        this.setXYOrigin(0, 0);
        this.calculatePlayerLocation();
    }

    public void requestPaint(byte preq_id) {
        this.paintRequested[preq_id] = true;
    }

    public void donePaint(byte preq_id) {
    }

    public void setMode(byte newmode) {
        for (int i = 0; i < this.PREQ_MAX; ++i) {
            this.paintRequested[i] = true;
        }
        this.previous_mode = this.mode;
        this.mode = newmode;
    }

    public byte getMode() {
        return this.mode;
    }

    public void restoreMode() {
        this.mode = this.previous_mode;
    }

    public void setXYOrigin(int _x, int _y) {
        this.screenXOrigin = _x;
        this.screenYOrigin = _y;
        this.menuX = this.screenXOrigin + 20 + 30;
        this.menuY = this.screenYOrigin + 296 - 10;
        this.splashX = this.screenXOrigin;
        this.splashY = this.screenYOrigin + 60;
        this.boardX = this.screenXOrigin + 18;
        this.boardY = this.screenYOrigin + 13;
        this.drawScoreX = this.screenXOrigin + 16;
        this.drawScoreY = this.screenYOrigin + 175;
        this.drawComputerAvatarX = this.screenXOrigin + 126 + 31;
        this.drawComputerAvatarY = this.screenYOrigin + 172 + 115 + 15;
    }

    public void startGameCanvas() {
        if (Game.dtr.equalsIgnoreCase("/lang_en.dat")) {
            this.setMode((byte)0);
            this.introSplash.startSplash();
        } else if (Game.dtr.equalsIgnoreCase("/lang_fr.dat")) {
            this.setMode((byte)0);
            this.introSplash.startSplash();
        } else if (Game.dtr.equalsIgnoreCase("/lang_de.dat")) {
            this.setMode((byte)0);
            this.introSplash.startSplash();
        } else if (Game.dtr.equalsIgnoreCase("/lang_it.dat")) {
            this.setMode((byte)0);
            this.introSplash.startSplash();
        } else if (Game.dtr.equalsIgnoreCase("/lang_es.dat")) {
            this.setMode((byte)0);
            this.introSplash.startSplash();
        } else {
            this.setMode((byte)11);
        }
        this.bRun = true;
        this.run();
    }

    public void destroyGameCanvas() {
    }

    public void run() {
        if (this.getMode() == 1 || this.getMode() == 8) {
            this.update();
        } else {
            switch (this.getMode()) {
                case 11: {
                    break;
                }
                case 12: {
                    break;
                }
                case 0: {
                    if (!this.loadDone) {
                        try {
                            Resources.loadHighscores();
                            Resources.loadImages();
                            Resources.loadSoundsNames();
                            this.loadDone = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.introSplash.update() || !this.loadDone) break;
                    this.introSplash.destroySplash();
                    this.introSplash = null;
                    Resources.images[14] = null;
                    Resources.images[15] = null;
                    System.gc();
                    this.initGameCanvas();
                    this.setMusic(Resources.isMusicOn);
                    this.setSound(Resources.isSoundOn);
                    this.setMode((byte)2);
                    break;
                }
                default: {
                    this.update();
                }
            }
        }
        this.repaint(0, 0, 240, 400);
    }

    private void drawMoreGame(Graphics _g) {
        gmgconnect = true;
        try {
            _g.setColor(0);
            _g.fillRect(0, 0, 240, 400);
            _g.drawImage(this.linkImage1[mgm], 12, 0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        _g.setColor(16494871);
        _g.drawString("Buy", 10, 390, 36);
        _g.setColor(16494871);
        _g.drawString("Back", 220, 390, 40);
        _g.drawImage(this.linkImage1[4], -1, 110, 0);
        _g.drawImage(this.linkImage1[5], 230, 110, 0);
        this.repaint();
    }

    public void pointerPressedGame(int x, int y) {
        if (x >= 207 && y >= 368 && x <= 240 && y <= 395) {
            Resources.stopAllSounds();
            if (this.getMode() != 7) {
                this.setMode((byte)2);
                this.menu.setMenu(this.menu.inGameMenu, true);
            } else if (this.tournament.tournamentState == 6) {
                this.tournament.setState((byte)12);
                this.menu.setMenu(this.menu.inGameMenu, true);
            }
        }
        if (x >= 5 && y >= 5 && x <= 235 && y <= 235) {
            if (x >= 5 && y >= 5 && x <= 37 && y <= 37) {
                this.playerFieldLocationX = 0;
                this.playerFieldLocationY = 0;
            } else if (x >= 40 && y >= 5 && x <= 68 && y <= 37) {
                this.playerFieldLocationX = 1;
                this.playerFieldLocationY = 0;
            } else if (x >= 70 && y >= 5 && x <= 102 && y <= 37) {
                this.playerFieldLocationX = 2;
                this.playerFieldLocationY = 0;
            } else if (x >= 104 && y >= 5 && x <= 135 && y <= 37) {
                this.playerFieldLocationX = 3;
                this.playerFieldLocationY = 0;
            } else if (x >= 137 && y >= 5 && x <= 169 && y <= 37) {
                this.playerFieldLocationX = 4;
                this.playerFieldLocationY = 0;
            } else if (x >= 171 && y >= 5 && x <= 201 && y <= 37) {
                this.playerFieldLocationX = 5;
                this.playerFieldLocationY = 0;
            } else if (x >= 203 && y >= 5 && x <= 235 && y <= 37) {
                this.playerFieldLocationX = 6;
                this.playerFieldLocationY = 0;
            } else if (x >= 5 && y >= 40 && x <= 37 && y <= 72) {
                this.playerFieldLocationX = 0;
                this.playerFieldLocationY = 1;
            } else if (x >= 40 && y >= 40 && x <= 68 && y <= 72) {
                this.playerFieldLocationX = 1;
                this.playerFieldLocationY = 1;
            } else if (x >= 70 && y >= 40 && x <= 102 && y <= 72) {
                this.playerFieldLocationX = 2;
                this.playerFieldLocationY = 1;
            } else if (x >= 104 && y >= 40 && x <= 135 && y <= 72) {
                this.playerFieldLocationX = 3;
                this.playerFieldLocationY = 1;
            } else if (x >= 137 && y >= 40 && x <= 169 && y <= 72) {
                this.playerFieldLocationX = 4;
                this.playerFieldLocationY = 1;
            } else if (x >= 171 && y >= 40 && x <= 201 && y <= 72) {
                this.playerFieldLocationX = 5;
                this.playerFieldLocationY = 1;
            } else if (x >= 203 && y >= 40 && x <= 235 && y <= 72) {
                this.playerFieldLocationX = 6;
                this.playerFieldLocationY = 1;
            } else if (x >= 5 && y >= 73 && x <= 37 && y <= 104) {
                this.playerFieldLocationX = 0;
                this.playerFieldLocationY = 2;
            } else if (x >= 40 && y >= 73 && x <= 68 && y <= 104) {
                this.playerFieldLocationX = 1;
                this.playerFieldLocationY = 2;
            } else if (x >= 70 && y >= 73 && x <= 102 && y <= 104) {
                this.playerFieldLocationX = 2;
                this.playerFieldLocationY = 2;
            } else if (x >= 104 && y >= 73 && x <= 135 && y <= 104) {
                this.playerFieldLocationX = 3;
                this.playerFieldLocationY = 2;
            } else if (x >= 137 && y >= 73 && x <= 169 && y <= 104) {
                this.playerFieldLocationX = 4;
                this.playerFieldLocationY = 2;
            } else if (x >= 171 && y >= 73 && x <= 201 && y <= 104) {
                this.playerFieldLocationX = 5;
                this.playerFieldLocationY = 2;
            } else if (x >= 203 && y >= 73 && x <= 235 && y <= 104) {
                this.playerFieldLocationX = 6;
                this.playerFieldLocationY = 2;
            } else if (x >= 5 && y >= 106 && x <= 37 && y <= 136) {
                this.playerFieldLocationX = 0;
                this.playerFieldLocationY = 3;
            } else if (x >= 40 && y >= 106 && x <= 68 && y <= 136) {
                this.playerFieldLocationX = 1;
                this.playerFieldLocationY = 3;
            } else if (x >= 70 && y >= 106 && x <= 102 && y <= 136) {
                this.playerFieldLocationX = 2;
                this.playerFieldLocationY = 3;
            } else if (x >= 104 && y >= 106 && x <= 135 && y <= 136) {
                this.playerFieldLocationX = 3;
                this.playerFieldLocationY = 3;
            } else if (x >= 137 && y >= 106 && x <= 171 && y <= 136) {
                this.playerFieldLocationX = 4;
                this.playerFieldLocationY = 3;
            } else if (x >= 171 && y >= 106 && x <= 201 && y <= 136) {
                this.playerFieldLocationX = 5;
                this.playerFieldLocationY = 3;
            } else if (x >= 203 && y >= 106 && x <= 235 && y <= 136) {
                this.playerFieldLocationX = 6;
                this.playerFieldLocationY = 3;
            } else if (x >= 5 && y >= 139 && x <= 37 && y <= 168) {
                this.playerFieldLocationX = 0;
                this.playerFieldLocationY = 4;
            } else if (x >= 40 && y >= 139 && x <= 68 && y <= 168) {
                this.playerFieldLocationX = 1;
                this.playerFieldLocationY = 4;
            } else if (x >= 70 && y >= 139 && x <= 102 && y <= 168) {
                this.playerFieldLocationX = 2;
                this.playerFieldLocationY = 4;
            } else if (x >= 104 && y >= 139 && x <= 135 && y <= 168) {
                this.playerFieldLocationX = 3;
                this.playerFieldLocationY = 4;
            } else if (x >= 137 && y >= 139 && x <= 169 && y <= 168) {
                this.playerFieldLocationX = 4;
                this.playerFieldLocationY = 4;
            } else if (x >= 171 && y >= 139 && x <= 201 && y <= 168) {
                this.playerFieldLocationX = 5;
                this.playerFieldLocationY = 4;
            } else if (x >= 203 && y >= 139 && x <= 235 && y <= 168) {
                this.playerFieldLocationX = 6;
                this.playerFieldLocationY = 4;
            } else if (x >= 5 && y >= 172 && x <= 37 && y <= 201) {
                this.playerFieldLocationX = 0;
                this.playerFieldLocationY = 5;
            } else if (x >= 40 && y >= 172 && x <= 68 && y <= 201) {
                this.playerFieldLocationX = 1;
                this.playerFieldLocationY = 5;
            } else if (x >= 70 && y >= 172 && x <= 102 && y <= 201) {
                this.playerFieldLocationX = 2;
                this.playerFieldLocationY = 5;
            } else if (x >= 104 && y >= 172 && x <= 135 && y <= 201) {
                this.playerFieldLocationX = 3;
                this.playerFieldLocationY = 5;
            } else if (x >= 137 && y >= 172 && x <= 169 && y <= 201) {
                this.playerFieldLocationX = 4;
                this.playerFieldLocationY = 5;
            } else if (x >= 171 && y >= 172 && x <= 201 && y <= 201) {
                this.playerFieldLocationX = 5;
                this.playerFieldLocationY = 5;
            } else if (x >= 203 && y >= 172 && x <= 235 && y <= 201) {
                this.playerFieldLocationX = 6;
                this.playerFieldLocationY = 5;
            } else if (x >= 5 && y >= 205 && x <= 37 && y <= 235) {
                this.playerFieldLocationX = 0;
                this.playerFieldLocationY = 6;
            } else if (x >= 40 && y >= 205 && x <= 68 && y <= 235) {
                this.playerFieldLocationX = 1;
                this.playerFieldLocationY = 6;
            } else if (x >= 70 && y >= 205 && x <= 102 && y <= 235) {
                this.playerFieldLocationX = 2;
                this.playerFieldLocationY = 6;
            } else if (x >= 104 && y >= 205 && x <= 135 && y <= 235) {
                this.playerFieldLocationX = 3;
                this.playerFieldLocationY = 6;
            } else if (x >= 137 && y >= 205 && x <= 169 && y <= 235) {
                this.playerFieldLocationX = 4;
                this.playerFieldLocationY = 6;
            } else if (x >= 171 && y >= 205 && x <= 201 && y <= 235) {
                this.playerFieldLocationX = 5;
                this.playerFieldLocationY = 6;
            } else if (x >= 203 && y >= 205 && x <= 235 && y <= 235) {
                this.playerFieldLocationX = 6;
                this.playerFieldLocationY = 6;
            }
            if (this.board.specialEffectDurationCounter == 0 && (this.board.getValue(this.playerFieldLocationX, this.playerFieldLocationY) == 3 || this.board.getValue(this.playerFieldLocationX, this.playerFieldLocationY) > 2) && this.isMove) {
                Resources.playFile(3);
                if (this.getMode() == 7) {
                    this.board.setSpecialObstacle();
                }
                this.board.setValue(this.playerFieldLocationX, this.playerFieldLocationY, this.board.getPlayer());
                this.board.last2Moves[this.board.getPlayer()][0] = this.playerFieldLocationX;
                this.board.last2Moves[this.board.getPlayer()][1] = this.playerFieldLocationY;
                byte[] byArray = this.menu.inGameMenu;
                this.menu.getClass();
                this.menu.getClass();
                byArray[1] = 34;
                this.setGameScore();
                this.requestPaint(this.PREQ_CANVAS_AITHNIKING);
                this.requestPaint(this.PREQ_CANVAS_SCORE);
                this.requestPaint(this.PREQ_BOARD_BACKGROUND);
                this.requestPaint(this.PREQ_BOARD_GAMEBOARD);
                this.paintPlayerLocation = false;
                this.repaint(0, 0, 240, 400);
                this.serviceRepaints();
                this.paintPlayerLocation = true;
                this.isMove = this.board.isMovePossible();
                if (this.getMode() == 8) {
                    if (this.board.getPlayer() == 1) {
                        this.board.setPlayer((byte)0);
                    } else {
                        this.board.setPlayer((byte)1);
                    }
                } else if (this.isMove) {
                    this.aiMove();
                }
                this.setGameScore();
                this.isMove = this.board.isMovePossible();
            } else {
                Resources.playFile(2);
            }
        }
        this.calculatePlayerLocation();
        this.requestPaint(this.PREQ_CANVAS_PLAYERLOCATION);
        this.requestPaint(this.PREQ_CANVAS_SCORE);
        this.requestPaint(this.PREQ_CANVAS_AITHNIKING);
        this.requestPaint(this.PREQ_BOARD_ET);
        this.requestPaint(this.PREQ_BOARD_ETBEAM);
        this.requestPaint(this.PREQ_BOARD_BACKGROUND);
        this.requestPaint(this.PREQ_BOARD_GAMEBOARD);
        this.requestPaint(this.PREQ_CANVAS_SPLASH);
        this.requestPaint(this.PREQ_MSGBOX_PAINT);
        this.requestPaint(this.PREQ_MSGBOX_TEXT_PAINT);
        this.requestPaint(this.PREQ_MENU_PAINT);
    }

    public void keyPressedGame(int _key) {
        switch (_key) {
            case 35: {
                Resources.stopAllSounds();
                if (this.getMode() != 7) {
                    this.setMode((byte)2);
                    this.menu.setMenu(this.menu.inGameMenu, true);
                    break;
                }
                if (this.tournament.tournamentState != 6) break;
                this.tournament.setState((byte)12);
                this.menu.setMenu(this.menu.inGameMenu, true);
                break;
            }
            case 42: {
                Resources.stopAllSounds();
                if (this.getMode() != 7) {
                    this.setMode((byte)2);
                    this.menu.setMenu(this.menu.inGameMenu, true);
                    break;
                }
                if (this.tournament.tournamentState != 6) break;
                this.tournament.setState((byte)12);
                this.menu.setMenu(this.menu.inGameMenu, true);
                break;
            }
            case 49: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationY = this.playerMoveUp();
                this.playerFieldLocationX = this.playerMoveLeft();
                break;
            }
            case -1: 
            case 1: 
            case 50: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationY = this.playerMoveUp();
                break;
            }
            case 51: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationY = this.playerMoveUp();
                this.playerFieldLocationX = this.playerMoveRight();
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationX = this.playerMoveLeft();
                break;
            }
            case 8: 
            case 53: {
                if (this.board.specialEffectDurationCounter == 0 && (this.board.getValue(this.playerFieldLocationX, this.playerFieldLocationY) == 3 || this.board.getValue(this.playerFieldLocationX, this.playerFieldLocationY) > 2) && this.isMove) {
                    if (this.getMode() == 7) {
                        this.board.setSpecialObstacle();
                    }
                    this.board.setValue(this.playerFieldLocationX, this.playerFieldLocationY, this.board.getPlayer());
                    this.board.last2Moves[this.board.getPlayer()][0] = this.playerFieldLocationX;
                    this.board.last2Moves[this.board.getPlayer()][1] = this.playerFieldLocationY;
                    byte[] byArray = this.menu.inGameMenu;
                    this.menu.getClass();
                    this.menu.getClass();
                    byArray[1] = 34;
                    Resources.playFile(3);
                    this.setGameScore();
                    this.requestPaint(this.PREQ_CANVAS_AITHNIKING);
                    this.requestPaint(this.PREQ_CANVAS_SCORE);
                    this.requestPaint(this.PREQ_BOARD_BACKGROUND);
                    this.requestPaint(this.PREQ_BOARD_GAMEBOARD);
                    this.paintPlayerLocation = false;
                    this.repaint(0, 0, 240, 400);
                    this.serviceRepaints();
                    this.paintPlayerLocation = true;
                    this.isMove = this.board.isMovePossible();
                    if (this.getMode() == 8) {
                        if (this.board.getPlayer() == 1) {
                            this.board.setPlayer((byte)0);
                        } else {
                            this.board.setPlayer((byte)1);
                        }
                    } else if (this.isMove) {
                        this.aiMove();
                    }
                    this.setGameScore();
                    this.isMove = this.board.isMovePossible();
                    break;
                }
                Resources.playFile(2);
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationX = this.playerMoveRight();
                break;
            }
            case 55: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationY = this.playerMoveDown();
                this.playerFieldLocationX = this.playerMoveLeft();
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationY = this.playerMoveDown();
                break;
            }
            case 57: {
                this.oldplayerFieldLocationX = this.playerFieldLocationX;
                this.oldplayerFieldLocationY = this.playerFieldLocationY;
                this.playerFieldLocationY = this.playerMoveDown();
                this.playerFieldLocationX = this.playerMoveRight();
            }
        }
        this.calculatePlayerLocation();
        this.requestPaint(this.PREQ_CANVAS_PLAYERLOCATION);
        this.requestPaint(this.PREQ_CANVAS_SCORE);
        this.requestPaint(this.PREQ_CANVAS_AITHNIKING);
        this.requestPaint(this.PREQ_BOARD_ET);
        this.requestPaint(this.PREQ_BOARD_ETBEAM);
        this.requestPaint(this.PREQ_BOARD_BACKGROUND);
        this.requestPaint(this.PREQ_BOARD_GAMEBOARD);
        this.requestPaint(this.PREQ_CANVAS_SPLASH);
        this.requestPaint(this.PREQ_MSGBOX_PAINT);
        this.requestPaint(this.PREQ_MSGBOX_TEXT_PAINT);
        this.requestPaint(this.PREQ_MENU_PAINT);
    }

    public void keyPressedGMG(int _key) {
        if ((_key == -6 || _key == 53) && this.getMode() != 10) {
            return;
        }
        switch (_key) {
            case -3: 
            case 2: 
            case 52: {
                if (--mgm >= 0) break;
                mgm = 3;
                break;
            }
            case -6: 
            case 8: 
            case 53: {
                Resources.stopAllSounds();
                if (!gmgconnect) break;
                Resources.stopAllSounds();
                try {
                    Game.instance.platformRequest("http://www.ama.us/product_1.htm");
                    Thread.sleep(500L);
                    mgm = 0;
                    this.midlet.exit();
                }
                catch (Exception exception) {}
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                if (++mgm < 4) break;
                mgm = 0;
            }
        }
    }

    public void pointerPressedGMG(int x, int y) {
        if (x >= 0 && y >= 106 && x <= 20 && y <= 137 && --mgm < 0) {
            mgm = 3;
        }
        if (x >= 0 && y >= 288 && x <= 45 && y <= 400 && gmgconnect) {
            Resources.stopAllSounds();
            try {
                Game.instance.platformRequest("http://www.ama.us/product_1.htm");
                Thread.sleep(500L);
                mgm = 0;
                this.midlet.exit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (x >= 220 && y >= 106 && x <= 240 && y <= 137 && ++mgm >= 4) {
            mgm = 0;
        }
    }

    public void pointerPressedLangSelect(int x, int y) {
        if (x >= 66 && y >= 118 + exY && x <= 189 && y <= 213 + exY) {
            if (x >= 66 && y >= 118 + exY && x <= 189 && y <= 137 + exY) {
                languageString = "en";
                lsImg = 0;
                lsY = 118 + exY;
            } else if (x >= 66 && y >= 143 + exY && x <= 189 && y <= 163 + exY) {
                languageString = "fr";
                lsImg = 1;
                lsY = 143 + exY;
            } else if (x >= 66 && y >= 168 + exY && x <= 189 && y <= 189 + exY) {
                languageString = "de";
                lsImg = 2;
                lsY = 168 + exY;
            } else if (x >= 66 && y >= 193 + exY && x <= 189 && y <= 213 + exY) {
                languageString = "it";
                lsImg = 3;
                lsY = 193 + exY;
            }
            try {
                Resources.initImages();
                Resources.loadSettings();
                byte[] bytes = languageString.getBytes();
                rs.addRecord(bytes, 0, bytes.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 1000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.setMode((byte)0);
            this.introSplash.startSplash();
            langbk = true;
        }
    }

    public void pointerPressedLangSt(int x, int y) {
        langbk = true;
        if (languageString != null) {
            try {
                languageString = null;
                if (x >= 66 && y >= 118 + exY && x <= 189 && y <= 137 + exY) {
                    languageString = "en";
                    lsImg = 0;
                    lsY = 118 + exY;
                }
                if (x >= 66 && y >= 143 + exY && x <= 189 && y <= 163 + exY) {
                    languageString = "fr";
                    lsImg = 1;
                    lsY = 143 + exY;
                }
                if (x >= 66 && y >= 168 + exY && x <= 189 && y <= 189 + exY) {
                    languageString = "de";
                    lsImg = 2;
                    lsY = 168 + exY;
                }
                if (x >= 66 && y >= 193 + exY && x <= 189 && y <= 213 + exY) {
                    languageString = "it";
                    lsImg = 3;
                    lsY = 193 + exY;
                }
                if (langbk && x >= 210 && y >= 370 && x <= 230 && y <= 399) {
                    System.out.println("LANG-BK ");
                    this.setMode((byte)2);
                    this.menu.setMenu(this.menu.mainMenu, true);
                }
                ii = 1;
                Resources.loadText();
                Resources.loadSettings();
                byte[] data = languageString.getBytes();
                rs.setRecord(1, data, 0, data.length);
                this.update();
                this.setMode((byte)2);
                this.menu.setMenu(this.menu.mainMenu, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.pointerPressedGMG(x, y);
        if (x < 160 || y < 280 || x > 200 || y <= 310) {
            // empty if block
        }
        if (this.getMode() == 1 || this.getMode() == 8) {
            this.pointerPressedGame(x, y);
        } else if (this.getMode() == 11) {
            this.pointerPressedLangSelect(x, y);
        } else {
            switch (this.getMode()) {
                case 12: {
                    langbk = true;
                    this.pointerPressedLangSt(x, y);
                    break;
                }
                case 3: {
                    this.highScore.pointerPressed(x, y);
                    this.requestPaint(this.PREQ_MENU_PAINT);
                    break;
                }
                case 0: {
                    this.introSplash.pointerPressed(x, y);
                    break;
                }
                case 7: {
                    this.tournament.pointerPress(x, y);
                    break;
                }
                default: {
                    this.menu.pointerPressed(x, y);
                    this.requestPaint(this.PREQ_CANVAS_AITHNIKING);
                    this.requestPaint(this.PREQ_CANVAS_SCORE);
                    this.requestPaint(this.PREQ_TOURNAMENT_DRAW_MSGBOX);
                }
            }
        }
    }

    public void keyPressed1(int key) {
        if (key == -6) {
            if (lsY == 95) {
                languageString = "en";
            } else if (lsY == 120) {
                languageString = "fr";
            } else if (lsY == 145) {
                languageString = "de";
            } else if (lsY == 170) {
                languageString = "it";
            }
            this.introSplash = new Splash(this);
            this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 1000);
            this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
            this.menu = new Menu(this);
            this.setMode((byte)0);
            this.introSplash.startSplash();
        }
        switch (key) {
            case 1: 
            case 50: {
                --lsImg;
                if ((lsY -= 25) < 95) {
                    lsY = 170;
                }
                if (lsImg >= 0) break;
                lsImg = 3;
                break;
            }
            case 8: 
            case 53: {
                if (lsY == 95) {
                    languageString = "en";
                } else if (lsY == 120) {
                    languageString = "fr";
                } else if (lsY == 145) {
                    languageString = "de";
                } else if (lsY == 170) {
                    languageString = "it";
                }
                try {
                    Resources.initImages();
                    Resources.loadSettings();
                    byte[] bytes = languageString.getBytes();
                    rs.addRecord(bytes, 0, bytes.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.introSplash = new Splash(this);
                this.introSplash.addSplashScreen(Resources.images[14], 0xFFFFFF, 1000);
                this.introSplash.addSplashScreen(Resources.images[15], 11840923, 3000, true);
                this.menu = new Menu(this);
                this.setMode((byte)0);
                this.introSplash.startSplash();
                break;
            }
            case 6: 
            case 56: {
                ++lsImg;
                if ((lsY += 25) > 170) {
                    lsY = 95;
                }
                if (lsImg <= 3) break;
                lsImg = 0;
            }
        }
    }

    public void keyPressed2(int key) {
        if (key == -6) {
            this.menu = new Menu(this);
            this.menu.update();
            this.setMode((byte)2);
        }
        switch (key) {
            case 1: 
            case 50: {
                --lsImg;
                if ((lsY -= 25) < 95) {
                    lsY = 170;
                }
                if (lsImg >= 0) break;
                lsImg = 3;
                break;
            }
            case 8: 
            case 53: {
                if (languageString == null) break;
                try {
                    languageString = null;
                    if (lsY == 95) {
                        languageString = "en";
                    } else if (lsY == 120) {
                        languageString = "fr";
                    } else if (lsY == 145) {
                        languageString = "de";
                    } else if (lsY == 170) {
                        languageString = "it";
                    }
                    ii = 1;
                    Resources.loadText();
                    Resources.loadSettings();
                    byte[] data = languageString.getBytes();
                    rs.setRecord(1, data, 0, data.length);
                    this.update();
                    this.menu = new Menu(this);
                    this.setMode((byte)2);
                }
                catch (Exception exception) {}
                break;
            }
            case 6: 
            case 56: {
                ++lsImg;
                if ((lsY += 25) > 170) {
                    lsY = 95;
                }
                if (lsImg <= 3) break;
                lsImg = 0;
            }
        }
    }

    public void keyPressed(int _key) {
    }

    private int playerMoveUp() {
        if (this.playerFieldLocationY - 1 >= 0) {
            return --this.playerFieldLocationY;
        }
        return 6;
    }

    private int playerMoveDown() {
        if (this.playerFieldLocationY + 1 < 7) {
            return ++this.playerFieldLocationY;
        }
        return 0;
    }

    private int playerMoveLeft() {
        if (this.playerFieldLocationX - 1 >= 0) {
            return --this.playerFieldLocationX;
        }
        return 6;
    }

    private int playerMoveRight() {
        if (this.playerFieldLocationX + 1 < 7) {
            return ++this.playerFieldLocationX;
        }
        return 0;
    }

    public void calculatePlayerLocation() {
        this.playerLocationX = this.getXLocation(this.playerFieldLocationX);
        this.playerLocationY = this.getYLocation(this.playerFieldLocationY);
    }

    private int getXLocation(int x) {
        return x * this.fieldWidth + this.boardX;
    }

    private int getYLocation(int y) {
        return y * this.fieldHeight + this.boardY;
    }

    public boolean isGameInProgress() {
        return this.bGameInProgress;
    }

    private void setMatchScore() {
        if (this.playerScore > this.computerScore) {
            this.playerMatch += 2;
        } else if (this.playerScore < this.computerScore) {
            this.computerMatch += 2;
        } else {
            ++this.computerMatch;
            ++this.playerMatch;
        }
    }

    public void setGameScore() {
        if (this.getMode() == 8) {
            this.playerScore = this.board.getScore((byte)1);
            this.computerScore = this.board.getScore((byte)0);
        } else {
            this.playerScore = this.board.getScore(this.board.getPlayer());
            this.computerScore = this.board.getScore(this.board.getComputer());
        }
    }

    private void setSound(boolean _value) {
        Resources.isSoundOn = _value;
        this.menu.setSound(Resources.isSoundOn);
    }

    private void setMusic(boolean _value) {
        Resources.isMusicOn = _value;
        this.menu.setMusic(Resources.isMusicOn);
    }

    public void newGame(byte[] _newMenu, byte _mode) {
        if (this.board != null) {
            Resources.stopAllSounds();
            this.bGameInProgress = true;
            this.board.newGame();
            this.board.createObstacles();
            this.setGameScore();
            this.isMove = this.board.isMovePossible();
            this.setMode(_mode);
            if (this.board.getPlayer() == 0 && this.getMode() != 8) {
                this.board.setComputer((byte)1);
                this.aiMove();
            } else {
                this.board.setComputer((byte)0);
            }
            if (this.getMode() != 7) {
                this.setAiImage(1 + (this.ai.nType - 1) * 2 + this.board.getComputer());
            }
            this.menu.setMenu(_newMenu, true);
            byte[] byArray = this.menu.inGameMenu;
            this.menu.getClass();
            this.menu.getClass();
            byArray[1] = 34;
        }
    }

    protected void splashAnimation() {
        if (this.messageBox == null) {
            this.messageBox = new MessageBox(this);
        }
        this.messageBox.startAnimationUp();
    }

    public Image getAiImage() {
        return Resources.images[4 + this.currentFaceIdx];
    }

    public void setAiImage(int _aiImageIndex) {
        this.requestPaint(this.PREQ_CANVAS_AITHNIKING);
        this.currentFaceIdx = _aiImageIndex;
    }

    private void setSplash(byte type) {
        this.splash = type;
        if (this.playerScore == this.computerScore) {
            Resources.playFile(7);
            this.sSplashMessage = Resources.getText((short)46);
        } else if (this.getMode() == 8) {
            Resources.playFile(9);
            this.sSplashMessage = this.playerScore > this.computerScore ? Resources.getText((short)47) : Resources.getText((short)48);
        } else if (this.playerScore > this.computerScore) {
            Resources.playFile(9);
            this.sSplashMessage = Resources.getText((short)44);
        } else {
            Resources.playFile(8);
            this.sSplashMessage = Resources.getText((short)45);
        }
        this.setMode((byte)6);
        this.splashAnimation();
        this.menu.setMenu(this.menu.splashMenu, true);
    }

    public void messageBoxPaint(Graphics _g, int _x, int _y, int _w, int _h) {
        if (this.paintRequested[this.PREQ_MSGBOX_PAINT]) {
            this.donePaint(this.PREQ_MSGBOX_PAINT);
            if (this.getMode() == 6) {
                this.requestPaint(this.PREQ_CANVAS_SPLASH);
            }
            this.messageBox.paint(_g, _x, _y, _w, _h);
        }
    }

    private void drawPlayerLocation(Graphics _g) {
        if (this.paintPlayerLocation && this.paintRequested[this.PREQ_CANVAS_PLAYERLOCATION]) {
            this.donePaint(this.PREQ_CANVAS_PLAYERLOCATION);
            _g.setColor(0);
            _g.drawRect(this.playerLocationX - 14, this.playerLocationY - 8, this.board.TILE_WIDTH - 2, this.board.TILE_WIDTH - 2);
            _g.drawRect(this.playerLocationX - 13, this.playerLocationY - 7, this.board.TILE_WIDTH - 2, this.board.TILE_WIDTH - 2);
            _g.drawRect(this.playerLocationX - 12, this.playerLocationY - 7, this.board.TILE_WIDTH - 2, this.board.TILE_WIDTH - 2);
            _g.drawRect(this.playerLocationX - 11, this.playerLocationY - 6, this.board.TILE_WIDTH - 2, this.board.TILE_WIDTH - 2);
        }
    }

    private void drawScore(Graphics _g) {
        this.abc.setAlign((byte)0);
        this.abc.drawInt(_g, this.playerScore, this.drawScoreX + 40, this.drawScoreY + 70 + 30, this.drawScoreWidth, this.drawScoreHeight);
        this.abc.setAlign((byte)1);
        if (this.getMode() == 8 || this.previous_mode == 8) {
            this.abc.drawInt(_g, this.computerScore, this.drawScoreX + this.drawComputerAvatarWidth + 30, this.drawScoreY + 70 + 30, this.drawScoreWidth, this.drawScoreHeight);
        } else {
            this.abc.drawInt(_g, this.computerScore, this.drawScoreX + 30, this.drawScoreY + 70 + 30, this.drawScoreWidth, this.drawScoreHeight);
        }
    }

    public void drawAiThinking(Graphics _g) {
        int shiftPicture = 0;
        shiftPicture = this.playerScore > this.computerScore ? 2 : (this.playerScore == this.computerScore ? 1 : 0);
        this.drawAiThinking(_g, shiftPicture);
    }

    public void drawAiThinking(Graphics _g, int shiftPicture) {
        this.donePaint(this.PREQ_CANVAS_AITHNIKING);
        _g.setClip(this.drawComputerAvatarX, 0, this.drawComputerAvatarWidth, 400);
        int picturePosX = this.drawComputerAvatarX - shiftPicture * this.drawComputerAvatarWidth;
        int picturePosY = this.drawComputerAvatarY;
        _g.setColor(0);
        _g.setClip(this.drawComputerAvatarX, this.drawComputerAvatarY - 37, this.drawComputerAvatarWidth, this.drawComputerAvatarHeight);
        _g.fillRect(this.drawComputerAvatarX, this.drawComputerAvatarY - 37, this.drawComputerAvatarWidth, this.drawComputerAvatarHeight);
        _g.drawImage(this.getAiImage(), picturePosX, picturePosY - 37, 20);
        _g.setClip(0, 0, 240, 400);
    }

    private void drawSplash(Graphics _g) {
        if (this.paintRequested[this.PREQ_CANVAS_SPLASH]) {
            this.donePaint(this.PREQ_CANVAS_SPLASH);
            if (this.splash != 0) {
                if (this.messageBox == null) {
                    this.messageBox = new MessageBox(this);
                }
                this.messageBoxPaint(_g, this.splashX, this.splashY - 12, this.splashWidth, this.splashHeight * 2);
                if (this.messageBox.isExtended()) {
                    this.abc.setAlign((byte)3);
                    this.abc.drawString(_g, this.sSplashMessage, this.splashX + 56, this.splashY + 50, this.splashWidth, this.splashHeight * 2, -1);
                }
            }
        }
    }

    public void drawPauseImg(Graphics _g) {
        try {
            _g.setClip(200, 370, 235, 395);
            _g.drawImage(this.pauseImg, 210, 373, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void paintGame(Graphics _g) {
        if (!this.bAiIsThinking) {
            this.board.drawBackground(_g, this.screenXOrigin, this.screenYOrigin, this.getWidth(), this.getHeight());
            if (this.getMode() != 8) {
                this.drawAiThinking(_g);
            }
            this.board.drawGameBoard(_g, this.getMode(), this.boardX - 12, this.boardY - 6, this.getWidth(), this.getHeight());
            this.drawPlayerLocation(_g);
            if (this.getMode() == 7) {
                if (this.board.specialObstacle == 5 && this.board.specialEffectDurationCounter > 0) {
                    if (this.board.ET_OBDUCTION) {
                        this.board.drawETBeam(_g, this.boardX + this.board.xET + 32, this.boardY + this.board.yET - 4, this.getWidth(), this.getHeight());
                        this.board.drawPlayer(_g, this.board.zappedstonecolor, this.boardX + this.board.xET + 32, this.boardY - 4 + this.board.yET + (this.board.specialEffectDurationCounter - 64) / 2, this.getWidth(), this.getHeight(), false);
                    }
                    this.board.drawET(_g, this.boardX + this.board.xET - this.board.ET_BEAM_OFFSET_X, this.boardY + this.board.yET - this.board.ET_BEAM_OFFSET_Y - 4, this.getWidth(), this.getHeight());
                }
            }
            _g.setClip(0, 0, 240, 400);
            this.drawScore(_g);
            _g.setClip(0, 0, 240, 400);
            this.drawSplash(_g);
            _g.setClip(0, 0, 240, 400);
            this.drawPauseImg(_g);
        }
    }

    public void dopaint(Graphics g) {
        try {
            g.setFont(Font.getFont((int)32, (int)1, (int)16));
            g.setColor(0x999999);
            g.fillRect(0, 0, 240, 400);
            g.setClip(0, 0, 240, 400);
            g.setColor(0x99CCFF);
            g.fillRect(lsX, lsY, 135, 19);
            g.setColor(0xFFFFFF);
            g.drawString(" ENGLISH", 66, 119 + exY, 0);
            g.drawString(" FRENCH", 66, 144 + exY, 0);
            g.drawString(" GERMAN", 66, 169 + exY, 0);
            g.drawString(" ITALIAN", 66, 194 + exY, 0);
            g.drawImage(this.langImage[lsImg], 81, 35 + exY, 0);
            if (langbk) {
                g.drawImage(this.linkImage1[4], 216, 370, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        currentTime = System.currentTimeMillis();
        long timePause = currentTime - this.prevTime;
        this.nowPainting = true;
        if (this.bRun) {
            Graphics _g = this.bufi.getGraphics();
            if (this.getMode() == 1 || this.getMode() == 8) {
                this.paintGame(_g);
                this.drawPauseImg(_g);
            } else {
                switch (this.getMode()) {
                    case 11: {
                        this.dopaint(_g);
                        break;
                    }
                    case 12: {
                        langbk = true;
                        this.dopaint(_g);
                        break;
                    }
                    case 0: {
                        this.introSplash.paint(_g, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    case 3: {
                        this.board.drawBackground(_g, this.screenXOrigin, this.screenYOrigin, this.getWidth(), this.getHeight());
                        this.board.drawGameBoard(_g, this.getMode(), this.boardX, this.boardY, this.getWidth(), this.getHeight());
                        if (this.messageBox != null) {
                            this.messageBoxPaint(_g, this.msgboxX, this.msgboxY, this.msgboxWidth, this.msgboxHeight);
                            if (this.messageBox.isExtended() && this.highScore != null) {
                                this.highScore.paint(_g);
                            }
                        }
                        this.menu.paint(_g, this.menuX, this.menuY, this.menuWidth, this.menuHeight);
                        break;
                    }
                    case 2: 
                    case 7: {
                        if (this.tournament != null) {
                            this.tournament.paint(_g);
                        }
                        if (this.getMode() != 2) {
                            if (this.tournament == null || this.getMode() != 7) break;
                            if (this.tournament.tournamentState != 12) break;
                        }
                        this.board.drawBackground(_g, this.screenXOrigin, this.screenYOrigin, this.getWidth(), this.getHeight());
                        this.board.drawGameBoard(_g, this.getMode(), this.boardX - 12, this.boardY - 6, this.getWidth(), this.getHeight());
                        this.menu.paint(_g, this.menuX, this.menuY, this.menuWidth, this.menuHeight);
                        Resources.playFile(10);
                        break;
                    }
                    case 6: {
                        this.board.drawBackground(_g, this.screenXOrigin, this.screenYOrigin, this.getWidth(), this.getHeight());
                        if (this.previous_mode != 8) {
                            this.drawAiThinking(_g);
                        }
                        this.board.drawGameBoard(_g, this.getMode(), this.boardX, this.boardY, this.getWidth(), this.getHeight());
                        this.drawSplash(_g);
                        this.menu.paint(_g, this.menuX, this.menuY, this.menuWidth, this.menuHeight);
                        break;
                    }
                    case 4: {
                        if (this.messageBox != null) {
                            if (this.messageBox.isExtended()) {
                                this.messageBoxPaint(_g, this.msgboxX, this.msgboxY, this.msgboxWidth, this.msgboxHeight);
                                this.abc.setAlign((byte)2);
                                String sAbout = Resources.TEXT_ABOUT;
                                this.mpmLength = sAbout.length();
                                if (this.paintRequested[this.PREQ_MSGBOX_TEXT_PAINT]) {
                                    this.donePaint(this.PREQ_MSGBOX_TEXT_PAINT);
                                    this.mpmDrawnChars = this.abc.drawString(_g, sAbout.substring(this.mpmIndex, this.mpmLength), this.msgboxX + 41, this.msgboxY + 3, this.msgboxWidth - 80, this.msgboxHeight - 20, -1);
                                }
                            } else {
                                this.board.drawBackground(_g, this.screenXOrigin, this.screenYOrigin, this.getWidth(), this.getHeight());
                                this.board.drawGameBoard(_g, this.getMode(), this.boardX, this.boardY, this.getWidth(), this.getHeight());
                                this.messageBoxPaint(_g, this.msgboxX, this.msgboxY, this.msgboxWidth, this.msgboxHeight);
                            }
                        }
                        _g.setColor(0);
                        _g.fillRect(this.menuX, this.menuY - 5, this.menuWidth, this.menuHeight + 5);
                        this.menu.paint(_g, this.menuX, this.menuY, this.menuWidth, this.menuHeight);
                        break;
                    }
                    case 10: {
                        this.drawMoreGame(_g);
                        break;
                    }
                    case 5: {
                        if (this.messageBox != null) {
                            if (this.messageBox.isExtended()) {
                                this.messageBoxPaint(_g, this.msgboxX, this.msgboxY, this.msgboxWidth, this.msgboxHeight);
                                this.abc.setAlign((byte)3);
                                String sHelp = Resources.getText((short)49) + Resources.getText((short)50);
                                this.mpmLength = sHelp.length();
                                if (this.paintRequested[this.PREQ_MSGBOX_TEXT_PAINT] && this.messageBox.isExtended()) {
                                    this.donePaint(this.PREQ_MSGBOX_TEXT_PAINT);
                                    this.mpmDrawnChars = this.abc.drawString(_g, sHelp.substring(this.mpmIndex, this.mpmLength), this.msgboxX + 54, this.msgboxY + 4, this.msgboxWidth - 100, this.msgboxHeight - 30 - 20, -1);
                                }
                            } else {
                                this.board.drawBackground(_g, this.screenXOrigin, this.screenYOrigin, this.getWidth(), this.getHeight());
                                this.board.drawGameBoard(_g, this.getMode(), this.boardX, this.boardY, this.getWidth(), this.getHeight());
                                this.messageBoxPaint(_g, this.msgboxX, this.msgboxY, this.msgboxWidth, this.msgboxHeight);
                            }
                        }
                        _g.setColor(0);
                        _g.fillRect(this.menuX, this.menuY - 5, this.menuWidth, this.menuHeight + 5);
                        this.menu.paint(_g, this.menuX, this.menuY, this.menuWidth, this.menuHeight);
                    }
                }
            }
            _g.setClip(0, 0, 240, 400);
            graphics.drawImage(this.bufi, 0, 0, 20);
            this.midlet.display.callSerially((Runnable)this);
        }
        if (timePause > 3000L) {
            System.out.println("3000300030003000 ");
            this.prevTime = currentTime;
            this.hideNotify();
            this.showNotify();
        } else {
            this.prevTime = currentTime;
        }
        this.nowPainting = false;
    }

    private void aiMove() {
        this.bAiIsThinking = true;
        byte[] move = this.ai.bestMove(this.board, this.board.getComputer());
        if (this.getMode() == 7) {
            this.board.setSpecialObstacle();
        }
        this.board.setValue(move[0], move[1], this.board.getComputer());
        this.board.last2Moves[this.board.getComputer()][0] = move[0];
        this.board.last2Moves[this.board.getComputer()][1] = move[1];
        this.playerScore = this.board.getScore(this.board.getPlayer());
        this.computerScore = this.board.getScore(this.board.getComputer());
        this.bAiIsThinking = false;
        move = null;
    }

    protected void update() {
        this.nowUpdating = true;
        if (this.bRun) {
            if (this.tournament != null && this.tournament.isEndState()) {
                this.playerScore = 0;
                this.computerScore = 0;
                int i = 0;
                while (true) {
                    if (i >= 7) break;
                    this.playerScore += this.tournament.TOURNAMENT[i][0];
                    ++i;
                }
                if (this.playerScore > 0) {
                    this.highScore.highScoreEditing(true);
                    this.setMode((byte)3);
                    if (this.highScore.isEditing()) {
                        this.menu.setMenu(this.menu.highscoreSaveMenu, true);
                    } else {
                        this.menu.setMenu(this.menu.mainMenu, true);
                    }
                    if (this.messageBox == null) {
                        this.messageBox = new MessageBox(this);
                    }
                    this.messageBox.startAnimationUp();
                } else {
                    this.menu.setMenu(this.menu.mainMenu, true);
                }
                if (!this.highScore.isEditing()) {
                    if (this.getMode() != 2) {
                        this.setMode((byte)2);
                    }
                    Resources.playFile(10);
                    this.messageBox = null;
                }
                this.tournament = null;
            }
            this.menu.update();
            if (this.highScore != null) {
                this.highScore.update();
            }
            if (this.tournament != null) {
                this.tournament.update();
            }
            if (this.messageBox != null) {
                this.messageBox.update();
                if (this.messageBox.isShrunk()) {
                    this.mpmIndex = 0;
                    this.mpmLength = 0;
                    this.mpmDrawnChars = 0;
                    if (this.getMode() != 7 && this.getMode() != 2) {
                        if (this.getMode() != 2) {
                            this.setMode((byte)2);
                        }
                        if (this.loadDone) {
                            Resources.playFile(10);
                        }
                        this.messageBox = null;
                    }
                }
            }
            if (this.board.getSpecialObstacle() != 3) {
                this.board.updateSpecialEffect();
            }
            if (!this.isMove) {
                this.setMatchScore();
                if (this.splash == 0 && this.getMode() != 7) {
                    this.setSplash((byte)1);
                }
                this.isMove = true;
                this.bGameInProgress = false;
            }
        }
        this.nowUpdating = false;
    }

    static {
        ii = 0;
        lsImg = 0;
        lsX = 50;
        lsY = 148;
        exY = 30;
    }
}

