/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.component;

import com.ximad.braincube2.component.Field;
import javax.microedition.lcdui.Graphics;

public class CustomItemBox
extends Field {
    private static final int DEFAULT_COUNT = 25;
    private static final int DEFAULT_STEP = 5;
    private static final int SPACING = 5;
    private Field[] items;
    private int itemsCount = 0;
    private int[] tops;
    private boolean SCROLL;
    private int lastEventY;
    private int scrollPosition;
    private int maxPosition;
    private int delta;
    private int speed;
    private int begin;
    boolean inertion = false;

    public CustomItemBox(int w, int h) {
        this.width = w;
        this.height = h;
        this.items = new Field[25];
        this.tops = new int[25];
        this.itemsCount = 0;
    }

    public void onPaint(Graphics g) {
        g.clipRect(this.left, this.top, this.width, this.height);
        for (int i = 0; i < this.itemsCount; ++i) {
            this.items[i].left = this.left;
            this.items[i].top = this.tops[i] - this.scrollPosition + this.top;
            this.items[i].onPaint(g);
        }
        g.setClip(0, 0, 640, 360);
    }

    public void add(Field f) {
        f.top = this.maxPosition;
        if (this.itemsCount == this.items.length) {
            Field[] tmp = new Field[this.itemsCount + 5];
            System.arraycopy(this.items, 0, tmp, 0, this.itemsCount);
            this.items = tmp;
            int[] tmp_i = new int[this.itemsCount + 5];
            System.arraycopy(this.tops, 0, tmp_i, 0, this.itemsCount);
            this.tops = tmp_i;
        }
        this.tops[this.itemsCount] = f.top;
        this.items[this.itemsCount++] = f;
        this.maxPosition += f.getHeight() + 5;
    }

    public void add(Field[] f) {
        for (int i = 0; i < f.length; ++i) {
            this.add(f[i]);
        }
    }

    public void onIdle() {
        if (this.inertion && this.begin > 10) {
            if (this.delta > 0) {
                this.scrollPosition -= this.speed * 2;
            } else if (this.delta < 0) {
                this.scrollPosition += this.speed * 2;
            }
            if (this.scrollPosition < 0) {
                this.scrollPosition = 0;
            } else if (this.scrollPosition > this.getMaxScrollPosition()) {
                this.scrollPosition = this.getMaxScrollPosition();
            }
            --this.speed;
            if (this.speed == 0) {
                this.inertion = false;
            }
            this.repaint(this.left, this.top, this.width, this.height);
        }
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public int getMaxScrollPosition() {
        return this.maxPosition - this.height;
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.SCROLL = true;
                this.lastEventY = eventY;
                this.begin = eventY;
                this.inertion = false;
                break;
            }
            case 1: {
                this.SCROLL = false;
                if (this.delta > 1 || this.delta < -1) {
                    this.inertion = true;
                    this.speed = 10;
                }
                this.begin = eventY - this.begin;
                if (this.begin >= 0) break;
                this.begin *= -1;
                break;
            }
            case 3: {
                if (!this.SCROLL) {
                    return false;
                }
                this.delta = eventY - this.lastEventY;
                this.scrollPosition -= this.delta;
                this.lastEventY = eventY;
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                } else if (this.scrollPosition > this.getMaxScrollPosition()) {
                    this.scrollPosition = this.getMaxScrollPosition();
                }
                this.repaint(this.left, this.top, this.width, this.height);
            }
        }
        return !out;
    }

    public void setLeft(int l) {
        this.left = l;
    }

    public void setTop(int t) {
        this.top = t;
    }
}

