/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.Boss;
import com.ximad.braincube2.components.Camera;
import com.ximad.braincube2.components.Cube;
import com.ximad.braincube2.components.Cubes;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.screens.GameScreen;
import javax.microedition.lcdui.Graphics;

public class BossTurbo
extends Boss {
    public int xAdd;
    public int yAdd;
    public boolean isDisplayed;
    public boolean isActive;
    private boolean isBossComing;
    public boolean isBossExiting;
    public boolean isBossMoving;
    public boolean isNeedToShift;
    private int animationFrame;
    private int counter;
    private int stepX;
    private int stepY;
    private Cube activeCube;

    public BossTurbo(int iX, int iY) {
        this.type = 1;
        this.x = iX;
        this.y = iY;
        this.isBossComing = false;
        this.isBossExiting = false;
        this.isNeedToShift = true;
    }

    public void nextMove() {
        if (this.isNeedToShift) {
            this.counter = 0;
            this.activeCube = Cubes.getInstance().getActiveCube();
            this.stepX = (Constants.cBc[0][0] * Board.getInstance().dimX + Constants.cBc[0][1] * this.activeCube.y - this.xR) / 4;
            this.stepY = (this.activeCube.yR + Constants.TURBO_SHIFTS[3] - this.yR) / 4;
            this.isBossMoving = true;
            Cubes.getInstance().getActiveCube().shiftCubeTurbo();
            this.yAdd = 0;
            this.xAdd = 0;
        }
    }

    public void paint(Graphics g, int shiftX, int shiftY) {
        if (this.isBossComing) {
            ++this.counter;
            if (this.counter > 12) {
                this.xAdd = 0;
                this.animationFrame = 0;
                this.counter = 0;
                this.isBossComing = false;
                Camera.getInstance().setShifts(Constants.TURBO_SHIFTS[0], Constants.TURBO_SHIFTS[1]);
                Camera.getInstance().smoothCenterCube(Cubes.getInstance().getActiveCube());
                Cubes.getInstance().getActiveCube().inAction = false;
                this.xR = this.activeCube.xR + Constants.TURBO_SHIFTS[2];
                this.yR = this.activeCube.yR + Constants.TURBO_SHIFTS[3];
            } else {
                this.xAdd -= 15;
                this.activeCube.inAction = true;
            }
        } else if (this.isBossExiting) {
            ++this.counter;
            if (this.counter > 40) {
                this.xAdd = -1000;
                this.deactivate();
                this.isBossExiting = false;
                Achievements.makeAchivment(Achievements.SECOND_BOSS_PASSED, 1);
                GameScreen.gameStatus = 6;
            } else {
                this.xAdd -= 20;
            }
        } else if (this.isBossMoving) {
            ++this.counter;
            if (this.counter > 4) {
                this.xR = Constants.cBc[0][0] * Board.getInstance().dimX + Constants.cBc[0][1] * this.activeCube.y;
                this.yR = this.activeCube.yR + Constants.TURBO_SHIFTS[3];
                this.yAdd = 0;
                this.xAdd = 0;
                this.counter = 0;
                this.isBossMoving = false;
            } else {
                this.yAdd += this.stepY;
                this.xAdd += this.stepX;
            }
        }
        if (this.isActive) {
            ImagesResources.turboBossImages[this.animationFrame].draw(g, this.xR + shiftX + this.xAdd, this.yR + shiftY + this.yAdd + ImagesResources.turboBossImages[this.animationFrame].getHeight());
            ++this.animationFrame;
            if (this.animationFrame > 3) {
                this.animationFrame = 0;
            }
        } else {
            ImagesResources.turboBossImages[this.animationFrame].draw(g, this.xR + shiftX + this.xAdd, this.yR + shiftY + this.yAdd + ImagesResources.turboBossImages[this.animationFrame].getHeight());
        }
    }

    public void finishBoss() {
        this.isActive = false;
        this.isBossExiting = true;
        this.counter = 0;
        this.animationFrame = 3;
    }

    public void startBoss() {
        this.activeCube = Cubes.getInstance().getActiveCube();
        this.activeCube.inAction = true;
        this.xR = Constants.cBc[0][0] * Board.getInstance().dimX + Constants.cBc[0][1] * this.activeCube.y;
        this.yR = this.activeCube.yR + Constants.TURBO_SHIFTS[3];
        this.animationFrame = 0;
        this.isActive = true;
        this.xAdd = Constants.TURBO_SHIFTS[4];
        this.isBossComing = true;
        Camera.getInstance().makeSmoothMove(Camera.getInstance().x + Constants.TURBO_SHIFTS[0], Camera.getInstance().y + Constants.TURBO_SHIFTS[1]);
        Board.getInstance().activateBossEffect(this);
    }

    public void deactivate() {
        this.isDisplayed = false;
        if (DataManager.isSoundEffectsEnabled) {
            SoundSystem.stopTurbo();
        }
    }
}

