/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class HintButtonScreen
extends Field {
    public long timeTotal;
    public int timeToGo;
    public int timeFromBeg;
    private boolean isNeedToUpdate;
    private Font font = Utils.getFont(64, 2, 8);
    private int width;
    private int height;
    public int state = 2;

    public HintButtonScreen() {
        this.timeTotal = Board.getInstance().hintTime;
        this.timeFromBeg = 0;
        this.timeToGo = (int)this.timeTotal;
        this.isNeedToUpdate = true;
        this.width = ImagesResources.gameTouchButtons[2][this.state].getWidth();
        this.height = ImagesResources.gameTouchButtons[2][this.state].getHeight();
    }

    public void reinitialize() {
        this.state = 2;
        this.timeTotal = Board.getInstance().hintTime;
        this.timeFromBeg = 0;
        this.timeToGo = (int)this.timeTotal;
        this.isNeedToUpdate = true;
        this.width = ImagesResources.gameTouchButtons[2][this.state].getWidth();
        this.height = ImagesResources.gameTouchButtons[2][this.state].getHeight();
    }

    public void onPaint(Graphics graphics) {
        if (this.state == 2) {
            graphics.setFont(this.font);
            graphics.setColor(0xD5D5D5);
            graphics.drawString(this.convertMsToTime(this.timeToGo), this.left + Constants.GAME_SCREEN_COORDS[7][0], this.top + Constants.GAME_SCREEN_COORDS[7][1], 0);
        }
        ImagesResources.gameTouchButtons[2][this.state].draw(graphics, this.left, this.top);
    }

    private String convertMsToTime(int ms) {
        int min;
        String time = "0:00";
        int sec = ms / 1000;
        time = (sec -= (min = sec / 60) * 60) < 10 ? min + ":0" + sec : min + ":" + sec;
        return time;
    }

    public void update(long newTime) {
        if (this.isNeedToUpdate) {
            this.timeFromBeg = (int)newTime;
            this.timeToGo = (int)(this.timeTotal - (long)this.timeFromBeg);
            if (this.timeToGo <= 0) {
                this.state = 0;
                this.isNeedToUpdate = false;
            }
        }
        if (Board.getInstance().hints.isActive) {
            this.state = 1;
        } else if (this.state != 2) {
            this.state = 0;
        }
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.status = 1;
                this.repaint();
                break;
            }
            case 1: {
                if (!out && this.status == 1) {
                    this.touchAction();
                    this.status = 0;
                    this.repaint();
                    break;
                }
                if (this.status == 1) {
                    this.status = 0;
                    this.repaint();
                    break;
                }
                this.status = 0;
            }
        }
        return !out;
    }

    protected void touchAction() {
    }
}

