/*
 * Decompiled with CFR 0.152.
 */
package LockemUp;

import LockemUp.Animal;
import LockemUp.Switch;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.GraphicObjectManager;
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import com.siemens.mp.game.Sprite;
import com.siemens.mp.game.Vibrator;

public class GameBoard {
    private static final int GAME_MAP_WIDTH = 11;
    private static final int GAME_MAP_HEIGHT = 11;
    private static final int GAME_TILE_WIDTH = 8;
    private static final int GAME_TILE_HEIGHT = 7;
    private static final int LINE_LEN = 77;
    private GraphicObjectManager gfxManager;
    private byte[] back;
    private byte[] map;
    private byte[] state;
    private byte[] info;
    private byte goodExit;
    private int numOfSwitches;
    private byte[] numOfActors = new byte[]{0, 0, 0};
    private Switch[] switches;
    private Animal[] animals;
    private Sprite[][] actors = new Sprite[3][];
    private byte[] arrowLocs;
    private Melody melody;
    private byte[] mapData;
    private boolean onSound;
    private boolean onVibrate;

    public GameBoard(GraphicObjectManager graphicObjectManager, byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        this.gfxManager = graphicObjectManager;
        this.back = new byte[847];
        this.map = new byte[121];
        this.state = new byte[121];
        this.info = new byte[121];
        this.animals = new Animal[4];
        this.mapData = byArray;
        this.dealWithMap(byArray, byArray2, byArray3, true, n);
    }

    public void reInit(int n) {
        this.dealWithMap(this.mapData, null, null, false, n);
    }

    public void Dispose() {
        this.back = null;
        this.map = null;
        this.state = null;
        this.info = null;
        this.gfxManager = null;
        this.switches = null;
        this.mapData = null;
    }

    public byte[] getBackground() {
        return this.back;
    }

    public void setOnSound(boolean bl) {
        this.onSound = bl;
    }

    public void setOnVibrate(boolean bl) {
        this.onVibrate = bl;
    }

    public void turnArrow(int n) {
        if (n < this.numOfActors[2] && n >= 0) {
            byte by = this.arrowLocs[n];
            int n2 = by % 11;
            int n3 = by / 11;
            byte by2 = this.state[by];
            while (!this.isTurnable(n2, n3, by2 = (byte)((by2 + 1) % 4))) {
            }
            this.state[by] = by2;
            this.actors[2][n].setFrame((int)by2);
            if (this.onSound) {
                Melody.stop();
                this.melody = null;
                this.melody = this.createMelody(1);
                this.melody.play();
            }
        }
    }

    public int manageMoves() {
        int n;
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < 4) {
            bl &= this.animals[n2].bDestroyed;
            if (!this.animals[n2].bDestroyed) {
                this.moveAnimal(n2);
            }
            if (!this.animals[n2].bImmune && this.map[n = this.animals[n2].gridy * 11 + this.animals[n2].gridx] == 7 && this.state[n] > 0) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 3) {
            if (!this.animals[n2].bDestroyed && !bl2) {
                n = n2 + 1;
                while (n < 4) {
                    if (!this.animals[n].bDestroyed && !bl2) {
                        bl2 = this.animals[n2].sprite.isCollidingWith(this.animals[n].sprite);
                    }
                    ++n;
                }
            }
            ++n2;
        }
        if (bl) {
            return 3;
        }
        if (bl2) {
            if (this.onVibrate) {
                Vibrator.triggerVibrator((int)500);
            }
            return 4;
        }
        return 0;
    }

    private void moveAnimal(int n) {
        int n2;
        int n3;
        Animal animal = this.animals[n];
        int n4 = -1;
        int n5 = animal.x + animal.vx;
        int n6 = animal.y + animal.vy;
        int n7 = animal.vx > 0 ? 7 : 0;
        int n8 = animal.vy > 0 ? 6 : 0;
        n7 = n5 >= 0 ? ((n5 >> 8) + n7) / 8 : -1;
        n8 = n6 >= 0 ? ((n6 >> 8) + n8) / 7 : -1;
        int n9 = animal.vx > 0 ? 1 : (n3 = animal.vx < 0 ? -1 : 0);
        int n10 = animal.vy > 0 ? 1 : (animal.vy < 0 ? -1 : 0);
        int n11 = ((n7 - n3) * 8 << 8) - n5;
        int n12 = ((n8 - n10) * 7 << 8) - n6;
        int n13 = animal.gridy * 11 + animal.gridx;
        if (animal.gridx != n7 || animal.gridy != n8) {
            int n14;
            if (animal.map == 6 && !animal.bImmune) {
                this.state[n13] = (byte)((this.state[n13] + 1) % 2);
                this.switches[this.info[n13]].sprite.setFrame((int)this.state[n13]);
                n2 = 0;
                while (n2 < this.switches[this.info[n13]].nblinks) {
                    n14 = this.switches[this.info[n13]].links[n2];
                    this.state[n14] = (byte)((this.state[n14] + 1) % 2);
                    switch (this.map[n14]) {
                        case 4: {
                            this.actors[1][this.info[n14]].setFrame((int)this.state[n14]);
                            break;
                        }
                        case 7: {
                            this.actors[0][this.info[n14]].setFrame((int)this.state[n14]);
                        }
                    }
                    ++n2;
                }
            }
            if (animal.bImmune) {
                animal.bImmune = false;
            }
            if (animal.map == 5 && animal.state == n) {
                this.goodExit = (byte)(this.goodExit + 1);
                animal.setPosition(animal.gridx * 8 << 8, animal.gridy * 7 << 8);
                if (this.onSound && this.goodExit < 4) {
                    Melody.stop();
                    this.melody = null;
                    this.melody = this.createMelody(0);
                    this.melody.play();
                }
                animal.setDestroyed();
                return;
            }
            if (animal.map == 8) {
                if (this.onSound) {
                    Melody.stop();
                    this.melody = null;
                    this.melody = this.createMelody(2);
                    this.melody.play();
                }
                animal.bImmune = true;
            }
            boolean bl = false;
            if (animal.map == 2) {
                bl = true;
                switch (animal.state) {
                    case 0: {
                        if (!this.isBlocked(animal.gridx - 1, animal.gridy, n)) break;
                        bl = false;
                        break;
                    }
                    case 2: {
                        if (!this.isBlocked(animal.gridx + 1, animal.gridy, n)) break;
                        bl = false;
                        break;
                    }
                    case 1: {
                        if (!this.isBlocked(animal.gridx, animal.gridy - 1, n)) break;
                        bl = false;
                        break;
                    }
                    case 3: {
                        if (!this.isBlocked(animal.gridx, animal.gridy + 1, n)) break;
                        bl = false;
                    }
                }
                n14 = -1;
                if (bl) {
                    n14 = animal.vx < 0 ? 0 : (animal.vx > 0 ? 2 : (animal.vy < 0 ? 1 : 3));
                    n4 = (5 - n14 + animal.state) % 4;
                }
            }
            if (!bl && (this.isBlocked(n7, n8, n) && !animal.bImmune || this.isOutScreen(n7, n8))) {
                n4 = !this.isBlocked(animal.gridx - n10, animal.gridy + n3, n) ? 2 : (!this.isBlocked(animal.gridx + n10, animal.gridy - n3, n) ? 0 : 3);
            }
            switch (n4) {
                case 2: {
                    n14 = animal.vx;
                    animal.vx = -animal.vy;
                    animal.vy = n14;
                    n5 += n11 + n12;
                    n6 += n12 - n11;
                    break;
                }
                case 0: {
                    n14 = animal.vx;
                    animal.vx = animal.vy;
                    animal.vy = -n14;
                    n5 += n11 - n12;
                    n6 += n12 + n11;
                    break;
                }
                case 3: {
                    animal.vx = -animal.vx;
                    animal.vy = -animal.vy;
                    n5 += 2 * n11;
                    n6 += 2 * n12;
                }
            }
        }
        animal.setPosition(n5, n6);
        n7 = animal.vx > 0 ? 7 : 0;
        n8 = animal.vy > 0 ? 6 : 0;
        animal.gridx = ((n5 >> 8) + n7) / 8;
        animal.gridy = ((n6 >> 8) + n8) / 7;
        if (n4 < 0) {
            n2 = animal.gridy * 11 + animal.gridx;
            animal.map = this.map[n2];
            animal.state = this.state[n2];
            animal.info = this.info[n2];
        } else {
            animal.map = 0;
            animal.state = 0;
            animal.info = 0;
        }
    }

    private boolean isOutScreen(int n, int n2) {
        return n < 0 || n >= 11 || n2 < 0 || n2 >= 11;
    }

    private boolean isBlocked(int n, int n2, int n3) {
        if (this.isOutScreen(n, n2)) {
            return true;
        }
        int n4 = n2 * 11 + n;
        if (this.map[n4] == 1) {
            return true;
        }
        if (this.map[n4] == 4 && this.state[n4] == 0) {
            return true;
        }
        return this.map[n4] == 5 && this.state[n4] != n3;
    }

    private boolean isTurnable(int n, int n2, int n3) {
        if (n3 % 2 == 0) {
            if (this.isOutScreen(n + n3 - 1, n2)) {
                return false;
            }
            return this.map[n2 * 11 + (n + n3 - 1)] != 1;
        }
        if (this.isOutScreen(n, n2 + n3 - 2)) {
            return false;
        }
        return this.map[(n2 + n3 - 2) * 11 + n] != 1;
    }

    private void dealWithMap(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl, int n) {
        int n2;
        Sprite sprite;
        byte[] byArray4;
        int n3;
        int n4 = 0;
        byte[] byArray5 = new byte[]{0, 0, 0};
        this.goodExit = (byte)(3 - n);
        this.numOfSwitches = byArray[n4];
        ++n4;
        if (bl) {
            this.switches = new Switch[this.numOfSwitches];
        }
        int n5 = 0;
        while (n5 < this.numOfSwitches) {
            if (bl) {
                this.switches[n5] = new Switch();
                this.switches[n5].nblinks = byArray[n4];
            }
            ++n4;
            if (bl) {
                this.switches[n5].links = new byte[this.switches[n5].nblinks];
            }
            n3 = 0;
            while (n3 < this.switches[n5].nblinks) {
                if (bl) {
                    this.switches[n5].links[n3] = byArray[n4];
                }
                ++n4;
                ++n3;
            }
            if (bl) {
                byArray4 = new byte[16];
                System.arraycopy(byArray3, 128, byArray4, 0, 16);
                this.switches[n5].sprite = sprite = new Sprite(byArray4, 0, 8, 8, null, 0, 2);
                this.gfxManager.addObject((GraphicObject)sprite);
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < 4) {
            n2 = byArray[n4];
            ++n4;
            if (bl) {
                byArray4 = new byte[16];
                System.arraycopy(byArray3, n5 * 32, byArray4, 0, 16);
                byte[] byArray6 = new byte[16];
                System.arraycopy(byArray3, n5 * 32 + 16, byArray6, 0, 16);
                sprite = new Sprite(byArray4, 0, 8, 8, byArray6, 0, 2);
                this.animals[n5] = new Animal(sprite);
            }
            this.animals[n5].initAnimal((byte)n2, byArray[n4], n5);
            if (n5 > n) {
                this.animals[n5].bDestroyed = true;
                this.animals[n5].sprite.setVisible(false);
            }
            ++n4;
            ++n5;
        }
        if (bl) {
            n2 = n4;
            n5 = 0;
            while (n5 < 121) {
                if (byArray[n2] < 100) {
                    if (byArray[n2] >= 65) {
                        this.numOfActors[0] = (byte)(this.numOfActors[0] + 1);
                    } else if (byArray[n2] < 60) {
                        if (byArray[n2] >= 55) {
                            this.numOfActors[1] = (byte)(this.numOfActors[1] + 1);
                        } else if (byArray[n2] >= 10) {
                            this.numOfActors[2] = (byte)(this.numOfActors[2] + 1);
                        }
                    }
                }
                ++n2;
                ++n5;
            }
            n5 = 0;
            while (n5 < 2) {
                this.actors[n5] = new Sprite[this.numOfActors[n5]];
                n3 = 0;
                while (n3 < this.numOfActors[n5]) {
                    byArray4 = new byte[16];
                    System.arraycopy(byArray3, 144 + n5 * 16, byArray4, 0, 16);
                    this.actors[n5][n3] = sprite = new Sprite(byArray4, 0, 8, 8, byArray4, 0, 2);
                    this.gfxManager.addObject((GraphicObject)sprite);
                    ++n3;
                }
                ++n5;
            }
            this.actors[2] = new Sprite[this.numOfActors[2]];
            this.arrowLocs = new byte[this.numOfActors[2]];
            n5 = 0;
            while (n5 < this.numOfActors[2]) {
                byArray4 = new byte[32];
                System.arraycopy(byArray3, 176 + n5 * 32, byArray4, 0, 32);
                this.actors[2][n5] = sprite = new Sprite(byArray4, 0, 8, 8, byArray4, 0, 4);
                this.gfxManager.addObject((GraphicObject)sprite);
                ++n5;
            }
        }
        n5 = 0;
        while (n5 < 11) {
            n3 = 0;
            while (n3 < 11) {
                int n6;
                if (byArray[n4] >= 100) {
                    n2 = byArray[n4] - 100;
                    this.map[n5 * 11 + n3] = 6;
                    this.state[n5 * 11 + n3] = (byte)(n2 % 2);
                    this.info[n5 * 11 + n3] = (byte)(n2 / 2);
                    this.switches[n2 /= 2].sprite.setPosition(8 * n3, 7 * n5);
                    this.switches[n2].sprite.setFrame((int)this.state[n5 * 11 + n3]);
                } else if (byArray[n4] >= 65) {
                    this.map[n5 * 11 + n3] = 7;
                    this.state[n5 * 11 + n3] = (byte)((byArray[n4] - 65) % 2);
                    this.info[n5 * 11 + n3] = byArray5[0];
                    this.actors[0][byArray5[0]].setPosition(8 * n3, 7 * n5);
                    this.actors[0][byArray5[0]].setFrame((int)this.state[n5 * 11 + n3]);
                    byArray5[0] = (byte)(byArray5[0] + 1);
                } else if (byArray[n4] >= 60) {
                    n2 = (byte)((byArray[n4] - 60) % 4);
                    this.state[n5 * 11 + n3] = (byte)n2;
                    this.map[n5 * 11 + n3] = 5;
                    if (bl) {
                        n6 = 0;
                        while (n6 < 7) {
                            this.back[77 * n5 + n3 + n6 * 11] = byArray2[n6 + (n2 + 1) * 7];
                            ++n6;
                        }
                    }
                } else if (byArray[n4] >= 55) {
                    this.map[n5 * 11 + n3] = 4;
                    this.state[n5 * 11 + n3] = (byte)((byArray[n4] - 55) % 2);
                    this.info[n5 * 11 + n3] = byArray5[1];
                    this.actors[1][byArray5[1]].setPosition(8 * n3, 7 * n5);
                    this.actors[1][byArray5[1]].setFrame((int)this.state[n5 * 11 + n3]);
                    byArray5[1] = (byte)(byArray5[1] + 1);
                } else if (byArray[n4] >= 10) {
                    n2 = byArray[n4] - 10;
                    n6 = n2 / 10;
                    byte by = byArray5[2];
                    byArray5[2] = (byte)(byArray5[2] + 1);
                    this.arrowLocs[by] = (byte)(n5 * 11 + n3);
                    this.state[n5 * 11 + n3] = (byte)n6;
                    this.actors[2][by].setPosition(8 * n3, 7 * n5);
                    this.info[n5 * 11 + n3] = by;
                    this.actors[2][by].setFrame(n6);
                    this.map[n5 * 11 + n3] = 2;
                } else if (byArray[n4] >= 2) {
                    if (bl) {
                        n6 = 0;
                        while (n6 < 7) {
                            this.back[77 * n5 + n3 + n6 * 11] = byArray2[n6 + 35];
                            ++n6;
                        }
                    }
                    this.map[n5 * 11 + n3] = 8;
                } else if (byArray[n4] == 1) {
                    if (bl) {
                        n6 = 0;
                        while (n6 < 7) {
                            this.back[77 * n5 + n3 + n6 * 11] = byArray2[n6];
                            ++n6;
                        }
                    }
                    this.map[n5 * 11 + n3] = 1;
                } else {
                    this.map[n5 * 11 + n3] = 0;
                }
                ++n4;
                ++n3;
            }
            ++n5;
        }
        if (bl) {
            n5 = 0;
            while (n5 < 4) {
                this.gfxManager.addObject((GraphicObject)this.animals[n5].sprite);
                ++n5;
            }
        }
    }

    private Melody createMelody(int n) {
        try {
            MelodyComposer melodyComposer = new MelodyComposer();
            melodyComposer.setBPM(132);
            switch (n) {
                case 0: {
                    melodyComposer.appendNote(19, 6);
                    melodyComposer.appendNote(18, 6);
                    melodyComposer.appendNote(17, 6);
                    melodyComposer.appendNote(16, 6);
                    melodyComposer.appendNote(15, 6);
                    melodyComposer.appendNote(28, 6);
                    melodyComposer.appendNote(29, 6);
                    melodyComposer.appendNote(30, 6);
                    melodyComposer.appendNote(31, 6);
                    melodyComposer.appendNote(32, 6);
                    melodyComposer.appendNote(33, 6);
                    melodyComposer.appendNote(34, 6);
                    melodyComposer.appendNote(24, 6);
                    melodyComposer.appendNote(36, 6);
                    break;
                }
                case 1: {
                    melodyComposer.appendNote(49, 6);
                    melodyComposer.appendNote(37, 6);
                    break;
                }
                case 2: {
                    melodyComposer.appendNote(24, 6);
                    melodyComposer.appendNote(28, 6);
                    melodyComposer.appendNote(31, 6);
                    melodyComposer.appendNote(33, 6);
                    melodyComposer.appendNote(24, 6);
                    melodyComposer.appendNote(36, 6);
                    melodyComposer.appendNote(58, 3);
                    melodyComposer.appendNote(58, 5);
                    melodyComposer.appendNote(41, 6);
                    melodyComposer.appendNote(43, 6);
                    melodyComposer.appendNote(45, 6);
                    melodyComposer.appendNote(36, 6);
                    melodyComposer.appendNote(48, 6);
                }
            }
            return melodyComposer.getMelody();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return null;
        }
    }
}

