/*
 * Decompiled with CFR 0.152.
 */
package LockemUp;

import LockemUp.BaseScreen;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import com.siemens.mp.game.GraphicObjectManager;
import com.siemens.mp.game.Sprite;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStore;

public class LevelScreen
extends BaseScreen {
    private static final int GAME_SCREEN_WIDTH = 96;
    private static final int GAME_SCREEN_HEIGHT = 80;
    private static final int BLINK_TIMER = 4;
    private static final int[] LEVELMAPCOUNT = new int[]{5, 10, 5, 5, 5, 10};
    private static final String MENU_DATA = "res\\menu.bin";
    private static final String NUM_TILES = "res\\num.bin";
    private static final String[] LEVELNAME = new String[]{"Learning", "Beginning", "Switch", "Death", "Jumper", "Master"};
    private static final String GAMERECORD = "REC";
    private byte[] records;
    private boolean modified;
    private int maxLevel;
    private int maxMap;
    private int level = 0;
    private int map = 0;
    private long timer;
    private CommandListener listener;
    private int state;
    private boolean running;
    private boolean readyToPaint;
    private Image gameScreenImage;
    private ExtendedImage gameScreen;
    private GraphicObjectManager gfxManager;
    private Sprite levelSpr;
    private Sprite mapSpr;
    private boolean blink;
    private boolean visible;
    private int blinkTimer;
    private boolean repaintFlag;
    private byte[] pixels;
    private int menuShow;
    private Image menu;
    private ExtendedImage menuEx;

    public LevelScreen() {
        try {
            this.gameScreenImage = Image.createImage((int)96, (int)80);
            this.gameScreen = new ExtendedImage(this.gameScreenImage);
            this.gfxManager = new GraphicObjectManager();
            this.pixels = this.ReadByteArray(NUM_TILES, 42, 0);
            byte[] byArray = new byte[42];
            int n = 0;
            while (n < 42) {
                byArray[n] = -2;
                ++n;
            }
            this.levelSpr = new Sprite(this.pixels, 0, 8, 7, byArray, 0, 6);
            byArray = null;
            this.pixels = this.ReadByteArray(NUM_TILES, 77, 0);
            byArray = new byte[77];
            n = 0;
            while (n < 77) {
                byArray[n] = -2;
                ++n;
            }
            this.mapSpr = new Sprite(this.pixels, 0, 8, 7, byArray, 0, 11);
            byArray = null;
            this.gfxManager.addObject((GraphicObject)this.levelSpr);
            this.gfxManager.addObject((GraphicObject)this.mapSpr);
            this.pixels = this.ReadByteArray(MENU_DATA, 960, 0);
            this.menu = Image.createImage((int)24, (int)8);
            this.menuEx = new ExtendedImage(this.menu);
            this.menuEx.setPixels(this.ReadByteArray("res\\menu_sprite.bin", 24, 0), 0, 0, 24, 8);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
        this.modified = false;
        this.records = new byte[80];
        this.timer = 0L;
        this.blink = false;
        this.visible = true;
        this.state = 0;
        this.readyToPaint = true;
        this.repaintFlag = true;
    }

    public void Dispose() {
        this.menuEx = null;
        this.gameScreen = null;
        this.gfxManager = null;
    }

    public void loadRecords() {
        int n = 0;
        while (n < 80) {
            this.records[n] = 0;
            ++n;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)GAMERECORD, (boolean)true);
            byte[] byArray = new byte[2];
            if (recordStore.getNumRecords() > 0) {
                recordStore.getRecord(1, this.records, 0);
                recordStore.getRecord(2, byArray, 0);
                this.maxLevel = byArray[0];
                this.level = this.maxLevel - 1;
                this.maxMap = byArray[1];
                this.map = this.maxMap - 1;
            } else {
                byArray[0] = 1;
                byArray[1] = 1;
                recordStore.addRecord(this.records, 0, 80);
                recordStore.addRecord(byArray, 0, 2);
                this.maxLevel = 1;
                this.level = 0;
                this.maxMap = 1;
                this.map = 0;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    public void saveRecords() {
        try {
            if (this.modified) {
                RecordStore recordStore = RecordStore.openRecordStore((String)GAMERECORD, (boolean)true);
                byte[] byArray = new byte[]{(byte)this.maxLevel, (byte)this.maxMap};
                if (recordStore.getNumRecords() > 0) {
                    recordStore.setRecord(1, this.records, 0, 80);
                    recordStore.setRecord(2, byArray, 0, 2);
                } else {
                    recordStore.addRecord(this.records, 0, 80);
                    recordStore.addRecord(byArray, 0, 2);
                }
                recordStore.closeRecordStore();
                this.modified = false;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    public void resetStateValue() {
        this.state = 0;
        this.repaintFlag = true;
        this.gameScreen.clear((byte)0);
    }

    public void setStateValue(int n) {
        this.state = n;
        this.repaintFlag = false;
        this.gameScreen.clear((byte)0);
        Font font = Font.getFont((int)0, (int)1, (int)8);
        this.gameScreenImage.getGraphics().setFont(font);
        int n2 = font.stringWidth("Please wait...");
        int n3 = font.getHeight();
        int n4 = (96 - n2) / 2;
        int n5 = (80 - n3) / 2;
        this.gameScreenImage.getGraphics().drawString("Please wait...", n4, n5, 20);
        this.gameScreenImage.getGraphics().drawRect(n4 -= 2, n5 -= 2, n2 + 3, n3 + 3);
        this.gameScreenImage.getGraphics().drawRect(n4 -= 2, n5 -= 2, n2 + 7, n3 + 7);
        this.gameScreen.blitToScreen(0, 0);
    }

    public void startTimer() {
        this.timer = System.currentTimeMillis();
    }

    public void stopTimer() {
        this.timer = (System.currentTimeMillis() - this.timer) / 1000L;
        if (this.timer > 5999L) {
            this.timer = 5999L;
        }
        if ((long)this.getBestTimeOfCurrentLevel() > this.timer) {
            this.records[2 * this.getMapNum()] = (byte)(this.timer / 60L);
            this.records[2 * this.getMapNum() + 1] = (byte)(this.timer % 60L);
            this.modified = true;
            if (this.level == this.maxLevel - 1 && this.map == this.maxMap - 1) {
                if (this.maxMap < LEVELMAPCOUNT[this.level]) {
                    ++this.maxMap;
                } else if (this.maxLevel < 6) {
                    ++this.maxLevel;
                    this.maxMap = 1;
                }
            }
        }
    }

    public void startBlink() {
        this.blink = true;
        this.blinkTimer = 4;
        this.visible = true;
    }

    public void stopBlink() {
        this.blink = false;
        this.visible = true;
    }

    public String getTimeOfThisTurn() {
        int n = (int)(this.timer / 60L);
        String string = n < 10 ? "0" + String.valueOf(n) : String.valueOf(n);
        n = (int)(this.timer % 60L);
        string = n < 10 ? string + ":0" + String.valueOf(n) : string + ":" + String.valueOf(n);
        return string;
    }

    public int getReturnValue() {
        if (this.state < 40) {
            return this.getMapNum();
        }
        return this.state;
    }

    public int nextMap() {
        if (this.map < LEVELMAPCOUNT[this.level] - 1) {
            ++this.map;
        } else {
            this.map = 0;
            this.level = (this.level + 1) % 6;
        }
        return this.getMapNum();
    }

    public int getMapNum() {
        return this.computeMapNum(this.level, this.map);
    }

    public String getStringOfBestTime() {
        if (this.level >= this.maxLevel || this.level == this.maxLevel - 1 && this.map >= this.maxMap) {
            return "LOCKED";
        }
        if (this.level == this.maxLevel - 1 && this.map == this.maxMap - 1 && (this.maxLevel != 6 || this.maxMap != 10)) {
            return "NO REC";
        }
        if (this.level == 5 && this.map == 9 && this.records[78] == 0 && this.records[79] == 0) {
            return "NO REC";
        }
        int n = this.getMapNum();
        byte by = this.records[2 * n];
        String string = by < 10 ? "0" + String.valueOf(by) : String.valueOf(by);
        by = this.records[2 * n + 1];
        string = by < 10 ? string + ":0" + String.valueOf(by) : string + ":" + String.valueOf(by);
        return string;
    }

    public void run() {
        int n = 11;
        this.running = true;
        while (this.running) {
            try {
                Thread.sleep(20L);
                if (this.blink) {
                    --this.blinkTimer;
                    if (this.blinkTimer <= 0) {
                        this.visible = !this.visible;
                        this.blinkTimer = 4;
                        this.repaintFlag = true;
                    }
                }
                if (this.repaintFlag) {
                    Font font = Font.getFont((int)0, (int)0, (int)8);
                    this.gameScreen.setPixels(this.pixels, 0, 0, 96, 80);
                    this.gameScreenImage.getGraphics().setColor(0xFFFFFF);
                    if (LEVELMAPCOUNT[this.level] == 5) {
                        this.gameScreenImage.getGraphics().fillRect(35, 49, 50, 9);
                    }
                    this.gameScreenImage.getGraphics().setFont(font);
                    this.gameScreenImage.getGraphics().drawString(LEVELNAME[this.level], 36, 20, 20);
                    if (this.visible) {
                        this.gameScreenImage.getGraphics().drawString(this.getStringOfBestTime(), 48, 66, 20);
                    }
                    this.gameScreenImage.getGraphics().setColor(0);
                    n = this.level >= this.maxLevel ? 0 : (this.level == this.maxLevel - 1 ? this.maxMap : 11);
                    while (n < LEVELMAPCOUNT[this.level]) {
                        this.gameScreenImage.getGraphics().fillRect(38 + n % 5 * 10, 39 + n / 5 * 12, 5, 5);
                        ++n;
                    }
                    this.drawMapNum();
                    this.drawLevelNum();
                    this.gfxManager.paint(this.gameScreen, 0, 0);
                    this.repaintFlag = false;
                }
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.state == 0) continue;
            this.running = false;
        }
    }

    public void paint(Graphics graphics) {
        int n = 11;
        if (this.gameScreen != null && this.readyToPaint) {
            try {
                this.gameScreen.blitToScreen(0, 0);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
        if (this.state == 0) {
            if ((this.menuShow++ & 8) != 0) {
                this.menuEx.blitToScreen(80, 67);
            } else {
                graphics.setColor(255, 255, 255);
                graphics.fillRect(96, 67, 5, 8);
            }
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        this.listener = commandListener;
    }

    protected void keyPressed(int n) {
        if (n == -12) {
            this.listener.commandAction(List.SELECT_COMMAND, (Displayable)this);
            return;
        }
        if (this.repaintFlag) {
            return;
        }
        this.repaintFlag = true;
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                if (this.map > 0) {
                    --this.map;
                }
                this.stopBlink();
                break;
            }
            case 5: {
                if (this.map < LEVELMAPCOUNT[this.level] - 1) {
                    ++this.map;
                }
                this.stopBlink();
                break;
            }
            case 1: {
                if (this.level > 0) {
                    --this.level;
                }
                if (this.map >= LEVELMAPCOUNT[this.level]) {
                    this.map = LEVELMAPCOUNT[this.level] - 1;
                }
                this.stopBlink();
                break;
            }
            case 6: {
                if (this.level < 5) {
                    ++this.level;
                }
                if (this.map >= LEVELMAPCOUNT[this.level]) {
                    this.map = LEVELMAPCOUNT[this.level] - 1;
                }
                this.stopBlink();
            }
        }
    }

    private void drawLevelNum() {
        this.levelSpr.setPosition(9, 19 + this.level * 10);
        this.levelSpr.setFrame(this.level);
    }

    private void drawMapNum() {
        this.mapSpr.setPosition(37 + this.map % 5 * 10, 38 + this.map / 5 * 12);
        if (this.level >= this.maxLevel) {
            this.mapSpr.setFrame(10);
        } else if (this.level == this.maxLevel - 1 && this.map >= this.maxMap) {
            this.mapSpr.setFrame(10);
        } else {
            this.mapSpr.setFrame(this.map);
        }
    }

    private int getBestTimeOfCurrentLevel() {
        int n = this.getMapNum();
        if ((n = this.records[2 * n] * 60 + this.records[2 * n + 1]) == 0) {
            n = 6000;
        }
        return n;
    }

    private int computeMapNum(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 += LEVELMAPCOUNT[n4];
            ++n4;
        }
        return n3 += n2;
    }
}

