/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.controller.IVideoListener;
import com.jarbull.efw.controller.VideoHandler;
import com.jarbull.efw.manager.IActionListener;
import com.jarbull.efw.ui.IScreen;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class VideoScreen
implements IScreen {
    String id;
    String path;
    Canvas canvas;
    int bgColor;
    boolean playing;
    IVideoListener listener;
    IActionListener actionListener;
    boolean fullScreen;

    public VideoScreen(String id, String path, Canvas canvas) {
        this.id = id;
        this.path = path;
        this.canvas = canvas;
        this.bgColor = 0;
        this.playing = false;
        this.listener = new IVideoListener(){

            public void onVideoFinished() {
                VideoScreen.this.keyPressed(0);
            }

            public void onHandlerLoaded() {
            }
        };
        VideoHandler.getInstance().setListener(this.listener);
    }

    public IActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(IActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    public String getId() {
        return this.id;
    }

    public void paint(Graphics g) {
        block3: {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
            try {
                Class.forName("javax.microedition.media.control.VideoControl");
                if (!this.playing) {
                    this.playing = true;
                    VideoHandler.getInstance().initializeVideosOn(this.canvas);
                    VideoHandler.getInstance().play(this.path);
                    int videoX = (this.canvas.getWidth() - VideoHandler.getInstance().getVideoWidth(this.path)) / 2;
                    int videoY = (this.canvas.getHeight() - VideoHandler.getInstance().getVideoHeight(this.path)) / 2;
                    VideoHandler.getInstance().setDisplayLocation(videoX, videoY);
                    VideoHandler.getInstance().setFullScreen(this.fullScreen);
                }
            }
            catch (ClassNotFoundException ex) {
                if (this.actionListener == null) break block3;
                this.actionListener.actionPerformed();
            }
        }
    }

    public void keyPressed(int keyCode) {
        VideoHandler.getInstance().stop(this.path);
        VideoHandler.getInstance().clear();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed();
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        this.keyPressed(0);
    }
}

