/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.io.EOFException;
import java.io.UTFDataFormatException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class Utils {
    private static Class a;
    public static final Boolean FALSE;
    public static final Boolean TRUE;

    public static __Persistable checkArgumentAndCast(Persistable persistable) {
        if (persistable == null) {
            throw new IllegalArgumentException("The persistable object cannot be null!");
        }
        if (persistable instanceof __Persistable) {
            return (__Persistable)persistable;
        }
        throw new IllegalArgumentException(persistable.getClass().getName() + " is not a valid persistable class. Check the weaver execution!");
    }

    public static __Persistable createInstance(Class serializable) {
        Utils.validatePersistableClassArgument(serializable);
        try {
            return (__Persistable)serializable.newInstance();
        }
        catch (Exception exception) {
            serializable = exception;
            throw Utils.handleException(exception);
        }
    }

    public static boolean equals(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        int n2 = stringArray.length;
        if (stringArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            String string2 = stringArray2[i2];
            if (string != null ? string.equals(string2) : string2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Vector vector, Vector vector2) {
        if (vector == vector2) {
            return true;
        }
        if (vector == null || vector2 == null) {
            return false;
        }
        if (vector.size() != vector2.size()) {
            return false;
        }
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = vector.elementAt(i2);
            Object e3 = vector2.elementAt(i2);
            if (!(e2 == null ? e3 != null : !e2.equals(e3))) continue;
            return false;
        }
        return true;
    }

    public static FloggyException handleException(Exception exception) {
        if (exception instanceof FloggyException) {
            return (FloggyException)exception;
        }
        String string = exception.getMessage();
        if (string == null) {
            string = exception.getClass().getName();
        }
        return new FloggyException(string, exception);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String readUTF8(byte[] byArray) {
        int n2;
        int n3;
        int n4 = byArray[0] & 0xFF;
        int n5 = byArray[1] & 0xFF;
        if ((n4 | n5) < 0) {
            throw new EOFException();
        }
        n4 = (n4 << 8) + n5 + 2;
        byte[] byArray2 = new byte[n4];
        char[] cArray = new char[n4];
        int n6 = 0;
        for (n3 = 2; n3 < n4 && (n2 = byArray[n3] & 0xFF) <= 127; ++n3) {
            cArray[n6++] = (char)n2;
        }
        block6: while (n3 < n4) {
            n2 = byArray2[n3] & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    cArray[n6++] = (char)n2;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((n3 += 2) > n4) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray2[n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n3);
                    }
                    cArray[n6++] = (char)((n2 & 0x1F) << 6 | by & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((n3 += 3) > n4) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray2[n3 - 2];
                    byte by2 = byArray2[n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n3 - 1));
                    }
                    cArray[n6++] = (char)((n2 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + n3);
        }
        return new String(cArray, 0, n6);
    }

    public static void validatePersistableClassArgument(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The persistable class cannot be null!");
        }
        if (!a.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a valid persistable class. Check the weaver execution!");
        }
    }

    static boolean a(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == hashtable2) {
            return true;
        }
        if (hashtable == null || hashtable2 == null) {
            return false;
        }
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            Object v2 = hashtable.get(k2);
            if (!(v2 == null ? hashtable2.get(k2) != null || !hashtable2.containsKey(k2) : !v2.equals(hashtable2.get(k2)))) continue;
            return false;
        }
        return true;
    }

    static boolean a(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n2 = nArray.length;
        if (nArray2.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    static int a(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = n2 * 31 + nArray[i2];
        }
        return n2;
    }

    static int a(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            n2 = n2 * 31 + (objectArray[i2] == null ? 0 : objectArray[i2].hashCode());
        }
        return n2;
    }

    static {
        try {
            a = Class.forName("net.sourceforge.floggy.persistence.impl.__Persistable");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        FALSE = new Boolean(false);
        TRUE = new Boolean(true);
    }
}

