/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.SerializationManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;
import net.sourceforge.floggy.persistence.migration.Enumeration;
import net.sourceforge.floggy.persistence.migration.FieldPersistableInfo;

public abstract class AbstractEnumerationImpl
implements Enumeration {
    protected PersistableManager manager = PersistableManager.getInstance();
    protected PersistableMetadata classBasedMetadata;
    protected PersistableMetadata rmsBasedMetadata;
    protected RecordEnumeration enumeration;
    protected RecordStore recordStore;
    protected boolean iterationMode;
    protected boolean lazy;
    protected int recordId = -1;

    protected AbstractEnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) {
        this.rmsBasedMetadata = persistableMetadata;
        this.classBasedMetadata = persistableMetadata2;
        this.enumeration = recordEnumeration;
        this.recordStore = recordStore;
        this.lazy = bl;
        this.iterationMode = bl2;
    }

    public int delete() {
        if (this.recordId != -1) {
            try {
                this.recordStore.deleteRecord(this.recordId);
                int n2 = this.recordId;
                this.recordId = -1;
                return n2;
            }
            catch (RecordStoreException recordStoreException) {
                RecordStoreException recordStoreException2 = recordStoreException;
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to delete. You have to iterate over the enumeration before call delete.");
    }

    public int getSize() {
        return this.enumeration.numRecords();
    }

    public boolean hasMoreElements() {
        return this.enumeration.hasNextElement();
    }

    public Hashtable nextElement() {
        if (this.recordId != -1 && !this.iterationMode) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            this.recordId = this.enumeration.nextRecordId();
            byte[] byArray = this.recordStore.getRecord(this.recordId);
            this.buildPersistable(this.rmsBasedMetadata, byArray, hashtableValueNullable);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
        return hashtableValueNullable;
    }

    public int update(Persistable persistable) {
        if (this.recordId != -1) {
            persistable = Utils.checkArgumentAndCast(persistable);
            persistable.__setId(this.recordId);
            int n2 = this.manager.save(persistable);
            this.recordId = -1;
            return n2;
        }
        throw new FloggyException("There isn't a register to update. You have to iterate over the enumeration before call update.");
    }

    protected abstract void buildPersistable(PersistableMetadata var1, byte[] var2, Hashtable var3);

    protected Object[] createArray(int n2, int n3) {
        switch (n2) {
            case 1: {
                return new Boolean[n3];
            }
            case 2: {
                return new Byte[n3];
            }
            case 4: {
                return new Calendar[n3];
            }
            case 8: {
                return new Character[n3];
            }
            case 16: {
                return new Date[n3];
            }
            case 32: {
                return new Double[n3];
            }
            case 64: {
                return new Float[n3];
            }
            case 128: {
                return new Hashtable[n3];
            }
            case 256: {
                return new Integer[n3];
            }
            case 512: {
                return new Long[n3];
            }
            case 1024: {
                return new FieldPersistableInfo[n3];
            }
            case 2048: {
                return new Short[n3];
            }
            case 4096: {
                return new Stack[n3];
            }
            case 8192: {
                return new String[n3];
            }
            case 16384: {
                return new StringBuffer[n3];
            }
            case 32768: {
                return new TimeZone[n3];
            }
            case 65536: {
                return new Vector[n3];
            }
        }
        throw new FloggyException("Type Unknow: " + n2);
    }

    protected Object readArray(int n2, String string, DataInputStream dataInputStream) {
        Object[] objectArray = null;
        if (dataInputStream.readByte() == 0) {
            int n3 = dataInputStream.readInt();
            if ((n2 & 0x40000) == 262144) {
                switch (n2 &= 0xFFFBFFFF) {
                    case 1: {
                        objectArray = this.readBooleanArray(n3, dataInputStream);
                        break;
                    }
                    case 2: {
                        objectArray = this.readByteArray(n3, dataInputStream);
                        break;
                    }
                    case 8: {
                        objectArray = this.readCharArray(n3, dataInputStream);
                        break;
                    }
                    case 32: {
                        objectArray = this.readDoubleArray(n3, dataInputStream);
                        break;
                    }
                    case 64: {
                        objectArray = this.readFloatArray(n3, dataInputStream);
                        break;
                    }
                    case 256: {
                        objectArray = this.readIntArray(n3, dataInputStream);
                        break;
                    }
                    case 512: {
                        objectArray = this.readLongArray(n3, dataInputStream);
                        break;
                    }
                    case 2048: {
                        objectArray = this.readShortArray(n3, dataInputStream);
                    }
                }
            } else {
                objectArray = this.createArray(n2, n3);
                for (int i2 = 0; i2 < n3; ++i2) {
                    objectArray[i2] = this.readObject(n2, string, dataInputStream);
                }
            }
        }
        return objectArray;
    }

    protected boolean[] readBooleanArray(int n2, DataInputStream dataInputStream) {
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            blArray[i2] = dataInputStream.readBoolean();
        }
        return blArray;
    }

    protected byte[] readByteArray(int n2, DataInputStream dataInputStream) {
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = dataInputStream.readByte();
        }
        return byArray;
    }

    protected char[] readCharArray(int n2, DataInputStream dataInputStream) {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = dataInputStream.readChar();
        }
        return cArray;
    }

    protected double[] readDoubleArray(int n2, DataInputStream dataInputStream) {
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = dataInputStream.readDouble();
        }
        return dArray;
    }

    protected float[] readFloatArray(int n2, DataInputStream dataInputStream) {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = dataInputStream.readFloat();
        }
        return fArray;
    }

    protected int[] readIntArray(int n2, DataInputStream dataInputStream) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = dataInputStream.readInt();
        }
        return nArray;
    }

    protected long[] readLongArray(int n2, DataInputStream dataInputStream) {
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = dataInputStream.readLong();
        }
        return lArray;
    }

    protected Object readObject(int n2, String string, DataInputStream dataInputStream) {
        switch (n2) {
            case 1: {
                return SerializationManager.readBoolean(dataInputStream);
            }
            case 2: {
                return SerializationManager.readByte(dataInputStream);
            }
            case 4: {
                return SerializationManager.readCalendar(dataInputStream);
            }
            case 8: {
                return SerializationManager.readChar(dataInputStream);
            }
            case 16: {
                return SerializationManager.readDate(dataInputStream);
            }
            case 32: {
                return SerializationManager.readDouble(dataInputStream);
            }
            case 64: {
                return SerializationManager.readFloat(dataInputStream);
            }
            case 128: {
                return SerializationManager.readHashtable(dataInputStream);
            }
            case 256: {
                return SerializationManager.readInt(dataInputStream);
            }
            case 512: {
                return SerializationManager.readLong(dataInputStream);
            }
            case 1024: {
                FieldPersistableInfo fieldPersistableInfo = null;
                string = this.rmsBasedMetadata.getPersistableImplementationClassForField(string);
                switch (dataInputStream.readByte()) {
                    case -1: {
                        string = dataInputStream.readUTF();
                    }
                    case 0: {
                        int n3 = dataInputStream.readInt();
                        fieldPersistableInfo = new FieldPersistableInfo(n3, string);
                    }
                }
                return fieldPersistableInfo;
            }
            case 2048: {
                return SerializationManager.readShort(dataInputStream);
            }
            case 4096: {
                return SerializationManager.readStack(dataInputStream, this.lazy);
            }
            case 8192: {
                return SerializationManager.readString(dataInputStream);
            }
            case 16384: {
                return SerializationManager.readStringBuffer(dataInputStream);
            }
            case 32768: {
                return SerializationManager.readTimeZone(dataInputStream);
            }
            case 65536: {
                return SerializationManager.readVector(dataInputStream, this.lazy);
            }
        }
        throw new FloggyException("Type Unknow: " + n2);
    }

    protected Object readPrimitive(int n2, DataInputStream dataInputStream) {
        switch (n2) {
            case 1: {
                if (dataInputStream.readBoolean()) {
                    return Utils.TRUE;
                }
                return Utils.FALSE;
            }
            case 2: {
                return new Byte(dataInputStream.readByte());
            }
            case 8: {
                return new Character(dataInputStream.readChar());
            }
            case 32: {
                return new Double(dataInputStream.readDouble());
            }
            case 64: {
                return new Float(dataInputStream.readFloat());
            }
            case 256: {
                return new Integer(dataInputStream.readInt());
            }
            case 512: {
                return new Long(dataInputStream.readLong());
            }
            case 2048: {
                return new Short(dataInputStream.readShort());
            }
        }
        throw new FloggyException("Type Unknow: " + n2);
    }

    protected short[] readShortArray(int n2, DataInputStream dataInputStream) {
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray[i2] = dataInputStream.readShort();
        }
        return sArray;
    }

    void a() {
        if (!this.enumeration.hasNextElement()) {
            this.enumeration.destroy();
            RecordStoreManager.closeRecordStore(this.recordStore);
            if (this.rmsBasedMetadata != this.classBasedMetadata) {
                try {
                    this.classBasedMetadata.setRecordId(this.rmsBasedMetadata.getRecordId());
                    this.classBasedMetadata.setRecordStoreVersion(PersistableMetadataManager.getBytecodeVersion());
                    PersistableMetadataManager.saveRMSStructure(this.classBasedMetadata);
                    return;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    throw Utils.handleException(exception);
                }
            }
        } else {
            throw new FloggyException("The enumeration must be whole processed before finish the process!");
        }
    }
}

