/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.controller.Animation;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.ISprite;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.util.ColorEx;
import com.jarbull.efw.util.FP;
import com.jarbull.efw.util.ImageEx;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class AnimationHolder {
    private static final AnimationHolder a = new AnimationHolder();
    private Hashtable b = new Hashtable();
    private Hashtable c = new Hashtable();
    private int d = 1;
    private int e = 0;
    private boolean f = true;

    public static AnimationHolder getInstance() {
        return a;
    }

    private AnimationHolder() {
    }

    public boolean isEnabled() {
        return this.f;
    }

    public void setEnabled(boolean bl) {
        this.f = bl;
    }

    public int getLastWorldTime() {
        return this.e;
    }

    public int getWorldTimeLimit() {
        return this.d;
    }

    public void setWorldTimeLimit(int n2) {
        this.d = n2;
    }

    public void addAnimation(Animation animation) {
        this.b.put(animation.a, animation);
    }

    public void removeAnimation(String string) {
        this.b.remove(string);
    }

    public int getSize() {
        return this.b.size();
    }

    public Animation getAnimation(String string) {
        return (Animation)this.b.get(string);
    }

    public void suspendAnimations() {
        this.f = false;
        Enumeration enumeration = this.b.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.c.put(string, this.b.get(string));
        }
        this.b.clear();
    }

    public void restoreSuspended() {
        Enumeration enumeration = this.c.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.b.put(string, this.c.get(string));
        }
        this.c.clear();
        this.f = true;
    }

    public void removeAllAnimations() {
        this.b.clear();
    }

    public Animation[] getAllAnimations() {
        Animation[] animationArray = new Animation[this.b.size()];
        Enumeration enumeration = this.b.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            animationArray[n2++] = (Animation)enumeration.nextElement();
        }
        return animationArray;
    }

    public Animation[] getAnimations(Graphics graphics) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!graphics.equals(objectArray.i)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new Animation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Animation[] getAnimations(ISprite iSprite) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!iSprite.equals(objectArray.h)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new Animation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Animation[] getAnimations(Component component) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!component.equals(objectArray.j)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new Animation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void animate(int n2) {
        if (!this.f) {
            return;
        }
        if (n2 > this.d) {
            n2 %= this.d;
        }
        Enumeration enumeration = this.b.elements();
        while (enumeration.hasMoreElements()) {
            Animation animation = (Animation)enumeration.nextElement();
            if (!animation.b) continue;
            int n3 = n2 - animation.e;
            int n4 = animation.f - animation.e;
            if (animation.c == 1) {
                if (n3 <= 0) continue;
                n3 %= n4 + animation.g;
            }
            if (this.e <= animation.f && n2 >= animation.f) {
                animation.onAnimationFinished();
                n3 = n4 - 1;
            } else if (n3 < 0) continue;
            switch (animation.getType()) {
                case 0: {
                    ISprite iSprite = animation.h;
                    iSprite.setFrameSequence(animation.k);
                    int n5 = n3 * iSprite.getFrameSequenceLength() / n4;
                    iSprite.setFrame(n5);
                    break;
                }
                case 1: {
                    int n6 = animation.d[0];
                    int n5 = animation.d[1];
                    int n7 = animation.d[2];
                    int n8 = animation.d[3];
                    int n9 = n3 * (n7 - n6) / n4 + n6;
                    int n10 = n3 * (n8 - n5) / n4 + n5;
                    if (animation.h != null) {
                        animation.h.setPosition(n9, n10);
                        break;
                    }
                    animation.j.setPosition(n9, n10);
                    break;
                }
                case 2: {
                    int n11 = animation.d[0];
                    int n5 = animation.d[1];
                    int n7 = FP.intToFP(animation.d[2]);
                    int n8 = FP.intToFP(animation.d[3]);
                    int n9 = FP.toRadians(FP.intToFP(animation.d[4]));
                    int n10 = animation.d[5];
                    int n12 = animation.d[6];
                    int n13 = FP.toRadians(FP.Div(FP.intToFP(n3 * (n5 - n11)), FP.intToFP(n4 + n11)));
                    n11 = FP.toInt(n7 + FP.Mul(FP.Mul(n10, FP.Cos(n13)), FP.Cos(n9)) - FP.Mul(FP.Mul(n12, FP.Sin(n13)), FP.Sin(n9)));
                    n5 = FP.toInt(n8 - FP.Mul(FP.Mul(n10, FP.Cos(n13)), FP.Sin(n9)) - FP.Mul(FP.Mul(n12, FP.Sin(n13)), FP.Cos(n9)));
                    if (animation.h != null) {
                        animation.h.setPosition(n11, n5);
                        break;
                    }
                    animation.j.setPosition(n11, n5);
                    break;
                }
                case 3: {
                    int n14 = animation.d[0];
                    int n5 = animation.d[1];
                    int n7 = n3 * (n5 - n14) / n4 + n14;
                    ImageHandler.getInstance().a(animation.h.getImageId(), ImageEx.setImageAlpha(animation.l, n7));
                    break;
                }
                case 4: {
                    int n15 = animation.d[0];
                    int n5 = animation.d[1];
                    int n7 = n3 * (n5 - n15) / n4 + n15;
                    ImageHandler.getInstance().a(animation.h.getImageId(), ImageEx.rotateImage(ImageHandler.getInstance().getImage(animation.l), n7));
                    break;
                }
                case 5: {
                    int n16 = animation.d[0];
                    int n5 = animation.d[1];
                    animation.i.setColor(ColorEx.getMidColor(n16, n5, n4 * (n4 - n3 - 1) / (n4 - 1), n4));
                    break;
                }
                case 6: {
                    int n8;
                    int n7;
                    int n17 = animation.d[0];
                    int n5 = animation.d[1];
                    if (animation.h != null) {
                        n7 = (n3 * n17 << 1) / n4 + animation.h.getX() - n17;
                        n8 = (n3 * n5 << 1) / n4 + animation.h.getY() - n5;
                        animation.h.setPosition(n7, n8);
                        break;
                    }
                    n7 = (n3 * n17 << 1) / n4 + animation.j.getX() - n17;
                    n8 = (n3 * n5 << 1) / n4 + animation.j.getY() - n5;
                    animation.j.setPosition(n7, n8);
                    break;
                }
                case 7: {
                    int n18 = animation.d[0];
                    int n5 = animation.d[1];
                    int n7 = animation.d[2];
                    int n8 = animation.d[3];
                    int n9 = n3 * (n7 - n18) / n4 + n18;
                    int n10 = n3 * (n8 - n5) / n4 + n5;
                    ImageHandler.getInstance().a(animation.h.getImageId(), ImageEx.resizeImage(ImageHandler.getInstance().getImage(animation.l), n9, n10, true));
                    animation.h.setImage(animation.h.getImageId(), ImageHandler.getInstance().getImage(animation.h.getImageId()).getWidth(), ImageHandler.getInstance().getImage(animation.h.getImageId()).getHeight());
                    break;
                }
                case 8: {
                    int n19 = animation.d[0];
                    int n5 = animation.d[1];
                    int n7 = animation.d[2];
                    int n8 = animation.d[3];
                    int n9 = animation.d[4];
                    int n10 = animation.d[5];
                    int n12 = animation.d[6];
                    int n13 = animation.d[7];
                    n19 = n3 * (n9 - n19) / n4 + n19;
                    n5 = n3 * (n10 - n5) / n4 + n5;
                    n7 = n3 * (n12 - n7) / n4 + n7;
                    n3 = n3 * (n13 - n8) / n4 + n8;
                    animation.i.setClip(n19, n5, n7, n3);
                    break;
                }
                case 9: {
                    boolean bl;
                    boolean bl2 = bl = animation.d[0] != 0;
                    if (n3 > n4) {
                        boolean bl3 = bl = !bl;
                    }
                    if (animation.h != null) {
                        animation.h.setVisible(bl);
                        break;
                    }
                    animation.j.setVisible(bl);
                }
            }
        }
        this.e = n2;
    }
}

