/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ParticleGenerator {
    Vector particles;
    int pID = 0;
    float startX;
    float startY;
    float endX;
    float endY;
    static int totalParticleStep = 20;
    int particleStep = 0;
    float stepSizeX;
    float stepSizeY;
    Random rnd;
    Image[] blood;
    static int BLOOD_IMAGES = 4;
    float maximumVelocity = 0.0f;
    int totalParticles = 200;

    ParticleGenerator(int id, int _startX, int _startY, int _endX, int _endY) {
        try {
            this.blood = new Image[BLOOD_IMAGES];
            switch (id) {
                case 1: {
                    int i;
                    for (i = 0; i < BLOOD_IMAGES; ++i) {
                        if (this.blood[i] != null) continue;
                        this.blood[i] = Image.createImage((String)("/c_red_0" + (i + 1) + ".png"));
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < BLOOD_IMAGES; ++i) {
                        if (this.blood[i] != null) continue;
                        this.blood[i] = Image.createImage((String)("/c_orange_0" + (i + 1) + ".png"));
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < BLOOD_IMAGES; ++i) {
                        if (this.blood[i] != null) continue;
                        this.blood[i] = Image.createImage((String)("/c_yellow_0" + (i + 1) + ".png"));
                    }
                    break;
                }
                case 4: {
                    int i;
                    for (i = 0; i < BLOOD_IMAGES; ++i) {
                        if (this.blood[i] != null) continue;
                        this.blood[i] = Image.createImage((String)("/c_pink_0" + (i + 1) + ".png"));
                    }
                    break;
                }
                case 5: {
                    int i;
                    for (i = 0; i < BLOOD_IMAGES; ++i) {
                        if (this.blood[i] != null) continue;
                        this.blood[i] = Image.createImage((String)("/c_blue_0" + (i + 1) + ".png"));
                    }
                    break;
                }
                case 6: {
                    int i;
                    for (i = 0; i < BLOOD_IMAGES; ++i) {
                        if (this.blood[i] != null) continue;
                        this.blood[i] = Image.createImage((String)("/c_green_0" + (i + 1) + ".png"));
                    }
                    break;
                }
                case 7: {
                    int i;
                    for (i = 0; i < BLOOD_IMAGES; ++i) {
                        if (this.blood[i] != null) continue;
                        this.blood[i] = Image.createImage((String)("/c_p_blue_0" + (i + 1) + ".png"));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.rnd = new Random();
        this.particles = new Vector();
        this.startX = _startX;
        this.startY = _startY;
        this.endX = _endX;
        this.endY = _endY;
        this.stepSizeX = (this.startX - this.endX) / (float)this.totalParticles;
        this.stepSizeY = (this.startY - this.endY) / (float)this.totalParticles;
        for (int i = 0; i < this.totalParticles; ++i) {
            int rX = this.rnd.nextInt(2);
            int rY = this.rnd.nextInt(2);
            rX = rX == 0 ? -1 : 1;
            rY = rY == 0 ? -1 : 1;
            float x = this.startX + (float)i * this.stepSizeX + (float)rX * this.rnd.nextFloat() * 5.0f;
            float y = this.startY + (float)i * this.stepSizeY + (float)rY * this.rnd.nextFloat() * 5.0f;
            int blood = BLOOD_IMAGES - BLOOD_IMAGES * i / this.totalParticles - 1;
            Particle p = new Particle(this.startX, this.startY, x, y, this.pID, blood);
            this.particles.addElement(p);
            ++this.pID;
        }
    }

    float abs(float n) {
        if (n < 0.0f) {
            return n * -1.0f;
        }
        return n;
    }

    void nextStep() {
        ++this.particleStep;
        for (int i = this.particles.size() - 1; i >= 0; --i) {
            Particle p = (Particle)this.particles.elementAt(i);
            if (p.exist(this.particleStep)) continue;
            this.particles.removeElementAt(i);
        }
    }

    void paint(Graphics g) {
        if (this.particleStep < totalParticleStep) {
            for (int i = this.particles.size() - 1; i >= 0; --i) {
                Particle p = (Particle)this.particles.elementAt(i);
                if (this.blood[p.bloodID] == null) continue;
                g.drawImage(this.blood[p.bloodID], (int)p.location.x, (int)p.location.y, 0);
            }
        }
    }
}

