/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import sk.inlogic.Game;
import sk.inlogic.util.RandomNum;

public class Block {
    public static int[] blocks = new int[64];

    public static void reset() {
        for (int i = 0; i < 64; ++i) {
            Block.blocks[i] = 0;
        }
    }

    public static void destroy(int pos) {
        if (blocks[pos] > 0) {
            int n = pos;
            blocks[n] = blocks[n] - 1;
            Game.blockChecker = true;
        } else {
            Game.blockChecker = false;
        }
    }

    public static int count() {
        int ret = 0;
        for (int pos = 0; pos < 64; ++pos) {
            if (blocks[pos] <= 0) continue;
            ++ret;
        }
        return ret;
    }

    public static int getValue(int pos) {
        return blocks[pos];
    }

    public static void setValue(int pos, int value) {
        Block.blocks[pos] = value;
    }

    public static void createBlockShape(int gameLevel) {
        switch (gameLevel) {
            case 1: {
                Block.createBlockSquare(2, 1);
                Block.createBlockFourCorners(3, 2);
                break;
            }
            case 2: {
                Block.createBlockVline(2, 1);
                Block.createBlockSquare(3, 3);
                break;
            }
            case 3: {
                Block.createBlockCircle(2, 2);
                Block.createBlockSquare(3, 1);
                break;
            }
            case 4: {
                Block.createBlockVline(3, 2);
                Block.createBlockHline(3, 2);
                break;
            }
            case 5: {
                Block.createBlockSquare(1, 1);
                Block.createBlockSquare(2, 2);
                Block.createBlockSquare(3, 3);
                break;
            }
            case 6: {
                Block.createBlockHline(2, 1);
                Block.createBlockFourCorners(2, 3);
                break;
            }
            case 7: {
                Block.createBlockCircle(2, 1);
                Block.createBlockFourCorners(1, 3);
                break;
            }
            case 8: {
                Block.createBlockHline(1, 2);
                Block.createBlockSquare(2, 1);
                break;
            }
            case 9: {
                Block.createBlockFillSquare(1, 2);
                Block.createBlockFourCorners(1, 3);
                break;
            }
            case 10: {
                Block.createBlockSquare(2, 1);
                Block.createBlockFourCorners(1, 2);
                Block.createBlockFourCorners(1, 3);
                Block.createBlockFourCorners(1, 4);
                break;
            }
            case 11: {
                Block.createBlockCircle(1, 2);
                Block.createBlockVline(1, 1);
                Block.createBlockHline(1, 1);
                break;
            }
            case 12: {
                Block.createBlockSquare(2, 3);
                Block.createBlockFourCorners(2, 4);
                break;
            }
            case 13: {
                Block.createBlockFillSquare(1, 3);
                break;
            }
            case 14: {
                Block.createBlockVline(2, 4);
                Block.createBlockSquare(2, 2);
                break;
            }
            case 15: {
                Block.createBlockCircle(2, 1);
                Block.createBlockSquare(1, 4);
                break;
            }
            case 16: {
                Block.createBlockFillSquare(3, 2);
                Block.createBlockFourCorners(2, 4);
                break;
            }
            case 17: {
                Block.createBlockCircle(3, 2);
                break;
            }
            default: {
                Block.createDefaultBlock();
            }
        }
    }

    private static void createDefaultBlock() {
        int p1 = RandomNum.getRandomUInt(5);
        if (p1 < 2) {
            Block.createRandomShape();
        }
        if (p1 < 4) {
            Block.createRandomShape();
            Block.createRandomShape();
        } else {
            Block.createRandomShape();
            Block.createRandomShape();
            Block.createRandomShape();
        }
    }

    private static void createRandomShape() {
        int level = RandomNum.getRandomUInt(3) + 1;
        int shape = RandomNum.getRandomUInt(6);
        if (shape == 0) {
            int size = RandomNum.getRandomUInt(2) + 1;
            Block.createBlockCircle(level, size);
        } else {
            int size = RandomNum.getRandomUInt(4) + 1;
            if (shape == 1) {
                Block.createBlockHline(level, size);
            } else if (shape == 2) {
                Block.createBlockVline(level, size);
            } else if (shape == 3) {
                Block.createBlockSquare(level, size);
            } else if (shape == 4) {
                Block.createBlockFillSquare(level, size);
            } else if (shape == 5) {
                Block.createBlockFourCorners(level, size);
            }
        }
    }

    private static void createBlockCircle(int level, int size) {
        if (size == 1) {
            Block.blocks[19] = level;
            Block.blocks[20] = level;
            Block.blocks[26] = level;
            Block.blocks[29] = level;
            Block.blocks[34] = level;
            Block.blocks[37] = level;
            Block.blocks[43] = level;
            Block.blocks[44] = level;
        } else if (size == 2) {
            Block.blocks[3] = level;
            Block.blocks[4] = level;
            Block.blocks[9] = level;
            Block.blocks[10] = level;
            Block.blocks[13] = level;
            Block.blocks[14] = level;
            Block.blocks[17] = level;
            Block.blocks[22] = level;
            Block.blocks[24] = level;
            Block.blocks[31] = level;
            Block.blocks[32] = level;
            Block.blocks[39] = level;
            Block.blocks[41] = level;
            Block.blocks[46] = level;
            Block.blocks[49] = level;
            Block.blocks[50] = level;
            Block.blocks[53] = level;
            Block.blocks[54] = level;
            Block.blocks[59] = level;
            Block.blocks[60] = level;
        }
    }

    private static void createBlockHline(int level, int size) {
        block8: {
            int i;
            block10: {
                int i2;
                block9: {
                    int i3;
                    block7: {
                        if (size != 1) break block7;
                        for (int i4 = 24; i4 < 40; ++i4) {
                            Block.blocks[i4] = level;
                        }
                        break block8;
                    }
                    if (size != 2) break block9;
                    for (i3 = 16; i3 < 24; ++i3) {
                        Block.blocks[i3] = level;
                    }
                    for (i3 = 40; i3 < 48; ++i3) {
                        Block.blocks[i3] = level;
                    }
                    break block8;
                }
                if (size != 3) break block10;
                for (i2 = 8; i2 < 16; ++i2) {
                    Block.blocks[i2] = level;
                }
                for (i2 = 48; i2 < 56; ++i2) {
                    Block.blocks[i2] = level;
                }
                break block8;
            }
            if (size != 4) break block8;
            for (i = 0; i < 8; ++i) {
                Block.blocks[i] = level;
            }
            for (i = 56; i < 64; ++i) {
                Block.blocks[i] = level;
            }
        }
    }

    private static void createBlockVline(int level, int size) {
        block9: {
            int i;
            block11: {
                int i2;
                block10: {
                    int i3;
                    block8: {
                        int i4;
                        if (size != 1) break block8;
                        for (i4 = 3; i4 < 60; i4 += 8) {
                            Block.blocks[i4] = level;
                        }
                        for (i4 = 4; i4 < 61; i4 += 8) {
                            Block.blocks[i4] = level;
                        }
                        break block9;
                    }
                    if (size != 2) break block10;
                    for (i3 = 2; i3 < 59; i3 += 8) {
                        Block.blocks[i3] = level;
                    }
                    for (i3 = 5; i3 < 62; i3 += 8) {
                        Block.blocks[i3] = level;
                    }
                    break block9;
                }
                if (size != 3) break block11;
                for (i2 = 1; i2 < 58; i2 += 8) {
                    Block.blocks[i2] = level;
                }
                for (i2 = 6; i2 < 63; i2 += 8) {
                    Block.blocks[i2] = level;
                }
                break block9;
            }
            if (size != 4) break block9;
            for (i = 0; i < 57; i += 8) {
                Block.blocks[i] = level;
            }
            for (i = 7; i < 64; i += 8) {
                Block.blocks[i] = level;
            }
        }
    }

    private static void createBlockFillSquare(int level, int size) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (size != 1) break block6;
                        Block.blocks[27] = level;
                        Block.blocks[28] = level;
                        Block.blocks[35] = level;
                        Block.blocks[36] = level;
                        break block7;
                    }
                    if (size != 2) break block8;
                    for (int j = 18; j < 50; j += 8) {
                        for (int i = 0; i < 4; ++i) {
                            Block.blocks[j + i] = level;
                        }
                    }
                    break block7;
                }
                if (size != 3) break block9;
                for (int j = 9; j < 57; j += 8) {
                    for (int i = 0; i < 6; ++i) {
                        Block.blocks[j + i] = level;
                    }
                }
                break block7;
            }
            if (size != 3) break block7;
            for (int j = 0; j < 64; j += 8) {
                for (int i = 0; i < 8; ++i) {
                    Block.blocks[j + i] = level;
                }
            }
        }
    }

    private static void createBlockFourCorners(int level, int size) {
        if (size == 1) {
            Block.blocks[27] = level;
            Block.blocks[28] = level;
            Block.blocks[35] = level;
            Block.blocks[36] = level;
        } else if (size == 2) {
            Block.blocks[18] = level;
            Block.blocks[21] = level;
            Block.blocks[42] = level;
            Block.blocks[45] = level;
        } else if (size == 3) {
            Block.blocks[9] = level;
            Block.blocks[14] = level;
            Block.blocks[49] = level;
            Block.blocks[54] = level;
        } else if (size == 4) {
            Block.blocks[0] = level;
            Block.blocks[7] = level;
            Block.blocks[56] = level;
            Block.blocks[63] = level;
        }
    }

    private static void createBlockSquare(int level, int size) {
        block11: {
            int i;
            block13: {
                int i2;
                block12: {
                    int i3;
                    block10: {
                        if (size != 1) break block10;
                        Block.blocks[27] = level;
                        Block.blocks[28] = level;
                        Block.blocks[35] = level;
                        Block.blocks[36] = level;
                        break block11;
                    }
                    if (size != 2) break block12;
                    for (i3 = 18; i3 < 22; ++i3) {
                        Block.blocks[i3] = level;
                    }
                    Block.blocks[26] = level;
                    Block.blocks[29] = level;
                    Block.blocks[34] = level;
                    Block.blocks[37] = level;
                    for (i3 = 42; i3 < 46; ++i3) {
                        Block.blocks[i3] = level;
                    }
                    break block11;
                }
                if (size != 3) break block13;
                for (i2 = 9; i2 < 15; ++i2) {
                    Block.blocks[i2] = level;
                }
                for (i2 = 49; i2 < 55; ++i2) {
                    Block.blocks[i2] = level;
                }
                for (i2 = 17; i2 < 49; i2 += 8) {
                    Block.blocks[i2] = level;
                }
                for (i2 = 22; i2 < 54; i2 += 8) {
                    Block.blocks[i2] = level;
                }
                break block11;
            }
            if (size != 4) break block11;
            for (i = 0; i < 8; ++i) {
                Block.blocks[i] = level;
            }
            for (i = 56; i < 64; ++i) {
                Block.blocks[i] = level;
            }
            for (i = 8; i < 56; i += 8) {
                Block.blocks[i] = level;
            }
            for (i = 15; i < 63; i += 8) {
                Block.blocks[i] = level;
            }
        }
    }
}

