/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Music
implements Runnable {
    private Player musicPlayer;
    private Hashtable musicResources = new Hashtable(3);
    private Hashtable soundPlayers = new Hashtable(10);
    private int volume;
    public static String VOLUME_CONTROL = "VolumeControl";
    public static String TYPE_MIDI = "audio/midi";

    public Music(int volume) {
        this.volume = volume;
    }

    public void run() {
    }

    public int getVolume() {
        return this.volume;
    }

    public void changeVolume(int quantity) {
        this.setVolume(this.volume + quantity);
    }

    public boolean setVolume(int volume) {
        boolean restartMusic;
        boolean bl = restartMusic = this.volume == 0 && volume > 0;
        this.volume = volume > 100 ? 100 : (volume <= 0 ? 0 : volume);
        try {
            if (this.volume > 0) {
                if (this.musicPlayer != null) {
                    VolumeControl vc = (VolumeControl)this.musicPlayer.getControl(VOLUME_CONTROL);
                    vc.setLevel(this.volume);
                    if (restartMusic) {
                        this.musicPlayer.stop();
                        this.musicPlayer.start();
                        restartMusic = false;
                    }
                }
                Enumeration players = this.soundPlayers.elements();
                while (players.hasMoreElements()) {
                    Player player = (Player)players.nextElement();
                    if (player.getState() != 400) continue;
                    VolumeControl vc = (VolumeControl)player.getControl(VOLUME_CONTROL);
                    vc.setLevel(this.volume);
                }
            } else {
                this.stopAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return restartMusic;
    }

    public void addMusic(String musicKey, String resource) {
        this.musicResources.put(musicKey, resource);
    }

    public void removeMusic(String musickey) {
        this.musicResources.remove(musickey);
    }

    public void stopMusic() {
        try {
            this.musicPlayer.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        this.musicPlayer = null;
    }

    public void addSound(String soundKey, String resource) {
        try {
            Player soundPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(resource), (String)TYPE_MIDI);
            soundPlayer.prefetch();
            VolumeControl volumeControl = (VolumeControl)soundPlayer.getControl(VOLUME_CONTROL);
            volumeControl.setLevel(this.volume);
            this.soundPlayers.put(soundKey, soundPlayer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeSound(String soundKey) {
        this.soundPlayers.remove(soundKey);
    }

    public void playMusic(String musicKey) {
        try {
            if (this.volume <= 0) {
                if (this.musicPlayer != null) {
                    this.musicPlayer.stop();
                }
                return;
            }
            this.musicPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream((String)this.musicResources.get(musicKey)), (String)TYPE_MIDI);
            this.musicPlayer.prefetch();
            VolumeControl volumeControl = (VolumeControl)this.musicPlayer.getControl(VOLUME_CONTROL);
            volumeControl.setLevel(this.volume);
            this.musicPlayer.setLoopCount(-1);
            this.musicPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopMusic(String musicKey) {
    }

    public void playSound(String soundKey) {
        if (this.volume <= 0) {
            return;
        }
        Player player = (Player)this.soundPlayers.get(soundKey);
        try {
            if (player.getState() == 400) {
                player.stop();
            }
            player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAll() {
        try {
            if (this.musicPlayer != null && this.musicPlayer.getState() == 400) {
                this.musicPlayer.stop();
            }
            Enumeration players = this.soundPlayers.elements();
            while (players.hasMoreElements()) {
                ((Player)players.nextElement()).stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        if (this.musicPlayer != null) {
            this.musicPlayer.close();
        }
        Enumeration players = this.soundPlayers.elements();
        while (players.hasMoreElements()) {
            ((Player)players.nextElement()).close();
        }
    }
}

