/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame;

import com.pipogame.Game;
import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Music;
import com.pipogame.Store;
import com.pipogame.components.Point;
import com.pipogame.components.Rect;
import com.pipogame.util.Drawer;
import com.pipogame.util.Queue;
import com.pipogame.util.TimeProcessMeasurer;
import com.pipogame.util.Util;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class ScreenManager
extends GameCanvas
implements Runnable {
    public final Store store;
    public final Music music;
    private boolean appRunning;
    private final Game game;
    private final Queue screens = new Queue(10);
    private int frameTime = 33;
    private int fixFrameTime = 33;
    private boolean runAtFixedRate = true;
    private int timeCounterToCancelInput;
    private final int timeCancelInputOfEachScreen;
    private boolean gamePaused = false;
    private boolean isSuppressDraw = false;
    private boolean reUpdate = false;
    private Input input;
    public static final Random RANDOM = new Random();
    private Thread gameThread;
    public static final byte SCR_320_320 = 1;
    public static final byte SCR_320_240 = 2;
    public static final byte SCR_240_320 = 3;
    public static final byte SCR_172_200 = 4;
    public static final byte SCR_128_160 = 5;
    public final byte screenType;
    private Graphics g;
    public final boolean handleSoftkeyByTouch;
    private Rect softLeftRect;
    private Rect softRightRect;
    private Point translatePoint;
    private Image softKeyPlaceImage;
    public boolean drawSoftkeyPlace;
    static String VOLUME_KEY = "&#vLmE;+";
    private final String unkErr;
    private final String hc;
    private TimeProcessMeasurer ggg;
    private long counttimeff = 3000L;
    public static final int TIME_SIZE_UPDATE = 3000;
    private String freeSize;
    private String totalsize;
    private String screenName;
    public boolean sizeEnabel;
    public boolean frameEnable;
    int frameRate;

    public ScreenManager(Game game, String gameName) {
        super(false);
        this.timeCancelInputOfEachScreen = 300;
        this.unkErr = "L\u1ed7i kh\u00f4ng x\u00e1c \u0111\u1ecbnh";
        this.hc = ": ";
        this.game = game;
        this.store = new Store(gameName, 1);
        this.music = this.store.contains(VOLUME_KEY) ? new Music(this.store.getInt(VOLUME_KEY)) : new Music(50);
        this.setFullScreenMode(true);
        this.screenType = this.getScreenType(super.getWidth(), super.getHeight());
        this.g = super.getGraphics();
        this.g.setColor(0);
        this.g.fillRect(0, 0, super.getWidth(), super.getHeight());
        this.handleSoftkeyByTouch = this.hasPointerEvents();
        if (this.handleSoftkeyByTouch) {
            try {
                this.softKeyPlaceImage = Image.createImage((String)"/com/pipogame/pt.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startUp() {
        this.redefineScreenSize(this.screenType);
        this.translatePoint = new Point((super.getWidth() - GameScreen._width) / 2, (super.getHeight() - GameScreen._height) / 2);
        this.input = new Input(this, this.hasPointerEvents(), this.translatePoint);
        int width = GameScreen._width / 4;
        int height = GameScreen._height / 8;
        this.softLeftRect = new Rect(0, GameScreen._height - height, width, height);
        this.softRightRect = new Rect(GameScreen._width - width, this.softLeftRect.y, width, height);
        this.g.translate((int)this.translatePoint.getX(), (int)this.translatePoint.getY());
        this.gameThread = new Thread(this);
        this.gameThread.setPriority(10);
        this.gameThread.start();
    }

    protected void redefineScreenSize(int screenType) {
        if (screenType == 5) {
            GameScreen._width = 128;
            GameScreen._height = 160;
        } else if (screenType == 4) {
            GameScreen._width = 172;
            GameScreen._height = 200;
        } else if (screenType == 2) {
            GameScreen._width = 320;
            GameScreen._height = 240;
        } else if (screenType == 1) {
            GameScreen._width = 320;
            GameScreen._height = 320;
        } else {
            GameScreen._width = 240;
            GameScreen._height = 320;
        }
    }

    private byte getScreenType(int width, int height) {
        GameScreen._width = width;
        GameScreen._height = height;
        if (width < 140) {
            return 5;
        }
        if (width < 190) {
            return 4;
        }
        if (width < 250) {
            return 3;
        }
        if (height > 300) {
            return 3;
        }
        return 2;
    }

    private void mainLoop() {
        try {
            this.loadHeadScreenIfUnloaded();
            if (this.timeCounterToCancelInput < 300) {
                this.timeCounterToCancelInput += this.frameTime;
                this.input.resetKey();
            } else {
                int keyState = this.getKeyStates();
                this.input.setNewKeyState(keyState);
                if (this.handleSoftkeyByTouch) {
                    if (this.input.touched(this.softLeftRect)) {
                        this.input.setSoftkeyLeftPrd();
                    } else if (this.input.touched(this.softRightRect)) {
                        this.input.setSoftkeyRightPrd();
                    }
                }
                this.handleInput(this.input);
            }
            if (this.gamePaused) {
                Thread.sleep(200L);
            } else {
                this.update(this.frameTime);
                if (!this.isSuppressDraw && !this.reUpdate) {
                    this.draw();
                } else {
                    Thread.sleep(10L);
                }
                this.reUpdate = false;
            }
        }
        catch (Exception e) {
            this.restoreClipping();
            this.g.setColor(0xFF0000);
            String err = Util.getClassName(e.getClass().getName()) + ": " + e.getMessage();
            if (err.equals(": ")) {
                err = "L\u1ed7i kh\u00f4ng x\u00e1c \u0111\u1ecbnh";
            }
            this.g.drawString(err, (this.getWidth() - this.g.getFont().stringWidth(err)) / 2, (this.getHeight() - this.g.getFont().getHeight()) / 2, 0);
            this.flushGraphics();
            this.appRunning = false;
        }
    }

    public final void run() {
        this.appRunning = true;
        this.gamePaused = false;
        while (this.appRunning) {
            long startTime = System.currentTimeMillis();
            this.mainLoop();
            long runTime = System.currentTimeMillis() - startTime;
            if (this.runAtFixedRate) {
                long sleepTime = (long)this.fixFrameTime - runTime;
                if (sleepTime > 0L) {
                    this.frameTime = this.fixFrameTime;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (runTime > 150L) {
                    this.frameTime = this.fixFrameTime;
                    continue;
                }
                this.frameTime = (int)runTime;
                continue;
            }
            if (runTime > 150L) {
                this.frameTime = this.fixFrameTime;
                continue;
            }
            this.frameTime = (int)runTime;
        }
    }

    public void addScreen(GameScreen gameScreen) {
        gameScreen.exiting = false;
        gameScreen.transitionPos = 1.0f;
        gameScreen.screenState = 1;
        gameScreen.screenManager = this;
        boolean screenAdded = this.screens.offer(gameScreen);
        this.restoreClipping();
    }

    private void loadHeadScreenIfUnloaded() {
        GameScreen screen = (GameScreen)this.screens.peek();
        if (screen != null) {
            if (!screen.initialized) {
                try {
                    screen.initialize();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                screen.initialized = true;
            }
            if (!screen.loaded) {
                try {
                    screen.loadContent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                screen.loaded = true;
            }
        }
    }

    void removeCurrentScreen() {
        this.timeCounterToCancelInput = 0;
        GameScreen screen = (GameScreen)this.screens.poll();
        screen.finalize();
        this.reUpdate = true;
        this.restoreClipping();
    }

    public void removeAllScreens() {
        this.timeCounterToCancelInput = 0;
        while (!this.screens.isEmpty()) {
            this.removeCurrentScreen();
        }
    }

    public boolean changePauseResume() {
        this.gamePaused = !this.gamePaused;
        return this.gamePaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitGameLoop() {
        Queue queue = this.screens;
        synchronized (queue) {
            while (!this.screens.isEmpty()) {
                ((GameScreen)this.screens.poll()).onExitGame();
            }
            this.store.set(VOLUME_KEY, this.music.getVolume());
            this.music.finalize();
            this.store.save();
            this.appRunning = false;
        }
    }

    public void exitGame() {
        this.game.exitGame();
    }

    private void handleInput(Input input) {
        GameScreen screen;
        if (!this.screens.isEmpty() && (screen = (GameScreen)this.screens.peek()).preHandleInput(input, this.frameTime) && !screen.exiting) {
            screen.handleInput(input, this.frameTime);
            input.resetKey();
        }
    }

    private void update(int frameTime) {
        if (!this.screens.isEmpty()) {
            GameScreen screen = (GameScreen)this.screens.peek();
            if (!screen.loaded) {
                this.reUpdate = true;
                return;
            }
            if (screen.preUpdate(frameTime, false)) {
                screen.update(frameTime, false);
            }
        }
    }

    public void cancelOneDraw() {
        this.reUpdate = true;
    }

    private void draw() {
        this.restoreClipping();
        if (!this.screens.isEmpty()) {
            ((GameScreen)this.screens.peek()).draw(this.g, this.frameTime);
        }
        if (this.drawSoftkeyPlace && this.handleSoftkeyByTouch) {
            Drawer.drawCenter(this.g, this.softKeyPlaceImage, this.softLeftRect.centerX(), this.softLeftRect.centerY());
            Drawer.drawCenter(this.g, this.softKeyPlaceImage, this.softRightRect.centerX(), this.softRightRect.centerY());
        }
        this.flushGraphics(this.translatePoint.getX(), this.translatePoint.getY(), GameScreen._width, GameScreen._height);
    }

    public void setSuppressDraw(boolean suppressDraw) {
        this.isSuppressDraw = suppressDraw;
    }

    public boolean isSuppressDraw() {
        return this.isSuppressDraw;
    }

    public boolean isRunning() {
        return !this.gamePaused;
    }

    public void restoreClipping() {
        this.g.setClip(0, 0, GameScreen._width, GameScreen._height);
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public void pauseGame() {
        this.gamePaused = true;
    }

    public void resumeGame() {
        this.gamePaused = false;
    }

    public void setFrameRate(int framePerSecond) {
        this.frameRate = framePerSecond;
        if (framePerSecond > 0 && framePerSecond <= 100) {
            this.fixFrameTime = 1000 / framePerSecond;
            this.runAtFixedRate = true;
        } else if (framePerSecond == 0) {
            this.runAtFixedRate = false;
            this.fixFrameTime = 33;
        }
    }

    public void keyPressed(int keyCode) {
        this.input.setKeyCode(keyCode);
    }

    protected void keyRepeated(int keyCode) {
        this.input.setKeyRepeated(keyCode);
    }

    protected void keyReleased(int keyCode) {
        this.input.setKeyReleased(keyCode);
    }

    public void pointerPressed(int x, int y) {
        this.input.setTouchPosition(x, y);
    }

    public void pointerReleased(int x, int y) {
        this.input.setTouchUpPosition(x, y);
    }

    public int getNumbersOfScreen() {
        return this.screens.occupiedSlots();
    }

    protected void hideNotify() {
        this.gamePaused = true;
    }

    protected void showNotify() {
        this.gamePaused = false;
    }
}

