/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.HelpDraw;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import com.pipogame.util.Page;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NormalDayScreen
extends GameScreen {
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    private Image bgrImage;
    private GameSprite piSprite;
    private GameSprite poSprite;
    private Image pipoShad;
    private Image traderImage;
    private int keyLand = 1;
    private Page page;
    private int keyIntro;
    private GameSprite leftArrowsSprite;
    private GameSprite rightArrowsSprite;
    int trader_x;
    int bgr_x = 23;
    int bgr_y = 8;

    public NormalDayScreen() {
    }

    public NormalDayScreen(int keyLand, int keyIntro) {
        this.keyLand = keyLand;
        this.keyIntro = keyIntro;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 500;
        this.transitionOnTime = 500;
    }

    public void loadContent() throws Exception {
        super.loadContent();
        this.asset = Store.loadJar(strings.MISSIONS_FILE);
        if (this.keyIntro > 0) {
            this.page = new Page(this.asset.getString(this.keyIntro), 6);
            this.page.setX((_width - this.page.getWidth()) / 2);
            this.page.setY(_height / 8);
            this.rightArrowsSprite = new GameSprite(this.loadImage(63), 3, 1);
            this.leftArrowsSprite = new GameSprite(this.rightArrowsSprite);
            this.leftArrowsSprite.setTransform(2);
            this.leftArrowsSprite.setVisible(false);
            this.rightArrowsSprite.setVisible(this.page.getTotalPages() > 1);
            this.leftArrowsSprite.setPosition(this.page.getX(), this.page.getY() + this.page.getHeight() + 2);
            this.rightArrowsSprite.setPosition(this.page.getX() + this.page.getWidth() - this.rightArrowsSprite.getWidth(), this.page.getY() + this.page.getHeight() + 2);
        }
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.paperTopImage = this.loadImage(0);
        this.paperBotImage = this.loadImage(1);
        this.paperMidImage = this.loadImage(2);
        this.bgrImage = Lands.getBgrImage(this.keyLand);
        int curChar = this.screenManager.store.getInt(strings.CHAR_SLTD);
        int curStage = this.screenManager.store.getInt(strings.STAGE);
        if (curChar == 1 || curStage <= 4 || curStage >= 17) {
            this.piSprite = new GameSprite(this.loadImage(46), 6, 1);
            this.piSprite.setTimeSequence(150);
            this.piSprite.setFrame(2);
            this.piSprite.setPositionFoot(this.bgr_x, this.bgr_y + this.bgrImage.getHeight() - 42);
        }
        if (curChar == 2 || curStage <= 4 || curStage >= 24) {
            this.poSprite = new GameSprite(this.loadImage(47), 6, 1);
            this.poSprite.setTimeSequence(150);
            this.poSprite.setPositionFoot(this.bgr_x - 23, this.bgr_y + this.bgrImage.getHeight() - 49);
        }
        this.pipoShad = this.loadImage(51);
        this.traderImage = this.loadImage(49);
        this.trader_x = _width - this.traderImage.getWidth() - 60;
    }

    public void handleInput(Input input, int frameTime) {
        if (this.keyIntro > 0) {
            this.page.handleInput(input, frameTime);
        }
        if (input.isFirePrd()) {
            this.exitScreen();
        } else if (this.keyIntro > 0) {
            if (input.isRightPrd()) {
                if (this.page.isLastPage()) {
                    this.rightArrowsSprite.setVisible(false);
                }
                if (this.page.getPage() > 0) {
                    this.leftArrowsSprite.setVisible(true);
                }
            } else if (input.isLeftPrd()) {
                if (this.page.isfirstPage()) {
                    this.leftArrowsSprite.setVisible(false);
                }
                if (this.page.getPage() < this.page.getTotalPages() - 1) {
                    this.rightArrowsSprite.setVisible(true);
                }
            }
        }
    }

    public void update(int frameTime, boolean covered) {
        if (this.poSprite != null) {
            if (this.poSprite.getLeftX() < this.trader_x) {
                this.poSprite.updateFrame(frameTime, true);
                this.poSprite.move(20, 0, frameTime);
            } else {
                this.poSprite.setFrame(0);
            }
        }
        if (this.piSprite != null) {
            if (this.piSprite.getLeftX() < this.trader_x) {
                this.piSprite.updateFrame(frameTime, true);
                this.piSprite.move(20, 0, frameTime);
            } else {
                this.piSprite.setFrame(0);
            }
        }
        if (this.keyIntro > 0) {
            this.leftArrowsSprite.updateFrame(frameTime, true);
            this.rightArrowsSprite.updateFrame(frameTime, true);
        }
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, this.bgr_x, this.bgr_y, 0);
        this.drawPiPo(g);
        HelpDraw.drawPaper(g, this.paperTopImage, this.paperBotImage, this.paperMidImage, this.screenManager.screenType);
        if (this.keyIntro > 0) {
            g.setColor(-1);
            g.drawRect(this.page.getX() - 1, this.page.getY() - 1, this.page.getWidth() + 1, this.page.getHeight() + 1);
            Drawer.drawBg(g, this.page.getX(), this.page.getY(), this.page.getWidth(), this.page.getHeight(), -2010963165);
            this.page.draw(g, frameTime);
            this.screenManager.restoreClipping();
            this.leftArrowsSprite.paint(g);
            this.rightArrowsSprite.paint(g);
        }
        switch (this.screenState) {
            case 1: 
            case 4: {
                this.drawFade(g, 0);
            }
        }
    }

    public void finalize() {
        super.finalize();
    }

    protected void drawPiPo(Graphics g) {
        g.drawImage(this.traderImage, this.trader_x, this.bgr_y + this.bgrImage.getHeight() - 42 - this.traderImage.getHeight(), 0);
        if (this.poSprite != null) {
            this.poSprite.paint(g);
            g.drawImage(this.pipoShad, this.poSprite.getX(), this.poSprite.getFootY() - this.pipoShad.getHeight() / 2, 0);
        }
        if (this.piSprite != null) {
            this.piSprite.paint(g);
            g.drawImage(this.pipoShad, this.piSprite.getX(), this.piSprite.getFootY() - this.pipoShad.getHeight() / 2, 0);
        }
    }
}

