/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Drawer {
    private static int current_color;
    private static int current_alpha;
    private static final int[] ARGB20;

    private static void drawBg(Graphics g, int x, int y, int width, int height) {
        if ((current_color & 0xFF000000) == 0) {
            return;
        }
        int mWidth = width / 20;
        int mHeight = height / 20;
        for (int i = 0; i < mWidth; ++i) {
            for (int j = 0; j < mHeight; ++j) {
                g.drawRGB(ARGB20, 0, 20, x + i * 20, y + j * 20, 20, 20, true);
            }
        }
        int rWidth = width % 20;
        int rHeight = height % 20;
        if (rWidth > 0) {
            Drawer.drawBg20(g, x + width - rWidth, y, rWidth, height);
        }
        if (rHeight > 0 && width > 20) {
            Drawer.drawBg20(g, x, y + height - rHeight, width - rWidth, rHeight);
        }
    }

    public static void drawBg(Graphics g, int x, int y, int width, int height, int color) {
        Drawer.setBgColor(color);
        Drawer.drawBg(g, x, y, width, height);
    }

    private static void drawBg20(Graphics g, int x, int y, int width, int height) {
        if (width < 20) {
            int nHeight = 400 / width;
            int num = height / nHeight;
            for (int i = 0; i < num; ++i) {
                g.drawRGB(ARGB20, 0, width, x, y + i * nHeight, width, nHeight, true);
            }
            int remain = height % nHeight;
            if (remain > 0) {
                g.drawRGB(ARGB20, 0, width, x, y + num * nHeight, width, remain, true);
            }
        } else {
            int nWidth = 400 / height;
            int num = width / nWidth;
            for (int i = 0; i < num; ++i) {
                g.drawRGB(ARGB20, 0, nWidth, x + i * nWidth, y, nWidth, height, true);
            }
            int remain = width % nWidth;
            if (remain > 0) {
                g.drawRGB(ARGB20, 0, remain, x + num * nWidth, y, remain, height, true);
            }
        }
    }

    public static void setBgAlpha(int alpha) {
        if (current_alpha == alpha) {
            return;
        }
        current_alpha = alpha;
        int color = alpha << 24 | ARGB20[0] & 0xFFFFFF;
        for (int k = ARGB20.length - 1; k >= 0; --k) {
            Drawer.ARGB20[k] = color;
        }
    }

    private static void setBgColor(int color) {
        if (color == current_color) {
            return;
        }
        current_color = color;
        for (int k = ARGB20.length - 1; k >= 0; --k) {
            Drawer.ARGB20[k] = color;
        }
    }

    public static void drawAtCenterX(Graphics g, Image image, int x, int y) {
        g.drawImage(image, x - image.getWidth() / 2, y, 0);
    }

    public static void drawCenter(Graphics g, Image image, int x, int y) {
        g.drawImage(image, x - image.getWidth() / 2, y - image.getHeight() / 2, 0);
    }

    public static void drawTransform(Graphics g, Image i, int x, int y, int transform) {
        g.drawRegion(i, 0, 0, i.getWidth(), i.getHeight(), transform, x, y, 0);
    }

    static {
        ARGB20 = new int[400];
    }
}

