/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

public final class MathExt {
    private static final float[] sinValues = new float[91];
    private static final float[] cosValues = new float[91];

    public static float sin(int i) {
        if (i >= 0 && i <= 90) {
            return sinValues[i];
        }
        if (i > 90 && i <= 180) {
            return sinValues[180 - i];
        }
        if (i > 180 && i <= 270) {
            return -sinValues[i - 180];
        }
        if (i > 270 && i <= 360) {
            return -sinValues[360 - i];
        }
        if (i > 360) {
            return MathExt.sin(i % 360);
        }
        return -MathExt.sin(-i);
    }

    public static float cos(int i) {
        if (i >= 0 && i <= 90) {
            return cosValues[i];
        }
        if (i > 90 && i <= 180) {
            return -cosValues[180 - i];
        }
        if (i > 180 && i <= 270) {
            return -cosValues[i - 180];
        }
        if (i > 270 && i <= 360) {
            return cosValues[360 - i];
        }
        if (i > 360) {
            return MathExt.cos(i % 360);
        }
        return MathExt.cos(-i);
    }

    public static float tan(int i) {
        return MathExt.sin(i %= 360) / MathExt.cos(i);
    }

    public static float cot(int i) {
        return MathExt.sin(i %= 360) / MathExt.cos(i);
    }

    public int round(float a) {
        int i = (int)a;
        if (a >= 0.5f) {
            return i + 1;
        }
        return i;
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static float sqr(float d) {
        return d * d;
    }

    public static double pow(double a, int b) {
        double y;
        if (b < 0) {
            return 1.0 / MathExt.pow(a, -b);
        }
        if (b == 0) {
            return 1.0;
        }
        if (b == 1) {
            return a;
        }
        if (a == 0.0) {
            return 0.0;
        }
        if (a == 1.0) {
            return 1.0;
        }
        double d = y = b % 2 == 1 ? a : 1.0;
        while ((b >>= 1) > 0) {
            a *= a;
            if (b % 2 != 1) continue;
            y *= a;
        }
        return y;
    }

    public static float pow(float a, int b) {
        float y;
        if (b < 0) {
            return 1.0f / MathExt.pow(a, -b);
        }
        if (b == 0) {
            return 1.0f;
        }
        if (b == 1) {
            return a;
        }
        float f = y = b % 2 == 1 ? a : 1.0f;
        while ((b >>= 1) > 0) {
            a *= a;
            if (b % 2 != 1) continue;
            y *= a;
        }
        return y;
    }

    public static double fourthRoot(double d) {
        return Math.sqrt(Math.sqrt(d));
    }

    public static int getSign(int number) {
        return number >= 0 ? 1 : -1;
    }

    static {
        for (int i = 0; i < 90; ++i) {
            double x = Math.toRadians(i);
            MathExt.sinValues[i] = (float)(x - MathExt.pow(x, 3) / 6.0 + MathExt.pow(x, 5) / 120.0 - MathExt.pow(x, 7) / 5040.0 + MathExt.pow(x, 9) / 362880.0);
            MathExt.cosValues[90 - i] = sinValues[i];
        }
        MathExt.cosValues[0] = 1.0f;
        MathExt.sinValues[90] = 1.0f;
    }
}

