/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad;

import com.pipogame.components.GameSprite;
import com.pipogame.fad.GameplayScreen;
import com.pipogame.util.ImageTool;
import com.pipogame.util.MathExt;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoreFly {
    private int x;
    private int y;
    private int time = 1000;
    private static final int TIME = 1000;
    private GameSprite[] numberSprite;
    public int score;

    public ScoreFly(int tbl_x, int tbl_y, Image numsImage) {
        this.x = tbl_x + GameplayScreen.PREMULTIPLY[4];
        this.y = tbl_y + GameplayScreen.PREMULTIPLY[4];
        this.makeSprite(numsImage);
    }

    public boolean paint(Graphics g, int frameTime) {
        this.time -= frameTime;
        if (this.time < 0) {
            this.time = 0;
        }
        char[] num = Integer.toString(this.score).toCharArray();
        int x = this.x - num.length * 7;
        int dy = (int)(50.0f * MathExt.sqr((float)this.time / 1000.0f));
        int i = 0;
        if (num[0] == '-') {
            this.numberSprite[10].setPosition(x, this.y + dy);
            this.numberSprite[10].paint(g);
            x += 14;
            ++i;
        }
        while (i < num.length) {
            this.numberSprite[num[i] - 48].setPosition(x, this.y + dy);
            this.numberSprite[num[i] - 48].paint(g);
            x += 14;
            ++i;
        }
        for (i = 0; i < 11; ++i) {
            this.numberSprite[i].updateFrame(frameTime, false);
        }
        if (this.numberSprite[0].isLastFrame()) {
            for (i = 0; i < 11; ++i) {
                this.numberSprite[i].reset();
            }
            this.time = 1000;
            return false;
        }
        return true;
    }

    public void update(int frameTime) {
        for (int i = 0; i < this.numberSprite.length; ++i) {
            this.numberSprite[i].updateFrame(frameTime, true);
        }
    }

    public void setFrame() {
        int[] frames1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 6, 5, 4, 3, 2, 1};
        int[] frames2 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1};
        int[] frames3 = new int[]{0, 1, 2, 4, 6, 8, 6, 4, 2, 1, 0, 1, 2, 3, 2, 1};
        for (int i = 0; i < this.numberSprite.length; ++i) {
            switch (i % 3) {
                case 0: {
                    this.numberSprite[i].setFrameSequence(frames1);
                    break;
                }
                case 1: {
                    this.numberSprite[i].setFrameSequence(frames2);
                    break;
                }
                default: {
                    this.numberSprite[i].setFrameSequence(frames3);
                }
            }
            this.numberSprite[i].setTimeSequence(100);
        }
    }

    public void paint(Graphics g) {
        char[] num = Integer.toString(this.score).toCharArray();
        int x = this.x;
        for (int i = 0; i < num.length; ++i) {
            this.numberSprite[num[i] - 48].setPosition(x, this.y);
            this.numberSprite[num[i] - 48].paint(g);
            x += 14;
        }
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getWidth() {
        return Integer.toString(this.score).length() * this.numberSprite[0].getWidth();
    }

    private void makeSprite(Image image) {
        this.numberSprite = new GameSprite[11];
        int numSprite = 10;
        for (int i = 0; i < 11; ++i) {
            Image sImage = ImageTool.createImage(140, 15);
            Graphics g = sImage.getGraphics();
            g.setColor(ImageTool.TRANSPARENT_COLOR);
            g.fillRect(0, 0, 140, 15);
            for (int j = 0; j < 10; ++j) {
                g.drawRegion(image, i * 14, 0, 14, 15, 0, j * 14, 0, 0);
            }
            int[] data = ImageTool.getMutableImageData(sImage);
            for (int j = 1; j < 10; ++j) {
                ImageTool.changeOpacity(data, 140, 15, (float)Math.sqrt(1.0f - (float)j / 10.0f), j * 14, 0, 14, 15);
            }
            this.numberSprite[i] = new GameSprite(Image.createRGBImage((int[])data, (int)140, (int)15, (boolean)true), 10, 1);
            this.numberSprite[i].setTimeSequence(100);
        }
        GameSprite temp = this.numberSprite[9];
        for (int i = 9; i > 0; --i) {
            this.numberSprite[i] = this.numberSprite[i - 1];
        }
        this.numberSprite[0] = temp;
    }
}

