/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.Rect;
import com.pipogame.util.Drawer;
import com.pipogame.util.MathExt;
import com.pipogame.util.PFont;
import javax.microedition.lcdui.Graphics;

public class MessageBox {
    private int width;
    private int height;
    private int x;
    private int y;
    private int transitionPos = 500;
    private int transitionDir = -1;
    private static final int TIME = 500;
    private byte[] ok;
    private byte[] cancel;
    private Rect okRect;
    private Rect cancelREct;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static String OK_STRING = "\u0110\u1ed3ng \u00fd";
    public static String CANCEL_STRING = "Th\u00f4i";
    private byte[][] text;

    public MessageBox(String filename, int width) {
        this.text = PFont.breakString(filename, width, Store.ENC_UTF8);
        this.width = width;
        this.height = 17 * this.text.length;
        this.ok = PFont.toBytesIndex(OK_STRING, null);
        this.cancel = PFont.toBytesIndex(CANCEL_STRING, null);
        this.okRect = new Rect(0, this.height - 17, PFont.getStringWidth(this.ok), 17);
        this.cancelREct = new Rect(0, this.okRect.y, this.okRect.width, 17);
    }

    public MessageBox(Store assets, int key, int width) {
        this.text = PFont.breakString(assets.getString(key), width);
        this.width = width;
        this.height = 17 * (this.text.length + 1);
        this.ok = PFont.toBytesIndex(OK_STRING, null);
        this.cancel = PFont.toBytesIndex(CANCEL_STRING, null);
        this.okRect = new Rect(0, this.height - 17, PFont.getStringWidth(this.ok), 17);
        this.cancelREct = new Rect(width - this.okRect.width, this.okRect.y, this.okRect.width, 17);
    }

    public void setY(int y) {
        this.y = y;
        this.cancelREct.y = this.okRect.y = y + this.height - 17;
    }

    public void setX(int x) {
        this.x = x;
        this.okRect.x = x;
        this.cancelREct.x = x + this.width - this.cancelREct.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int handleInput(Input input) {
        if (this.transitionDir == -1) {
            if (input.isSoftLeftPrd() || input.touched(this.okRect)) {
                this.transitionDir = 1;
                return 1;
            }
            if (input.isSoftRightPrd() || input.touched(this.cancelREct)) {
                this.transitionDir = 1;
                return 2;
            }
        }
        return 0;
    }

    public void transOff() {
        this.transitionDir = 1;
    }

    public boolean draw(Graphics g, int frameTime) {
        this.transitionPos += this.transitionDir * frameTime;
        if (this.transitionPos < 0) {
            this.transitionPos = 0;
        } else if (this.transitionPos > 500) {
            this.transitionPos = 500;
        }
        float tranpos2 = MathExt.sqr((float)this.transitionPos / 500.0f);
        int xx = this.x + (int)((float)(this.width / 2) * tranpos2);
        int yy = this.y + (int)((float)(this.height / 2) * tranpos2);
        int ww = this.width - (xx - this.x) * 2;
        int hh = this.height - (yy - this.y) * 2;
        g.setClip(xx, yy, ww, hh);
        Drawer.drawBg(g, xx, yy, ww, hh, -2013265920);
        for (int i = 0; i < this.text.length; ++i) {
            PFont.drawString(g, this.x, this.y + i * 17, this.text[i], -1);
        }
        yy = this.y + this.height - 17;
        g.setColor(0xFFFF22);
        g.drawLine(this.x, yy, this.x + this.width, yy);
        PFont.drawString(g, this.x, yy, this.ok, -65536);
        PFont.drawStringL(g, this.x + this.width, yy, this.cancel, -65536);
        g.setClip(0, 0, GameScreen.width(), GameScreen.height());
        if (this.transitionDir > 0 && this.transitionPos >= 500) {
            this.transitionDir = -1;
            return false;
        }
        return true;
    }
}

