/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.progressBar;

import tv.ingames.j2dm.display.progressBar.IProgressTimeBar;
import tv.ingames.j2dm.display.progressBar.J2DM_ProgressBar;
import tv.ingames.j2dm.display.progressBar.J2DM_ProgressBarParameters;

public class J2DM_ProgressTimeBar
extends J2DM_ProgressBar {
    protected int _id;
    protected int _timeBar;
    protected long _timeStart;
    protected long _timePause;
    protected boolean _pause;
    protected long _initTimePause;
    protected IProgressTimeBar _callback;
    protected boolean _active;

    public J2DM_ProgressTimeBar(int id, IProgressTimeBar callback, J2DM_ProgressBarParameters parameters, String name) {
        super(parameters, name);
        this.init(id, callback);
    }

    public J2DM_ProgressTimeBar(int id, IProgressTimeBar callback, J2DM_ProgressBarParameters parameters) {
        super(parameters);
        this.init(id, callback);
    }

    private void init(int id, IProgressTimeBar callback) {
        this._id = id;
        this._callback = callback;
        this._pause = false;
        this._active = false;
        this._timePause = 0L;
    }

    public void start() {
        this._active = true;
        this._timeBar = this.getMaxValue();
        this._timeStart = System.currentTimeMillis();
        this._timePause = 0L;
    }

    public void setPauseOn() {
        if (!this._pause && this._active) {
            this._pause = true;
            this._initTimePause = System.currentTimeMillis();
        }
    }

    public void setPauseOff() {
        if (this._pause && this._active) {
            this._pause = false;
            this._timePause += System.currentTimeMillis() - this._initTimePause;
        }
    }

    public void update() {
        if (!this._pause && this._active) {
            long timeNow = System.currentTimeMillis();
            long deltaTime = timeNow - (this._timeStart + this._timePause);
            this.setValue((int)((long)this._timeBar - deltaTime));
            if (this._value <= 0) {
                this._active = false;
                if (this._callback != null) {
                    this._callback.finishProgressTimeBar(this._id);
                }
            }
        }
    }
}

