/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.sprite.bitmapRender;

import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_FrameBitmapData;
import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_StructSecuence;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Point;
import tv.ingames.j2dm.utils.J2DM_Rect;
import tv.ingames.j2dm.utils.J2DM_SpriteTools;

public class J2DM_SpriteAnimation {
    private J2DM_StructSecuence _secuence;
    private String _name;

    public J2DM_SpriteAnimation(String name, J2DM_Image image, J2DM_Rect[] rectArray, J2DM_Point point) {
        if (rectArray == null) {
            J2DM_Console.getInstance().addLog("J2DM_SpriteAnimation::J2DM_SpriteAnimation", "null rectArray", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return;
        }
        J2DM_Point[] pointArray = new J2DM_Point[rectArray.length];
        int i = 0;
        while (i < rectArray.length) {
            pointArray[i] = new J2DM_Point(point._x, point._y);
            ++i;
        }
        this.init(name, image, rectArray, pointArray);
    }

    public J2DM_SpriteAnimation(String name, J2DM_Image image, J2DM_Rect[] rectArray, J2DM_Point[] pointArray) {
        this.init(name, image, rectArray, pointArray);
    }

    public J2DM_SpriteAnimation(String name, J2DM_Image image, J2DM_Rect[] rectArray, int anchorX, int anchorY) {
        this.init(name, image, rectArray, anchorX, anchorY);
    }

    public J2DM_SpriteAnimation(String name, J2DM_Image image, int anchorX, int anchorY) {
        J2DM_Rect[] rectArray = new J2DM_Rect[]{new J2DM_Rect(0, 0, image.getWidth(), image.getHeight())};
        this.init(name, image, rectArray, anchorX, anchorY);
    }

    public J2DM_SpriteAnimation(String name, J2DM_Image image, J2DM_Point point) {
        J2DM_Rect[] rectArray = new J2DM_Rect[]{new J2DM_Rect(0, 0, image.getWidth(), image.getHeight())};
        J2DM_Point[] pointArray = new J2DM_Point[]{point};
        this.init(name, image, rectArray, pointArray);
    }

    private void init(String name, J2DM_Image image, J2DM_Rect[] rectArray, J2DM_Point[] pointArray) {
        this._name = name;
        this.createSecuence(image, rectArray, pointArray);
    }

    private void init(String name, J2DM_Image image, J2DM_Rect[] rectArray, int anchorX, int anchorY) {
        this._name = name;
        this.createSecuence(image, rectArray, anchorX, anchorY);
    }

    public String getName() {
        return this._name;
    }

    public J2DM_StructSecuence getSecuence() {
        return this._secuence;
    }

    public J2DM_FrameBitmapData getFrame(int frame) {
        if (this._secuence != null) {
            return this._secuence.getFrame(frame);
        }
        J2DM_Console.getInstance().addLog("J2DM_SpriteAnimation::getFrame", "null _secuence", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return null;
    }

    public int getFrameCount() {
        if (this._secuence != null) {
            return this._secuence.getFrameSecuence().size();
        }
        J2DM_Console.getInstance().addLog("J2DM_SpriteAnimation::getFrameCount", "null _secuence", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return -1;
    }

    public void destroy() {
        if (this._secuence != null) {
            this._secuence.destroy();
            this._secuence = null;
        }
    }

    private void createSecuence(J2DM_Image image, J2DM_Rect[] rectArray, J2DM_Point[] pointArray) {
        this._secuence = J2DM_SpriteTools.createSecuence(image, rectArray, pointArray);
        if (this._secuence == null) {
            J2DM_Console.getInstance().addLog("J2DM_SpriteAnimation::createSecuence", "null _secuence name=" + this._name, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        }
    }

    private void createSecuence(J2DM_Image image, J2DM_Rect[] rectArray, int anchorX, int anchorY) {
        this._secuence = J2DM_SpriteTools.createSecuence(image, rectArray, anchorX, anchorY);
        if (this._secuence == null) {
            J2DM_Console.getInstance().addLog("J2DM_SpriteAnimation::createSecuence", "null _secuence name=" + this._name, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        }
    }

    public void print() {
        if (this._secuence != null) {
            this._secuence.print();
        }
    }
}

