/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.textfield;

import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_KeyCodes;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.system.input.IListenKeyboard;

public class J2DM_InputText
extends J2DM_TextField
implements IListenKeyboard {
    public static int NONE_CASE = 0;
    public static int LOWER_CASE = 1;
    public static int UPPER_CASE = 2;
    protected int _maxCharacters;
    protected int _xCursor;
    protected boolean _cursorVisibility;
    protected long _lastTimeBlinking;
    protected int _blinkingTime;
    protected int _cursorColor;
    protected int _forceLowerUpperCase;

    public J2DM_InputText(String fontName, int maxCharacters, String name) {
        super(fontName, "", name);
        this.init(maxCharacters);
    }

    public J2DM_InputText(String fontName, int maxCharacters) {
        super(fontName, "");
        this.init(maxCharacters);
    }

    private void init(int maxCharacters) {
        J2DM_Stage.getInstance().suscribeKeyboardElement(this);
        this.setMaxCharacters(maxCharacters);
        this._xCursor = this._x;
        this._cursorVisibility = false;
        this._lastTimeBlinking = 0L;
        this._text = new String[1];
        this._text[0] = "";
        this._blinkingTime = 300;
        this._cursorColor = 0xFFFFFF;
        this._forceLowerUpperCase = NONE_CASE;
    }

    public int getForceLowerUpperCase() {
        return this._forceLowerUpperCase;
    }

    public void setForceLowerUpperCase(int value) {
        this._forceLowerUpperCase = value;
    }

    public void setX(int x) {
        super.setX(x);
        this._xCursor = x;
    }

    public void setText(String[] text) {
    }

    public int getCursorColor() {
        return this._cursorColor;
    }

    public void setCursorColor(int cursorColor) {
        this._cursorColor = cursorColor;
    }

    public int getBlinkingTime() {
        return this._blinkingTime;
    }

    public void setBlinkingTime(int blinkingTime) {
        this._blinkingTime = blinkingTime;
    }

    public int getMaxCharacters() {
        return this._maxCharacters;
    }

    public void setMaxCharacters(int maxCharacters) {
        this._maxCharacters = maxCharacters;
    }

    public void draw(J2DM_Graphics g) {
        long newTimeBlinking = System.currentTimeMillis();
        if (newTimeBlinking - this._lastTimeBlinking > (long)this._blinkingTime) {
            this._cursorVisibility = !this._cursorVisibility;
            this._lastTimeBlinking = newTimeBlinking;
        }
        if (this._cursorVisibility) {
            g.setColor(this._cursorColor);
            g.drawLine(this._xCursor, this._y, this._xCursor, this._y + this._font.getSize());
        }
        super.draw(g);
    }

    public void destroy() {
        super.destroy();
        J2DM_Stage.getInstance().unsuscribeKeyboardElement(this);
    }

    public void insertChar(char character) {
        if (this._text[0].length() >= this._maxCharacters) {
            return;
        }
        if (!this._font.hasCharacter(character)) {
            return;
        }
        this._text[0] = String.valueOf(this._text[0]) + character;
        this._xCursor += this._font.getCharWidth(character);
    }

    public void deleteKey() {
        if (this._text[0].length() == 0) {
            return;
        }
        this._xCursor -= this._font.getCharWidth(this._text[0].charAt(this._text[0].length() - 1));
        this._text[0] = this._text[0].substring(0, this._text[0].length() - 1);
    }

    public void keyPressed(char key) {
        char newKey = this.checkLowerUpperCase(key);
        this.insertChar(newKey);
    }

    public char checkLowerUpperCase(char key) {
        int keyCode = J2DM_KeyCodes.getInstance().getKeyCodeFromChar(key);
        if (this._forceLowerUpperCase == UPPER_CASE) {
            if (keyCode >= 97 && keyCode <= 122) {
                key = J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode -= 32);
            }
        } else if (this._forceLowerUpperCase == LOWER_CASE && keyCode >= 65 && keyCode <= 90) {
            key = J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode += 32);
        }
        return key;
    }

    public void keyReleased(char key) {
    }

    public void keyRepeated(char key) {
    }

    public void specialKeyPressed(int keyCode) {
        if (keyCode == 8) {
            this.deleteKey();
        }
    }

    public void specialKeyReleased(int keyCode) {
    }

    public void specialKeyRepeated(int keyCode) {
    }
}

