/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.ui;

import tv.ingames.j2dm.core.J2DM_AbstractGameLoop;
import tv.ingames.j2dm.display.ui.IButtonCallBack;
import tv.ingames.j2dm.display.ui.J2DM_GenericButtonWithText;
import tv.ingames.j2dm.platform.J2DM_Image;

public class J2DM_ButtonWithTimer
extends J2DM_GenericButtonWithText {
    protected long _timeInit;
    protected int _timeToWait = 15000;
    protected int _timeShow;
    protected int _lastNumberShown = -100;
    protected boolean _buttonReady;
    protected String _textButton;

    public J2DM_ButtonWithTimer(J2DM_Image image, int typeButton, String fontName, String text, IButtonCallBack buttonCallback, String name) {
        super(image, typeButton, fontName, text, buttonCallback, name);
        this.initButton(text);
    }

    public J2DM_ButtonWithTimer(J2DM_Image image, int typeButton, String fontName, String text, IButtonCallBack buttonCallback) {
        super(image, typeButton, fontName, text, buttonCallback);
        this.initButton(text);
    }

    private void initButton(String textButton) {
        this._buttonReady = false;
        this._textButton = textButton;
        J2DM_AbstractGameLoop.suscribeElement(this);
    }

    public void start() {
        this._timeInit = System.currentTimeMillis();
    }

    public boolean isButtonReady() {
        return this._buttonReady;
    }

    public void update() {
        long timeNow = System.currentTimeMillis();
        long deltaTime = timeNow - this._timeInit;
        if (deltaTime < (long)this._timeToWait) {
            this._timeShow = this._timeToWait / 1000 - (int)(deltaTime / 1000L);
            if (this._lastNumberShown != this._timeShow) {
                this._lastNumberShown = this._timeShow;
                this.setText("" + this._timeShow);
            }
        } else {
            this._buttonReady = true;
            this.setText(this._textButton);
        }
    }

    public void destroy() {
        super.destroy();
        J2DM_AbstractGameLoop.unsuscribeElement(this);
    }

    public void onMouseDown(int x, int y) {
        if (this._buttonReady) {
            this.gotoAndStop(1);
            this._pressed = true;
            if (this._buttonCallback != null) {
                this._buttonCallback.buttonEvent(0, this);
            }
        }
    }
}

