/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.stage;

import java.util.Vector;
import tv.ingames.j2dm.core.J2DM_AbstractGameLoop;
import tv.ingames.j2dm.display.J2DM_Display;
import tv.ingames.j2dm.display.J2DM_DisplayContainer;
import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.platform.J2DM_CanvasScreen;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.platform.J2DM_KeyCodes;
import tv.ingames.j2dm.stage.J2DM_Layer;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.system.input.IListenKeyboard;
import tv.ingames.j2dm.system.input.IMouseCapture;
import tv.ingames.j2dm.system.input.J2DM_InputKeyboard;
import tv.ingames.j2dm.utils.J2DM_Rect;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class J2DM_Stage
extends J2DM_Layer {
    private static J2DM_Stage _instance;
    private J2DM_CanvasScreen _canvasScreen;
    private int _width;
    private int _height;
    private J2DM_Image _backBuffer0;
    private J2DM_Image _backBuffer1;
    private J2DM_Image _currentBuffer;
    private J2DM_Image _drawingBuffer;
    private J2DM_Graphics _gBuffer;
    private int _bgColor;
    private J2DM_AbstractGameLoop _gameLoop;
    private J2DM_InputKeyboard _inputKeyBoard;
    private Vector _suscribeKeyboardElements = new Vector();
    private Vector _suscribeMouseElements = new Vector();
    private boolean _useDoubleBuffer;
    private boolean _flagMsgOrientation;
    private J2DM_TextField _textFieldMsgOrientation;
    private int _offsetX;
    private int _offsetY;
    private int _widthScale;
    private int _heightScale;
    private float _xFactorScale;
    private float _yFactorScale;

    private J2DM_Stage() {
    }

    public static J2DM_Stage getInstance() {
        if (_instance == null) {
            _instance = new J2DM_Stage();
        }
        return _instance;
    }

    public void init(J2DM_AbstractGameLoop gameLoop, int width, int height, J2DM_CanvasScreen canvasScreen, boolean useDoubleBuffer) {
        this._useDoubleBuffer = true;
        this._gameLoop = gameLoop;
        this._offsetX = 0;
        this._offsetY = 0;
        this._widthScale = width;
        this._heightScale = height;
        this._xFactorScale = 1.0f;
        this._yFactorScale = 1.0f;
        this.addChild(new J2DM_Layer());
        this.addChild(new J2DM_Layer());
        this.addChild(new J2DM_Layer());
        this.addChild(new J2DM_Layer());
        this.addChild(new J2DM_Layer());
        this.addChild(new J2DM_Layer());
        this._width = width;
        this._height = height;
        this._backBuffer0 = new J2DM_Image(J2DM_Image.getDefaultType(), this._width, this._height);
        if (this._useDoubleBuffer) {
            this._backBuffer1 = new J2DM_Image(J2DM_Image.getDefaultType(), this._width, this._height);
        }
        this._bgColor = 0xAAAAAA;
        this._canvasScreen = canvasScreen == null ? new J2DM_CanvasScreen() : canvasScreen;
        this._inputKeyBoard = J2DM_InputKeyboard.getInstance();
        this._flagMsgOrientation = false;
        this.suscribeUpdate();
    }

    public void changeCurrentResolution(int widthValue, int heightValue) {
        this._widthScale = this._canvasScreen.getCurrentWidth();
        this._heightScale = this._canvasScreen.getCurrentHeight();
        this._heightScale = (int)(1.0 * (double)this._canvasScreen.getCurrentWidth() / (double)widthValue * (double)heightValue);
        if (this._heightScale > this._canvasScreen.getCurrentHeight()) {
            this._heightScale = this._canvasScreen.getCurrentHeight();
            this._widthScale = (int)(1.0 * (double)this._canvasScreen.getCurrentHeight() / (double)heightValue * (double)widthValue);
        }
        this._width = widthValue;
        this._height = heightValue;
        this._backBuffer0 = new J2DM_Image(J2DM_Image.getDefaultType(), this._width, this._height);
        if (this._useDoubleBuffer) {
            this._backBuffer1 = new J2DM_Image(J2DM_Image.getDefaultType(), this._width, this._height);
        }
        this._offsetX = (this._canvasScreen.getCurrentWidth() - this._widthScale) / 2;
        this._offsetY = (this._canvasScreen.getCurrentHeight() - this._heightScale) / 2;
        this._xFactorScale = 1.0f * (float)this._widthScale / (float)this._width;
        this._yFactorScale = 1.0f * (float)this._heightScale / (float)this._height;
    }

    public J2DM_Image getCurrentBuffer() {
        return this._currentBuffer;
    }

    public J2DM_CanvasScreen getCanvasScreen() {
        return this._canvasScreen;
    }

    public boolean onCloseVserv() {
        return this._canvasScreen.onCloseVserv();
    }

    public boolean getUseDoubleBuffer() {
        return this._useDoubleBuffer;
    }

    public boolean isReady() {
        if (this._canvasScreen != null) {
            return this._canvasScreen.isReady();
        }
        return false;
    }

    public boolean getFlagMsgOrientation() {
        return this._flagMsgOrientation;
    }

    public void setFlagMsgOrientation(boolean value, String fontName, String textMsgOrientation) {
        this._flagMsgOrientation = value;
        this._textFieldMsgOrientation = new J2DM_TextField(fontName, textMsgOrientation);
        this._textFieldMsgOrientation.setAnchorX(1);
        this._textFieldMsgOrientation.setAnchorY(2);
    }

    public int getOffsetX() {
        return this._offsetX;
    }

    public int getOffsetY() {
        return this._offsetY;
    }

    public int getWidthScale() {
        return this._widthScale;
    }

    public int getHeightScale() {
        return this._heightScale;
    }

    public float getXFactorScale() {
        return this._xFactorScale;
    }

    public float getYFactorScale() {
        return this._yFactorScale;
    }

    public int getCurrentWidth() {
        return this._canvasScreen.getCurrentWidth();
    }

    public int getCurrentHeight() {
        return this._canvasScreen.getCurrentHeight();
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getBgColor() {
        return this._bgColor;
    }

    public void setBgColor(int bgColor) {
        this._bgColor = bgColor;
    }

    private int getLayerByElement(J2DM_Display element) {
        int i = 0;
        while (i < this._elements.size()) {
            J2DM_Layer layer = (J2DM_Layer)this._elements.elementAt(i);
            if (layer.contains(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean addElement(J2DM_Display element, int layerId) {
        if (layerId >= this._elements.size()) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::addElement", "layerId is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (this._elements.elementAt(layerId) == null) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::addElement", "the layer is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        return ((J2DM_Layer)this._elements.elementAt(layerId)).addChild(element);
    }

    public boolean removeElement(J2DM_Display element) {
        return this.removeElement(element, -1);
    }

    public boolean removeElement(J2DM_Display element, int layerId) {
        if (layerId >= this._elements.size()) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::removeElement", "layerId is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (layerId < 0 && (layerId = this.getLayerByElement(element)) < 0) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::removeElement", "the element doesn't exist", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (this._elements.elementAt(layerId) == null) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::removeElement", "the layer is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        return ((J2DM_Layer)this._elements.elementAt(layerId)).removeChild(element);
    }

    public J2DM_DisplayContainer getElementByName(String name, int layerId) {
        if (!J2DM_StringTools.validateString(name)) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::getElementByName", "Element name isn't a valid name", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        if (layerId >= this._elements.size()) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::getElementByName", "layerId is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        if (layerId >= 0) {
            J2DM_Layer layer = (J2DM_Layer)this._elements.elementAt(layerId);
            return layer.getChildByName(name);
        }
        int cant = this._elements.size();
        int i = 0;
        while (i < cant) {
            J2DM_Layer layer = (J2DM_Layer)this._elements.elementAt(i);
            J2DM_DisplayContainer element = layer.getChildByName(name);
            if (element != null) {
                return element;
            }
            ++i;
        }
        J2DM_Console.getInstance().addLog("J2DM_Stage::getElementByName", "Element doesn't exist", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return null;
    }

    public void destroy() {
    }

    public void update() {
        this._drawingBuffer = this.getNextBuffer();
        this._gBuffer = this._drawingBuffer.getGraphics();
        this._gBuffer.setColor(this._bgColor);
        this._gBuffer.fillRect(0, 0, this._width, this._height);
        if (!this._flagMsgOrientation) {
            super.draw(this._gBuffer);
        } else if (this._width != this._canvasScreen.getCurrentWidth() || this._height != this._canvasScreen.getCurrentHeight()) {
            this._gBuffer.setColor(this._bgColor);
            this._gBuffer.fillRect(0, 0, this._height, this._width);
            this._textFieldMsgOrientation.setX(this._canvasScreen.getCurrentWidth() / 2);
            this._textFieldMsgOrientation.setY(this._canvasScreen.getCurrentHeight() / 2);
            this._textFieldMsgOrientation.draw(this._gBuffer);
        } else {
            super.draw(this._gBuffer);
        }
        this._currentBuffer = this._drawingBuffer;
        this._canvasScreen.refreshScreen(this._offsetX, this._offsetY, this._widthScale, this._heightScale);
    }

    private J2DM_Image getNextBuffer() {
        if (!this._useDoubleBuffer) {
            return this._backBuffer0;
        }
        if (this._currentBuffer == this._backBuffer0) {
            return this._backBuffer1;
        }
        return this._backBuffer0;
    }

    public void paint(J2DM_Graphics g) {
        J2DM_Image.drawImageOverGraphics(g, this._currentBuffer, 0, 0, 4, 16);
    }

    public boolean supportTouch() {
        return this._canvasScreen.supportTouch();
    }

    public void setSupportTouch(boolean value) {
        this._canvasScreen.setSupportTouch(value);
    }

    public boolean suscribeKeyboardElement(IListenKeyboard element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::suscribeElement", "The Element is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            if (element == (IListenKeyboard)this._suscribeKeyboardElements.elementAt(i)) {
                J2DM_Console.getInstance().addLog("J2DM_Stage::suscribeElement", "The Element already exists", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return false;
            }
            ++i;
        }
        this._suscribeKeyboardElements.addElement(element);
        return true;
    }

    public boolean unsuscribeKeyboardElement(IListenKeyboard element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::unsuscribeElement", "Null Element", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            if ((IListenKeyboard)this._suscribeKeyboardElements.elementAt(i) == element) {
                this._suscribeKeyboardElements.removeElementAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void deleteSuscribeKeyboardElements() {
        this._suscribeKeyboardElements.removeAllElements();
    }

    public void keyPressed(int keyCode) {
        this._inputKeyBoard.keyPressed(keyCode);
        char charKey = J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode);
        this._gameLoop.keyPressed(charKey);
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            ((IListenKeyboard)this._suscribeKeyboardElements.elementAt(i)).keyPressed(charKey);
            ++i;
        }
    }

    public void keyReleased(int keyCode) {
        this._inputKeyBoard.keyReleased(keyCode);
        char charKey = J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode);
        this._gameLoop.keyReleased(charKey);
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            ((IListenKeyboard)this._suscribeKeyboardElements.elementAt(i)).keyReleased(charKey);
            ++i;
        }
    }

    public void keyRepeated(int keyCode) {
        char charKey = J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode);
        this._gameLoop.keyRepeated(charKey);
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            ((IListenKeyboard)this._suscribeKeyboardElements.elementAt(i)).keyRepeated(charKey);
            ++i;
        }
    }

    public void specialKeyPressed(int keyCode) {
        this._inputKeyBoard.keyPressed(keyCode);
        this._gameLoop.specialKeyPressed(keyCode);
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            ((IListenKeyboard)this._suscribeKeyboardElements.elementAt(i)).specialKeyPressed(keyCode);
            ++i;
        }
    }

    public void specialKeyReleased(int keyCode) {
        this._inputKeyBoard.keyReleased(keyCode);
        this._gameLoop.specialKeyReleased(keyCode);
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            ((IListenKeyboard)this._suscribeKeyboardElements.elementAt(i)).specialKeyReleased(keyCode);
            ++i;
        }
    }

    public void specialKeyRepeated(int keyCode) {
        this._gameLoop.specialKeyRepeated(keyCode);
        int cant = this._suscribeKeyboardElements.size();
        int i = 0;
        while (i < cant) {
            ((IListenKeyboard)this._suscribeKeyboardElements.elementAt(i)).specialKeyRepeated(keyCode);
            ++i;
        }
    }

    public boolean suscribeMouseElement(IMouseCapture element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::suscribeMouseElement", "The Element is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = this._suscribeMouseElements.size();
        int i = 0;
        while (i < cant) {
            if (element == (IMouseCapture)this._suscribeMouseElements.elementAt(i)) {
                J2DM_Console.getInstance().addLog("J2DM_Stage::suscribeMouseElement", "The Element already exists", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return false;
            }
            ++i;
        }
        this._suscribeMouseElements.addElement(element);
        return true;
    }

    public boolean unsuscribeMouseElement(IMouseCapture element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_Stage::unsuscribeMouseElement", "Null Element", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = this._suscribeMouseElements.size();
        int i = 0;
        while (i < cant) {
            if ((IMouseCapture)this._suscribeMouseElements.elementAt(i) == element) {
                this._suscribeMouseElements.removeElementAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void deleteSuscribeMouseElements() {
        this._suscribeMouseElements.removeAllElements();
    }

    public void onMouseDown(int x, int y) {
        int cant = this._suscribeMouseElements.size();
        Object[] array = new Object[cant];
        this._suscribeMouseElements.copyInto(array);
        int i = 0;
        while (i < cant) {
            if (array[i] instanceof IMouseCapture) {
                IMouseCapture element = (IMouseCapture)array[i];
                element.onMouseDownStage(x, y);
                J2DM_Rect rect = element.getBounds();
                if (rect != null && element.getEnable() && element.getVisible() && x >= rect._x && x <= rect._x + rect._width && y >= rect._y && y <= rect._y + rect._height) {
                    element.onMouseDown(x, y);
                }
            }
            ++i;
        }
    }

    public void onMouseUp(int x, int y) {
        int cant = this._suscribeMouseElements.size();
        Object[] array = new Object[cant];
        this._suscribeMouseElements.copyInto(array);
        int i = 0;
        while (i < cant) {
            if (array[i] instanceof IMouseCapture) {
                IMouseCapture element = (IMouseCapture)array[i];
                element.onMouseUpStage(x, y);
                J2DM_Rect rect = element.getBounds();
                if (element.getEnable() && element.getVisible() && element.isPressed() && x >= rect._x && x <= rect._x + rect._width && y >= rect._y && y <= rect._y + rect._height) {
                    element.onMouseUp(x, y);
                }
            }
            ++i;
        }
    }

    public void onMouseMove(int x, int y) {
        int cant = this._suscribeMouseElements.size();
        Object[] array = new Object[cant];
        this._suscribeMouseElements.copyInto(array);
        int i = 0;
        while (i < cant) {
            IMouseCapture element;
            if (array[i] instanceof IMouseCapture && (element = (IMouseCapture)array[i]).isPressed() && element.getEnable() && element.getVisible()) {
                element.onMouseMove(x, y);
            }
            ++i;
        }
    }

    public void activateTouchKeyboard() {
        this._canvasScreen.activateTouchKeyboard();
    }

    public void deactivateTouchKeyboard() {
        this._canvasScreen.deactivateTouchKeyboard();
    }

    public void setOrientationScreen(int orientation) {
        this._canvasScreen.setOrientationScreen(orientation);
    }
}

