/*
 * Decompiled with CFR 0.152.
 */
package Core;

import Core.KEY;
import Core.VirtualKEY;
import CoreGame.GUIManager;
import Util.StaticObj;
import javax.microedition.lcdui.Graphics;

public class TextInput {
    public static TextInput me = null;
    private final int MAX_TIME_TO_CONFIRM_KEY;
    private final int CARET_HEIGHT;
    private final int CARET_WIDTH;
    private final int CARET_SHOWING_TIME;
    private final int TEXT_GAP_X;
    private final int MAX_SHOW_CARET_COUNER;
    public static final int INPUT_TYPE_ANY = 0;
    public static final int INPUT_TYPE_NUMERIC = 1;
    public static final int INPUT_TYPE_PASSWORD = 2;
    private String[] print = null;
    private String[] printabc = new String[]{" 0", ".,?!\"1-()@/:*+<=>;_$%&", "abc2", "def3", "ghi4", "jkl5", "mno6", "pqrs7", "tuv8", "wxyz9"};
    private String[] printABC = new String[]{" 0", ".,?!\"1-()@/:*+<=>;_$%&", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9"};
    private String[] mode = new String[]{"abc", "ABC", "123"};
    private int iMode = 0;
    private int inputTypeBak = 0;
    private String text = "";
    private boolean isPassword = false;
    private String passwordText = "";
    private String paintedText = "";
    private int caretPos = 0;
    private int counter = 0;
    private int maxTextLenght = 255;
    private int offsetX = 0;
    private int lastKey = -1983;
    private int keyInActiveState = 0;
    private int indexOfActiveChar = 0;
    private int showCaretCounter = 10;
    public int inputType = 0;
    public boolean isTypeNumeric = false;
    public int height = 0;
    public int width = 0;
    public int x = 0;
    public int y = 0;
    public int color = 0;
    public boolean isFocused = false;
    public boolean isqwerty = false;

    public void setBound(int x, int y, int width, int height, int color) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
    }

    public void setFocus() {
        this.isFocused = true;
        me = this;
        if (VirtualKEY.ins != null) {
            VirtualKEY.ins.changeMode(this.iMode);
        }
    }

    public TextInput(String text, int maxLen, int inputType) {
        this.MAX_TIME_TO_CONFIRM_KEY = 14;
        this.CARET_HEIGHT = 2;
        this.CARET_WIDTH = 6;
        this.CARET_SHOWING_TIME = 5;
        this.TEXT_GAP_X = 7;
        this.MAX_SHOW_CARET_COUNER = 10;
        if (inputType != 1) {
            this.print = this.printabc;
        } else {
            this.iMode = 2;
        }
        this.isTypeNumeric = this.iMode == 2;
        this.text = text;
        this.maxTextLenght = maxLen;
        this.inputTypeBak = inputType;
        this.inputType = inputType;
        if (inputType == 2) {
            this.inputTypeBak = 0;
            this.inputType = 0;
            this.isPassword = true;
            this.setPasswordTest();
            this.paintedText = this.passwordText;
        }
        this.caretPos = text.length();
    }

    public void clear() {
        if (this.caretPos > 0 && this.text.length() > 0) {
            this.text = this.text.substring(0, this.caretPos - 1) + this.text.substring(this.caretPos, this.text.length());
            if (this.isPassword) {
                this.passwordText = this.passwordText.substring(0, this.caretPos - 1) + this.passwordText.substring(this.caretPos, this.passwordText.length());
            }
            --this.caretPos;
            this.setOffset();
        }
    }

    public void clearAll() {
        this.text = "";
        this.caretPos = 0;
        this.lastKey = -43;
    }

    public void setOffset() {
        this.paintedText = this.isPassword ? this.passwordText : this.text;
        int w = this.width - 7 - StaticObj.bmf_normal.stringWidth(this.mode[this.iMode]) - 7;
        int tw = StaticObj.bmf_normal.stringWidth(this.paintedText);
        int cw = StaticObj.bmf_normal.stringWidth(this.paintedText.substring(0, this.caretPos));
        if (this.offsetX < 0 && tw + this.offsetX < w) {
            this.offsetX = w - tw;
        }
        if (this.offsetX + cw <= 0) {
            this.offsetX = -cw;
        } else if (this.offsetX + cw >= w) {
            this.offsetX = w - cw;
        }
        if (this.offsetX > 0) {
            this.offsetX = 0;
        }
    }

    public void keyPressedAscii(int keyCode) {
        try {
            if (this.text.length() < this.maxTextLenght) {
                String ttext = this.text.substring(0, this.caretPos) + (char)keyCode;
                if (this.caretPos < this.text.length()) {
                    ttext = ttext + this.text.substring(this.caretPos, this.text.length());
                }
                this.text = ttext;
                ++this.caretPos;
                this.setPasswordTest();
                this.setOffset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyPressedAny(int keyCode) {
        if (this.caretPos == 0 && this.text.length() == this.maxTextLenght) {
            this.lastKey = -43;
        } else if (keyCode == this.lastKey) {
            this.indexOfActiveChar = (this.indexOfActiveChar + 1) % this.print[keyCode - 0].length();
            String ttext = this.text.substring(0, this.caretPos - 1) + this.print[keyCode - 0].charAt(this.indexOfActiveChar);
            if (this.caretPos < this.text.length()) {
                ttext = ttext + this.text.substring(this.caretPos, this.text.length());
            }
            this.text = ttext;
            this.keyInActiveState = 14;
            this.setPasswordTest();
        } else if (this.text.length() <= this.maxTextLenght) {
            this.indexOfActiveChar = 0;
            String ttext = this.text.substring(0, this.caretPos - (this.text.length() == this.maxTextLenght ? 1 : 0)) + this.print[keyCode - 0].charAt(this.indexOfActiveChar);
            if (this.caretPos < this.text.length()) {
                ttext = ttext + this.text.substring(this.caretPos, this.text.length());
            }
            this.text = ttext;
            this.keyInActiveState = 14;
            if (this.caretPos < this.text.length() && this.text.length() < this.maxTextLenght || this.text.length() == this.maxTextLenght && this.caretPos == this.text.length() - 1) {
                ++this.caretPos;
            }
            this.setPasswordTest();
            this.setOffset();
        }
        this.lastKey = keyCode;
    }

    public void keyPressedNumeric(int keyCode) {
        if (this.text.length() <= this.maxTextLenght) {
            String ttext = this.text.substring(0, this.caretPos - (this.text.length() == this.maxTextLenght ? 1 : 0)) + String.valueOf(keyCode - 0);
            if (this.caretPos < this.text.length()) {
                ttext = ttext + this.text.substring(this.caretPos, this.text.length());
            }
            this.text = ttext;
            this.keyInActiveState = 14;
            if (this.caretPos < this.text.length() && this.text.length() < this.maxTextLenght || this.text.length() == this.maxTextLenght && this.caretPos == this.text.length() - 1) {
                ++this.caretPos;
            }
            this.setPasswordTest();
            this.setOffset();
        }
    }

    public void ChangeMode(int inewMode) {
        this.inChangeMode(inewMode);
        VirtualKEY.ins.changeMode(inewMode);
    }

    public void inChangeMode(int inewMode) {
        if (inewMode == 0) {
            this.inputType = this.inputTypeBak;
            this.print = this.printabc;
        } else if (inewMode == 1) {
            this.inputType = this.inputTypeBak;
            this.print = this.printABC;
        } else if (inewMode == 2 && (this.inputType == 0 || this.isPassword)) {
            this.inputTypeBak = this.inputType;
            this.inputType = 1;
        }
        this.iMode = inewMode;
    }

    public void updateTouch(int x, int y) {
        if (this.paintedText == null) {
            return;
        }
        if (x < this.x || x > this.x + this.width || y < this.y || y > this.y + this.height) {
            return;
        }
        int wT = x - this.x - 7 - this.offsetX;
        int i = StaticObj.bmf_normal.stringPosFix(this.paintedText, wT);
        this.caretPos = i < 0 ? 0 : (i >= this.paintedText.length() ? this.paintedText.length() : i);
        this.setOffset();
    }

    public boolean updateKeyPressed(int keyCode) {
        if (keyCode == 10) {
            if (this.isTypeNumeric) {
                return true;
            }
            ++this.iMode;
            if (this.iMode >= this.mode.length) {
                this.iMode = 0;
            }
            this.ChangeMode(this.iMode);
            KEY.AsciiKeyPressed = '\u0000';
            return true;
        }
        if (keyCode == 11) {
            KEY.AsciiKeyPressed = '\u0000';
            return true;
        }
        if (keyCode == -1 && KEY.AsciiKeyPressed != '\u0000') {
            this.isqwerty = true;
        }
        if (this.isqwerty) {
            if (KEY.AsciiKeyPressed == '-') {
                if (KEY.AsciiKeyPressed == this.lastKey && this.keyInActiveState < 14) {
                    this.paintedText = this.text = this.text.substring(0, this.caretPos - 1) + '_';
                    this.setPasswordTest();
                    this.setOffset();
                    this.lastKey = -1984;
                    return true;
                }
                this.lastKey = 45;
            }
            if (KEY.AsciiKeyPressed >= ' ') {
                if (this.isPassword) {
                    this.keyInActiveState = 14;
                }
                if (this.inputType == 1 && this.inputType == 1) {
                    if (KEY.AsciiKeyPressed >= '0' && KEY.AsciiKeyPressed <= '9') {
                        this.keyPressedAscii(KEY.AsciiKeyPressed);
                        KEY.AsciiKeyPressed = '\u0000';
                    }
                    return true;
                }
                if (this.iMode == 0) {
                    KEY.AsciiKeyPressed = ("" + KEY.AsciiKeyPressed).toLowerCase().charAt(0);
                } else if (this.iMode == 1) {
                    KEY.AsciiKeyPressed = ("" + KEY.AsciiKeyPressed).toUpperCase().charAt(0);
                }
                this.keyPressedAscii(KEY.AsciiKeyPressed);
                KEY.AsciiKeyPressed = '\u0000';
                return true;
            }
        }
        if (!this.isFocused) {
            return false;
        }
        if (keyCode >= 0 && keyCode <= 9) {
            if (this.inputType == 0) {
                this.keyPressedAny(keyCode);
            } else if (this.inputType == 1) {
                this.keyPressedNumeric(keyCode);
            }
            return true;
        }
        if (keyCode == 18 || keyCode == 19) {
            return false;
        }
        if (keyCode == 12 || keyCode == 13) {
            this.isFocused = false;
            return false;
        }
        this.indexOfActiveChar = 0;
        this.lastKey = -43;
        if (keyCode == 14) {
            if (this.caretPos > 0) {
                --this.caretPos;
                this.setOffset();
                this.showCaretCounter = 10;
            }
            return true;
        }
        if (keyCode == 15) {
            if (this.caretPos < this.text.length()) {
                ++this.caretPos;
                this.setOffset();
                this.showCaretCounter = 10;
            }
            return true;
        }
        if (keyCode == 16 || keyCode == 20) {
            this.clear();
            return true;
        }
        this.lastKey = keyCode;
        return true;
    }

    public void paint(Graphics g) {
        this.paintedText = this.isPassword ? this.passwordText : this.text;
        StaticObj.bmf_normal.drawString(g, this.mode[this.iMode], this.x + this.width - 5 - StaticObj.bmf_normal.stringWidth(this.mode[this.iMode]), this.y + (this.height - StaticObj.bmf_normal.getHeight()) / 2, 0, 0x999999);
        g.setClip(this.x + 7, this.y + 2, this.width - 15 - StaticObj.bmf_normal.stringWidth(this.mode[this.iMode]), this.height - 2);
        StaticObj.bmf_normal.drawString(g, this.paintedText, this.x + 7 + this.offsetX, this.y + (this.height - StaticObj.bmf_normal.getHeight()) / 2, 0, this.color);
        if (this.isFocused && (this.keyInActiveState > 0 || this.showCaretCounter > 0 || this.counter / 5 % 2 == 0)) {
            g.setColor(255);
            g.fillRect(7 + this.offsetX + this.x + StaticObj.bmf_normal.stringWidth(this.paintedText.substring(0, this.caretPos)), this.y + (this.height + StaticObj.bmf_normal.getHeight()) / 2, 6, 2);
        }
        g.setClip(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
    }

    private void setPasswordTest() {
        if (this.isPassword) {
            this.passwordText = "";
            for (int i = 0; i < this.text.length(); ++i) {
                this.passwordText = this.passwordText + "*";
            }
            if (this.keyInActiveState > 0 && this.caretPos > 0) {
                this.passwordText = this.passwordText.substring(0, this.caretPos - 1) + this.text.charAt(this.caretPos - 1) + this.passwordText.substring(this.caretPos, this.passwordText.length());
            }
        }
    }

    public void update() {
        ++this.counter;
        if (this.keyInActiveState > 0) {
            --this.keyInActiveState;
            if (this.keyInActiveState == 0) {
                this.indexOfActiveChar = 0;
                this.lastKey = -43;
                this.setPasswordTest();
            }
        }
        if (this.showCaretCounter > 0) {
            --this.showCaretCounter;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.isPassword) {
            this.setPasswordTest();
            this.paintedText = this.passwordText;
        }
        this.caretPos = text.length();
    }
}

