/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.resource_manager;

import com.innovazione.essentials.Midlet;
import com.innovazione.resource_manager.SettingsManager;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class Sound {
    public static final int Car_Sound = 1;
    public static final int Blast = 2;
    public static final int Gems = 3;
    public static final int PreGame = 4;
    public static final int THEME_SOUND = 5;
    public static final int BOMB_SOUND = 6;
    Player PreGameSound;
    Player Car;
    Player Blast_Sound;
    Player Gems_Sound;
    Player sound_theme;
    Player sound_bomb;
    Midlet midlet;
    VolumeControl volumeCar;
    VolumeControl volumeBlast;
    VolumeControl volumeGems;
    VolumeControl volumePreGameSound;
    VolumeControl volumeThemeSound;
    VolumeControl volumeBombSound;

    public static boolean supportsMixing() {
        String s = System.getProperty("supports.mixing");
        return s != null && s.equalsIgnoreCase("true");
    }

    public Sound(Midlet m) {
        this.midlet = m;
        this.loadSounds();
    }

    public final void vibrate(int timeMilliseconds) {
        if (SettingsManager.isVibrateOn()) {
            Display.getDisplay((MIDlet)this.midlet).vibrate(timeMilliseconds);
        }
    }

    private void loadSounds() {
        try {
            this.Blast_Sound = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/blast.wav"), (String)"audio/wav");
            this.Gems_Sound = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/gems.wav"), (String)"audio/wav");
            this.PreGameSound = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/gems.wav"), (String)"audio/wav");
            this.sound_theme = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/theme_sound.mid"), (String)"audio/mid");
            this.sound_bomb = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/sound/bomb_sound.wav"), (String)"audio/x-wav");
        }
        catch (IOException ex) {
        }
        catch (MediaException ex) {
            // empty catch block
        }
        try {
            this.Blast_Sound.realize();
            this.Gems_Sound.realize();
            this.PreGameSound.realize();
            this.sound_theme.realize();
            this.sound_bomb.realize();
        }
        catch (MediaException ex) {
            // empty catch block
        }
        try {
            this.Blast_Sound.prefetch();
            this.Gems_Sound.prefetch();
            this.PreGameSound.prefetch();
            this.sound_theme.prefetch();
            this.sound_bomb.prefetch();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        this.volumeBlast = (VolumeControl)this.Blast_Sound.getControl("VolumeControl");
        this.volumeBlast.setLevel(100);
        this.volumeGems = (VolumeControl)this.Gems_Sound.getControl("VolumeControl");
        this.volumeGems.setLevel(100);
        this.volumePreGameSound = (VolumeControl)this.PreGameSound.getControl("VolumeControl");
        this.volumePreGameSound.setLevel(30);
        this.volumeThemeSound = (VolumeControl)this.sound_theme.getControl("VolumeControl");
        this.volumeThemeSound.setLevel(70);
        this.volumeBombSound = (VolumeControl)this.sound_bomb.getControl("VolumeControl");
        this.volumeBombSound.setLevel(100);
        this.sound_theme.setLoopCount(-1);
    }

    public void play(int SOUND_PLAY_REQUEST) {
        if (SettingsManager.isSoundOn()) {
            if (SOUND_PLAY_REQUEST == 1) {
                this.play_SoundRunWheel();
            } else if (SOUND_PLAY_REQUEST == 2) {
                this.play_SoundBlast();
            } else if (SOUND_PLAY_REQUEST == 3) {
                this.play_SoundGems();
            } else if (SOUND_PLAY_REQUEST == 4) {
                this.play_SoundPreGame();
            } else if (SOUND_PLAY_REQUEST == 5) {
                this.play_theme_sound();
            } else if (SOUND_PLAY_REQUEST == 6) {
                this.play_bomb_sound();
            }
        }
    }

    public void stop(int SOUND_STOP_REQUEST) {
        if (SOUND_STOP_REQUEST == 1) {
            this.stop_SoundRunWheel();
        } else if (SOUND_STOP_REQUEST == 2) {
            this.stop_SoundBlast();
        } else if (SOUND_STOP_REQUEST == 3) {
            this.stop_SoundGems();
        } else if (SOUND_STOP_REQUEST == 4) {
            this.stop_SoundPreGame();
        } else if (SOUND_STOP_REQUEST == 5) {
            this.stop_theme_sound();
        } else if (SOUND_STOP_REQUEST == 6) {
            this.stop_bomb_sound();
        }
    }

    private void play_SoundRunWheel() {
    }

    private void stop_SoundRunWheel() {
    }

    private void play_SoundPreGame() {
        try {
            this.PreGameSound.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void stop_SoundPreGame() {
        try {
            this.PreGameSound.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void stop_SoundBlast() {
        try {
            this.Blast_Sound.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void stop_SoundGems() {
        try {
            this.Gems_Sound.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void play_SoundBlast() {
        try {
            this.Blast_Sound.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void play_SoundGems() {
        try {
            this.Gems_Sound.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void play_theme_sound() {
        try {
            this.sound_theme.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void stop_theme_sound() {
        try {
            this.sound_theme.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void play_bomb_sound() {
        try {
            this.sound_bomb.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void stop_bomb_sound() {
        try {
            this.sound_bomb.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }
}

