/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.essentials;

import Main.Common;
import com.innovazione.essentials.Canvas_MenuTimer;
import com.innovazione.essentials.Midlet;
import com.innovazione.essentials.Options;
import com.innovazione.resource_manager.SettingsManager;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Canvas_Menu
extends Canvas {
    public Midlet midlet;
    public static int CURRENT_SCREEN;
    public static int MENU_SCREEN;
    public static int OPTION_SCREEN;
    public int AppTimerSpeed = 100;
    public boolean[] AdOnChecker = new boolean[]{true, true};
    private boolean ButtonPressedState;
    public static Image background;
    public static Sprite InHouseAd;
    public static Sprite direction;
    public Sprite menuicons;
    public Sprite menuicons1;
    private final Options OScreen;
    public Timer refreshScreenTimer;
    public int MinRangeY = 0;
    public int MinRangeX = 0;
    public int MaxRangeY = 2;
    public int MaxRangeX = 6;
    public int TotalRows = 2;
    public int TotalCols = 4;
    public int CurrentItemY = 1;
    public int CurrentItemX = 0;
    public static boolean ImagesDumped;

    protected void sizeChanged(int w, int h) {
        Common.OrientationChecker(Common.DeviceW, Common.DeviceH, w, h);
    }

    public Canvas_Menu(Midlet m) {
        this.setFullScreenMode(true);
        this.midlet = m;
        this.OScreen = new Options(this);
        this.Before_GetImages();
    }

    private void Before_GetImages() {
        Common.DeviceW = this.getWidth();
        Common.DeviceH = this.getHeight();
        this.GetRange();
    }

    public void GetRange() {
        Midlet.AdHeight = Common.DeviceH < 240 ? 35 : 50;
        if (!Common.isAdsOn) {
            this.AdOnChecker[0] = false;
            this.AdOnChecker[1] = false;
        }
        this.MinRangeY = this.AdOnChecker[0] ? 0 : 1;
        this.MaxRangeY = this.AdOnChecker[1] ? this.MaxRangeY : --this.MaxRangeY;
        this.MinRangeX = 0;
    }

    public void GetImages() {
        try {
            int tempWidth;
            int tempHeight;
            background = Common.Resizer(Image.createImage((String)"/images/essentials/background.png"), Common.DeviceW, Common.DeviceH);
            Image temp = Common.Resizer(Image.createImage((String)"/images/essentials/inHouseAd.png"), Common.DeviceH, Midlet.AdHeight);
            InHouseAd = new Sprite(temp);
            if (Common.DeviceW > Common.DeviceH) {
                tempHeight = Common.DeviceH;
                tempWidth = Common.DeviceW;
            } else {
                tempHeight = Common.DeviceW;
                tempWidth = Common.DeviceH;
            }
            temp = Common.Resizer(Image.createImage((String)"/images/menu/menuicons1.png"), (int)((double)tempWidth * 0.1) * this.TotalCols, (int)((double)tempWidth * 0.1) * this.TotalRows);
            this.menuicons1 = new Sprite(temp, temp.getWidth() / this.TotalCols, temp.getHeight() / this.TotalRows);
            int tempX = tempHeight < 360 ? tempHeight - 2 * Midlet.AdHeight - 2 * this.menuicons1.getHeight() : tempHeight - 2 * Midlet.AdHeight - 2 * this.menuicons1.getHeight();
            temp = Common.Resizer(Image.createImage((String)"/images/menu/menuicons.png"), tempX * this.TotalCols, tempX * this.TotalRows);
            this.menuicons = new Sprite(temp, temp.getWidth() / this.TotalCols, temp.getHeight() / this.TotalRows);
            if (tempX % 2 != 0) {
                tempX = tempX / 2 + 1;
            }
            temp = Common.Resizer(Image.createImage((String)"/images/menu/direction.png"), tempX, tempX / 2);
            direction = new Sprite(temp, temp.getWidth() / 2, temp.getHeight());
            ImagesDumped = false;
            System.out.println("LOADED MENU IMAGES");
        }
        catch (IOException ex) {
            System.out.println("CANVAS MENU IMAGE ERROR");
        }
    }

    public void DumpImages() {
        this.endRefreshScreen();
        ImagesDumped = true;
        this.menuicons1 = null;
        this.menuicons = null;
        System.out.println("DUMPED MENU IMAGES");
    }

    public void After_GetImages() {
        this.CurrentItemY = 1;
        this.CurrentItemX = 0;
        this.ButtonPressedState = false;
        CURRENT_SCREEN = MENU_SCREEN;
        this.startRefreshScreen();
    }

    public void startRefreshScreen() {
        if (this.refreshScreenTimer == null) {
            this.refreshScreenTimer = new Timer();
            this.refreshScreenTimer.schedule((TimerTask)new Canvas_MenuTimer(this), 50L, (long)this.AppTimerSpeed);
        }
    }

    public void endRefreshScreen() {
        if (this.refreshScreenTimer != null) {
            this.refreshScreenTimer.cancel();
            this.refreshScreenTimer = null;
        }
    }

    protected void paint(Graphics g) {
        if (!ImagesDumped) {
            this.paint_DefaultBackground(g);
            if (Common.ScreenSize) {
                if (CURRENT_SCREEN == MENU_SCREEN) {
                    this.paint_Menu(g);
                }
                if (CURRENT_SCREEN == OPTION_SCREEN) {
                    this.OScreen.paint(g);
                }
                if (Common.isAdsOn) {
                    this.paint_Ads_Vertical(g);
                }
                if (CURRENT_SCREEN == OPTION_SCREEN) {
                    this.paint_Back(g);
                }
            } else {
                this.midlet.customFonts.paint(g, "SIZE", this.getWidth() / 2, this.getHeight() / 2 - Common.FontLargeH, 5, 1, 0, 2);
                this.midlet.customFonts.paint(g, "NOT SUPPORTED", this.getWidth() / 2, this.getHeight() / 2 + Common.FontLargeH, 5, 1, 0, 2);
            }
        }
    }

    private void paint_DefaultBackground(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (Common.ScreenSize) {
            g.drawImage(background, Common.DeviceW / 2, Common.DeviceH / 2, 3);
        }
    }

    private void paint_Menu(Graphics g) {
        int CenterX = (Common.DeviceW - this.menuicons.getWidth()) / 2;
        int CenterY = (Common.DeviceH - this.menuicons.getHeight()) / 2;
        int SmallCenterY = (Common.DeviceH - this.menuicons1.getHeight()) / 2;
        int space = (int)((double)Common.DeviceW * 0.01);
        for (int i = 0; i <= this.MaxRangeX; ++i) {
            if (i == this.CurrentItemX) {
                if (i == 3 && !SettingsManager.soundOn) {
                    this.menuicons.setFrame(i + 4);
                } else {
                    this.menuicons.setFrame(i);
                }
                this.menuicons.setPosition(CenterX, CenterY);
                this.menuicons.paint(g);
                continue;
            }
            if (i == 3 && !SettingsManager.soundOn) {
                this.menuicons1.setFrame(i + 4);
            } else {
                this.menuicons1.setFrame(i);
            }
            int temp = this.CurrentItemX - i;
            if (temp < 0) {
                this.menuicons1.setPosition(CenterX - (temp + 1) * this.menuicons1.getWidth() + this.menuicons.getWidth() - temp * space, SmallCenterY);
            } else {
                this.menuicons1.setPosition(CenterX - temp * this.menuicons1.getWidth() - temp * space, SmallCenterY);
            }
            this.menuicons1.paint(g);
        }
        this.Paint_Touch_Keys(g);
    }

    private void Paint_Touch_Keys(Graphics g) {
        if (Midlet.TouchPad) {
            if (this.ButtonPressedState) {
                direction.setFrame(1);
            } else {
                direction.setFrame(0);
            }
            direction.setTransform(0);
            direction.setPosition(Common.DeviceW - direction.getWidth(), Common.DeviceH - Midlet.AdHeight - direction.getHeight());
            direction.paint(g);
            if (this.ButtonPressedState) {
                direction.setFrame(1);
            } else {
                direction.setFrame(0);
            }
            direction.setTransform(2);
            direction.setPosition(0, Common.DeviceH - Midlet.AdHeight - direction.getHeight());
            direction.paint(g);
        }
    }

    private void paint_Ads_Vertical(Graphics g) {
        if (this.AdOnChecker[0]) {
            this.midlet.ShowAd(g, 0);
        }
        if (this.AdOnChecker[1]) {
            this.midlet.ShowAd(g, 2);
        }
        if (this.AdOnChecker[0] && this.CurrentItemY == 0) {
            g.drawImage(this.midlet.adSelected, Common.DeviceW / 2, Midlet.AdHeight, 33);
        }
        if (this.AdOnChecker[1] && this.CurrentItemY == this.MaxRangeY) {
            g.drawImage(this.midlet.adSelected, Common.DeviceW / 2, Common.DeviceH - Midlet.AdHeight, 17);
        }
    }

    private void paint_Back(Graphics g) {
        g.drawImage(this.midlet.backButton, Common.DeviceW, Common.DeviceH, 40);
    }

    protected void keyPressed(int keyCode) {
        if (Common.ScreenSize) {
            if (CURRENT_SCREEN == MENU_SCREEN) {
                this.key(keyCode);
            } else if (CURRENT_SCREEN == OPTION_SCREEN) {
                this.OScreen.OptionkeyPressed(keyCode);
            }
        }
    }

    private void key(int keyCode) {
        switch (keyCode) {
            case -7: {
                this.rightSoftKeyPressed();
                break;
            }
            case -1: {
                this.handleUpPressed();
                break;
            }
            case -2: {
                this.handleDownPressed();
                break;
            }
            case -4: {
                this.handleRightPressed();
                break;
            }
            case -3: {
                this.handleLeftPressed();
                break;
            }
            case -5: {
                this.handleOkPressed();
            }
        }
    }

    private void handleOkPressed() {
        if (this.CurrentItemY == 0) {
            this.midlet.ClickAd();
        } else if (this.CurrentItemY == 1 && this.CurrentItemX == 0) {
            this.midlet.Display_Canvas_MemoryCleaner(3);
        } else if (this.CurrentItemY == 1 && this.CurrentItemX == 1) {
            this.OScreen.reset();
            CURRENT_SCREEN = OPTION_SCREEN;
            this.midlet.showMidBillboard();
        } else if (this.CurrentItemY == 1 && this.CurrentItemX == 2) {
            this.midlet.exitApp();
        } else if (this.CurrentItemY == 1 && this.CurrentItemX == 3) {
            SettingsManager.toggleSoundOn();
        } else if (this.CurrentItemY == 1 && this.CurrentItemX == 4) {
            this.facebook();
        } else if (this.CurrentItemY == 1 && this.CurrentItemX == 5) {
            this.twitter();
        } else if (this.CurrentItemY == 1 && this.CurrentItemX == 6) {
            this.policyView();
        } else if (this.CurrentItemY == 2) {
            this.midlet.ClickAd();
        }
    }

    private void facebook() {
        try {
            this.midlet.platformRequest("https://www.facebook.com/pages/Innovazione-Labs/190934771117454");
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    private void twitter() {
        try {
            this.midlet.platformRequest("https://twitter.com/InnovazioneLabs");
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    private void policyView() {
        try {
            this.midlet.platformRequest("http://innovazionelabs.com/privacy-policy.html");
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    private void handleLeftPressed() {
        if (this.CurrentItemX > this.MinRangeX && this.CurrentItemY == 1) {
            --this.CurrentItemX;
        }
        this.midlet.sound.stop(4);
        this.midlet.sound.play(4);
    }

    private void handleRightPressed() {
        if (this.CurrentItemX < this.MaxRangeX && this.CurrentItemY == 1) {
            ++this.CurrentItemX;
        }
        this.midlet.sound.stop(4);
        this.midlet.sound.play(4);
    }

    private void handleDownPressed() {
        ++this.CurrentItemY;
        if (this.CurrentItemY > this.MaxRangeY) {
            this.CurrentItemY = this.MinRangeY;
        }
    }

    private void handleUpPressed() {
        --this.CurrentItemY;
        if (this.CurrentItemY < this.MinRangeY) {
            this.CurrentItemY = this.MaxRangeY;
        }
    }

    private void rightSoftKeyPressed() {
    }

    protected void pointerPressed(int x, int y) {
        if (Common.ScreenSize && CURRENT_SCREEN != MENU_SCREEN && CURRENT_SCREEN == OPTION_SCREEN) {
            this.OScreen.pointerPressed(x, y);
        }
        this.refreshScreen();
    }

    protected void pointerReleased(int x, int y) {
        if (Common.ScreenSize) {
            if (CURRENT_SCREEN == MENU_SCREEN) {
                if (y < Midlet.AdHeight) {
                    this.midlet.ClickAd();
                } else if (y > Common.DeviceH - Midlet.AdHeight) {
                    this.midlet.ClickAd();
                } else {
                    this.menutouch(x, y);
                }
            } else if (CURRENT_SCREEN == OPTION_SCREEN) {
                this.OScreen.pointerReleased(x, y);
            }
            this.refreshScreen();
        }
    }

    void menutouch(int x, int y) {
        if (x < direction.getWidth() && y > Common.DeviceH - Midlet.AdHeight - direction.getHeight()) {
            this.handleLeftPressed();
        } else if (x > Common.DeviceW - direction.getWidth() && y > Common.DeviceH - Midlet.AdHeight - direction.getHeight()) {
            this.handleRightPressed();
        } else if (x > (Common.DeviceW - this.menuicons.getWidth()) / 2 && x < (Common.DeviceW + this.menuicons.getWidth()) / 2) {
            this.handleOkPressed();
        }
    }

    protected void hideNotify() {
        super.hideNotify();
    }

    public void refreshScreen() {
        this.repaint();
        this.serviceRepaints();
    }

    static {
        MENU_SCREEN = 1;
        OPTION_SCREEN = 2;
        ImagesDumped = true;
    }
}

