/*
 * Decompiled with CFR 0.152.
 */
package com.danhhuynh.donttapthewhitetile.view;

import com.danhhuynh.donttapthewhitetile.Midlet;
import com.danhhuynh.donttapthewhitetile.game.Tile;
import com.danhhuynh.donttapthewhitetile.utils.DataManipulator;
import com.danhhuynh.donttapthewhitetile.utils.GameResources;
import com.danhhuynh.donttapthewhitetile.view.MenuCanvas;
import com.danhhuynh.donttapthewhitetile.widget.Button;
import com.nokia.mid.ui.DirectUtils;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class MyCanvas
extends GameCanvas
implements Runnable,
CommandListener {
    private Midlet midlet;
    private int width;
    private int height;
    private Tile tile;
    private Tile[][] tiles;
    private static final int SIZE = 4;
    private static final int MAX_CPS = 100;
    private static final int MS_PER_FRAME = 10;
    private static final int MIN_NEW_TILE = 2;
    private static final int MAX_NEW_TILE = 50;
    private int score;
    private long time;
    private int count;
    private int sc;
    private int _c;
    private long best;
    private boolean repaint;
    private boolean isPause = false;
    private boolean isWin = false;
    private boolean isGameover = false;
    private Button btnMenu;
    private Button button;
    private Button[] buttons;
    private int newTile = 2;
    private static final int[] COL_NUMBER;
    private long startMillis = 0L;
    private boolean isStarted = false;
    private DataManipulator dataManipulator;
    private static final Command CMD_BACK;
    private Thread thread = null;
    private static final String KEYBOARD_TYPE = "PhoneKeypad FullKeyboard LimitedKeyboard4x10 LimitedKeyboard3x11 HalfKeyboard";
    private int mode;
    public static final int MODE_CLASSIC = 0;
    public static final int MODE_ZEN = 1;
    public static final int MODE_ARCADE = 2;
    public static final String RS_BEST_CLASSIC = "rs_best_classic";
    public static final String RS_BEST_ZEN = "rs_best_zen";
    public static final String RS_BEST_ARCADE = "rs_best_arcade";
    private static final String[] TITLES;
    private String title;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        COL_NUMBER = nArray;
        CMD_BACK = new Command("Back", 2, 0);
        TITLES = new String[]{"Classic", "Zen", "Arcade"};
    }

    public MyCanvas(Midlet midlet, int mode) {
        super(false);
        this.midlet = midlet;
        this.mode = mode;
        this.setFullScreenMode(true);
        this.init();
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void init() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.repaint = true;
        this.tiles = this.initBoard(this.tiles);
        this.initButtons();
        this.dataManipulator = new DataManipulator();
        this.best = this.getBest();
        this.addCommand(CMD_BACK);
        this.setCommandListener(this);
        if (this.mode == 0) {
            this.time = 0L;
        } else if (this.mode == 1) {
            this.time = 30000L;
        } else if (this.mode == 2) {
            this.count = 0;
            this.sc = 0;
            this._c = 0;
        }
        this.title = TITLES[this.mode];
    }

    private long getBest() {
        String strRSName = "";
        long emptyValue = 0L;
        if (this.mode == 0) {
            strRSName = RS_BEST_CLASSIC;
            emptyValue = 3600000L;
        } else if (this.mode == 1) {
            strRSName = RS_BEST_ZEN;
            emptyValue = 0L;
        } else if (this.mode == 2) {
            strRSName = RS_BEST_ARCADE;
            emptyValue = 0L;
        }
        return this.dataManipulator.readStream(strRSName, emptyValue);
    }

    private void setBest() {
        String strRSName = "";
        long strData = 0L;
        if (this.mode == 0) {
            strRSName = RS_BEST_CLASSIC;
            strData = this.time;
        } else if (this.mode == 1) {
            strRSName = RS_BEST_ZEN;
            strData = this.score;
        } else if (this.mode == 2) {
            strRSName = RS_BEST_ARCADE;
            strData = this.sc;
        }
        this.dataManipulator.writeStream(strRSName, strData);
    }

    private Tile[][] initBoard(Tile[][] tiles) {
        tiles = new Tile[4][4];
        Random r = new Random();
        int i = 0;
        while (i < 4) {
            int black = r.nextInt(4);
            int j = 0;
            while (j < 4) {
                this.tile = new Tile();
                this.tile.width = this.width / 4;
                this.tile.height = this.height / 4;
                this.tile.x = j * this.tile.width;
                this.tile.y = i * this.tile.height;
                if (i == 3) {
                    this.tile.color = 0xFFFF00;
                } else if (j == black) {
                    this.tile.color = 0;
                }
                if (i == 2 && j == black) {
                    this.tile.isStart = true;
                }
                tiles[i][j] = this.tile;
                ++j;
            }
            ++i;
        }
        return tiles;
    }

    private void initButtons() {
        this.buttons = new Button[2];
        this.button = new Button();
        this.button.str = "Exit";
        this.button.width = 50;
        this.button.height = 25;
        this.button.x = this.width / 2 - (this.button.width + 10);
        this.button.y = this.height - (this.button.height + 50);
        this.button.color = 0xFFFFFF;
        this.buttons[0] = this.button;
        this.button = new Button();
        this.button.str = "Again";
        this.button.width = 50;
        this.button.height = 25;
        this.button.x = this.width / 2 + 10;
        this.button.y = this.height - (this.button.height + 50);
        this.button.color = 0xFFFFFF;
        this.buttons[1] = this.button;
        this.btnMenu = new Button();
        this.btnMenu.str = "Menu";
        this.btnMenu.width = 50;
        this.btnMenu.height = 25;
        this.btnMenu.x = (this.width - this.btnMenu.width) / 2;
        this.btnMenu.y = this.height - this.button.height;
        this.btnMenu.color = 0xFFFFFF;
        this.btnMenu.bg = 0xCC0000;
    }

    private void reinit() {
        this.isWin = false;
        this.isGameover = false;
        this.newTile = 2;
        this.isStarted = false;
        if (this.mode == 0) {
            this.time = 0L;
        } else if (this.mode == 1) {
            this.time = 30000L;
        } else if (this.mode == 2) {
            this.count = 0;
            this.sc = 0;
            this._c = 0;
        }
        this.tiles = this.initBoard(this.tiles);
    }

    private Tile[] getNewData(Tile[] tiles) {
        int black = MyCanvas.shuffleArray(COL_NUMBER)[0];
        int i = 0;
        while (i < 4) {
            this.tile = tiles[i];
            this.tile.color = i == black ? 0 : 0xFFFFFF;
            ++i;
        }
        return tiles;
    }

    private static int[] shuffleArray(int[] ar) {
        Random rnd = new Random();
        int i = ar.length - 1;
        while (i > 0) {
            int index = rnd.nextInt(i + 1);
            int a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
            --i;
        }
        return ar;
    }

    public void drawGraphics(Graphics g) {
        g.setColor(65280);
        g.fillRect(0, 0, this.width, this.height);
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.tile = this.tiles[i][j];
                this.tile.draw(g);
                ++j;
            }
            ++i;
        }
        g.setColor(0xFF0000);
        g.setFont(Font.getFont((int)0, (int)1, (int)16));
        if (this.mode == 2) {
            g.drawString("" + this.sc, this.width / 2, 10, 17);
        } else {
            g.drawString(this.formatTime(this.time), this.width / 2, 10, 17);
        }
        this.btnMenu.draw(g);
        this.drawPause(g);
        this.drawWin(g);
        this.drawGameover(g);
    }

    private void drawPause(Graphics g) {
        if (this.isPause) {
            g.drawImage(GameResources.bgPause, 0, 0, 20);
            g.setColor(0xFFFFFF);
            Font font = Font.getFont((int)0, (int)1, (int)16);
            g.setFont(font);
            g.drawString("Tap to restart!", this.width / 2, this.height / 2 - font.getHeight() / 2, 17);
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
        }
    }

    private void drawWin(Graphics g) {
        if (this.isWin) {
            if (this.mode == 0) {
                g.setColor(65280);
            } else if (this.mode == 1) {
                g.setColor(0x999999);
            } else if (this.mode == 2) {
                g.setColor(0xFF0000);
            }
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(0xFFFFFF);
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
            g.drawString("Don't Tap The White Tile", this.width - 5, 5, 24);
            g.setFont(Font.getFont((int)0, (int)1, (int)16));
            g.drawString(String.valueOf(this.title) + " Mode", this.width / 2, 30, 17);
            g.setColor(0);
            Font font = this.getLargeFont();
            g.setFont(font);
            String result = "";
            if (this.mode == 0) {
                result = this.formatTime(this.time);
            } else if (this.mode == 1) {
                result = "" + this.score;
            } else if (this.mode == 2) {
                result = "" + this.sc;
            }
            g.drawString(result, this.width / 2, this.height / 2 - font.getHeight() / 2, 17);
            g.setFont(Font.getFont((int)0, (int)1, (int)8));
            String b = "";
            if (this.mode == 0) {
                b = this.formatTime(this.best);
            } else if (this.mode == 1) {
                b = "" + this.best;
            } else if (this.mode == 2) {
                b = "" + this.best;
            }
            g.drawString("BEST " + b, this.width / 2, this.height / 2 - font.getHeight() / 2 + font.getHeight(), 17);
            int i = 0;
            while (i < this.buttons.length) {
                this.button = this.buttons[i];
                this.button.draw(g);
                ++i;
            }
        }
    }

    private void drawGameover(Graphics g) {
        if (this.isGameover) {
            g.setColor(0xFF0000);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(0xFFFFFF);
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
            g.drawString("Don't Tap The White Tile", this.width - 5, 5, 24);
            g.setFont(Font.getFont((int)0, (int)1, (int)16));
            g.drawString(String.valueOf(this.title) + " Mode", this.width / 2, 30, 17);
            g.setColor(0);
            Font font = this.getLargeFont();
            g.setFont(font);
            g.drawString("Failed!", this.width / 2, this.height / 2 - font.getHeight() / 2, 17);
            int i = 0;
            while (i < this.buttons.length) {
                this.button = this.buttons[i];
                this.button.draw(g);
                ++i;
            }
        }
    }

    private Font getLargeFont() {
        if (this.hasPointerEvents() && !MyCanvas.hasKeyboard()) {
            return DirectUtils.getFont((int)0, (int)1, (int)40);
        }
        return Font.getFont((int)0, (int)1, (int)16);
    }

    public void run() {
        while (true) {
            long cycleStartTime = System.currentTimeMillis();
            if (!this.repaint) continue;
            if (!(this.isPause || this.isWin || this.isGameover)) {
                this.update();
            }
            this.drawGraphics(this.getGraphics());
            this.flushGraphics();
            long timeSinceStart = System.currentTimeMillis() - cycleStartTime;
            if (timeSinceStart >= 10L) continue;
            try {
                Thread.sleep(10L - timeSinceStart);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void update() {
        if (this.isStarted) {
            if (this.mode == 0) {
                if (this.time < 3600000L) {
                    this.time = System.currentTimeMillis() - this.startMillis;
                } else {
                    this.setGameover();
                }
            } else if (this.mode == 1) {
                if (this.time > 0L) {
                    this.time = 30000L - (System.currentTimeMillis() - this.startMillis);
                } else {
                    this.setWin();
                }
            } else if (this.mode == 2) {
                ++this.count;
                if (this.count % 20 == 0) {
                    this.updateBoard();
                    if (this._c > this.sc) {
                        this.setWin();
                    }
                }
            }
        }
        if (this.newTile == 52 && this.mode == 0) {
            this.setWin();
        }
    }

    private void setGameover() {
        this.isGameover = true;
    }

    private void setWin() {
        this.isWin = true;
        if (this.mode == 0) {
            if (this.time < this.best) {
                this.setBest();
                this.best = this.getBest();
            }
        } else if (this.mode == 1) {
            if ((long)this.score > this.best) {
                this.setBest();
                this.best = this.getBest();
            }
        } else if (this.mode == 2) {
            int tmp = this.sc;
            if ((long)this.sc > this.best) {
                this.setBest();
                this.best = this.getBest();
            }
            this.sc = tmp;
        }
    }

    private void updateBoard() {
        ++this._c;
        ++this.newTile;
        Tile[] tmp = this.tiles[3];
        tmp = this.getNewData(tmp);
        int[] yy = new int[]{this.tiles[0][0].y, this.tiles[1][0].y, this.tiles[2][0].y, this.tiles[3][0].y};
        int i = 3;
        while (i >= 0) {
            int j;
            int y;
            if (i - 1 >= 0) {
                y = yy[i];
                this.tiles[i] = this.tiles[i - 1];
                j = 0;
                while (j < 4) {
                    this.tiles[i][j].y = y;
                    this.tiles[i][j].isStart = false;
                    ++j;
                }
            } else {
                y = yy[i];
                this.tiles[i] = tmp;
                j = 0;
                while (j < 4) {
                    this.tiles[i][j].y = y;
                    this.tiles[i][j].isStart = false;
                    if (this.mode == 0 && this.newTile >= 50) {
                        this.tiles[i][j].width = 0;
                        this.tiles[i][j].height = 0;
                    }
                    ++j;
                }
            }
            if (i == 3) {
                int j2 = 0;
                while (j2 < 4) {
                    if (this.tiles[i][j2].color == 0) {
                        this.tiles[i][j2].color = 0x999999;
                    }
                    ++j2;
                }
            }
            --i;
        }
    }

    private String formatTime(long millis) {
        String str = "";
        int milli = (int)(millis % 1000L);
        int second = (int)(millis / 1000L % 60L);
        int minute = (int)(millis / 60000L % 60L);
        str = millis < 60000L ? String.valueOf(second) + "." + milli : String.valueOf(minute) + ":" + second + "." + milli;
        return String.valueOf(str) + "\"";
    }

    private void showScreen(int i) {
        switch (i) {
            case 0: {
                this.midlet.showDisplayable((Displayable)new MenuCanvas(this.midlet));
                break;
            }
            case 1: {
                this.reinit();
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!(this.isPause || this.isGameover || this.isWin)) {
            if (this.btnMenu.isPressed(x, y)) {
                this.midlet.showDisplayable((Displayable)new MenuCanvas(this.midlet));
            } else {
                boolean bool = false;
                int i = 1;
                while (i < 3) {
                    int j = 0;
                    while (j < 4) {
                        this.tile = this.tiles[i][j];
                        if (this.tile.isPressed(x, y)) {
                            if (this.tile.color == 0 && i == 2) {
                                bool = true;
                                break;
                            }
                            if (this.tile.color == 0xFFFFFF && i != 3) {
                                this.setGameover();
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                if (bool) {
                    if (!this.isStarted) {
                        this.startMillis = System.currentTimeMillis();
                        if (this.mode == 2) {
                            this.updateBoard();
                        }
                        this.isStarted = true;
                    }
                    if (this.mode == 0) {
                        this.updateBoard();
                    } else if (this.mode == 1) {
                        ++this.score;
                        this.updateBoard();
                    } else if (this.mode == 2) {
                        ++this.sc;
                    }
                    bool = false;
                }
            }
        } else if (this.isWin || this.isGameover) {
            int i = 0;
            while (i < this.buttons.length) {
                this.button = this.buttons[i];
                if (this.button.isPressed(x, y)) {
                    this.showScreen(i);
                    break;
                }
                ++i;
            }
        } else if (this.isPause) {
            this.isPause = false;
            this.reinit();
        }
    }

    protected void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == CMD_BACK) {
            this.midlet.showDisplayable((Displayable)new MenuCanvas(this.midlet));
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        this.isPause = true;
    }

    protected void showNotify() {
        super.showNotify();
    }

    public static boolean hasKeyboard() {
        String type = System.getProperty("com.nokia.keyboard.type");
        if (type == null) {
            return true;
        }
        return KEYBOARD_TYPE.indexOf(type) >= 0;
    }
}

