/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.views;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import com.rocktasticgames.farmmatch.utils.XMath;
import com.rocktasticgames.farmmatch.views.View;
import javax.microedition.lcdui.Image;

public class MapView
extends View {
    private static final int MAX_TOUCHES = 2;
    private static float[] xloc = new float[]{888.0f, 294.0f, 688.0f, 1136.0f, 2032.0f, 2504.0f, 2639.0f, 1830.0f, 3366.0f, 3248.0f, 3696.0f, 4016.0f};
    private static float[] yloc = new float[]{1058.0f, 548.0f, 176.0f, 32.0f, 32.0f, 240.0f, 816.0f, 1168.0f, 1152.0f, 544.0f, 0.0f, 848.0f};
    private static float[] xloc_bdg = new float[]{1276.0f, 300.0f, 853.0f, 1326.0f, 2227.0f, 2612.0f, 2832.0f, 2066.0f, 3617.0f, 3507.0f, 3878.0f, 4228.0f};
    private static float[] yloc_bdg = new float[]{1396.0f, 476.0f, 698.0f, 498.0f, 591.0f, 788.0f, 1216.0f, 1635.0f, 1571.0f, 1027.0f, 506.0f, 1510.0f};
    private static String[] IMGS = new String[]{"map_obj_2_bad", "map_obj_11_bad", "map_obj_6_bad", "map_obj_13_bad", "map_obj_12_bad", "map_obj_1_bad", "map_obj_10_bad", "map_obj_8_bad", "map_obj_3_bad", "map_obj_14_bad", "map_obj_7_bad", "map_obj_5_bad"};
    private static String[] IMGS_GOOD = new String[]{"map_obj_2_good", "map_obj_11_good", "map_obj_6_good", "map_obj_13_good", "map_obj_12_good", "map_obj_1_good", "map_obj_10_good", "map_obj_8_good", "map_obj_3_good", "map_obj_14_good", "map_obj_7_good", "map_obj_5_good"};
    private AnimatedElement fliprt;
    private boolean showright;
    private boolean fromright;
    private boolean fliprtselect = false;
    private AnimatedElement[] buildings;
    private MainActivity activity;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement background;
    private AnimatedElement menu;
    private AnimatedElement flip;
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private long start_time;
    private boolean destroyed = false;
    private boolean showleft;
    private long start_anim = 0L;
    private boolean menuselect = false;
    private boolean flipselect = false;
    private int delays = 0;
    private AnimatedElement[] levels;
    private int levelselect = -1;
    private int maxsection;
    private boolean dialog_tapped = false;
    private boolean on_dialog_pre = false;
    private boolean on_dialog_post = false;
    private boolean wasanimating = false;

    public MapView(MainActivity mainActivity, int n) {
        super(mainActivity);
        this.activity = mainActivity;
        this.start_time = System.currentTimeMillis();
        this.maxsection = this.activity.getSharedPref().getInt("maxlevel", 0) / 10;
        this.showleft = n == 0;
        this.showright = n == 2;
        this.activity.getAssetLoader().load("mapcheckmark", 1);
        this.activity.getMusic().playMusic("pizza_openingscreen_music_j2me");
        this.on_dialog_pre = this.activity.checkMessage(this.maxsection * 10 + 1, 6);
        if (!this.on_dialog_pre) {
            this.on_dialog_post = this.activity.checkMessage(this.maxsection * 10 + 1, 7);
        }
    }

    public boolean needsTranslate(AnimatedElement animatedElement) {
        if (this.levels == null) {
            return false;
        }
        for (int i = 4; i < this.levels.length; ++i) {
            if (this.levels[i] != animatedElement) continue;
            return true;
        }
        return false;
    }

    public boolean needsDoubleTranslate(AnimatedElement animatedElement) {
        if (this.levels == null) {
            return false;
        }
        for (int i = 8; i < this.levels.length; ++i) {
            if (this.levels[i] != animatedElement) continue;
            return true;
        }
        return false;
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (animatedElement == null) {
            return this.menu;
        }
        if (n == 1) {
            if (animatedElement == this.menu || animatedElement == this.flip || animatedElement == this.fliprt) {
                if (this.showleft) {
                    return this.levels[0];
                }
                if (this.showright) {
                    if (this.maxsection >= 8) {
                        return this.levels[8];
                    }
                    return animatedElement;
                }
                if (this.maxsection >= 7) {
                    return this.levels[7];
                }
                if (this.maxsection >= 4) {
                    return this.levels[this.maxsection];
                }
                return animatedElement;
            }
            for (int i = 0; i <= this.maxsection; ++i) {
                if (animatedElement != this.levels[i]) continue;
                if (i < 4) {
                    if (i < this.maxsection && i < 3) {
                        return this.levels[i + 1];
                    }
                } else {
                    if (i < 8) {
                        if (i > 4) {
                            return this.levels[i - 1];
                        }
                        return this.levels[4];
                    }
                    if (i < this.maxsection && i < 11) {
                        return this.levels[i + 1];
                    }
                }
                return animatedElement;
            }
            return animatedElement;
        }
        if (animatedElement == this.menu) {
            if (n == 5 && this.showleft || n == 2 && !this.showleft && !this.showright) {
                return this.flip;
            }
            if (n == 2 && this.showright || n == 5 && !this.showleft && !this.showright) {
                return this.fliprt;
            }
            return animatedElement;
        }
        if (animatedElement == this.flip) {
            if (n == 5 && !this.showleft || n == 2 && this.showleft) {
                return this.menu;
            }
            return animatedElement;
        }
        if (animatedElement == this.fliprt) {
            if (n == 2 && !this.showright || n == 5 && this.showright) {
                return this.menu;
            }
            return animatedElement;
        }
        if (n == 6) {
            for (int i = 0; i <= this.maxsection; ++i) {
                if (animatedElement != this.levels[i]) continue;
                if (i < 4) {
                    if (i > 0) {
                        return this.levels[i - 1];
                    }
                } else if (i < 8) {
                    if (i < Math.min(this.maxsection, 7)) {
                        return this.levels[i + 1];
                    }
                } else if (i > 8) {
                    return this.levels[i - 1];
                }
                return this.menu;
            }
            return animatedElement;
        }
        return animatedElement;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activity.getAssetLoader().unload("mapcheckmark");
        if (this.background != null) {
            int n;
            this.background.unload();
            this.menu.unload();
            this.flip.unload();
            this.fliprt.unload();
            for (n = 0; n < this.levels.length; ++n) {
                this.levels[n].unload();
            }
            for (n = 0; n < this.buildings.length; ++n) {
                this.buildings[n].unload();
            }
        }
    }

    public boolean onBack() {
        if (this.on_dialog_pre) {
            this.on_dialog_pre = this.activity.progressDialog();
            if (!this.on_dialog_pre) {
                this.on_dialog_post = this.activity.checkMessage(this.maxsection * 10 + 1, 5);
            }
            return true;
        }
        if (this.on_dialog_post) {
            this.on_dialog_post = this.activity.progressDialog();
            return true;
        }
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        int n;
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        if (this.showleft) {
            this.background = new AnimatedElement(this.activity.getAssetLoader(), "gamemap_with_parchment_v4_left", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.flip = new AnimatedElement(this.activity.getAssetLoader(), "button_279_nextpage", 0.9f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        } else if (this.showright) {
            this.background = new AnimatedElement(this.activity.getAssetLoader(), "gamemap_with_parchment_v4_right", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.fliprt = new AnimatedElement(this.activity.getAssetLoader(), "button_279_prevpage", 0.1f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        } else {
            this.background = new AnimatedElement(this.activity.getAssetLoader(), "gamemap_with_parchment_v4_center", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.flip = new AnimatedElement(this.activity.getAssetLoader(), "button_279_prevpage", 0.1f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.fliprt = new AnimatedElement(this.activity.getAssetLoader(), "button_279_nextpage", 0.9f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        }
        if (this.flip == null) {
            this.flip = new AnimatedElement(this.activity.getAssetLoader(), "button_279_nextpage", 0.9f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.flip.animateOut(-10000L);
        }
        if (this.fliprt == null) {
            this.fliprt = new AnimatedElement(this.activity.getAssetLoader(), "button_279_nextpage", 0.9f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
            this.fliprt.animateOut(-10000L);
        }
        this.menu = new AnimatedElement(this.activity.getAssetLoader(), "button_279_home", 0.5f, 1.2239584f * f2 + (1.0f - f2 * 4.0f / 3.0f), (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.levels = new AnimatedElement[Math.min(xloc.length, this.maxsection + 1)];
        for (n = 0; n < this.levels.length; ++n) {
            this.levels[n] = new AnimatedElement(this.activity.getAssetLoader(), Params.MAPMARKERS[n / 4], (xloc[n] + 186.0f) / 1536.0f, (yloc[n] + 157.0f) / 1536.0f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        }
        this.activity.getCanvas().setFocus(this.menu);
        this.buildings = new AnimatedElement[14];
        n = 1;
        for (int i = 0; i < 12; ++i) {
            this.buildings[i] = i < this.levels.length - 1 ? new AnimatedElement(this.activity, IMGS_GOOD[i], xloc_bdg[i] / 1536.0f, yloc_bdg[i] / 1536.0f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L) : new AnimatedElement(this.activity, IMGS[i], xloc_bdg[i] / 1536.0f, yloc_bdg[i] / 1536.0f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        }
        this.buildings[13] = this.activity.getSharedPref().getInt("maxlevel", 0) >= 5 ? new AnimatedElement(this.activity, "map_obj_9_good", 0.6282552f, 1.0911459f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L) : new AnimatedElement(this.activity, "map_obj_9_bad", 0.6282552f, 1.0911459f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.buildings[12] = this.activity.getSharedPref().getInt("maxlevel", 0) >= 15 ? new AnimatedElement(this.activity, "map_obj_4_good", 0.29296875f, 0.79296875f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L) : new AnimatedElement(this.activity, "map_obj_4_bad", 0.29296875f, 0.79296875f * f2 + (1.0f - f2 * 4.0f / 3.0f) / 2.0f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
    }

    public void showRight() {
        if (this.showright) {
            return;
        }
        this.activity.getCanvas().setFocus(this.menu);
        this.background.setPNG("gamemap_with_parchment_v4_right");
        this.fliprt.setPNG("button_279_prevpage");
        this.fliprt.setX(0.1f);
        this.fliprt.animate(3, 0L);
        this.flip.animateOut(0L);
        this.loaded = false;
        this.showleft = false;
        this.showright = true;
        this.start_anim = System.currentTimeMillis();
        this.callInvalidate();
    }

    public void showCenter() {
        if (!this.showleft && !this.showright) {
            return;
        }
        this.fromright = this.showright;
        this.activity.getCanvas().setFocus(this.menu);
        this.background.setPNG("gamemap_with_parchment_v4_center");
        this.flip.setPNG("button_279_prevpage");
        this.flip.setX(0.1f);
        this.flip.animate(3, 0L);
        this.fliprt.setPNG("button_279_nextpage");
        this.fliprt.setX(0.9f);
        this.fliprt.animate(4, 0L);
        this.loaded = false;
        this.showleft = false;
        this.showright = false;
        this.start_anim = System.currentTimeMillis();
        this.callInvalidate();
    }

    public void showLeft() {
        if (this.showleft) {
            return;
        }
        this.activity.getCanvas().setFocus(this.menu);
        this.background.setPNG("gamemap_with_parchment_v4_left");
        this.flip.setPNG("button_279_nextpage");
        this.flip.setX(0.9f);
        this.flip.animate(4, 0L);
        this.fliprt.animateOut(0L);
        this.loaded = false;
        this.showleft = true;
        this.start_anim = System.currentTimeMillis();
        this.callInvalidate();
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        int n;
        graphicsContainer.setColor(-1);
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n2 = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 240;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded) {
            this.loaded = this.activity.getAssetLoader().isCurrent();
            this.start_time = System.currentTimeMillis();
            bl = true;
        }
        this.time = System.currentTimeMillis() - this.start_time;
        long l = System.currentTimeMillis() - this.start_anim;
        if (!this.loaded || this.start_anim > 0L && (float)l < 500.0f) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                if (this.start_anim > 0L) {
                    this.loaded = false;
                    if (this.showleft) {
                        graphicsContainer.translate(XMath.min(0.0f, (float)((long)(-image.getWidth()) * (500L - l)) / 0.5f / 1000.0f), 0.0f);
                        graphicsContainer.translate(image.getWidth(), 0);
                    } else if (this.showright) {
                        graphicsContainer.translate(XMath.max(0.0f, (float)((long)image.getWidth() * (500L - l)) / 0.5f / 1000.0f), 0.0f);
                        graphicsContainer.translate(-image.getWidth(), 0);
                    } else if (this.fromright) {
                        graphicsContainer.translate(XMath.min(0.0f, (float)((long)(-image.getWidth()) * (500L - l)) / 0.5f / 1000.0f), 0.0f);
                        graphicsContainer.translate(image.getWidth(), 0);
                    } else {
                        graphicsContainer.translate(XMath.max(0.0f, (float)((long)image.getWidth() * (500L - l)) / 0.5f / 1000.0f), 0.0f);
                        graphicsContainer.translate(-image.getWidth(), 0);
                    }
                    this.callInvalidate();
                } else {
                    this.postInvalidateDelayed(50L);
                }
                graphicsContainer.drawImage(image, 0, 0, n2);
                if (this.showleft || this.showright) {
                    graphicsContainer.translate(-image.getWidth(), 0);
                } else if (this.fromright) {
                    graphicsContainer.translate(-2 * image.getWidth(), 0);
                }
                graphicsContainer.scale(1.0f / (float)MainActivity.PLACEHOLDER_BLUR, 1.0f / (float)MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.translate(0.0f, -((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                if (this.start_anim > 0L) {
                    int n3;
                    this.activity.getTitan().setSize(this.levels[0].getHeight() / 5);
                    for (n3 = 0; n3 < this.buildings.length; ++n3) {
                        this.buildings[n3].render(graphicsContainer, n2, this.time);
                    }
                    for (n3 = 0; n3 < this.levels.length; ++n3) {
                        if (this.on_dialog_pre && n3 == this.levels.length - 1) continue;
                        if (this.levelselect == n3) {
                            this.levels[n3].setColorFilter(Params.filter_dark);
                        } else if (this.maxsection < n3) {
                            this.levels[n3].setColorFilter(Params.filter_gray);
                        }
                        this.levels[n3].render(graphicsContainer, n2, this.time);
                        this.levels[n3].setColorFilter(null);
                        graphicsContainer.setColor(-1);
                        String string = n3 * 10 + 1 + "-" + (n3 + 1) * 10;
                        graphicsContainer.save();
                        graphicsContainer.translate(this.levels[n3].getX(this.time) - (float)(this.activity.getBrady().measure(string) / 2), this.levels[n3].getY(this.time) - this.activity.getBrady().getSize(graphicsContainer) / 2.0f - (float)(this.levels[n3].getHeight() / 4));
                        this.activity.getBrady().renderString(graphicsContainer, n2, string);
                        graphicsContainer.restore();
                    }
                }
                graphicsContainer.restore();
                if (this.start_anim > 0L) {
                    if (this.menuselect) {
                        this.menu.setColorFilter(Params.filter_dark);
                    }
                    if (!this.menu.render(graphicsContainer, n2, this.time)) {
                        bl = true;
                    }
                    if (this.menuselect) {
                        this.menu.setColorFilter(null);
                    }
                    graphicsContainer.setColor(-1);
                }
            } else {
                graphicsContainer.setColor(-13722999);
                graphicsContainer.drawPaint(n2);
                this.postInvalidateDelayed(50L);
            }
            graphicsContainer.restore();
            return;
        }
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        this.background.render(graphicsContainer, n2, this.time);
        graphicsContainer.save();
        if (!this.showleft) {
            graphicsContainer.translate(-240, 0);
        }
        if (this.showright) {
            graphicsContainer.translate(-240, 0);
        }
        for (n = 0; n < this.buildings.length; ++n) {
            this.buildings[n].render(graphicsContainer, n2, this.time);
        }
        graphicsContainer.restore();
        graphicsContainer.setColor(-1);
        if (this.menuselect) {
            this.menu.setColorFilter(Params.filter_dark);
        }
        if (!this.menu.render(graphicsContainer, n2, this.time)) {
            bl = true;
        }
        if (this.menuselect) {
            this.menu.setColorFilter(null);
        }
        graphicsContainer.setColor(-1);
        if (this.flipselect) {
            this.flip.setColorFilter(Params.filter_dark);
        }
        if (!this.flip.isAnimatingOut() && !this.flip.render(graphicsContainer, n2, this.time)) {
            bl = true;
        }
        if (this.flipselect) {
            this.flip.setColorFilter(null);
        }
        if (this.fliprtselect) {
            this.fliprt.setColorFilter(Params.filter_dark);
        }
        if (!this.fliprt.isAnimatingOut() && !this.fliprt.render(graphicsContainer, n2, this.time)) {
            bl = true;
        }
        if (this.fliprtselect) {
            this.fliprt.setColorFilter(null);
        }
        if (!this.showleft) {
            graphicsContainer.translate(-240, 0);
        }
        if (this.showright) {
            graphicsContainer.translate(-240, 0);
        }
        this.activity.getTitan().setSize(this.levels[0].getHeight() / 5);
        for (n = 0; n < this.levels.length - 1; ++n) {
            if (this.on_dialog_pre && n != this.levels.length - 2) continue;
        }
        for (n = 0; n < this.levels.length; ++n) {
            if (this.on_dialog_pre && n == this.levels.length - 1) continue;
            if (this.levelselect == n) {
                this.levels[n].setColorFilter(Params.filter_dark);
            }
            this.levels[n].render(graphicsContainer, n2, this.time);
            Image image = this.activity.getAssetLoader().get("mapcheckmark");
            if (n < this.maxsection && n < this.levels.length && image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(this.levels[n].getX(this.time), this.levels[n].getY(this.time));
                graphicsContainer.scale(1.0f, 1.0f);
                graphicsContainer.drawImage(image, -image.getWidth() / 2, -image.getHeight() / 2, n2);
                graphicsContainer.restore();
            }
            if (this.levelselect == n) {
                this.levels[n].setColorFilter(null);
            }
            graphicsContainer.setColor(-1);
            String string = n * 10 + 1 + "-" + (n + 1) * 10;
            graphicsContainer.save();
            graphicsContainer.translate(this.levels[n].getX(this.time) - (float)(this.activity.getBrady().measure(string) / 2), this.levels[n].getY(this.time) - this.activity.getBrady().getSize(graphicsContainer) / 2.0f - (float)(this.levels[n].getHeight() / 4));
            this.activity.getBrady().renderString(graphicsContainer, n2, string);
            graphicsContainer.restore();
        }
        if ((float)this.time < 500.0f && this.start_anim == 0L) {
            Image image;
            if (!this.showleft) {
                graphicsContainer.translate(240, 0);
            }
            if (this.showright) {
                graphicsContainer.translate(240, 0);
            }
            if ((image = this.activity.getPlaceholder()) != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n2);
                graphicsContainer.restore();
            } else {
                graphicsContainer.drawPaint(n2);
            }
            bl = true;
        } else if (!this.wasanimating) {
            // empty if block
        }
        if (this.on_dialog_pre || this.on_dialog_post && this.time > 2500L) {
            this.activity.renderDialog(graphicsContainer, n2, this.scale, this.dialog_tapped);
        }
        graphicsContainer.restore();
        this.last_time = this.time;
        this.time = System.currentTimeMillis() - this.start_time;
        this.wasanimating = bl;
        if (bl) {
            this.callInvalidate();
        } else if (this.delays == 0) {
            this.postInvalidateDelayed(100L);
        }
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
    }

    public void postInvalidateDelayed(long l) {
        ++this.delays;
        super.postInvalidateDelayed(l);
    }

    public void callInvalidate() {
        ++this.delays;
        this.invalidate();
    }

    public void invalidate() {
        this.delays = Math.max(0, this.delays - 1);
        super.invalidate();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.dialog_tapped) {
                    if (!this.activity.progressDialog()) {
                        if (this.on_dialog_pre) {
                            this.on_dialog_pre = false;
                            this.on_dialog_post = this.activity.checkMessage(this.maxsection * 10 + 1, 5);
                        } else {
                            this.on_dialog_post = false;
                        }
                    }
                    this.dialog_tapped = false;
                } else if (this.menuselect) {
                    this.menuselect = false;
                    this.activity.openMainMenu();
                } else if (this.flipselect) {
                    this.flipselect = false;
                    if (this.showleft) {
                        this.showCenter();
                    } else {
                        this.showLeft();
                    }
                } else if (this.fliprtselect) {
                    this.fliprtselect = false;
                    if (this.showright) {
                        this.showCenter();
                    } else {
                        this.showRight();
                    }
                } else if (this.levelselect >= 0) {
                    this.activity.startSelection(this.levelselect);
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                if (this.on_dialog_pre || this.on_dialog_post) {
                    if (motionEvent.getX() > this.activity.getCanvas().getWidth() * 4 / 10 && motionEvent.getX() < this.activity.getCanvas().getWidth() * 6 / 10 && motionEvent.getY() > this.activity.getCanvas().getHeight() * 7 / 8) {
                        this.dialog_tapped = true;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.menu.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.activity.playSound("standard_click");
                    this.menuselect = true;
                } else if (this.flip.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale) && !this.wasanimating) {
                    this.activity.playSound("standard_click");
                    this.flipselect = true;
                } else if (this.fliprt.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale) && !this.wasanimating) {
                    this.activity.playSound("standard_click");
                    this.fliprtselect = true;
                } else if (!this.wasanimating) {
                    for (int i = 0; i < this.levels.length && i <= this.maxsection; ++i) {
                        if (this.showleft) {
                            if (!this.levels[i].inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) continue;
                            this.levelselect = i;
                            return true;
                        }
                        if (this.showright) {
                            if (!this.levels[i].inRange((float)(motionEvent.getX() + this.activity.getCanvas().getWidth() * 2) / this.scale, (float)motionEvent.getY() / this.scale)) continue;
                            this.levelselect = i;
                            return true;
                        }
                        if (!this.levels[i].inRange((float)(motionEvent.getX() + this.activity.getCanvas().getWidth()) / this.scale, (float)motionEvent.getY() / this.scale)) continue;
                        this.levelselect = i;
                        return true;
                    }
                    this.swipe_time = this.last_time;
                    this.swipe_active[n] = true;
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.dialog_tapped && (motionEvent.getX() <= this.activity.getCanvas().getWidth() * 4 / 10 || motionEvent.getX() >= this.activity.getCanvas().getWidth() * 6 / 10 || motionEvent.getY() <= this.activity.getCanvas().getHeight() * 7 / 8)) {
                    this.dialog_tapped = false;
                } else if (this.menuselect && !this.menu.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.menuselect = false;
                } else if (this.flipselect && !this.flip.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.flipselect = false;
                } else if (this.fliprtselect && !this.fliprt.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.fliprtselect = false;
                } else if (this.showleft && this.levelselect >= 0 && !this.levels[this.levelselect].inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.levelselect = -1;
                } else if (this.showright && this.levelselect >= 0 && !this.levels[this.levelselect].inRange((float)(motionEvent.getX() + this.activity.getCanvas().getWidth() * 2) / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.levelselect = -1;
                } else if (!(this.showleft || this.showright || this.levelselect < 0 || this.levels[this.levelselect].inRange((float)(motionEvent.getX() + this.activity.getCanvas().getWidth()) / this.scale, (float)motionEvent.getY() / this.scale))) {
                    this.levelselect = -1;
                } else if (this.swipe_active[n] && XMath.abs(f - this.mousex[n]) + XMath.abs(f2 - this.mousey[n]) > (float)(this.activity.getCanvas().getWidth() / 50) && XMath.abs(f - this.mousex[n]) > XMath.abs(f2 - this.mousey[n])) {
                    if (f - this.mousex[n] > 0.0f) {
                        if (this.showright) {
                            this.showCenter();
                        } else {
                            this.showLeft();
                        }
                    } else if (this.showleft) {
                        this.showCenter();
                    } else {
                        this.showRight();
                    }
                    this.swipe_active[n] = false;
                }
                return true;
            }
        }
        return true;
    }
}

