/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class LevelManager {
    public static String[] availableSetName;
    public static short[] availableSetLevelQty;
    public static String[] setName;
    public static long[] setLevelTime;
    public static short[] setCurrentLevel;
    public static short[] setLevelQty;
    public static int currentSet;
    public static String[] levelNames;
    public static final String[] standartLevelNames;

    public static void init() {
        String[] stringArray;
        try {
            stringArray = RecordStore.openRecordStore((String)"levelset", (boolean)true);
            if (stringArray.getNumRecords() != 0) {
                byte[] byArray = stringArray.getRecord(1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int n = dataInputStream.readShort();
                currentSet = dataInputStream.readShort();
                setName = new String[n];
                setCurrentLevel = new short[n];
                setLevelQty = new short[n];
                for (int i = 0; i < n; ++i) {
                    LevelManager.setName[i] = dataInputStream.readUTF();
                    LevelManager.setCurrentLevel[i] = dataInputStream.readShort();
                    LevelManager.setLevelQty[i] = dataInputStream.readShort();
                }
                dataInputStream.close();
            } else {
                setName = new String[1];
                setCurrentLevel = new short[1];
                setLevelQty = new short[1];
                LevelManager.setName[0] = "Standart";
                LevelManager.setCurrentLevel[0] = 0;
                LevelManager.setLevelQty[0] = 25;
                currentSet = 0;
                RecordStore recordStore = RecordStore.openRecordStore((String)"Standart", (boolean)true);
                byte[] byArray = new byte[setLevelQty[0] << 3];
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.closeRecordStore();
            }
            stringArray.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = new String[setName.length + 2];
        System.arraycopy(setName, 0, stringArray, 1, setName.length);
        stringArray[0] = Game.ChooseLevelSetText[0];
        stringArray[stringArray.length - 1] = Game.QUIT;
        Game.ChooseLevelSetText = stringArray;
        LevelManager.setCurrent(setName[currentSet]);
    }

    public static void setCurrent(String string) {
        int n;
        Object[] objectArray;
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < setName.length; ++n2) {
            if (!setName[n2].equals(string)) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            return;
        }
        if (setLevelTime != null) {
            LevelManager.saveBestTime();
        }
        currentSet = n3;
        short s = setLevelQty[currentSet];
        setLevelTime = new long[s];
        DataInputStream dataInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        int n4 = s + 1;
        if (currentSet == 0) {
            n4 = 1;
        }
        try {
            objectArray = RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).getRecord(n4);
            byteArrayInputStream = new ByteArrayInputStream((byte[])objectArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
            for (n2 = 0; n2 < s; ++n2) {
                LevelManager.setLevelTime[n2] = dataInputStream.readLong();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentSet == 0) {
            levelNames = standartLevelNames;
        } else {
            try {
                objectArray = RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).getRecord(n4 + 1);
                byteArrayInputStream = new ByteArrayInputStream((byte[])objectArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                levelNames = new String[s];
                for (n2 = 0; n2 < s; ++n2) {
                    LevelManager.levelNames[n2] = dataInputStream.readUTF();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        objectArray = new String[s];
        for (n2 = n = 0; n2 < s; ++n2) {
            objectArray[n2] = (byte)LevelManager.levelString(n2);
        }
        Game.ChooseLevelText = (String[])objectArray;
    }

    public static String levelString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toString(n + 1));
        stringBuffer.append(" - ");
        stringBuffer.append(levelNames[n]);
        stringBuffer.append(" ");
        if (setLevelTime[n] == (long)0) {
            stringBuffer.append("???");
        } else {
            int n2 = (int)(setLevelTime[n] / (long)60000);
            int n3 = (int)(setLevelTime[n] % (long)60000 / (long)1000);
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n2));
            stringBuffer.append(':');
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n3));
        }
        return stringBuffer.toString();
    }

    public static void save() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"levelset", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(setName.length);
            dataOutputStream.writeShort(currentSet);
            for (int i = 0; i < setName.length; ++i) {
                dataOutputStream.writeUTF(setName[i]);
                dataOutputStream.writeShort(setCurrentLevel[i]);
                dataOutputStream.writeShort(setLevelQty[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getLevelSets() {
        if (availableSetName != null) {
            return;
        }
        Game.GameState = 16;
        Game.Draw();
        HttpConnection httpConnection = null;
        DataInputStream dataInputStream = null;
        InputStream inputStream = null;
        String string = String.valueOf(String.valueOf(Game.Robo2Http)).concat("/levels/desc");
        try {
            httpConnection = (HttpConnection)Connector.open((String)string);
            if (httpConnection == null || httpConnection.getResponseCode() != 200 || (inputStream = httpConnection.openInputStream()) == null) {
                Game.GameState = 17;
                Game.Redraw = true;
                return;
            }
            dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readShort();
            availableSetName = new String[n];
            availableSetLevelQty = new short[n];
            Game.DownloadLevelSetText = new String[n + 1];
            Game.DownloadLevelSetText[n] = Game.QUIT;
            for (int i = 0; i < n; ++i) {
                Game.DownloadLevelSetText[i] = LevelManager.availableSetName[i] = dataInputStream.readUTF();
                LevelManager.availableSetLevelQty[i] = dataInputStream.readShort();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            Game.GameState = 17;
            Game.Redraw = true;
            return;
        }
        Game.GameState = 14;
    }

    public static void download(String string) {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        int n2;
        int n3 = 0;
        Game.GameState = 16;
        Game.Draw();
        HttpConnection httpConnection = null;
        DataInputStream dataInputStream = null;
        InputStream inputStream = null;
        int n4 = -1;
        for (n2 = 0; n2 < availableSetName.length; ++n2) {
            if (!availableSetName[n2].equals(string)) continue;
            n4 = n2;
            break;
        }
        for (n2 = 0; n2 < setName.length; ++n2) {
            if (!setName[n2].equals(string)) continue;
            n4 = -1;
            break;
        }
        if (n4 == -1) {
            return;
        }
        String string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Game.Robo2Http))).append("/levels/").append(availableSetName[n4])));
        RecordStore recordStore = null;
        try {
            int n5;
            int n6;
            int n7;
            recordStore = RecordStore.openRecordStore((String)availableSetName[n4], (boolean)true);
            httpConnection = (HttpConnection)Connector.open((String)string2);
            if (httpConnection == null || httpConnection.getResponseCode() != 200 || (inputStream = httpConnection.openInputStream()) == null) {
                Game.GameState = 17;
                Game.Redraw = true;
                return;
            }
            dataInputStream = new DataInputStream(inputStream);
            n = availableSetLevelQty[n4];
            objectArray2 = null;
            for (n2 = 0; n2 < n; ++n2) {
                short s = dataInputStream.readShort();
                objectArray2 = new byte[s];
                n6 = n7 = dataInputStream.read((byte[])objectArray2);
                n5 = s - n7;
                while (n5 > 0) {
                    byte[] byArray = new byte[n5];
                    n7 = dataInputStream.read(byArray);
                    n5 -= n7;
                    System.arraycopy(byArray, 0, objectArray2, n6, n7);
                    n6 += n7;
                }
                n3 = recordStore.addRecord(objectArray2, 0, (int)s);
            }
            objectArray = new byte[n << 3];
            n3 = recordStore.addRecord(objectArray, 0, objectArray.length);
            n7 = dataInputStream.readShort();
            objectArray2 = new byte[n7];
            n5 = n6 = dataInputStream.read((byte[])objectArray2);
            int n8 = n7 - n6;
            while (n8 > 0) {
                byte[] byArray = new byte[n8];
                n6 = dataInputStream.read(byArray);
                n8 -= n6;
                System.arraycopy(byArray, 0, objectArray2, n5, n6);
                n5 += n6;
            }
            n3 = recordStore.addRecord(objectArray2, 0, n7);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            try {
                RecordStore.deleteRecordStore((String)availableSetName[n4]);
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            Game.GameState = 18;
            Game.Redraw = true;
            return;
        }
        catch (Exception exception) {
            Game.GameState = 17;
            Game.Redraw = true;
            return;
        }
        n = setName.length;
        objectArray2 = new String[n + 1];
        objectArray = new short[n + 1];
        short[] sArray = new short[n + 1];
        System.arraycopy(setName, 0, objectArray2, 0, n);
        System.arraycopy(setCurrentLevel, 0, objectArray, 0, n);
        System.arraycopy(setLevelQty, 0, sArray, 0, n);
        objectArray2[n] = (byte)string;
        objectArray[n] = 0;
        sArray[n] = availableSetLevelQty[n4];
        setName = (String[])objectArray2;
        setCurrentLevel = objectArray;
        setLevelQty = sArray;
        String[] stringArray = new String[setName.length + 2];
        System.arraycopy(setName, 0, stringArray, 1, setName.length);
        stringArray[0] = Game.ChooseLevelSetText[0];
        stringArray[stringArray.length - 1] = Game.QUIT;
        Game.ChooseLevelSetText = stringArray;
        LevelManager.save();
        Game.GameState = 14;
    }

    public static boolean setBestTime(long l, int n) {
        if (l >= setLevelTime[n] && setLevelTime[n] != (long)0) {
            return false;
        }
        LevelManager.setLevelTime[n] = l;
        Game.ChooseLevelText[n] = LevelManager.levelString(n);
        return true;
    }

    public static void saveBestTime() {
        int n = setLevelQty[currentSet];
        DataOutputStream dataOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n2 = n + 1;
        if (currentSet == 0) {
            n2 = 1;
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeLong(setLevelTime[i]);
            }
            RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).setRecord(n2, byteArrayOutputStream.toByteArray(), 0, n << 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void delete(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < setName.length; ++n) {
            if (!setName[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == 0) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (currentSet == n2) {
            LevelManager.setCurrent("Standart");
        } else if (currentSet > n2) {
            --currentSet;
        }
        int n3 = setName.length - 1;
        String[] stringArray = new String[n3];
        short[] sArray = new short[n3];
        short[] sArray2 = new short[n3];
        for (n = 0; n < n3; ++n) {
            int n4 = n;
            if (n >= n2) {
                ++n4;
            }
            stringArray[n] = setName[n4];
            sArray[n] = setCurrentLevel[n4];
            sArray2[n] = setLevelQty[n4];
        }
        setName = stringArray;
        setCurrentLevel = sArray;
        setLevelQty = sArray2;
        String[] stringArray2 = new String[setName.length + 2];
        System.arraycopy(setName, 0, stringArray2, 1, setName.length);
        stringArray2[0] = Game.ChooseLevelSetText[0];
        stringArray2[stringArray2.length - 1] = Game.QUIT;
        Game.ChooseLevelSetText = stringArray2;
        LevelManager.save();
    }

    public static InputStream getLevel(int n) {
        if (n > setCurrentLevel[currentSet]) {
            LevelManager.setCurrentLevel[LevelManager.currentSet] = (short)n;
        }
        if (currentSet == 0) {
            return Game.pGame.getClass().getResourceAsStream("/data/".concat(String.valueOf(String.valueOf(n))));
        }
        try {
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray = RecordStore.openRecordStore((String)setName[currentSet], (boolean)true).getRecord(n + 1);
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream2;
        }
        catch (RecordStoreException recordStoreException) {
            InputStream inputStream = null;
            return inputStream;
        }
    }

    static {
        standartLevelNames = new String[]{"The beggining!", "Some mirrors", "Dark forest", "Voodoo people", "Forest maze", "Green Square", "The ruins", "Rock to power", "Mirror puzzle", "Alarm system", "Ammunition", "Our office", "The Iceland", "Bomb trap", "Dragon&Dracula", "Icy lawn", "Ice alley", "Snowflake", "The Space Base", "Rocks&Rockets", "Laser field", "Long way", "Think twice", "Almost win", "Saving Eny!"};
    }
}

