/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class World {
    public static final int TILE_W = 12;
    public static final int TILE_H = 12;
    public static final int CELL_FREE = 0;
    public static final int CELL_WALL = 1;
    public static final int CELL_STONE = 2;
    public static final int CELL_EXIT = 3;
    public static final int CELL_MIRROR = 4;
    public static final int CELL_CANNON = 5;
    public static final int CELL_BOMB = 6;
    public static Image Ground;
    static int GroundTilesW;
    static int GroundTilesH;
    static int GroundI;
    static int GroundJ;
    public static Cell[][] Cells;
    public static Cell[] Cannons;
    public static short[] CannonsI;
    public static short[] CannonsJ;
    public static int[] CannonsColor;
    public static int[] CannonsDeltaColor;
    public static int W;
    public static int H;
    static int CenterX;
    static int CenterY;
    static int ScreenTileW;
    static int ScreenTileH;
    public static boolean isScroll;
    public static int Level;
    public static boolean DestroySourceCannon;
    public static boolean Retrace;
    public static long StartTime;
    public static long PauseTime;
    public static Animation Clock;
    public static Animation Turns;
    public static byte DrawState;
    static DetonatingCell detList;
    public static int startCellI;
    public static int startCellJ;
    public static int startCellX;
    public static int startCellY;
    public static int levelPixelW;
    public static int levelPixelH;
    public static final int[] WALL_ARRAY;
    public static Laser[] lasers;
    public static Laser curLaser;
    public static int lasersQty;
    public static int CannonNumber;

    public static void Init() {
        Kent.Init();
        Cell.InitTiles();
        Clock = new Animation("clock", 8);
        Turns = new Animation(Kent.aniRight);
        ScreenTileW = Game.Screen_W / 12 + 1;
        ScreenTileH = Game.Screen_H / 12 + 1;
        CenterX = Game.Screen_W >> 1;
        CenterY = Game.Screen_H >> 1;
    }

    public static void Process() {
        int n;
        int n2;
        boolean bl = false;
        if ((Game.LastKey == 49 || Game.LastKey == 51) && Game.Screen_Y > 0) {
            if ((Game.Screen_Y -= 4) < 0) {
                Game.Screen_Y = 0;
            }
            bl = true;
        }
        if ((Game.LastKey == 49 || Game.LastKey == 55) && Game.Screen_X > 0) {
            if ((Game.Screen_X -= 4) < 0) {
                Game.Screen_X = 0;
            }
            bl = true;
        }
        if ((Game.LastKey == 55 || Game.LastKey == 57) && Game.Screen_Y + Game.Screen_H < (H << 3) + (H << 2) - 1) {
            if ((Game.Screen_Y += 4) + Game.Screen_H >= (H << 3) + (H << 2)) {
                Game.Screen_Y = (H << 3) + (H << 2) - Game.Screen_H - 1;
            }
            bl = true;
        }
        if ((Game.LastKey == 51 || Game.LastKey == 57) && Game.Screen_X + Game.Screen_W < (W << 3) + (W << 2) - 1) {
            if ((Game.Screen_X += 4) + Game.Screen_W >= (W << 3) + (W << 2)) {
                Game.Screen_X = (W << 3) + (W << 2) - Game.Screen_W - 1;
            }
            bl = true;
        }
        if (bl) {
            isScroll = true;
            World.updateStartCell();
        }
        DetonatingCell detonatingCell = detList;
        Cell cell = null;
        while (detonatingCell != null) {
            cell = detonatingCell.cell;
            if (detonatingCell.counter != 0) {
                --detonatingCell.counter;
                if (cell.type == 0) {
                    if (detonatingCell.counter == 0) {
                        cell.Ani = null;
                    } else if (detonatingCell.counter > 5) {
                        Game.Play(Game.mBoom);
                    }
                }
                if (cell.type == 5) {
                    cell.f ^= 8;
                    if (detonatingCell.counter > 10) {
                        Game.Play(Game.mCannonBoom);
                    } else if (detonatingCell.counter == 0) {
                        detonatingCell.cell.f &= 0xFFFFFFF3;
                        cell.type = 0;
                        cell.Detonate(detonatingCell.i, detonatingCell.j);
                        Retrace = true;
                    }
                }
                if (detonatingCell.counter == 0 && cell.type == 6) {
                    n2 = detonatingCell.i;
                    n = detonatingCell.j;
                    Cell.boom(n2 - 1, n);
                    Cell.boom(n2 + 1, n);
                    Cell.boom(n2, n - 1);
                    Cell.boom(n2, n + 1);
                    detonatingCell.cell.f &= 0xFFFFFFF3;
                    cell.type = 0;
                    cell.Detonate(n2, n);
                    Retrace = true;
                }
            }
            if (detonatingCell.counter == 0) {
                detonatingCell.cell.f &= 0xFFFFFFF3;
                if (detonatingCell.next != null) {
                    detonatingCell.next.prev = detonatingCell.prev;
                }
                if (detonatingCell.prev != null) {
                    detonatingCell.prev.next = detonatingCell.next;
                }
                if (detonatingCell == detList) {
                    detList = detonatingCell.next;
                }
            }
            detonatingCell = detonatingCell.next;
        }
        n2 = Cannons.length;
        while (n2 != 0) {
            if ((n = CannonsColor[--n2] + CannonsDeltaColor[n2]) > 0 && n < 255) {
                World.CannonsColor[n2] = n;
                continue;
            }
            World.CannonsDeltaColor[n2] = -CannonsDeltaColor[n2];
        }
        Kent.Process();
        if (Retrace) {
            World.TraceAll();
        }
        DrawState = 1;
    }

    public static void updateStartCell() {
        if (!isScroll) {
            Game.Screen_X = Kent.x - CenterX;
            Game.Screen_Y = Kent.y - CenterY;
            if (Game.Screen_X < 0) {
                Game.Screen_X = 0;
            }
            if (Game.Screen_Y < 0) {
                Game.Screen_Y = 0;
            }
            if (Game.Screen_X + Game.Screen_W > levelPixelW) {
                Game.Screen_X = levelPixelW - Game.Screen_W;
            }
            if (Game.Screen_Y + Game.Screen_H > levelPixelH) {
                Game.Screen_Y = levelPixelH - Game.Screen_H;
            }
        }
        while (Game.Screen_X < startCellX) {
            startCellX -= 12;
            --startCellI;
        }
        while (Game.Screen_X > startCellX + 12) {
            startCellX += 12;
            ++startCellI;
        }
        while (Game.Screen_Y < startCellY) {
            startCellY -= 12;
            --startCellJ;
        }
        while (Game.Screen_Y > startCellY + 12) {
            startCellY += 12;
            ++startCellJ;
        }
        World.DrawWalls();
    }

    public static void DrawWalls() {
        int n;
        if (startCellI == GroundI && startCellJ == GroundJ) {
            return;
        }
        boolean bl = true;
        if (GroundI < 0 || GroundJ < 0) {
            bl = false;
        }
        Graphics graphics = Ground.getGraphics();
        int n2 = GroundI - startCellI;
        int n3 = GroundJ - startCellJ;
        GroundI = startCellI;
        GroundJ = startCellJ;
        int n4 = 0;
        int n5 = 0;
        int n6 = GroundI + ScreenTileW + 1;
        if (n6 > W) {
            n6 = W;
        }
        if ((n = GroundJ + ScreenTileH + 1) > H) {
            n = H;
        }
        Cell cell = null;
        Cell[] cellArray = null;
        for (int i = GroundI; i < n6; ++i) {
            n5 = 0;
            cellArray = Cells[i];
            for (int j = GroundJ; j < n; ++j) {
                cell = cellArray[j];
                int n7 = cell.f;
                if (cell.type != 1 && cell.type != 3) {
                    n7 = 0;
                }
                if (bl) {
                    int n8 = n2 + i;
                    int n9 = n3 + j;
                    if (n8 >= 0 && n9 >= 0 && n8 < W && n9 < H) {
                        Cell cell2 = Cells[n8][n9];
                        int n10 = cell2.f;
                        if (cell2.type != 1 && cell2.type != 3) {
                            n10 = 0;
                        }
                        if (n7 == n10) {
                            n5 += 12;
                            continue;
                        }
                    }
                }
                Cell.CurTiles.Frame = n7;
                Cell.CurTiles.Draw(graphics, n4, n5);
                n5 += 12;
            }
            n4 += 12;
        }
    }

    public static void Draw() {
        if (DrawState == 1) {
            int n;
            int n2;
            Game.Gfx.translate(-Game.Screen_X, -Game.Screen_Y);
            Game.Gfx.drawImage(Ground, startCellX, startCellY, 20);
            int n3 = GroundI + ScreenTileW + 1;
            if (n3 > W) {
                n3 = W;
            }
            if ((n2 = GroundJ + ScreenTileH + 1) > H) {
                n2 = H;
            }
            Cell cell = null;
            Cell[] cellArray = null;
            for (n = GroundI; n < n3; ++n) {
                cellArray = Cells[n];
                for (int i = GroundJ; i < n2; ++i) {
                    cell = cellArray[i];
                    if (cell.Ani == null) continue;
                    cell.Draw();
                }
            }
            n = Cannons.length;
            while (n != 0) {
                if (lasers[--n] == null) continue;
                Game.Gfx.setColor(CannonsColor[n], 89, 255 - CannonsColor[n]);
                lasers[n].draw();
            }
            Kent.Draw();
            Game.Gfx.translate(-Game.Gfx.getTranslateX(), -Game.Gfx.getTranslateY());
        } else if (DrawState == 4) {
            int n = (Game.Screen_W >> 1) - 28;
            if (StartTime != (long)0) {
                long l = System.currentTimeMillis() - StartTime;
                boolean bl = LevelManager.setBestTime(l, Level);
                int n4 = (int)l / 60000;
                int n5 = (int)(l % (long)60000) / 1000;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Game.BEST_TIME);
                stringBuffer.append(' ');
                n4 = (int)(l / (long)60000);
                n5 = (int)(l % (long)60000 / (long)1000);
                if (n4 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toString(n4));
                stringBuffer.append(':');
                if (n5 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toString(n5));
                Game.Gfx.setColor(0xFFFFFF);
                Game.Gfx.fillRect(0, 0, Game.Screen_W, Game.Screen_H);
                Game.Gfx.setColor(0);
                Game.Gfx.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Game.LEVEL))).append(" ").append(Level + 1).append(" ").append(Game.COMPLETED))), Game.Screen_W >> 1, 30, 1 | 0x10);
                if (n4 > 0) {
                    Game.Gfx.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n4))).append(" ").append(Game.MIN).append(" ").append(n5).append(" ").append(Game.SEC))), n + 16, 50, 4 | 0x10);
                } else {
                    Game.Gfx.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n5))).append(" ").append(Game.SEC))), n + 16, 50, 4 | 0x10);
                }
                Game.Gfx.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Kent.TurnCounter))).append(" ").append(Game.TURNS))), n + 16, 75, 4 | 0x10);
                StartTime = 0L;
                if (bl) {
                    Game.Gfx.setColor(0xFF0000);
                    Game.Gfx.drawString(Game.NEW_BEST_TIME, Game.Screen_W >> 1, 100, 1 | 0x10);
                    Game.Gfx.setColor(0);
                } else {
                    long l2 = LevelManager.setLevelTime[Level];
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(Game.BEST_TIME);
                    stringBuffer.append(' ');
                    n4 = (int)(l2 / (long)60000);
                    n5 = (int)(l2 % (long)60000 / (long)1000);
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(Integer.toString(n4));
                    stringBuffer.append(':');
                    if (n5 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(Integer.toString(n5));
                    Game.Gfx.drawString(stringBuffer.toString(), Game.Screen_W >> 1, 100, 1 | 0x10);
                }
            }
            Clock.Draw(n, 47);
            Turns.Draw(n, 72);
            if (World.Clock.Frame == 0) {
                Game.Gfx.setColor(0);
                Game.Gfx.drawString(Game.PRESS_ANY_KEY, Game.Screen_W >> 1, Game.Screen_H - 1, 1 | 0x20);
            } else if (World.Clock.Frame == 4) {
                Game.Gfx.setColor(0xFFFFFF);
                Game.Gfx.drawString(Game.PRESS_ANY_KEY, Game.Screen_W >> 1, Game.Screen_H - 1, 1 | 0x20);
            }
        } else if (DrawState == 5) {
            Game.Gfx.setColor(0xFFFFFF);
            Game.Gfx.fillRect(0, 0, Game.Screen_W, Game.Screen_H);
            Game.Gfx.setColor(0);
            Game.Gfx.drawString(Game.LOADING, Game.Screen_W >> 1, Game.Screen_H >> 1, 1 | 0x10);
        } else if (DrawState == 6) {
            Game.Gfx.setColor(0xFFFFFF);
            Game.Gfx.fillRect(0, 0, Game.Screen_W, Game.Screen_H);
            Animation animation = new Animation("win");
            animation.Draw(Game.Screen_W - animation.w >> 1, Game.Screen_H - animation.h >> 1);
            animation = null;
            System.gc();
        }
    }

    public static void NextLevel() {
        Game.Play(Game.mLevelEnd);
        Game.Key = -1;
        while (Game.Key == -1) {
            DrawState = (byte)4;
            Game.Draw();
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {}
        }
        World.Load(Level + 1);
        Game.Key = -1;
    }

    public static void Load(int n) {
        Cells = null;
        Cannons = null;
        CannonsJ = null;
        CannonsI = null;
        CannonsDeltaColor = null;
        CannonsColor = null;
        lasers = null;
        detList = null;
        System.gc();
        if (n == LevelManager.setLevelQty[LevelManager.currentSet]) {
            Game.Key = -1;
            Game.Play(Game.mLevelBegin);
            DrawState = (byte)6;
            Game.Draw();
            while (Game.Key == -1) {
            }
            Game.MenuState = 0;
            Game.Redraw = true;
            Game.GameState = 2;
            Game.MenuText = Game.MainMenuText;
            Game.Key = -1;
        } else {
            int n2;
            int n3;
            int n4;
            DrawState = (byte)5;
            Game.Draw();
            Game.Play(Game.mLevelBegin);
            DrawState = (byte)5;
            int n5 = 0;
            System.gc();
            InputStream inputStream = null;
            try {
                inputStream = LevelManager.getLevel(n);
                if (inputStream != null) {
                    W = inputStream.read();
                    H = inputStream.read();
                    Cell.setCurTiles(inputStream.read());
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = W;
                    int n9 = H;
                    if (W < ScreenTileW) {
                        W = ScreenTileW;
                        n6 = W - n8 >> 1;
                    }
                    if (H < ScreenTileH) {
                        H = ScreenTileH;
                        n7 = H - n9 >> 1;
                    }
                    Cells = new Cell[W][H];
                    levelPixelW = W * 12;
                    levelPixelH = H * 12;
                    int n10 = 0;
                    n4 = 0;
                    for (n3 = 0; n3 < W; ++n3) {
                        for (n2 = 0; n2 < H; ++n2) {
                            if (n3 < n6 || n2 < n7 || n3 >= n6 + n8 || n2 >= n7 + n9) {
                                World.Cells[n3][n2] = new Cell(0, n3, n2);
                                continue;
                            }
                            byte by = 0;
                            if (n4 == 0) {
                                n10 = inputStream.read();
                                if (n10 < 0) {
                                    n10 += 256;
                                }
                                by = (byte)((n10 & 0xF0) >> 4);
                                n4 = 1;
                            } else {
                                by = (byte)(n10 & 0xF);
                                n4 = 0;
                            }
                            if (by == 11) {
                                Kent.i = n3;
                                Kent.j = n2;
                                Kent.x = n3 * 12;
                                Kent.y = n2 * 12;
                                by = 0;
                            }
                            World.Cells[n3][n2] = new Cell(by, n3, n2);
                            if (World.Cells[n3][n2].type != 5) continue;
                            ++n5;
                        }
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Cannons = new Cell[n5];
            CannonsI = new short[n5];
            CannonsJ = new short[n5];
            CannonsColor = new int[n5];
            CannonsDeltaColor = new int[n5];
            lasers = new Laser[n5];
            int n11 = 0;
            Random random = new Random();
            Random random2 = new Random(1456017315L);
            n3 = W;
            while (n3 != 0) {
                Cell[] cellArray = Cells[--n3];
                n2 = H;
                while (n2 != 0) {
                    Cell cell = cellArray[--n2];
                    if (cell.type == 5) {
                        World.Cannons[n11] = cell;
                        n4 = random.nextInt() % 255;
                        if (n4 < 0) {
                            n4 = -n4;
                        }
                        World.CannonsColor[n11] = n4;
                        n4 = random.nextInt() % 5;
                        if (n4 < 0) {
                            n4 = -n4;
                        }
                        World.CannonsDeltaColor[n11] = ++n4;
                        World.CannonsI[n11] = (short)n3;
                        World.CannonsJ[n11] = (short)n2;
                        ++n11;
                        continue;
                    }
                    if (cell.type != 1) continue;
                    n4 = WALL_ARRAY[(World.isWall(n3 - 1, n2) << 0) + (World.isWall(n3, n2 - 1) << 1) + (World.isWall(n3 + 1, n2) << 2) + (World.isWall(n3, n2 + 1) << 3)];
                    if (n4 == 1) {
                        n4 = random2.nextInt() % 3;
                        if (n4 < 0) {
                            n4 = -n4;
                        }
                        ++n4;
                    }
                    cell.f = (byte)n4;
                }
            }
            Level = n;
            GroundJ = -1;
            GroundI = -1;
            startCellJ = 0;
            startCellI = 0;
            startCellX = 0;
            startCellY = 0;
            World.updateStartCell();
            Kent.DeathProgress = 0;
            Kent.MovingTo = 0;
            Kent.aniCurrent = Kent.aniMain;
            Kent.StopCounter = 0;
            Kent.TurnCounter = 0;
            World.TraceAll();
            DrawState = 1;
            Game.Key = -1;
            System.gc();
            StartTime = System.currentTimeMillis();
        }
    }

    public static int isWall(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= W || n2 >= H || World.Cells[n][n2].type != 1 && World.Cells[n][n2].type != 3) {
            return 0;
        }
        return 1;
    }

    public static Laser getNextLaser(int n, int n2, int n3, int n4, int n5) {
        Laser laser = new Laser(n += 6 + (n3 << 2) + (n3 << 1), n2 += 6 + (n4 << 2) + (n4 << 1));
        if (n5 != -1) {
            if (n4 == 1) {
                laser.y1 -= 6;
            } else if (n3 == 1 && n5 == 1) {
                laser.x1 -= 6;
            } else if (n3 == -1 && n5 == 0) {
                laser.x1 += 6;
            }
        }
        return laser;
    }

    public static void TraceAll() {
        int n;
        DrawState = 1;
        int n2 = W;
        while (n2 != 0) {
            Cell[] cellArray = Cells[--n2];
            n = H;
            while (n != 0) {
                Cell cell = cellArray[--n];
                if (cell.type != 0 && cell.type != 4) continue;
                cell.f &= 0xFFFFFFFD;
            }
        }
        Retrace = false;
        int n3 = Cannons.length;
        while (n3 != 0) {
            if (World.Cannons[--n3].type != 5 || Kent.movingCell == Cannons[n3]) {
                World.lasers[n3] = null;
                continue;
            }
            DestroySourceCannon = false;
            n2 = CannonsI[n3];
            n = CannonsJ[n3];
            int n4 = World.Cannons[n3].f & 3;
            int n5 = 0;
            int n6 = 0;
            if (n4 == 0) {
                n6 = 1;
            } else if (n4 == 1) {
                n5 = 1;
            } else if (n4 == 2) {
                n6 = -1;
            } else if (n4 == 3) {
                n5 = -1;
            }
            World.lasers[n3] = curLaser = World.getNextLaser(World.Cannons[n3].x, World.Cannons[n3].y, n5, n6, -1);
            World.TraceRay(n2 + n5, n + n6, n5, n6);
            if (!DestroySourceCannon) continue;
            Cells[n2][n].Detonate(n2, n);
        }
    }

    public static void TraceRay(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n >= W || n2 >= H) {
            return;
        }
        int n5 = World.Cells[n][n2].type;
        if (n5 == 0 && Kent.i == n && Kent.j == n2 && Kent.DeathProgress == 0) {
            Kent.Kill();
        } else {
            if (n5 == 0) {
                World.Cells[n][n2].f |= 2;
                World.curLaser.x2 += (n3 << 3) + (n3 << 2);
                World.curLaser.y2 += (n4 << 3) + (n4 << 2);
                World.TraceRay(n + n3, n2 + n4, n3, n4);
                return;
            }
            if (n5 == 4) {
                Cell cell = Cells[n][n2];
                if (cell == Kent.movingCell) {
                    return;
                }
                cell.f |= 2;
                if (n4 == -1) {
                    World.curLaser.y2 -= 6;
                } else if (n3 == 1 && (cell.f & 1) == 0) {
                    World.curLaser.x2 += 6;
                } else if (n3 == -1 && (cell.f & 1) == 1) {
                    World.curLaser.x2 -= 6;
                }
                int n6 = n3;
                if ((cell.f & 1) == 1) {
                    n3 = -n4;
                    n4 = -n6;
                } else {
                    n3 = n4;
                    n4 = n6;
                }
                curLaser = World.curLaser.nextLaser = World.getNextLaser(cell.x, cell.y, n3, n4, cell.f & 1);
                World.TraceRay(n + n3, n2 + n4, n3, n4);
            } else if (n5 == 5) {
                int n7 = World.Cells[n][n2].f & 3;
                int n8 = 0;
                int n9 = 0;
                if (n7 == 0) {
                    n9 = -1;
                } else if (n7 == 1) {
                    n8 = -1;
                } else if (n7 == 2) {
                    n9 = 1;
                } else if (n7 == 3) {
                    n8 = 1;
                }
                if (n8 == n3 && n9 == n4) {
                    DestroySourceCannon = true;
                }
                Cells[n][n2].Detonate(n, n2);
            } else if (n5 == 6) {
                Cells[n][n2].Detonate(n, n2);
            }
        }
    }

    static {
        TILE_W = 12;
        TILE_H = 12;
        CELL_FREE = 0;
        CELL_WALL = 1;
        CELL_STONE = 2;
        CELL_EXIT = 3;
        CELL_MIRROR = 4;
        CELL_CANNON = 5;
        CELL_BOMB = 6;
        Level = 1;
        DestroySourceCannon = false;
        Retrace = true;
        DrawState = 1;
        WALL_ARRAY = new int[]{1, 17, 19, 14, 16, 1, 7, 11, 18, 10, 6, 12, 5, 9, 8, 13};
        lasers = null;
    }
}

