/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class SoundManager
implements Runnable {
    private boolean Enable = false;
    private Player LastSound;
    public Player[] Players;
    public static boolean SoundIsOn;
    private Player SoundMelody;
    public static String Str;
    private boolean isRunning;
    private int loopCount = 1;
    public static int playerIndex;
    private Thread soundThread;

    static {
        playerIndex = -1;
        SoundIsOn = false;
        Str = "";
    }

    public SoundManager(String[] soundNames) {
        this.Players = new Player[soundNames.length];
        int i = 0;
        while (i < soundNames.length) {
            this.Players[i] = this.createPlayer(soundNames[i]);
            ++i;
        }
        this.isRunning = true;
        this.soundThread = new Thread(this);
        this.soundThread.setPriority(5);
        this.soundThread.start();
    }

    public Player createPlayer(String fileName) {
        Player newPlayer = null;
        int i = 0;
        String[] soundTypes = new String[]{"audio/midi", "audio/amr", "audio/x-wav", "audio/mmf"};
        String[] fileExtensions = new String[]{".mid", ".amr", ".wav", ".mmf"};
        String Err = "none";
        while (newPlayer == null && i < soundTypes.length) {
            try {
                newPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(fileName + fileExtensions[i]), (String)soundTypes[i]);
                newPlayer.realize();
                newPlayer.prefetch();
            }
            catch (Exception ex) {
                Err = "" + ex;
            }
            ++i;
        }
        if (newPlayer == null) {
            // empty if block
        }
        return newPlayer;
    }

    public void destroy() {
        this.stop();
        this.isRunning = false;
        this.Players = null;
        try {
            this.soundThread.join();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.soundThread = null;
    }

    public boolean isPlayed() {
        if (this.LastSound != null) {
            if (this.loopCount == -1) {
                return true;
            }
            if (this.LastSound.getState() == 400) {
                return true;
            }
        }
        return false;
    }

    private boolean play(Player NewSound) {
        if (this.LastSound != null) {
            if (this.LastSound.getState() == 400) {
                return false;
            }
        }
        try {
            NewSound.setLoopCount(this.loopCount);
            ((VolumeControl)NewSound.getControl("javax.microedition.media.control.VolumeControl")).setLevel(25);
            NewSound.start();
            this.LastSound = NewSound;
        }
        catch (Exception e) {
            this.LastSound = NewSound;
            this.stop();
            return false;
        }
        return true;
    }

    public void play(int index, int new_loopCount) {
        if (!SoundIsOn || this.Players[index] == null) {
            return;
        }
        this.loopCount = new_loopCount;
        playerIndex = index;
        this.SoundMelody = this.Players[index];
        this.Enable = true;
    }

    public void run() {
        while (this.isRunning) {
            if (this.Enable && this.play(this.SoundMelody)) {
                this.Enable = false;
                this.SoundMelody = null;
            }
            SoundManager soundManager = this;
            soundManager.soundThread.yield();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public void stop() {
        if (this.LastSound != null) {
            playerIndex = -1;
            if (this.LastSound.getState() == 400) {
                try {
                    this.LastSound.stop();
                }
                catch (Exception e) {
                }
            }
            this.LastSound = null;
            this.Enable = false;
        }
    }
}

