/*
 * Decompiled with CFR 0.152.
 */
package Sparkygtantra;

import Sparkygtantra.GTantra;
import Sparkygtantra.Layer;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class TileMapInfo {
    private int tileWidth;
    private int tileHeight;
    private int totalRows;
    private int totalColums;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;
    private GTantra mapTantra;
    private Vector layers = new Vector();

    public void setMapTantra(GTantra mapTantra) {
        this.mapTantra = mapTantra;
    }

    public Layer getLayer(int index) {
        return (Layer)this.layers.elementAt(index);
    }

    public Vector getLayers() {
        return this.layers;
    }

    public int getTileIndex(int col, int row, int layerId) {
        return this.getLayer((int)layerId).cells[row * this.totalColums + col];
    }

    public int getTileIndexFromPosition(int x, int y, int layerId) {
        int row = y / this.tileHeight;
        int col = x / this.tileWidth;
        return this.getLayer((int)layerId).cells[row * this.totalColums + col];
    }

    public void loadTitleMap(InputStream is, int mapIndex) {
        try {
            int totalMaps = this.byteToint(is, 1);
            for (int i = 0; i < mapIndex; ++i) {
                is.skip(4L);
                int cols = this.byteToint(is, 2);
                int rows = this.byteToint(is, 2);
                int totalLayers = this.byteToint(is, 2);
                is.skip(cols * rows * totalLayers * 3);
            }
            this.tileWidth = this.byteToint(is, 2);
            this.tileHeight = this.byteToint(is, 2);
            this.totalColums = this.byteToint(is, 2);
            this.totalRows = this.byteToint(is, 2);
            int totalLayers = this.byteToint(is, 2);
            this.layers.removeAllElements();
            for (int i = 0; i < totalLayers; ++i) {
                int j;
                Layer layer = new Layer();
                layer.cells = new int[this.totalColums * this.totalRows];
                layer.flags = new int[this.totalColums * this.totalRows];
                for (j = 0; j < this.totalColums * this.totalRows; ++j) {
                    layer.cells[j] = this.byteToint(is, 2);
                }
                for (j = 0; j < this.totalColums * this.totalRows; ++j) {
                    layer.flags[j] = this.byteToint(is, 1);
                }
                this.layers.addElement(layer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int byteToint(InputStream is, int noofBytes) throws Exception {
        int _lib_pOffset = 0;
        switch (noofBytes) {
            case 1: {
                _lib_pOffset = (byte)is.read() & 0xFF;
                break;
            }
            case 2: {
                _lib_pOffset = (byte)is.read() & 0xFF;
                _lib_pOffset += ((byte)is.read() & 0xFF) << 8;
                break;
            }
            case 3: {
                _lib_pOffset = (byte)is.read() & 0xFF;
                _lib_pOffset += ((byte)is.read() & 0xFF) << 8;
                if ((byte)is.read() != 1) break;
                _lib_pOffset *= -1;
                break;
            }
            case 4: {
                _lib_pOffset = (byte)is.read() & 0xFF;
                _lib_pOffset += ((byte)is.read() & 0xFF) << 8;
                _lib_pOffset += ((byte)is.read() & 0xFF) << 16;
                _lib_pOffset += ((byte)is.read() & 0xFF) << 24;
            }
        }
        return _lib_pOffset;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTotalColums() {
        return this.totalColums;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void drawMap(Graphics g, int drawX, int drawY, int width, int height, int x, int y) {
        int colNum = x / this.tileWidth;
        int rowNum = y / this.tileHeight;
        int endCol = (x + width) / this.tileWidth;
        int endRow = (y + height) / this.tileHeight;
        if ((x + width) % this.tileWidth != 0) {
            ++endCol;
        }
        if ((y + height) % this.tileHeight != 0) {
            ++endRow;
        }
        int shiftX = x - colNum * this.tileWidth;
        int shiftY = y - rowNum * this.tileHeight;
        this.saveNSetClip(g, drawX, drawY, width, height);
        for (int i = colNum; i < endCol; ++i) {
            for (int j = rowNum; j < endRow; ++j) {
                int tileId = j * this.totalColums + i;
                this.drawTile(g, tileId, drawX + (i - colNum) * this.tileWidth - shiftX, drawY + (j - rowNum) * this.tileHeight - shiftY);
            }
        }
        this.restoreClip(g);
    }

    private void drawTile(Graphics g, int tileId, int x, int y) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer object = (Layer)this.layers.elementAt(i);
            if (object.isMarker()) continue;
            if (tileId >= 0 && tileId <= object.getCells().length - 1) {
                this.mapTantra.DrawModule(g, object.getCells()[tileId], x, y, object.getFlags()[tileId]);
                continue;
            }
            g.setColor(0);
            g.fillRect(x, y, this.tileWidth, this.tileHeight);
        }
    }

    private void saveNSetClip(Graphics g, int x, int y, int width, int height) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipWidth = g.getClipWidth();
        this.clipHeight = g.getClipHeight();
        g.setClip(x, y, width, height);
    }

    public void restoreClip(Graphics g) {
        g.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }
}

